//! @file scene.h
//! @brief eʂǗNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef SCENE_H
#define SCENE_H

//#include "main.h"
//	wb_[t@C̉Ő錾B

//! @brief ʊǗNXiNXj
//! @details Q[̉ʂǗł̃NXłB
class scene
{
protected:
	class StateMachine *GameState;	//!< Q[Ŝ̏ԑJڃNX
	class D3DGraphics *d3dg;		//!< `NX
	class InputControl *inputCtrl;	//!< ͎擾NX
	unsigned int framecnt;		//!< t[̃JEg

public:
	scene();
	~scene();
	virtual void SetClass(StateMachine *in_GameState, D3DGraphics *in_d3dg, InputControl *in_inputCtrl);
	virtual int Create();
	virtual void Input();
	virtual void Process();
	virtual void RenderMain();
	virtual void Destroy();
	float GetEffectAlpha(unsigned int tframecnt, float MaxAlpha, float timingsec, float offsetsec, bool reversal);
	float GetEffectAlphaLoop(unsigned int tframecnt, float MaxAlpha, float timingsec, bool reversal);
};

//! @brief 2DʊǗNXiNXj
//! @details Q[ʂ̒ŁA2D`݂̂sV[Ǘ̃NXłB
class D2Dscene : public scene
{
protected:
	int gametitle;				//!< Q[^Cg摜
	virtual void Render2D();

public:
	D2Dscene();
	~D2Dscene();
	virtual int Create();
	virtual void RenderMain();
	virtual void Destroy();
};

//! @brief 3DʊǗNXiNXj
//! @details Q[ʂ̒ŁA3D`sV[Ǘ̃NXłB
class D3Dscene : public scene
{
protected:
	class SoundManager *GameSound;		//!< Q[ʉǗNX
	float camera_x;			//!< JW
	float camera_y;			//!< JW
	float camera_z;			//!< JW
	float camera_rx;		//!< JW
	float camera_ry;		//!< JW
	virtual void Render3D();
	virtual void Render2D();

public:
	D3Dscene();
	~D3Dscene();
	virtual void SetClass(StateMachine *in_GameState, D3DGraphics *in_d3dg, InputControl *in_inputCtrl, SoundManager *in_GameSound);
	virtual void Process();
	virtual void Sound();
	virtual void RenderMain();
};

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 3		//!< Select include file.
#endif
#include "main.h"

#endif