//! @file main.cpp
//! @brief WinMain()֐̒`уeXgvO 

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2021, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

//Doxygenݒt@C
#include "doxygen.h"

#include "main.h"

#ifdef _DEBUG
 #include <shlwapi.h>
 #pragma comment(lib, "Shlwapi.lib")
#endif

#ifdef ENABLE_DEBUGLOG
 //! Oo
 DebugLog OutputLog;
#endif

//! Xe[g}V
StateMachine GameState;

//! Q[ݒf[^
Config GameConfig;

//! CEBhE
WindowControl MainWindow;

//! @brief WinMain()֐
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	//gp΍
	UNREFERENCED_PARAMETER(hInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	char path[MAX_PATH];

#ifdef ENABLE_AUTOLOADMIF
	bool NoBriefingFlag = false;
	int gamemode = 0;
#endif

	//
	InitRand();

	//st@ĈꏊAJgfBNgɂB
	GetFileDirectory(__argv[0], path);
	chdir(path);

#ifdef _DEBUG
	//[Ňo
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	char str[255];
	strcpy(str, "[Information]\nThe compiler is the Debug mode.\nIf release the software, Switch compiler to Release mode.");
	MessageBox(NULL, str, GAMENAME, MB_OK);
#endif

	//
	//FWindowsȂAlpCmdLineƂGetCommandLine()֐ł܂ǂˁEEB
	strcpy(path, "");
	if( __argc > 1 ){
		for(int param=1; param<__argc; param++){
#ifdef ENABLE_DEBUGLOG
			//"Log"^ĂAOo͂L
			if( (strcmp(__argv[param], "-Log") == 0)||(strcmp(__argv[param], "/Log") == 0)||
				(strcmp(__argv[param], "-log") == 0)||(strcmp(__argv[param], "/log") == 0)
			){
				//Oo͂L
				OutputLog.EnableOutputLog();

				MainWindow.ErrorInfo("Enable Debug Log...");
				continue;
			}
#endif

#ifdef ENABLE_AUTOLOADMIF
			//"Dir"^ĂAJgfBNgړ
			if( (strcmp(__argv[param], "-Dir") == 0)||(strcmp(__argv[param], "/Dir") == 0)||
				(strcmp(__argv[param], "-dir") == 0)||(strcmp(__argv[param], "/dir") == 0)
			){
				if( (param+1) < __argc ){
					chdir(__argv[param+1]);
					param += 1;
				}
				continue;
			}

			//"NoBriefing"^ĂAi.mifw莞́ju[tBOȗ
			if( (strcmp(__argv[param], "-NoBriefing") == 0)||(strcmp(__argv[param], "/NoBriefing") == 0)||
				(strcmp(__argv[param], "-nobriefing") == 0)||(strcmp(__argv[param], "/bobriefing") == 0)
			){
				NoBriefingFlag = true;
				continue;
			}

			//ȊÖȂΊgqoĂ݂
			for(int i=strlen(__argv[param])-1; i>0; i--){
				if( __argv[param][i] == '.' ){
					if( strcmp(&(__argv[param][i]), ".mif") == 0 ){
						//.mifł΃t@CpXƂċL
						strcpy(path, __argv[param]);
					}
					break;
				}
			}
#endif
		}

#ifdef ENABLE_AUTOLOADMIF
		//.mifw肳ĂȂ΁Au[tBOtOf
		if( path[0] != '\0' ){
			if( NoBriefingFlag == false ){ gamemode = 1; }
			else{ gamemode = 2; }
		}
#endif
	}

#ifdef ENABLE_DEBUGLOG
	//t@C쐬
	OutputLog.MakeLog();

	//[U[o
	GetOperatingEnvironment();

	char infostr[64];

	/*
	//Oɏo
	sprintf(infostr, "Total Parameters : %d", __argc);
	OutputLog.WriteLog(LOG_CHECK, "Parameter", infostr);
	for(int i=0; i<__argc; i++){
		sprintf(infostr, "Parameter[%d]", i);
		OutputLog.WriteLog(LOG_CHECK, infostr, __argv[i]);
	}
	*/

	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Startup", "Start program entry point");
#endif

#ifdef _DEBUG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Startup", "Visual C++ debug mode");
#endif

	//ݒt@Cǂݍ
	if( GameConfig.LoadFile("config.dat") == 1 ){
#ifndef ENABLE_AUTOCREATECONFIG
		MainWindow.ErrorInfo("config data open failed");
		return 1;
#else
		//ftHgl𔽉fAݒt@Cɕۑ
		GameConfig.SetDefaultConfig();
		if( GameConfig.SaveFile("config.dat") == 1 ){
			MainWindow.ErrorInfo("config data save failed");
			return 1;
		}
#endif
	}

	//ǉݒǂݍ
#ifdef ENABLE_ADDCONFIG
	GameConfig.LoadExtFile("config-openxops.ini");
#else
	GameConfig.LoadExtFile(NULL);
#endif

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	sprintf(infostr, "Display resolution : %d x %d", GameConfig.GetScreenWidth(), GameConfig.GetScreenHeight());
	OutputLog.WriteLog(LOG_CHECK, "Environment", infostr);
	if( GameConfig.GetFullscreenFlag() == false ){
		OutputLog.WriteLog(LOG_CHECK, "Environment", "Window mode : Window");
	}
	else{
		OutputLog.WriteLog(LOG_CHECK, "Environment", "Window mode : Fullscreen");
	}
#endif

	//EBhE
	MainWindow.SetParam(hPrevInstance, nCmdShow);
	MainWindow.InitWindow(GAMENAME, GameConfig.GetScreenWidth(), GameConfig.GetScreenHeight(), GameConfig.GetFullscreenFlag());

	//{Iȏ
#ifdef ENABLE_AUTOLOADMIF
	if( InitGame(&MainWindow, gamemode, path) ){
#else
	if( InitGame(&MainWindow, 0, "") ){
#endif
		return 1;
	}

	opening Opening;
	mainmenu MainMenu;
	briefing Briefing;
	maingame MainGame;
	result Result;
	InitScreen(&MainWindow, &Opening, &MainMenu, &Briefing, &MainGame, &Result);

#ifdef ENABLE_AUTOLOADMIF
	//CQ[̂ݕ\郂[hȂ΁AWŃfobN\LɂB
	if( gamemode == 2 ){ MainGame.SetShowInfoFlag(true); }
#endif


#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Startup", "Start main loop");
#endif

	unsigned int framecnt = 0;

	for(int flag = 0; flag != -1; flag = MainWindow.CheckMainLoop()){
		if( flag == 1 ){
			//C
			ProcessScreen(&MainWindow, &Opening, &MainMenu, &Briefing, &MainGame, &Result, framecnt);

			//FPS
			ControlFps();

			framecnt++;
		}
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Exit", "Exit main loop");
#endif


	//{Iȉ
	CleanupGame();

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "Exit", "Exit program entry point");
#endif
	return 0;
}