//! @file soundmanager.h
//! @brief SoundManagerNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2021, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef SOUNDMANAGER_H
#define SOUNDMANAGER_H

#define MAX_SOUNDMGR_LIST 100		//!< TEhXg̍ő吔

#define MAX_SOUNDHITMAP 95			//!< }bve̍ő剹
#define MAX_SOUNDHITSMALLOBJ 110	//!< e̍ő剹
#define MAX_SOUNDHITHUMAN 75		//!< leiej̍ő剹
#define MAX_SOUNDPASSING 80			//!< e؂鉹̍ő剹
#define MAX_SOUNDCCOGRENADE 100		//!< ֒e oEhE˕Ԃ艹̍ő剹
#define MAX_SOUNDHITGRENADE 120		//!< ֒e ̍ő剹

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 2		//!< Select include file.
#endif
#include "main.h"

//! TEhXguparamidvp萔
enum SoundmgrID {
	SHOT_WEAPON = 0,	//!< C
	SHOT_WEAPON_PLAYER,	//!< vC[g̔C
	HIT_MAP,			//!< }bve
	HIT_HUMAN,			//!< e
	HIT_SMALLOBJECT,	//!< j
	BULLET,				//!< eẻE؂鉹
	GRE_BOUND,			//!< ֒e oEh
	GRE_EXPLOSION,		//!< ֒e 
	FOOTSTEPS,			//!< E鉹
	WEAPON_RELOAD		//!< [h
};

//! TEhXgp\
struct soundlist{
	int paramid;	//!< ̎ޔԍESoundmgrID萔
	int dataid;		//!< f[^ԍ
	float x;		//!< XW
	float y;		//!< YW
	float z;		//!< ZW
	float move_x;	//!< 1t[ XWړ
	float move_y;	//!< 1t[ YWړ
	float move_z;	//!< 1t[ ZWړ
	int teamid;		//!< `[ԍ
};

//! @brief TEhǗNX
//! @details eTEh̏EvZEĐȂǂsǗ܂B
class SoundManager
{
	class SoundControl *SoundCtrl;		//!< TEhĐNX
	class ResourceManager *Resource;	//!< \[XǗNX
	class ParameterInfo *Param;			//!< ݒlǗNX
	soundlist *soundlistA;		//!< TEhXg A
	soundlist *soundlistB;		//!< TEhXg B
	bool changeAB;				//!< TEhXg̔]
	int listAdatas;				//!< TEhXg A ̓o^
	int listBdatas;				//!< TEhXg B ̓o^

	bool GetNewList(soundlist **plist);
	int GetTargetList(soundlist **plist);
	bool CheckApproach(soundlist *plist, float camera_x, float camera_y, float camera_z, float *min_x, float *min_y, float *min_z);
	void PlaySound(soundlist *plist, float camera_x, float camera_y, float camera_z, int teamID);

public:
	SoundManager(SoundControl *in_SoundCtrl = NULL, ResourceManager *in_Resource = NULL, ParameterInfo *in_Param = NULL);
	~SoundManager();
	void SetClass(SoundControl *in_SoundCtrl, ResourceManager *in_Resource, ParameterInfo *in_Param);
	void InitWorldSound();
	bool ShotWeapon(float x, float y, float z, int id, int teamID, bool player);
	bool HitMap(float x, float y, float z, int teamID);
	bool HitHuman(float x, float y, float z, int teamID);
	bool HitSmallObject(float x, float y, float z, int id, int teamID);
	bool PassingBullet(float x, float y, float z, float move_x, float move_y, float move_z, int teamID);
	bool GrenadeBound(float x, float y, float z, int teamID);
	bool GrenadeExplosion(float x, float y, float z, int teamID);
	bool SetFootsteps(float x, float y, float z, int teamID);
	bool ReloadWeapon(float x, float y, float z, int teamID);
	int GetTotalSoundList();
	int GetWorldSound(float pos_x, float pos_y, float pos_z, int teamID, soundlist *psoundlist);
	void PlayWorldSound(float camera_x, float camera_y, float camera_z, float camera_rx, int teamID);
};

#endif