//! @file d3dgraphics-opengl.cpp
//! @brief D3DGraphicsNX̒`iOpenGLŁj

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2017, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

// ***** OpenGL core only *****
//
// libjpeg
//    Copyright (C) 1991-2014, Thomas G. Lane, Guido Vollbeding.
//    this software is based in part on the work of the Independent JPEG Group
//
// zlib
//    Copyright (C) 1995-2013 Jean-loup Gailly and Mark Adler
//
// libpng
//    Copyright (c) 1998-2014 Glenn Randers-Pehrson
//
// ****************************

#include "d3dgraphics.h"

#ifdef ENABLE_GRAPHICS_OPENGL

//! @brief RXgN^
D3DGraphics::D3DGraphics()
{
	hGLRC = NULL;
	width = 0;
	height = 0;
	fullscreenflag = false;
	SystemFont = NULL;
	now_SystemFontUStr = new WCHAR [1];
	now_SystemFontUStr[0] = NULL;
	SystemFontListIdx = 0;
	SystemFontListIdxSize = 0;
	SystemFont_posz = 1.0f;
	now_textureid = -1;

	camera_x = 0.0f;
	camera_y = 0.0f;
	camera_z = 0.0f;
	camera_rx = 0.0f;
	camera_ry = 0.0f;
	viewangle = 0.0f;

	blockdata = NULL;
	for(int i=0; i<TOTAL_BLOCKTEXTURE; i++){
		mapTextureID[i] = -1;
	}

	TextureFont = -1;

#ifdef ENABLE_DEBUGCONSOLE
	TextureDebugFont = -1;
#endif
}

//! @brief fBXgN^
D3DGraphics::~D3DGraphics()
{
	DestroyD3D();
}

//! @brief tXN[tOݒ
//! @param fullscreen tXN[tO
//! @attention tÓA InitD3D() ֐łݒł܂B
void D3DGraphics::SetFullScreenFlag(bool fullscreen)
{
	fullscreenflag = fullscreen;
}

//! @brief tXN[tO擾
//! @return tXN[tO
bool D3DGraphics::GetFullScreenFlag()
{
	return fullscreenflag;
}

//! @brief @n
//! iOpenGL 1.1j
//! @param WindowCtrl WindowControlNX̃|C^
//! @param TextureFontFilename gpeNX`tHg̃t@C
//! @param fullscreen falseFEBhE\@trueFtXN[p\
//! @return F0@sF1
int D3DGraphics::InitD3D(WindowControl *WindowCtrl, char *TextureFontFilename, bool fullscreen)
{
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_INIT, "OtBbN", "OpenGL");
#endif

	hWnd = WindowCtrl->GethWnd();

	RECT prc;
	GetClientRect(hWnd, &prc);
	width = prc.right;
	height = prc.bottom;

	fullscreenflag = fullscreen;

	//tXN[
	if( fullscreen == true ){
		DEVMODE devmode;
		ZeroMemory(&devmode, sizeof(devmode));
		devmode.dmSize = sizeof(devmode);
		devmode.dmPelsWidth = width;
		devmode.dmPelsHeight = height;
		devmode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;

		if( ChangeDisplaySettings(&devmode, CDS_TEST) != DISP_CHANGE_SUCCESSFUL ){
			return 1;
		}
		ChangeDisplaySettings(&devmode, CDS_FULLSCREEN);
	}



	HDC hDC;
	int pfdID;
	BOOL bResult;

	//sNZtH[}bg
	static PIXELFORMATDESCRIPTOR pfd = {
		sizeof (PIXELFORMATDESCRIPTOR),
		1,
		PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL,
		PFD_TYPE_RGBA,
		24,
		0, 0, 0,
		0, 0, 0,
		0, 0,
		0, 0, 0, 0, 0,
		32,
		0,
		0,
		PFD_MAIN_PLANE,
		0,
		0,
		0,
		0
	};

	//foCXReLXg擾
	hDC = GetDC(hWnd);

	//sNZtH[}bg擾
	pfdID = ChoosePixelFormat(hDC, &pfd);	
	if( pfdID == 0 ){ return 1; }

	//sNZtH[}bgw
	bResult = SetPixelFormat(hDC, pfdID, &pfd);
	if( bResult == FALSE ){ return 1; }

	//ReLXgw
	hGLRC = wglCreateContext(hDC);
	if( hGLRC == NULL ){ return 1; }

	//foCXReLXg
	ReleaseDC(hWnd, hDC);

	//VXetHgp
	//tHgFlr SVbN@TCYF18
	SystemFont = CreateFont(18, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FIXED_PITCH | FF_MODERN, "lr SVbN");

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif

	//eNX`tHgp摜̃t@Cݒ
	strcpy(TextureFontFname, TextureFontFilename);

	//eNX`tHgp摜擾
	TextureFont = LoadTexture(TextureFontFname, true, false);


	//HUD@ݎĂ镐`悷W
	HUD_myweapon_x[0] = SCREEN_WIDTH - 140.0f;
	HUD_myweapon_y[0] = SCREEN_HEIGHT - 40.0f;
	HUD_myweapon_z[0] = 0.86f;

	//HUD@\̕`悷W
	HUD_myweapon_x[1] = SCREEN_WIDTH - 72.0f;
	HUD_myweapon_y[1] = SCREEN_HEIGHT - 25.0f;
	HUD_myweapon_z[1] = 0.93f;


#ifdef ENABLE_DEBUGCONSOLE
	InitDebugFontData();
	if( LoadDebugFontTexture() == false ){
		return 1;
	}
#endif


	//libjpeg
	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_decompress(&cinfo);

	return 0;
}

//! @brief Zbg@n
//! iEBhEŏ̕A@Ȃǁj
//! @param WindowCtrl WindowControlNX̃|C^
//! @return F0@҂F1@sF2
int D3DGraphics::ResetD3D(WindowControl *WindowCtrl)
{
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_INIT, "OtBbN", "OpenGLiZbgj");
#endif

	//\[X
	CleanupD3Dresource();

	if( hGLRC != NULL ){
		wglDeleteContext(hGLRC);
		hGLRC = NULL;
	}


	//  ܂
	//@珉

	hWnd = WindowCtrl->GethWnd();

	//tXN[
	if( fullscreenflag == true ){
		DEVMODE devmode;
		ZeroMemory(&devmode, sizeof(devmode));
		devmode.dmSize = sizeof(devmode);
		devmode.dmPelsWidth = width;
		devmode.dmPelsHeight = height;
		devmode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;

		if( ChangeDisplaySettings(&devmode, CDS_TEST) != DISP_CHANGE_SUCCESSFUL ){
			return 1;
		}
		ChangeDisplaySettings(&devmode, CDS_FULLSCREEN);
	}



	HDC hDC;
	int pfdID;
	BOOL bResult;

	//sNZtH[}bg
	static PIXELFORMATDESCRIPTOR pfd = {
		sizeof (PIXELFORMATDESCRIPTOR),
		1,
		PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL,
		PFD_TYPE_RGBA,
		24,
		0, 0, 0,
		0, 0, 0,
		0, 0,
		0, 0, 0, 0, 0,
		32,
		0,
		0,
		PFD_MAIN_PLANE,
		0,
		0,
		0,
		0
	};

	//foCXReLXg擾
	hDC = GetDC(hWnd);

	//sNZtH[}bg擾
	pfdID = ChoosePixelFormat(hDC, &pfd);	
	if( pfdID == 0 ){ return 1; }

	//sNZtH[}bgw
	bResult = SetPixelFormat(hDC, pfdID, &pfd);
	if( bResult == FALSE ){ return 1; }

	//ReLXgw
	hGLRC = wglCreateContext(hDC);
	if( hGLRC == NULL ){ return 1; }

	//foCXReLXg
	ReleaseDC(hWnd, hDC);

	//VXetHgp
	//tHgFlr SVbN@TCYF18
	SystemFont = CreateFont(18, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FIXED_PITCH | FF_MODERN, "lr SVbN");

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif

	//eNX`tHgp摜擾
	TextureFont = LoadTexture(TextureFontFname, true, false);

#ifdef ENABLE_DEBUGCONSOLE
	if( LoadDebugFontTexture() == false ){
		return 1;
	}
#endif

	return 0;
}

//! @brief 
//! @attention {֐͎IɌĂяo܂AIɌĂяoƂ\łB
void D3DGraphics::DestroyD3D()
{
	if( hGLRC == NULL ){ return; }

	CleanupD3Dresource();

	if( hGLRC != NULL ){
		wglDeleteContext(hGLRC);
		hGLRC = NULL;
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CLEANUP, "OtBbN", "OpenGL");
#endif

	//libjpeg
	jpeg_destroy_decompress(&cinfo);
}

//! @brief foCX̃\[X
void D3DGraphics::CleanupD3Dresource()
{
	if( TextureFont != -1 ){
		CleanupTexture(TextureFont);
		TextureFont = -1;
	}

#ifdef ENABLE_DEBUGCONSOLE
	if( TextureDebugFont != -1 ){
		CleanupTexture(TextureDebugFont);
		TextureDebugFont = -1;
	}
#endif

	for(int i=0; i<MAX_MODEL; i++){
		CleanupModel(i);
	}
	for(int i=0; i<MAX_TEXTURE; i++){
		CleanupTexture(i);
	}

	if( SystemFont != NULL ){
		DeleteObject(SystemFont);
		SystemFont = NULL;
	}
	if( now_SystemFontUStr != NULL ){
		delete [] now_SystemFontUStr;
		now_SystemFontUStr = NULL;
	}
	if( SystemFontListIdx != 0 ){
		glDeleteLists(SystemFontListIdx, SystemFontListIdxSize);
		SystemFontListIdx = 0;
	}
}

//! @brief ft@Cǂݍށi.xj
//! @param filename t@C
//! @return FfFԍi0ȏj@sF-1
int D3DGraphics::LoadModel(char* filename)
{
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "f", filename);
#endif

	int id = -1;
	FILE *fp;
	char buf[256];
	char str[256];

	int vertexs = 0;
	MODELVDATA *vertex = NULL;
	int polygons = 0;
	int *index = NULL;
	int in_vertexs, in_polygons;
	MODELVDATA *old_vertex;
	int *old_index;

	char stroks[] = " ;,";		//؂镶

	//󂢂ĂFԍT
	for(int i=0; i<MAX_MODEL; i++){
		if( pmodel[i].useflag == false ){
			id = i;
			break;
		}
	}
	if( id == -1 ){ return -1; }

	//t@Cǂݍ
	fp = fopen(filename, "r");
	if( fp == NULL ){
		return -1;		//t@Cǂ߂Ȃ
	}

	//}WbNR[h擾
	fgets(buf, 256, fp);
	buf[ strlen("xof 0302txt") ] = '\0';
	if( strcmp(buf, "xof 0302txt") != 0 ){
		fclose( fp );
		return -1;		//Xt@CłȂ
	}

	while( fgets(buf, 256, fp) != NULL ){
		strcpy(str, buf);
		str[ strlen("Mesh") ] = '\0';
		if( strcmp(str, "Mesh") == 0 ){
			
			fgets(buf, 256, fp);
			in_vertexs = atoi(buf);

			if( vertexs == 0 ){
				//1ڂ̃bVf[^Ȃ΁Ä쐬邾B
				vertex = new MODELVDATA [in_vertexs];
			}
			else{
				//2ڂ̈ȍ~ȂÄmۂăRs[AÂ͍̈폜B
				old_vertex = vertex;
				vertex = new MODELVDATA [vertexs+in_vertexs];
				memcpy(vertex, old_vertex, sizeof(MODELVDATA)*vertexs);
				delete [] old_vertex;
			}

			for(int i=0; i<in_vertexs; i++){
				fgets(buf, 256, fp);
				vertex[i+vertexs].x = (float)atof( strtok(buf, stroks) ) * -1;
				vertex[i+vertexs].y = (float)atof( strtok(NULL, stroks) );
				vertex[i+vertexs].z = (float)atof( strtok(NULL, stroks) );
			}

			fgets(buf, 256, fp);

			fgets(buf, 256, fp);
			in_polygons = atoi(buf);

			if( polygons == 0 ){
				//1ڂ̃CfbNXf[^Ȃ΁Ä쐬邾B
				index = new int [in_polygons*5];
			}
			else{
				//2ڂ̈ȍ~ȂÄmۂăRs[AÂ͍̈폜B
				old_index = index;
				index = new int [(polygons+in_polygons)*5];
				memcpy(index, old_index, sizeof(int)*polygons*5);
				delete [] old_index;
			}

			for(int i=0; i<in_polygons; i++){
				fgets(buf, 256, fp);
				index[(i+polygons)*5] = atoi( strtok(buf, stroks) );
				for(int j=0; j<index[(i+polygons)*5]; j++){
					index[(i+polygons)*5 + j + 1] = atoi( strtok(NULL, stroks) ) + vertexs;
				}
			}

			while( fgets(buf, 256, fp) != NULL ){
				strcpy(str, buf);
				str[ strlen(" MeshTextureCoords") ] = '\0';
				if( strcmp(str, " MeshTextureCoords") == 0 ){

					fgets(buf, 256, fp);
					if( atoi(buf) != in_vertexs ){ break; }

					for(int i=0; i<in_vertexs; i++){
						fgets(buf, 256, fp);
						vertex[i+vertexs].u = (float)atof( strtok(buf, stroks) );
						vertex[i+vertexs].v = (float)atof( strtok(NULL, stroks) );
					}

					break;
				}
			}

			vertexs += in_vertexs;
			polygons += in_polygons;
		}
	}

	//t@Cnh
	fclose( fp );

	float *VertexAry = new float [polygons*6*3];
	float *ColorAry = new float [polygons*6*4];
	float *ColorGrayAry = new float [polygons*6*4];
	float *TexCoordAry = new float [polygons*6*2];
	int vid;
	int cnt = 0;

	for(int i=0; i<polygons; i++){
		if( index[i*5] == 3 ){
			//Op`
			vid = index[i*5+1];
			VertexAry[0 + cnt*3] = vertex[vid].x;
			VertexAry[1 + cnt*3] = vertex[vid].y;
			VertexAry[2 + cnt*3] = vertex[vid].z;
			TexCoordAry[0 + cnt*2] = vertex[vid].u;
			TexCoordAry[1 + cnt*2] = vertex[vid].v;

			VertexAry[3 + cnt*3] = vertex[vid].x;
			VertexAry[4 + cnt*3] = vertex[vid].y;
			VertexAry[5 + cnt*3] = vertex[vid].z;
			TexCoordAry[2 + cnt*2] = vertex[vid].u;
			TexCoordAry[3 + cnt*2] = vertex[vid].v;

			vid = index[i*5+3];
			VertexAry[6 + cnt*3] = vertex[vid].x;
			VertexAry[7 + cnt*3] = vertex[vid].y;
			VertexAry[8 + cnt*3] = vertex[vid].z;
			TexCoordAry[4 + cnt*2] = vertex[vid].u;
			TexCoordAry[5 + cnt*2] = vertex[vid].v;

			vid = index[i*5+2];
			VertexAry[9 + cnt*3] = vertex[vid].x;
			VertexAry[10 + cnt*3] = vertex[vid].y;
			VertexAry[11 + cnt*3] = vertex[vid].z;
			TexCoordAry[6 + cnt*2] = vertex[vid].u;
			TexCoordAry[7 + cnt*2] = vertex[vid].v;

			VertexAry[12 + cnt*3] = vertex[vid].x;
			VertexAry[13 + cnt*3] = vertex[vid].y;
			VertexAry[14 + cnt*3] = vertex[vid].z;
			TexCoordAry[8 + cnt*2] = vertex[vid].u;
			TexCoordAry[9 + cnt*2] = vertex[vid].v;

			VertexAry[15 + cnt*3] = vertex[vid].x;
			VertexAry[16 + cnt*3] = vertex[vid].y;
			VertexAry[17 + cnt*3] = vertex[vid].z;
			TexCoordAry[10 + cnt*2] = vertex[vid].u;
			TexCoordAry[11 + cnt*2] = vertex[vid].v;

			cnt += 6;
		}
		else{
			//lp`
			vid = index[i*5+1];
			VertexAry[0 + cnt*3] = vertex[vid].x;
			VertexAry[1 + cnt*3] = vertex[vid].y;
			VertexAry[2 + cnt*3] = vertex[vid].z;
			TexCoordAry[0 + cnt*2] = vertex[vid].u;
			TexCoordAry[1 + cnt*2] = vertex[vid].v;

			VertexAry[3 + cnt*3] = vertex[vid].x;
			VertexAry[4 + cnt*3] = vertex[vid].y;
			VertexAry[5 + cnt*3] = vertex[vid].z;
			TexCoordAry[2 + cnt*2] = vertex[vid].u;
			TexCoordAry[3 + cnt*2] = vertex[vid].v;

			vid = index[i*5+4];
			VertexAry[6 + cnt*3] = vertex[vid].x;
			VertexAry[7 + cnt*3] = vertex[vid].y;
			VertexAry[8 + cnt*3] = vertex[vid].z;
			TexCoordAry[4 + cnt*2] = vertex[vid].u;
			TexCoordAry[5 + cnt*2] = vertex[vid].v;

			vid = index[i*5+2];
			VertexAry[9 + cnt*3] = vertex[vid].x;
			VertexAry[10 + cnt*3] = vertex[vid].y;
			VertexAry[11 + cnt*3] = vertex[vid].z;
			TexCoordAry[6 + cnt*2] = vertex[vid].u;
			TexCoordAry[7 + cnt*2] = vertex[vid].v;

			vid = index[i*5+3];
			VertexAry[12 + cnt*3] = vertex[vid].x;
			VertexAry[13 + cnt*3] = vertex[vid].y;
			VertexAry[14 + cnt*3] = vertex[vid].z;
			TexCoordAry[8 + cnt*2] = vertex[vid].u;
			TexCoordAry[9 + cnt*2] = vertex[vid].v;

			VertexAry[15 + cnt*3] = vertex[vid].x;
			VertexAry[16 + cnt*3] = vertex[vid].y;
			VertexAry[17 + cnt*3] = vertex[vid].z;
			TexCoordAry[10 + cnt*2] = vertex[vid].u;
			TexCoordAry[11 + cnt*2] = vertex[vid].v;

			cnt += 6;
		}
	}

	//Fzp
	ColorAry[0] = 1.0f;
	ColorAry[1] = 1.0f;
	ColorAry[2] = 1.0f;
	ColorAry[3] = 1.0f;
	for(int i=1; i<cnt; i++){
		memcpy(&(ColorAry[i*4]), ColorAry, sizeof(float)*4);
	}
	ColorGrayAry[0] = 0.8f;
	ColorGrayAry[1] = 0.8f;
	ColorGrayAry[2] = 0.8f;
	ColorGrayAry[3] = 1.0f;
	for(int i=1; i<cnt; i++){
		memcpy(&(ColorGrayAry[i*4]), ColorGrayAry, sizeof(float)*4);
	}

	delete [] vertex;
	delete [] index;

	pmodel[id].useflag = true;
	pmodel[id].polygons = polygons;
	pmodel[id].VertexAry = VertexAry;
	pmodel[id].ColorAry = ColorAry;
	pmodel[id].ColorGrayAry = ColorGrayAry;
	pmodel[id].TexCoordAry = TexCoordAry;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", id);
#endif
	return id;
}

//! @brief ft@C̒ԃf[^쐬i[tBOj
//! @param idA fA̔Fԍ
//! @param idB fB̔Fԍ
//! @return FVfFԍi0ȏj@sF-1
//! @attention fAƃfB́A_E|SECfbNXłKv܂B
//! @attention ꂼ̃ff[^Ȃ _قȂꍇAsɎs܂B
int D3DGraphics::MorphingModel(int idA, int idB)
{
#ifdef ENABLE_DEBUGLOG
	char str[128];
	sprintf(str, "ԃf[^쐬@@IDF%d and %d", idA, idB);

	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "f", str);
#endif

	//f[^ׂ
	if( (idA < 0)||((MAX_MODEL -1) < idA) ){ return -1; }
	if( pmodel[idA].useflag == false ){ return -1; }
	if( (idB < 0)||((MAX_MODEL -1) < idB) ){ return -1; }
	if( pmodel[idB].useflag == false ){ return -1; }

	int idN = -1;
	int numpA, numpB;

	//󂢂ĂFԍT
	for(int i=0; i<MAX_MODEL; i++){
		if( pmodel[i].useflag == false ){
			idN = i;
			break;
		}
	}
	if( idN == -1 ){ return -1; }

	//|S擾
	numpA = pmodel[idA].polygons;
	numpB = pmodel[idB].polygons;

	//|Sǂׂ
	if( numpA != numpB ){ return -1; }

	float *VertexAry = new float [numpA*6*3];
	float *ColorAry = new float [numpA*6*4];
	float *ColorGrayAry = new float [numpA*6*4];
	float *TexCoordAry = new float [numpA*6*2];

	//e_ǂݏovZ
	for(int i=0; i<numpA*6; i++){
		VertexAry[i*3 + 0] = (pmodel[idA].VertexAry[i*3 + 0] + pmodel[idB].VertexAry[i*3 + 0])/2;
		VertexAry[i*3 + 1] = (pmodel[idA].VertexAry[i*3 + 1] + pmodel[idB].VertexAry[i*3 + 1])/2;
		VertexAry[i*3 + 2] = (pmodel[idA].VertexAry[i*3 + 2] + pmodel[idB].VertexAry[i*3 + 2])/2;
	}

	//}eARs[
	for(int i=0; i<numpA*6; i++){
		ColorAry[i*4 + 0] = pmodel[idA].ColorAry[i*4 + 0];
		ColorAry[i*4 + 1] = pmodel[idA].ColorAry[i*4 + 1];
		ColorAry[i*4 + 2] = pmodel[idA].ColorAry[i*4 + 2];
		ColorAry[i*4 + 3] = pmodel[idA].ColorAry[i*4 + 3];
		ColorGrayAry[i*4 + 0] = pmodel[idA].ColorGrayAry[i*4 + 0];
		ColorGrayAry[i*4 + 1] = pmodel[idA].ColorGrayAry[i*4 + 1];
		ColorGrayAry[i*4 + 2] = pmodel[idA].ColorGrayAry[i*4 + 2];
		ColorGrayAry[i*4 + 3] = pmodel[idA].ColorGrayAry[i*4 + 3];
		TexCoordAry[i*2 + 0] = pmodel[idA].TexCoordAry[i*2 + 0];
		TexCoordAry[i*2 + 1] = pmodel[idA].TexCoordAry[i*2 + 1];
	}

	pmodel[idN].useflag = true;
	pmodel[idN].polygons = numpA;
	pmodel[idN].VertexAry = VertexAry;
	pmodel[idN].ColorAry = ColorAry;
	pmodel[idN].ColorGrayAry = ColorGrayAry;
	pmodel[idN].TexCoordAry = TexCoordAry;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", idN);
#endif
	return idN;
}

//! @brief ft@C
//! @param id fFԍ
void D3DGraphics::CleanupModel(int id)
{
	if( (id < 0)||((MAX_MODEL -1) < id) ){ return; }
	if( pmodel[id].useflag == false ){ return; }

	delete pmodel[id].VertexAry;
	delete pmodel[id].ColorAry;
	delete pmodel[id].ColorGrayAry;
	delete pmodel[id].TexCoordAry;
	pmodel[id].useflag = false;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CLEANUP, "f", id);
#endif
}

//! @brief eNX`tH[}bggqŔ
//! @param filename t@C
//! @param nowformat ݂̔ʒl
//! @return VȔʒl
int D3DGraphics::CheckFileExtension(char* filename, int nowformat)
{
	char filename2[MAX_PATH];

	//t@C֕ϊigqpj
	for(int i=0; i<(int)strlen(filename); i++){
		filename2[i] = (char)tolower(filename[i]);
	}
	filename2[ strlen(filename) ] = '\0';

	//gqŃt@CtH[}bg𔻒
	for(int i=strlen(filename2)-1; i>0; i--){
		if( filename2[i] == '.' ){
			if( strcmp(&(filename2[i]), ".bmp") == 0 ){
				return 1;
			}
			if( strcmp(&(filename2[i]), ".dds") == 0 ){
				return 2;
			}
			if( strcmp(&(filename2[i]), ".jpeg") == 0 ){
				return 3;
			}
			if( strcmp(&(filename2[i]), ".jpg") == 0 ){
				return 3;
			}
			if( strcmp(&(filename2[i]), ".jpe") == 0 ){
				return 3;
			}
			if( strcmp(&(filename2[i]), ".png") == 0 ){
				return 4;
			}
		}
	}

	return nowformat;
}

//! @brief eNX`tH[}bgt@Cwb_[Ŕ
//! @param filename t@C
//! @param nowformat ݂̔ʒl
//! @return VȔʒl
int D3DGraphics::CheckFileTypeFlag(char* filename, int nowformat)
{
	FILE *fp;
	unsigned char header[4];

	//t@Cǂݍ
	fp = fopen(filename, "rb");
	if( fp == NULL ){
		return false;		//t@Cǂ߂Ȃ
	}

	//wb_[ǂ
	fread(header, 1, 4, fp);

	//t@Cnh
	fclose( fp );

	if( (header[0x00] == 'B')&&(header[0x01] == 'M') ){															//.bmp
		return 1;
	}
	if( (header[0x00] == 'D')&&(header[0x01] == 'D')&&(header[0x02] == 'S') ){									//.dds
		return 2;
	}
	if( (header[0x00] == 0xFF)&&(header[0x01] == 0xD8) ){														//.jpg
		return 3;
	}
	if( (header[0x00] == 0x89)&&(header[0x01] == 'P')&&(header[0x02] == 'N')&&(header[0x03] == 'G') ){			//.png@{8oCg
		return 4;
	}

	return nowformat;
}

//! @brief eNX`ǂݍ
//! @param filename t@C
//! @param texturefont eNX`tHgtO
//! @param BlackTransparent 𓧉߂
//! @return FeNX`Fԍi0ȏj@sF-1
int D3DGraphics::LoadTexture(char* filename, bool texturefont, bool BlackTransparent)
{
	//gp΍
	UNREFERENCED_PARAMETER(texturefont);

	int id = -1;
	int format = 0;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "eNX`", filename);
#endif

	//󂢂ĂFԍT
	for(int i=0; i<MAX_TEXTURE; i++){
		if( ptextures[i].useflag == false ){
			id = i;
			break;
		}
	}
	if( id == -1 ){ return -1; }

	//܂gqŃt@CtH[}bg𔻒
	format = CheckFileExtension(filename, format);

	//t@Cwb_[̏łmF
	format = CheckFileTypeFlag(filename, format);

	//ΉĂȂtH[}bg
	if( format == 0 ){ return -1; }

	if( format == 1 ){	// .bmp
		if( LoadBMPTexture(filename, BlackTransparent, &(ptextures[id])) == false ){
			return -1;
		}
	}
	if( format == 2 ){	// .dds
		if( LoadDDSTexture(filename, BlackTransparent, &(ptextures[id])) == false ){
			return -1;
		}
	}
	if( format == 3 ){	// .jpeg
		if( LoadJPEGTexture(filename, BlackTransparent, &(ptextures[id])) == false ){
			return -1;
		}
	}
	if( format == 4 ){	// .png
		if( LoadPNGTexture(filename, BlackTransparent, &(ptextures[id])) == false ){
			return -1;
		}
	}


	//eNX`L
	glEnable(GL_TEXTURE_2D);

	HDC hDC;
	hDC = GetDC(hWnd);
	wglMakeCurrent(hDC, hGLRC);
	glGenTextures(1, &(textureobjname[id]));
	ReleaseDC(hWnd, hDC);

	glBindTexture(GL_TEXTURE_2D, textureobjname[id]);

	//OpenGLɃZbg
	int width = ptextures[id].width;
	int height = ptextures[id].height;
	unsigned char *data = ptextures[id].data;
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);

	//~bv}bvݒ
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); 
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	//Z
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	//eNX`
	glDisable(GL_TEXTURE_2D);

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", id);
#endif

	return id;


	/*
	unsigned char *data = new unsigned char [16*4];

	data[0*4 + 0] = 255;	data[0*4 + 1] = 255;	data[0*4 + 2] = 255;	data[0*4 + 3] = 255;
	data[1*4 + 0] = 0;		data[1*4 + 1] = 0;		data[1*4 + 2] = 0;		data[1*4 + 3] = 255;
	data[2*4 + 0] = 255;	data[2*4 + 1] = 255;	data[2*4 + 2] = 255;	data[2*4 + 3] = 255;
	data[3*4 + 0] = 0;		data[3*4 + 1] = 0;		data[3*4 + 2] = 0;		data[3*4 + 3] = 255;
	data[4*4 + 0] = 255;	data[4*4 + 1] = 0;		data[4*4 + 2] = 0;		data[4*4 + 3] = 255;
	data[5*4 + 0] = 0;		data[5*4 + 1] = 255;	data[5*4 + 2] = 0;		data[5*4 + 3] = 255;
	data[6*4 + 0] = 0;		data[6*4 + 1] = 0;		data[6*4 + 2] = 255;	data[6*4 + 3] = 255;
	data[7*4 + 0] = 0;		data[7*4 + 1] = 0;		data[7*4 + 2] = 0;		data[7*4 + 3] = 255;
	data[8*4 + 0] = 128;	data[8*4 + 1] = 0;		data[8*4 + 2] = 0;		data[8*4 + 3] = 255;
	data[9*4 + 0] = 0;		data[9*4 + 1] = 128;	data[9*4 + 2] = 0;		data[9*4 + 3] = 255;
	data[10*4 + 0] = 0;		data[10*4 + 1] = 0;		data[10*4 + 2] = 128;	data[10*4 + 3] = 255;
	data[11*4 + 0] = 0;		data[11*4 + 1] = 0;		data[11*4 + 2] = 0;		data[11*4 + 3] = 255;
	data[12*4 + 0] = 255;	data[12*4 + 1] = 255;	data[12*4 + 2] = 0;		data[12*4 + 3] = 255;
	data[13*4 + 0] = 255;	data[13*4 + 1] = 0;		data[13*4 + 2] = 255;	data[13*4 + 3] = 255;
	data[14*4 + 0] = 0;		data[14*4 + 1] = 255;	data[14*4 + 2] = 255;	data[14*4 + 3] = 255;
	data[15*4 + 0] = 255;	data[15*4 + 1] = 255;	data[15*4 + 2] = 255;	data[15*4 + 3] = 255;

	ptextures[id].data = data;
	ptextures[id].width = 4;
	ptextures[id].height = 4;

	ptextures[id].useflag = true;

	return id;
	*/
}

//! @brief BMPt@Cǂݍ
//! @param filename t@C
//! @param BlackTransparent 𓧉߂
//! @param ptexture 󂯎TEXTUREDATA\̂̃|C^
//! @return Ftrue@sFfalse
//! @attention ʏ LoadTexture()֐ ĂтƁB
bool D3DGraphics::LoadBMPTexture(char* filename, bool BlackTransparent, TEXTUREDATA *ptexture)
{
	FILE *fp;
	unsigned char header[54];
	unsigned int dataPos;
	unsigned int width, height;
	unsigned int index;

	//t@Cǂݍ
	fp = fopen(filename, "rb");
	if( fp == NULL ){
		return false;		//t@Cǂ߂Ȃ
	}

	//wb_[ǂ
	fread(header, 1, 54, fp);

	if( (header[0x00] != 'B')||(header[0x01] != 'M') ){
		fclose(fp);
		return false;		//.bmpł͂Ȃ
	}

	// oCgz񂩂琮ǂݍ
	dataPos = *(int*)&(header[0x0E]) + 14;
	width = *(int*)&(header[0x12]);
	height = *(int*)&(header[0x16]);
	index = *(int*)&(header[0x1C]);

	//f[^̐擪܂ňړ
	fseek(fp, dataPos, SEEK_SET);

	unsigned char *data = new unsigned char [width*height*4];

	//esNZ4rbgȂA16Fpbg[h
	if( index == 4 ){
		unsigned char pixel;
		unsigned char pixelH;
		unsigned char pixelL;
		unsigned char *pallet = new unsigned char [16*4];
		fread(pallet, 1, 16*4, fp);

		for(int h=height-1; h>=0; h--){
			for(int w=0; w<((int)width/2); w++){
				fread(&pixel, 1, 1, fp);
				pixelH = (pixel >> 4)&0x0F;
				pixelL = pixel&0x0F;

				data[(h*width+w*2)*4 + 0] = pallet[pixelH*4 + 2];
				data[(h*width+w*2)*4 + 1] = pallet[pixelH*4 + 1];
				data[(h*width+w*2)*4 + 2] = pallet[pixelH*4 + 0];
				data[(h*width+w*2)*4 + 3] = 255;

				data[(h*width+w*2+1)*4 + 0] = pallet[pixelL*4 + 2];
				data[(h*width+w*2+1)*4 + 1] = pallet[pixelL*4 + 1];
				data[(h*width+w*2+1)*4 + 2] = pallet[pixelL*4 + 0];
				data[(h*width+w*2+1)*4 + 3] = 255;

				if( BlackTransparent == true ){
					//ȂΓ߂
					if( (data[(h*width+w*2)*4 + 0] == 0)&&(data[(h*width+w*2)*4 + 1] == 0)&&(data[(h*width+w*2)*4 + 2] == 0) ){
						data[(h*width+w*2)*4 + 3] = 0;
					}
					if( (data[(h*width+w*2+1)*4 + 0] == 0)&&(data[(h*width+w*2+1)*4 + 1] == 0)&&(data[(h*width+w*2+1)*4 + 2] == 0) ){
						data[(h*width+w*2+1)*4 + 3] = 0;
					}
				}
			}
		}

		delete []pallet;
	}

	//esNZ8rbgȂA256Fpbg[h
	if( index == 8 ){
		unsigned char pixel;
		unsigned char *pallet = new unsigned char [256*4];
		fread(pallet, 1, 256*4, fp);

		for(int h=height-1; h>=0; h--){
			for(int w=0; w<(int)width; w++){
				fread(&pixel, 1, 1, fp);

				data[(h*width+w)*4 + 0] = pallet[pixel*4 + 2];
				data[(h*width+w)*4 + 1] = pallet[pixel*4 + 1];
				data[(h*width+w)*4 + 2] = pallet[pixel*4 + 0];
				data[(h*width+w)*4 + 3] = 255;

				if( BlackTransparent == true ){
					//ȂΓ߂
					if( (data[(h*width+w)*4 + 0] == 0)&&(data[(h*width+w)*4 + 1] == 0)&&(data[(h*width+w)*4 + 2] == 0) ){
						data[(h*width+w)*4 + 3] = 0;
					}
				}
			}
		}

		delete []pallet;
	}

	//esNZ24rbgȂAtJ[
	if( index == 24 ){
		unsigned char pixel[3];
		for(int h=height-1; h>=0; h--){
			for(int w=0; w<(int)width; w++){
				fread(&pixel, 1, 3, fp);

				data[(h*width+w)*4 + 0] = pixel[2];
				data[(h*width+w)*4 + 1] = pixel[1];
				data[(h*width+w)*4 + 2] = pixel[0];
				data[(h*width+w)*4 + 3] = 255;

				if( BlackTransparent == true ){
					//ȂΓ߂
					if( (data[(h*width+w)*4 + 0] == 0)&&(data[(h*width+w)*4 + 1] == 0)&&(data[(h*width+w)*4 + 2] == 0) ){
						data[(h*width+w)*4 + 3] = 0;
					}
				}
			}
		}
	}

	//esNZ32rbgȂAtJ[
	if( index == 32 ){
		unsigned char pixel[4];
		for(int h=height-1; h>=0; h--){
			for(int w=0; w<(int)width; w++){
				fread(&pixel, 1, 4, fp);

				data[(h*width+w)*4 + 0] = pixel[2];
				data[(h*width+w)*4 + 1] = pixel[1];
				data[(h*width+w)*4 + 2] = pixel[0];
				data[(h*width+w)*4 + 3] = 255;

				if( BlackTransparent == true ){
					//ȂΓ߂
					if( (data[(h*width+w)*4 + 0] == 0)&&(data[(h*width+w)*4 + 1] == 0)&&(data[(h*width+w)*4 + 2] == 0) ){
						data[(h*width+w)*4 + 3] = 0;
					}
				}
			}
		}
	}

	//t@Cnh
	fclose( fp );

	//\̂ɑ
	ptexture->data = data;
	ptexture->width = width;
	ptexture->height = height;

	ptexture->useflag = true;

	return true;
}

//! @brief DDSt@Cǂݍ
//! @param filename t@C
//! @param BlackTransparent 𓧉߂
//! @param ptexture 󂯎TEXTUREDATA\̂̃|C^
//! @return Ftrue@sFfalse
//! @attention ʏ LoadTexture()֐ ĂтƁB
bool D3DGraphics::LoadDDSTexture(char* filename, bool BlackTransparent, TEXTUREDATA *ptexture)
{
	FILE *fp;
	unsigned char header[124+4];
	unsigned int width, height;
	unsigned int index;
	unsigned int flag;
	unsigned int Caps;

	//t@Cǂݍ
	fp = fopen(filename, "rb");
	if( fp == NULL ){
		return false;		//t@Cǂ߂Ȃ
	}

	//wb_[ǂ
	fread(header, 1, 124+4, fp);

	if( (header[0x00] != 'D')||(header[0x01] != 'D')||(header[0x02] != 'S')||(header[0x03] != ' ') ){
		fclose(fp);
		return false;		//.ddsł͂Ȃ
	}

	// oCgz񂩂琮ǂݍ
	width = *(int*)&(header[0x10]);
	height = *(int*)&(header[0x0C]);
	index = *(int*)&(header[0x58]);
	flag = *(int*)&(header[0x08]);
	Caps = *(int*)&(header[0x70]);

	if( (index != 16)&&(index != 32) ){
		fclose(fp);
		return false;		//ΉĂȂtH[}bg
	}

	if( (flag & 0x00020000)&&(Caps & 0x00400000) ){		//DDSD_MIPMAPCOUNTEDDSCAPS_MIPMAP
		//~bv}bvǂݍ݁i_~[j
		fread(header, 1, 128, fp);
	}

	unsigned char *data = new unsigned char [width*height*4];

	for(int h=0; h<(int)height; h++){
		for(int w=0; w<(int)width; w++){
			unsigned char pixel[4];
			fread(&pixel, 1, index/8, fp);

			if( index == 16 ){		//esNZ16rbg
				data[(h*width+w)*4 + 0] = (pixel[1]<<4)&0xF0;
				data[(h*width+w)*4 + 1] = pixel[0]&0xF0;
				data[(h*width+w)*4 + 2] = (pixel[0]<<4)&0xF0;
				data[(h*width+w)*4 + 3] = pixel[1]&0xF0;
			}
			if( index == 32 ){		//esNZ32rbg
				data[(h*width+w)*4 + 0] = pixel[2];
				data[(h*width+w)*4 + 1] = pixel[1];
				data[(h*width+w)*4 + 2] = pixel[0];
				data[(h*width+w)*4 + 3] = pixel[3];
			}

			if( BlackTransparent == true ){
				//ȂΓ߂
				if( (data[(h*width+w)*4 + 0] == 0)&&(data[(h*width+w)*4 + 1] == 0)&&(data[(h*width+w)*4 + 2] == 0) ){
					data[(h*width+w)*4 + 3] = 0;
				}
			}
		}
	}

	//t@Cnh
	fclose( fp );

	//\̂ɑ
	ptexture->data = data;
	ptexture->width = width;
	ptexture->height = height;

	ptexture->useflag = true;

	return true;
}

//! @brief JPEGt@Cǂݍ
//! @param filename t@C
//! @param BlackTransparent 𓧉߂
//! @param ptexture 󂯎TEXTUREDATA\̂̃|C^
//! @return Ftrue@sFfalse
//! @attention ʏ LoadTexture()֐ ĂтƁB
bool D3DGraphics::LoadJPEGTexture(char* filename, bool BlackTransparent, TEXTUREDATA *ptexture)
{
	FILE *fp;
	JSAMPARRAY img;
	unsigned int width, height;

	//t@Cǂݍ
	fp = fopen(filename, "rb");
	if( fp == NULL ){
		return false;		//t@Cǂ߂Ȃ
	}
	jpeg_stdio_src(&cinfo, fp);

	//p[^̐ݒ
	jpeg_read_header(&cinfo, true);

	//WJJn
	jpeg_start_decompress(&cinfo);

	//̈m
	img = (JSAMPARRAY)new JSAMPROW [cinfo.output_height];
	for(int i=0; i<(int)cinfo.output_height; i++){
		img[i] = (JSAMPROW)new JSAMPLE [cinfo.output_width * cinfo.out_color_components];
	}

	//WJ
	while( cinfo.output_scanline < cinfo.output_height ) {
		jpeg_read_scanlines(&cinfo, img + cinfo.output_scanline, cinfo.output_height - cinfo.output_scanline);
	}

	//WJI
	jpeg_finish_decompress(&cinfo);


	//t@Cnh
	fclose( fp );


	// oCgz񂩂琮ǂݍ
	width = (int)cinfo.output_width;
	height = (int)cinfo.output_height;

	unsigned char *data = new unsigned char [width*height*4];

	for(int h=0; h<(int)height; h++){
		//1C擾
		JSAMPROW p = img[h];

		for(int w=0; w<(int)width; w++){
			data[(h*width+w)*4 + 0] = p[w*3 + 0];
			data[(h*width+w)*4 + 1] = p[w*3 + 1];
			data[(h*width+w)*4 + 2] = p[w*3 + 2];
			data[(h*width+w)*4 + 3] = 255;

			if( BlackTransparent == true ){
				//ȂΓ߂
				if( (data[(h*width+w)*4 + 0] == 0)&&(data[(h*width+w)*4 + 1] == 0)&&(data[(h*width+w)*4 + 2] == 0) ){
					data[(h*width+w)*4 + 3] = 0;
				}
			}

		}
	}

	//̈
	for(int i=0; i<(int)cinfo.output_height; i++){
		delete [] img[i];
	}
	delete [] img;

	//\̂ɑ
	ptexture->data = data;
	ptexture->width = width;
	ptexture->height = height;

	ptexture->useflag = true;

	return true;
}

//! @brief PNGt@Cǂݍ
//! @param filename t@C
//! @param BlackTransparent 𓧉߂
//! @param ptexture 󂯎TEXTUREDATA\̂̃|C^
//! @return Ftrue@sFfalse
//! @attention ʏ LoadTexture()֐ ĂтƁB
bool D3DGraphics::LoadPNGTexture(char* filename, bool BlackTransparent, TEXTUREDATA *ptexture)
{
	FILE *fp;
	png_byte sig[4];
	png_structp pPng;
    png_infop pInfo;
	unsigned int width, height;
	bool pallet;

	//t@Cǂݍ
	fp = fopen(filename, "rb");
	if( fp == NULL ){
		return false;		//t@Cǂ߂Ȃ
	}

	//PNGt@C
	fread(sig, 4, 1, fp);
	if( png_sig_cmp(sig, 0, 4) != 0 ){
		fclose(fp);
		return false;	//.pngł͂Ȃ
	}

	//\̂
	pPng = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
    pInfo = png_create_info_struct(pPng);

	//擾
	png_init_io(pPng, fp);
	png_set_sig_bytes(pPng, 4);
	png_read_info(pPng, pInfo);

	//eNX`̑傫擾
	width = png_get_image_width(pPng, pInfo);
	height =  png_get_image_height(pPng, pInfo);

	//C^[X
	if( png_get_interlace_type(pPng, pInfo) != PNG_INTERLACE_NONE ){
		png_destroy_read_struct(&pPng, &pInfo, (png_infopp)NULL);
		fclose(fp);
		return false;	//C^[Xɂ͑ΉȂB
	}

	//rbg[x
	if( png_get_bit_depth(pPng, pInfo) != 8 ){
		png_destroy_read_struct(&pPng, &pInfo, (png_infopp)NULL);
		fclose(fp);
		return false;	//[x8rbgȊO͑ΉĂȂB
	}

	//J[^Cv
	if( (png_get_color_type(pPng, pInfo) == PNG_COLOR_TYPE_GRAY)||(png_get_color_type(pPng, pInfo) == PNG_COLOR_TYPE_GRAY_ALPHA) ){
		png_destroy_read_struct(&pPng, &pInfo, (png_infopp)NULL);
		fclose(fp);
		return false;	//O[XP[ɂ͑ΉĂȂEEƎv̂ŏOBi؁j
	}

	//J[^Cv擾
	if( png_get_color_type(pPng, pInfo) == PNG_COLOR_TYPE_PALETTE ){
		pallet = true;
	}
	else{
		pallet = false;
	}

	unsigned char *data = new unsigned char [width*height*4];

	//At@`l
	png_set_add_alpha(pPng, 0xff, PNG_FILLER_AFTER);

	if( pallet == false ){
		// tRNS`N΁AAt@`lɕϊ
		if( png_get_valid(pPng, pInfo, PNG_INFO_tRNS) ){
			png_set_tRNS_to_alpha(pPng);
		}

		//1C̍Ɨ̈m
		png_bytep buf = new png_byte[width*4];

		for(int h=0; h<(int)height; h++){
			//1C擾
			png_read_row(pPng, buf, NULL);

			for(int w=0; w<(int)width; w++){
				data[(h*width+w)*4 + 0] = buf[w*4 + 0];
				data[(h*width+w)*4 + 1] = buf[w*4 + 1];
				data[(h*width+w)*4 + 2] = buf[w*4 + 2];
				data[(h*width+w)*4 + 3] = buf[w*4 + 3];

				if( BlackTransparent == true ){
					//ȂΓ߂
					if( (data[(h*width+w)*4 + 0] == 0)&&(data[(h*width+w)*4 + 1] == 0)&&(data[(h*width+w)*4 + 2] == 0) ){
						data[(h*width+w)*4 + 3] = 0;
					}
				}
			}
		}

		//1C̍Ɨ̈
		delete [] buf;
	}
	else{
		png_colorp palette;
		int num;

		//pbg擾
		png_get_PLTE(pPng, pInfo, &palette, &num);

		//1C̍Ɨ̈m
		png_bytep buf = new png_byte[width];

		for(int h=0; h<(int)height; h++){
			//1C擾
			png_read_row(pPng, buf, NULL);

			for(int w=0; w<(int)width; w++){
				data[(h*width+w)*4 + 0] = palette[ buf[w] ].red;
				data[(h*width+w)*4 + 1] = palette[ buf[w] ].green;
				data[(h*width+w)*4 + 2] = palette[ buf[w] ].blue;
				data[(h*width+w)*4 + 3] = 255;

				if( BlackTransparent == true ){
					//ȂΓ߂
					if( (data[(h*width+w)*4 + 0] == 0)&&(data[(h*width+w)*4 + 1] == 0)&&(data[(h*width+w)*4 + 2] == 0) ){
						data[(h*width+w)*4 + 3] = 0;
					}
				}
			}
		}

		//1C̍Ɨ̈
		delete [] buf;
	}

	//
	png_read_end(pPng, NULL);
	png_destroy_read_struct(&pPng, &pInfo, (png_infopp)NULL);

	//t@Cnh
	fclose( fp );

	//\̂ɑ
	ptexture->data = data;
	ptexture->width = width;
	ptexture->height = height;

	ptexture->useflag = true;

	return true;
}

#ifdef ENABLE_DEBUGCONSOLE
//! @brief fobNptHgǂݍ
//! @return Ftrue@sFfalse
//! @attention ̊֐ĂяoOɁAInitDebugFontData()֐sĂB
bool D3DGraphics::LoadDebugFontTexture()
{
	int charwidth = 8;
	int charheight = 16;
	int width = charwidth * 16;
	int height = charheight * 8;

	int datacnt = 0;
	int id = -1;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "eNX`", "DebugFontTexture");
#endif

	//ɓǂݍ܂ĂȂ玸s
	if( TextureDebugFont != -1 ){ return false; }

	//󂢂ĂFԍT
	for(int i=0; i<MAX_TEXTURE; i++){
		if( ptextures[i].useflag == false ){
			id = i;
			break;
		}
	}
	if( id == -1 ){ return false; }

	unsigned char *data = new unsigned char [width*height*4];

	//R[hĂ2s 32́A󗓂ɂB
	for(int cnt_y=0; cnt_y<2; cnt_y++){
		for(int line_y=0; line_y<charheight; line_y++){
			for(int cnt_x=0; cnt_x<16; cnt_x++){
				for(int line_x=0; line_x<charwidth; line_x++){
					data[datacnt + 0] = 0;
					data[datacnt + 1] = 0;
					data[datacnt + 2] = 0;
					data[datacnt + 3] = 0;

					datacnt += 4;
				}
			}
		}
	}

	//6s̃f[^쐬
	for(int cnt_y=0; cnt_y<6; cnt_y++){
		for(int line_y=0; line_y<charheight; line_y++){
			for(int cnt_x=0; cnt_x<16; cnt_x++){
				for(int line_x=(charwidth-1); line_x>=0; line_x--){
					unsigned char mask;

					//rbgp}XN쐬
					switch(line_x){
						case 0: mask = 0x01; break;
						case 1: mask = 0x02; break;
						case 2: mask = 0x04; break;
						case 3: mask = 0x08; break;
						case 4: mask = 0x10; break;
						case 5: mask = 0x20; break;
						case 6: mask = 0x40; break;
						case 7: mask = 0x80; break;
						default: mask = 0x00;		//G[
					}

					//Yrbg1Ȃ甒A0Ȃ獕B
					if( (DebugFontData[cnt_y*16 + cnt_x][line_y] & mask) != 0 ){
						data[datacnt + 0] = 255;
						data[datacnt + 1] = 255;
						data[datacnt + 2] = 255;
						data[datacnt + 3] = 255;
					}
					else{
						data[datacnt + 0] = 0;
						data[datacnt + 1] = 0;
						data[datacnt + 2] = 0;
						data[datacnt + 3] = 0;
					}

					datacnt += 4;
				}
			}
		}
	}

	//eNX`L
	glEnable(GL_TEXTURE_2D);

	HDC hDC;
	hDC = GetDC(hWnd);
	wglMakeCurrent(hDC, hGLRC);
	glGenTextures(1, &(textureobjname[id]));
	ReleaseDC(hWnd, hDC);

	glBindTexture(GL_TEXTURE_2D, textureobjname[id]);

	//OpenGLɃZbg
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);

	//~bv}bvݒ
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); 
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	//Z
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	//eNX`
	glDisable(GL_TEXTURE_2D);


	//\̂ɑ
	ptextures[id].data = data;
	ptextures[id].width = width;
	ptextures[id].height = height;

	ptextures[id].useflag = true;


#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", id);
#endif

	//eNX`IDݒ
	TextureDebugFont = id;
	return true;
}
#endif

//! @brief eNX`̃TCY擾
//! @param id eNX`Fԍ
//! @param width 󂯎|C^
//! @param height 󂯎|C^
//! @return F0@sF1
//! @attention T[tFCX̃TCY擾܂BGPUɃ[hꂽTCYłAeNX`ijƈقȂꍇ܂B
int D3DGraphics::GetTextureSize(int id, int *width, int *height)
{
	//ȔFԍw肳ĂAԂB
	if( id == -1 ){ return 1; }
	if( ptextures[id].useflag == false ){ return 1; }

	*width = ptextures[id].width;
	*height = ptextures[id].height;

	return 0;
}

//! @brief eNX`w
//! @param TextureID eNX`Fԍ
void D3DGraphics::SetTexture(int TextureID)
{
	if( now_textureid == TextureID ){
		return;
	}

	//OpenGLɃZbg
	glBindTexture(GL_TEXTURE_2D, textureobjname[TextureID]);

	now_textureid = TextureID;
}

//! @brief eNX`
//! @param id eNX`Fԍ
void D3DGraphics::CleanupTexture(int id)
{
	if( (id < 0)||((MAX_TEXTURE -1) < id) ){ return; }
	if( ptextures[id].useflag == false ){ return; }

	delete ptextures[id].data;
	glDeleteTextures(1, &(textureobjname[id]));
	ptextures[id].useflag = false;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CLEANUP, "eNX`", id);
#endif
}

//! @brief SĂ̕`揈Jn
//! @return F0@sF1
//! @attention `揈̍ŏɌĂяoKv܂B
int D3DGraphics::StartRender()
{
	HDC hDC;

	hDC = BeginPaint(hWnd, &Paint_ps);

	//ReLXgw
	wglMakeCurrent(hDC, hGLRC);

	//
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);

	//iߗLj
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	//At@eXg
	glAlphaFunc(GL_GREATER, 0.0f);
	glEnable(GL_ALPHA_TEST);

	//2DVXetHgZW
	SystemFont_posz = 1.0f;

	return 0;
}

//! @brief SĂ̕`揈I
//! @return Ffalse@sFtrue
//! @attention `揈̍ŌɌĂяoKv܂B
bool D3DGraphics::EndRender()
{
	glFlush();

	wglMakeCurrent(NULL, NULL);

	EndPaint(hWnd, &Paint_ps);

	return false;
}

//! @brief Zobt@Zbg
void D3DGraphics::ResetZbuffer()
{
	glClear(GL_DEPTH_BUFFER_BIT);
}

//! @brief [hԂ_i0,0,0jɖ߂@Ȃ
void D3DGraphics::ResetWorldTransform()
{
	float camera_y_flag;

	if( fabs(camera_ry) <= (float)M_PI/2 ){
		camera_y_flag = 1.0f;
	}
	else{
		camera_y_flag = -1.0f;
	}

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(viewangle*(180.0f/(float)M_PI), (float)width/height, CLIPPINGPLANE_NEAR, CLIPPINGPLANE_FAR);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(camera_x*-1, camera_y, camera_z, camera_x*-1 + cos(camera_rx*-1 + (float)M_PI)*cos(camera_ry), camera_y + sin(camera_ry), camera_z + sin(camera_rx*-1 + (float)M_PI)*cos(camera_ry), 0.0f, camera_y_flag, 0.0f);
}

//! @brief [hԂ̍WEpxEg嗦ݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx px
//! @param ry cpx
//! @param size g嗦
void D3DGraphics::SetWorldTransform(float x, float y, float z, float rx, float ry, float size)
{
	SetWorldTransform(x, y, z, rx, ry, 0.0f, size);
}

//! @brief [hԂ̍WEpxEg嗦ݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx px
//! @param ry1 cpx
//! @param ry2 cpx
//! @param size g嗦
void D3DGraphics::SetWorldTransform(float x, float y, float z, float rx, float ry1, float ry2, float size)
{
	ResetWorldTransform();

	glMatrixMode(GL_MODELVIEW);

	glTranslatef(x*-1, y, z);
	glRotatef(rx*-1*(180.0f/(float)M_PI), 0.0f, 1.0f, 0.0f);
	glRotatef(ry1*(180.0f/(float)M_PI), 1.0f, 0.0f, 0.0f);
	glRotatef(ry2*-1*(180.0f/(float)M_PI), 0.0f, 0.0f, 1.0f);
	glScalef(size, size, size);
}

//! @brief [hԂ̍WEpxEg嗦ݒiGtFNgpj
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param rx px
//! @param ry cpx
//! @param rt ]px
//! @param size g嗦
void D3DGraphics::SetWorldTransformEffect(float x, float y, float z, float rx, float ry, float rt, float size)
{
	ResetWorldTransform();

	glMatrixMode(GL_MODELVIEW);

	glTranslatef(x*-1, y, z);
	glRotatef(rx*-1*(180.0f/(float)M_PI), 0.0f, 1.0f, 0.0f);
	glRotatef(ry*-1*(180.0f/(float)M_PI), 0.0f, 0.0f, 1.0f);
	glRotatef(rt*(180.0f/(float)M_PI), 1.0f, 0.0f, 0.0f);
	glScalef(size, size, size);
}

//! @brief [hԂlꏊɐݒ
//! @param x XW
//! @param y YW
//! @param z ZW
//! @param mx 茳_ɂ fXW
//! @param my 茳_ɂ fYW
//! @param mz 茳_ɂ fZW
//! @param rx px
//! @param ry cpx
//! @param size g嗦
void D3DGraphics::SetWorldTransformHumanWeapon(float x, float y, float z, float mx, float my, float mz, float rx, float ry, float size)
{
	ResetWorldTransform();

	glMatrixMode(GL_MODELVIEW);

	glTranslatef(x*-1, y, z);
	glRotatef(rx*-1*(180.0f/(float)M_PI), 0.0f, 1.0f, 0.0f);
	glRotatef(ry*(180.0f/(float)M_PI), 1.0f, 0.0f, 0.0f);
	glTranslatef(mx*-1, my, mz);
	glScalef(size, size, size);
}

//! @brief [hԂĂ镐`悷ꏊɐݒ
//! @param rotation ]
//! @param camera_rx J̉px
//! @param camera_ry J̏cpx
//! @param rx ̂̏cpx
//! @param size `TCY
//! @note rotationEE@trueFݎĂ镐łB@falseF\̕łBirx ͖܂j
//! @todo ʒuTCY̔
void D3DGraphics::SetWorldTransformPlayerWeapon(bool rotation, float camera_rx, float camera_ry, float rx, float size)
{
	float screenX, screenY, screenZ;
	double modelview[16];
	double projection[16];
	int viewport[4];
	double objX, objY, objZ;

	if( rotation == true ){
		screenX = HUD_myweapon_x[0];
		screenY = SCREEN_HEIGHT - HUD_myweapon_y[0];
		screenZ = HUD_myweapon_z[0];
	}
	else{
		screenX = HUD_myweapon_x[1];
		screenY = SCREEN_HEIGHT - HUD_myweapon_y[1];
		screenZ = HUD_myweapon_z[1];
	}

	ResetWorldTransform();

	glMatrixMode(GL_MODELVIEW);

	//fr[sEesEr[|[g擾
	glGetDoublev(GL_MODELVIEW_MATRIX, modelview);
	glGetDoublev(GL_PROJECTION_MATRIX, projection);
	glGetIntegerv(GL_VIEWPORT, viewport);

	//XN[WIuWFNgW߂
	gluUnProject(screenX, screenY, screenZ, modelview, projection, viewport, &objX, &objY, &objZ);

	//size = size * 0.3f;
	size = size * (0.0004f*SCREEN_HEIGHT*SCREEN_HEIGHT - 0.92f*SCREEN_HEIGHT + 650.0f) / 1000.f;

	//svZ
	glTranslated(objX, objY, objZ);
	glRotatef(camera_rx*(180.0f/(float)M_PI), 0.0f, 1.0f, 0.0f);
	glRotatef(camera_ry*-1*(180.0f/(float)M_PI), 0.0f, 0.0f, 1.0f);
	if( rotation == true ){
		glRotatef(rx*-1*(180.0f/(float)M_PI), 0.0f, 1.0f, 0.0f);
	}
	else{
		glRotatef(180, 0.0f, 1.0f, 0.0f);
	}
	glScalef(size, size, size);
}

//! @brief [hԂ̍W擾
//! @param *x x󂯎|C^
//! @param *y y󂯎|C^
//! @param *z z󂯎|C^
void D3DGraphics::GetWorldTransformPos(float *x, float *y, float *z)
{
	GLfloat model[16];
	glMatrixMode(GL_MODELVIEW);
	glGetFloatv(GL_MODELVIEW_MATRIX, model);
	*x = model[12];
	*y = model[13];
	*z = model[14];
}

//! @brief tHOݒ
//! @param skynumber ̔ԍ
void D3DGraphics::SetFog(int skynumber)
{
	float fogColor[4];

	//̔ԍɂF
	switch(skynumber){
		case 1:		fogColor[0] = 0.25f;	fogColor[1] = 0.25f+0.0625;	fogColor[2] = 0.25f;	fogColor[3] = 1.0f;		break;
		case 2:		fogColor[0] = 0.0625;	fogColor[1] = 0.0625;		fogColor[2] = 0.0625;	fogColor[3] = 1.0f;		break;
		case 3:		fogColor[0] = 0.0f;		fogColor[1] = 0.0625;		fogColor[2] = 0.125;	fogColor[3] = 1.0f;		break;
		case 4:		fogColor[0] = 0.125;	fogColor[1] = 0.0625;		fogColor[2] = 0.0625;	fogColor[3] = 1.0f;		break;
		case 5:		fogColor[0] = 0.25f;	fogColor[1] = 0.125;		fogColor[2] = 0.125;	fogColor[3] = 1.0f;		break;
		default:	fogColor[0] = 0.0f;		fogColor[1] = 0.0f;			fogColor[2] = 0.0f;		fogColor[3] = 1.0f;		break;
	}

	float fog_st = 100;
	float fog_end = 800;
	glFogi(GL_FOG_MODE, GL_LINEAR);
	glFogfv(GL_FOG_COLOR, fogColor);
	glHint(GL_FOG_HINT, GL_NICEST);
	glFogf(GL_FOG_START, fog_st);
	glFogf(GL_FOG_END, fog_end);

	glEnable(GL_FOG);
}

//! @brief Ji_jݒ
//! @param in_camera_x JXW
//! @param in_camera_y JYW
//! @param in_camera_z JZW
//! @param in_camera_rx J̉px
//! @param in_camera_ry J̏cpxi-΁`Έȓj
//! @param in_viewangle p
void D3DGraphics::SetCamera(float in_camera_x, float in_camera_y, float in_camera_z, float in_camera_rx, float in_camera_ry, float in_viewangle)
{
	glViewport(0, 0, width, height);
	
	camera_x = in_camera_x;
	camera_y = in_camera_y;
	camera_z = in_camera_z;
	camera_rx = in_camera_rx;
	camera_ry = in_camera_ry;
	viewangle = in_viewangle;

	ResetWorldTransform();
}

//! @brief }bvf[^荞
//! @param in_blockdata ubNf[^
//! @param directory ubNf[^݂fBNg
void D3DGraphics::LoadMapdata(BlockDataInterface* in_blockdata, char *directory)
{
	//ubNf[^w肳ĂȂ΁AȂB
	if( in_blockdata == NULL ){ return; }

	char fname[MAX_PATH];
	char fnamefull[MAX_PATH];

	//NXݒ
	blockdata = in_blockdata;

	//ubN擾
	bs = blockdata->GetTotaldatas();

	//eNX`ǂݍ
	for(int i=0; i<TOTAL_BLOCKTEXTURE; i++){
		//eNX`擾
		blockdata->GetTexture(fname, i);

		if( strcmp(fname, "") == 0 ){	//w肳ĂȂ΁AȂ
			mapTextureID[i] = -1;
		}
		else{
			//ufBNg{t@Cv𐶐Aǂݍ
			strcpy(fnamefull, directory);
			strcat(fnamefull, fname);
			mapTextureID[i] = LoadTexture(fnamefull, false, false);
		}
	}
}

//! @brief }bvf[^`
//! @param wireframe C[t[\
void D3DGraphics::DrawMapdata(bool wireframe)
{
	//ubNf[^ǂݍ܂ĂȂ΁AȂB
	if( blockdata == NULL ){ return; }

	struct blockdata data;
	int textureID;
	int vID[4];
	int uvID[4];
	float *VertexAry = new float [bs*6 * 6*3];
	float *ColorAry = new float [bs*6 * 6*4];
	float *TexCoordAry = new float [bs*6 * 6*2];

	if( wireframe == true ){
		//C[t[\
		for(int i=0; i<bs; i++){
			blockdata->Getdata(&data, i);
			Drawline(data.x[0], data.y[0], data.z[0], data.x[1], data.y[1], data.z[1], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[1], data.y[1], data.z[1], data.x[2], data.y[2], data.z[2], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[2], data.y[2], data.z[2], data.x[3], data.y[3], data.z[3], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[3], data.y[3], data.z[3], data.x[0], data.y[0], data.z[0], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[4], data.y[4], data.z[4], data.x[5], data.y[5], data.z[5], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[5], data.y[5], data.z[5], data.x[6], data.y[6], data.z[6], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[6], data.y[6], data.z[6], data.x[7], data.y[7], data.z[7], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[7], data.y[7], data.z[7], data.x[4], data.y[4], data.z[4], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[0], data.y[0], data.z[0], data.x[4], data.y[4], data.z[4], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[1], data.y[1], data.z[1], data.x[5], data.y[5], data.z[5], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[2], data.y[2], data.z[2], data.x[6], data.y[6], data.z[6], GetColorCode(0.0f,1.0f,0.0f,1.0f));
			Drawline(data.x[3], data.y[3], data.z[3], data.x[7], data.y[7], data.z[7], GetColorCode(0.0f,1.0f,0.0f,1.0f));
		}
		return;
	}

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	for(textureID=0; textureID<TOTAL_BLOCKTEXTURE; textureID++){
		int cnt = 0;

		//eNX`ɓǂݍ߂ĂȂΐݒ
		if( mapTextureID[textureID] == -1 ){
			//eNX`
			glDisable(GL_TEXTURE_2D);
		}
		else if( ptextures[ mapTextureID[textureID] ].useflag == false ){
			//eNX`
			glDisable(GL_TEXTURE_2D);
		}
		else{
			//eNX`L
			glEnable(GL_TEXTURE_2D);

			//eNX`Zbg
			SetTexture(mapTextureID[textureID]);
		}

		for(int i=0; i<bs; i++){
			//f[^擾
			blockdata->Getdata(&data, i);

			for(int j=0; j<6; j++){
				//eNX`Fԍ擾
				int ID = data.material[j].textureID;

				if( textureID == ID ){
					//ʂ̒_f[^̊֘At擾
					blockdataface(j, &vID[0], &uvID[0]);

					//_zp
					VertexAry[0 + cnt*18] = data.x[ vID[1] ]*-1;		VertexAry[1 + cnt*18] = data.y[ vID[1] ];	VertexAry[2 + cnt*18] = data.z[ vID[1] ];
					VertexAry[3 + cnt*18] = data.x[ vID[1] ]*-1;		VertexAry[4 + cnt*18] = data.y[ vID[1] ];	VertexAry[5 + cnt*18] = data.z[ vID[1] ];
					VertexAry[6 + cnt*18] = data.x[ vID[0] ]*-1;		VertexAry[7 + cnt*18] = data.y[ vID[0] ];	VertexAry[8 + cnt*18] = data.z[ vID[0] ];
					VertexAry[9 + cnt*18] = data.x[ vID[2] ]*-1;		VertexAry[10 + cnt*18] = data.y[ vID[2] ];	VertexAry[11 + cnt*18] = data.z[ vID[2] ];
					VertexAry[12 + cnt*18] = data.x[ vID[3] ]*-1;		VertexAry[13 + cnt*18] = data.y[ vID[3] ];	VertexAry[14 + cnt*18] = data.z[ vID[3] ];
					VertexAry[15 + cnt*18] = data.x[ vID[3] ]*-1;		VertexAry[16 + cnt*18] = data.y[ vID[3] ];	VertexAry[17 + cnt*18] = data.z[ vID[3] ];

					//Fzp
					ColorAry[0 + cnt*24] = data.material[j].shadow;
					ColorAry[1 + cnt*24] = data.material[j].shadow;
					ColorAry[2 + cnt*24] = data.material[j].shadow;
					ColorAry[3 + cnt*24] = 1.0f;
					for(int k=1; k<6; k++){
						memcpy(&(ColorAry[k*4 + cnt*24]), &(ColorAry[cnt*24]), sizeof(float)*4);
					}

					//UVWzp
					TexCoordAry[0 + cnt*12] = data.material[j].u[ uvID[1] ];	TexCoordAry[1 + cnt*12] = data.material[j].v[ uvID[1] ];
					TexCoordAry[2 + cnt*12] = data.material[j].u[ uvID[1] ];	TexCoordAry[3 + cnt*12] = data.material[j].v[ uvID[1] ];
					TexCoordAry[4 + cnt*12] = data.material[j].u[ uvID[0] ];	TexCoordAry[5 + cnt*12] = data.material[j].v[ uvID[0] ];
					TexCoordAry[6 + cnt*12] = data.material[j].u[ uvID[2] ];	TexCoordAry[7 + cnt*12] = data.material[j].v[ uvID[2] ];
					TexCoordAry[8 + cnt*12] = data.material[j].u[ uvID[3] ];	TexCoordAry[9 + cnt*12] = data.material[j].v[ uvID[3] ];
					TexCoordAry[10 + cnt*12] = data.material[j].u[ uvID[3] ];	TexCoordAry[11 + cnt*12] = data.material[j].v[ uvID[3] ];

					cnt += 1;
				}
			}
		}

		//`
		glVertexPointer(3, GL_FLOAT, 0, VertexAry);
		glColorPointer(4, GL_FLOAT, 0, ColorAry);
		glTexCoordPointer(2, GL_FLOAT, 0, TexCoordAry);
		glDrawArrays(GL_TRIANGLE_STRIP, 1, 6*cnt-2);
	}

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

	delete [] VertexAry;
	delete [] ColorAry;
	delete [] TexCoordAry;
}

//! @brief }bveNX`擾
//! @param id eNX`ԍ
//! @return eNX`FԍisF-1j
int D3DGraphics::GetMapTextureID(int id)
{
	if( (id < 0)||((TOTAL_BLOCKTEXTURE -1) < id ) ){ return -1; }
	return mapTextureID[id];
}

//! @brief }bvf[^
void D3DGraphics::CleanupMapdata()
{
	//eNX`J
	for(int i=0; i<TOTAL_BLOCKTEXTURE; i++){
		CleanupTexture(mapTextureID[i]);
	}

	bs = 0;

	blockdata = NULL;
}

//! @brief ft@C`
//! @param id_model fFԍ
//! @param id_texture eNX`Fԍ
//! @param darkflag fÂ
void D3DGraphics::RenderModel(int id_model, int id_texture, bool darkflag)
{
	//Ȉݒ肳ĂΎs
	if( id_model == -1 ){ return; }
	if( pmodel[id_model].useflag == false ){ return; }

	//eNX`ɓǂݍ߂ĂȂΐݒ
	if( id_texture == -1 ){
		//eNX`
		glDisable(GL_TEXTURE_2D);
	}
	else if( ptextures[id_texture].useflag == false ){
		//eNX`
		glDisable(GL_TEXTURE_2D);
	}
	else{
		//eNX`L
		glEnable(GL_TEXTURE_2D);

		//eNX`Zbg
		SetTexture(id_texture);
	}

	float *ColorAry = NULL;
	if( darkflag == false ){
		ColorAry = pmodel[id_model].ColorAry;
	}
	else{
		ColorAry = pmodel[id_model].ColorGrayAry;
	}

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	//`
	glVertexPointer(3, GL_FLOAT, 0, pmodel[id_model].VertexAry);
	glColorPointer(4, GL_FLOAT, 0, ColorAry);
	glTexCoordPointer(2, GL_FLOAT, 0, pmodel[id_model].TexCoordAry);
	glDrawArrays(GL_TRIANGLE_STRIP, 1, pmodel[id_model].polygons*6-2);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

	/*
	Drawline(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
	Drawline(0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f);
	Drawline(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f);
	*/
}

//! @brief `
//! @param id_texture eNX`Fԍ
//! @param alpha x@i0.0`1.0@0.0FSj
void D3DGraphics::RenderBoard(int id_texture, float alpha)
{
	//eNX`ݒ肳ĂȂ΁AȂB
	if( id_texture == -1 ){ return; }
	if( ptextures[id_texture].useflag == false ){ return; }

	float VertexAry[4*3];
	float ColorAry[4*4];
	float TexCoordAry[4*2];

	//eNX`L
	glEnable(GL_TEXTURE_2D);

	//eNX`Zbg
	SetTexture(id_texture);

	//_zp
	VertexAry[0] = 0.0f;	VertexAry[1] = 0.5f;	VertexAry[2] = 0.5f;
	VertexAry[3] = 0.0f;	VertexAry[4] = -0.5f;	VertexAry[5] = 0.5f;
	VertexAry[6] = 0.0f;	VertexAry[7] = 0.5f;	VertexAry[8] = -0.5f;
	VertexAry[9] = 0.0f;	VertexAry[10] = -0.5f;	VertexAry[11] = -0.5f;

	//Fzp
	ColorAry[0] = 1.0f;
	ColorAry[1] = 1.0f;
	ColorAry[2] = 1.0f;
	ColorAry[3] = alpha;
	for(int i=1; i<4; i++){
		memcpy(&(ColorAry[i*4]), ColorAry, sizeof(float)*4);
	}

	//UVWzp
	TexCoordAry[0] = 1.0f;	TexCoordAry[1] = 0.0f;
	TexCoordAry[2] = 1.0f;	TexCoordAry[3] = 1.0f;
	TexCoordAry[4] = 0.0f;	TexCoordAry[5] = 0.0f;
	TexCoordAry[6] = 0.0f;	TexCoordAry[7] = 1.0f;

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	//`
	glVertexPointer(3, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_FLOAT, 0, ColorAry);
	glTexCoordPointer(2, GL_FLOAT, 0, TexCoordAry);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);
}

//! @brief ʂ̖邳ݒ
//! @param Width 
//! @param Height 
//! @param Brightness ʂ̖邳@i0 ŕsρA1 ȏŖ邳̓xj
void D3DGraphics::ScreenBrightness(int Width, int Height, int Brightness)
{
	//邳sςȂ珈Ȃiyʉj
	if( Brightness == 0 ){ return; }

	//xݒ肵A`
	float alpha = 0.02f * Brightness;
	Draw2DBox(0, 0, Width, Height, GetColorCode(1.0f,1.0f,1.0f,alpha));
}

//! @brief yfobNpzS\
void D3DGraphics::Centerline()
{
	ResetWorldTransform();
	Drawline(100.0f, 0.0f, 0.0f, -100.0f, 0.0f, 0.0f, GetColorCode(1.0f,0.0f,0.0f,1.0f));
	Drawline(0.0f, 100.0f, 0.0f, 0.0f, -100.0f, 0.0f, GetColorCode(0.0f,1.0f,0.0f,1.0f));
	Drawline(0.0f, 0.0f, 100.0f, 0.0f, 0.0f, -100.0f, GetColorCode(0.0f,0.0f,1.0f,1.0f));
}

//! @brief yfobNpz\
void D3DGraphics::Drawline(float x1, float y1, float z1, float x2, float y2, float z2, int color)
{
	float VertexAry[2*3];
	unsigned char ColorAry[2*4];

	//eNX`
	glDisable(GL_TEXTURE_2D);

	//_zp
	VertexAry[0] = (float)x1*-1;	VertexAry[1] = (float)y1;	VertexAry[2] = (float)z1;
	VertexAry[3] = (float)x2*-1;	VertexAry[4] = (float)y2;	VertexAry[5] = (float)z2;

	//Fzp
	ColorAry[0] = (color>>24)&0xFF;
	ColorAry[1] = (color>>16)&0xFF;
	ColorAry[2] = (color>>8)&0xFF;
	ColorAry[3] = color&0xFF;
	memcpy(&(ColorAry[4]), ColorAry, sizeof(unsigned char)*4);

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);

	//\
	glVertexPointer(3, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_UNSIGNED_BYTE, 0, ColorAry);
	glDrawArrays(GL_LINE_STRIP, 0, 2);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
}

//! @brief łs̕擾
//! @param str @isR[hFj
//! @return 
//! @attention }`oCg 1 2 ƂăJEg܂B
int D3DGraphics::StrMaxLineLen(char *str)
{
	int maxlen = 0;
	int cnt = 0;

	for(int i=0; i<(int)strlen(str); i++){
		if( str[i] == '\n' ){
			if( maxlen < cnt ){
				maxlen = cnt;
			}
			cnt = 0;
		}
		else{
			cnt += 1;
		}
	}

	if( maxlen < cnt ){
		maxlen = cnt;
	}

	return maxlen;
}

//! @brief \iVXetHggpj
//! @param x xW
//! @param y yW
//! @param str @isR[hFj
//! @param color F
//! @warning {֐1t[Ԃ100܂łĂяo܂BiOpenGLRÂ݁j
//! @warning <b>\͔ɒᑬłB</b>ʓŉxĂяoƃptH[}Xɉe܂B
//! @warningusR[hpxɕ\vu{ꂪKvȂ̓eNX`tHgpvȂǂ̑ΉuĂB
//! @attention tHg̎ނTCY͌ŒłB@dɏd˂ė̊oȂƌɂȂ܂B
//! @todo 1ڂꍇB
void D3DGraphics::Draw2DMSFontText(int x, int y, char *str, int color)
{
	int len = strlen(str);
	WCHAR *ustr;

	y += 18;

	Start2DRender();
	glEnable(GL_DEPTH_TEST);

	//eNX`
	glDisable(GL_TEXTURE_2D);

	//Unicode֕ϊ
	ustr = new WCHAR [len+1];
	MultiByteToWideChar(CP_ACP,	0, str, -1, ustr, len + 1);

	//VȕȂA\[X蒼
	if( lstrcmpW(ustr, now_SystemFontUStr) != 0 ){
		GLuint listIdx;
		HDC hDC;

		//Âf[^폜
		glDeleteLists(SystemFontListIdx, SystemFontListIdxSize);
		delete [] now_SystemFontUStr;

		//foCXReLXgݒ
		hDC = GetDC(hWnd);
		wglMakeCurrent(hDC, hGLRC);
		SelectObject(hDC, SystemFont);

		//fBXvCXg쐬
		listIdx = glGenLists(len);
		wglUseFontBitmapsW(hDC, ustr[0], 1, listIdx);	//_~[
		for(int i=0; i<lstrlenW(ustr); i++){
			wglUseFontBitmapsW(hDC, ustr[i], 1, listIdx+i);
		}

		//foCXReLXgp
		ReleaseDC(hWnd, hDC);

		//ݒL^
		now_SystemFontUStr = new WCHAR [len+1];
		lstrcpyW(now_SystemFontUStr, ustr);
		SystemFontListIdx = listIdx;
		SystemFontListIdxSize = len;
	}

	//WƐFݒ
	glBitmap(0, 0, 0, 0, 10, 0, NULL);
	glRasterPos3f((float)x, (float)y, SystemFont_posz);
	glColor4ub((color>>24)&0xFF, (color>>16)&0xFF, (color>>8)&0xFF, color&0xFF);

	for(int i=0; i<lstrlenW(ustr); i++){
		if( ustr[i] == '\n' ){
			//s
			y += 19;
			glRasterPos3f((float)x, (float)y, SystemFont_posz);
		}
		else{
			//fBXvCXg`
			glCallList(SystemFontListIdx + i);
		}
	}

	SystemFont_posz -= 0.01f;

	//Unicode̔p
	delete [] ustr;

	//glDisable(GL_DEPTH_TEST);
	End2DRender();
}

//! @brief 𒆉ŕ\iVXetHggpj
//! @param x xW
//! @param y yW
//! @param w ̑傫
//! @param h c̑傫
//! @param str @isR[hFj
//! @param color F
void D3DGraphics::Draw2DMSFontTextCenter(int x, int y, int w, int h, char *str, int color)
{
	//gp΍
	UNREFERENCED_PARAMETER(h);

	Draw2DMSFontText(x + (w/2 - (StrMaxLineLen(str)*9/2)), y, str, color);
}

//! @brief 2D`pݒ
void D3DGraphics::Start2DRender()
{
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0, width, height, 0, -1, 1);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	gluLookAt(0, 0, 1, 0, 0, 0, 0, 1, 0);

	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
}

//! @brief `ieNX`tHggpj
//! @param x xW
//! @param y yW
//! @param str @isR[hF<b>s</b>j
//! @param color F
//! @param fontwidth ꕶ̕
//! @param fontheight ꕶ̍
//! @attention dɏd˂ė̊oȂƌɂȂ܂B
void D3DGraphics::Draw2DTextureFontText(int x, int y, char *str, int color, int fontwidth, int fontheight)
{
	//eNX`tHg̎擾ɎsĂ΁AȂ
	if( TextureFont == -1 ){ return; }

	int strlens = (int)strlen(str);

	float *VertexAry = new float [strlens*6*2];
	unsigned char *ColorAry = new unsigned char [strlens*6*4];
	float *TexCoordAry = new float [strlens*6*2];

	//2D`pݒKp
	Start2DRender();

	int w;
	float font_u, font_v;
	float t_u, t_v;

	//1UVWvZ
	font_u = 1.0f / 16;
	font_v = 1.0f / 16;

	//eNX`L
	glEnable(GL_TEXTURE_2D);

	//eNX`Zbg
	SetTexture(TextureFont);

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	//Fzp
	ColorAry[0] = (color>>24)&0xFF;
	ColorAry[1] = (color>>16)&0xFF;
	ColorAry[2] = (color>>8)&0xFF;
	ColorAry[3] = color&0xFF;
	for(int i=1; i<strlens*6; i++){
		memcpy(&(ColorAry[i*4]), ColorAry, sizeof(unsigned char)*4);
	}

	// ^ꂽ[v
	for(int i=0; i<strlens; i++){
		//UVWvZ
		w = str[i];
		if( w < 0 ){ w += 256; }
		t_u = (w % 16) * font_u;
		t_v = (w / 16) * font_v;

		VertexAry[0 + i*12] = (float)x + i*fontwidth;			VertexAry[1 + i*12] = (float)y;
		VertexAry[2 + i*12] = (float)x + i*fontwidth;			VertexAry[3 + i*12] = (float)y;
		VertexAry[4 + i*12] = (float)x + fontwidth + i*fontwidth;	VertexAry[5 + i*12] = (float)y;
		VertexAry[6 + i*12] = (float)x + i*fontwidth;			VertexAry[7 + i*12] = (float)y + fontheight;
		VertexAry[8 + i*12] = (float)x + fontwidth + i*fontwidth;	VertexAry[9 + i*12] = (float)y + fontheight;
		VertexAry[10 + i*12] = (float)x + fontwidth + i*fontwidth;	VertexAry[11 + i*12] = (float)y + fontheight;
		TexCoordAry[0 + i*12] = t_u;		TexCoordAry[1 + i*12] = t_v;
		TexCoordAry[2 + i*12] = t_u;		TexCoordAry[3 + i*12] = t_v;
		TexCoordAry[4 + i*12] = t_u + font_u;	TexCoordAry[5 + i*12] = t_v;
		TexCoordAry[6 + i*12] = t_u;		TexCoordAry[7 + i*12] = t_v + font_v;
		TexCoordAry[8 + i*12] = t_u + font_u;	TexCoordAry[9 + i*12] = t_v + font_v;
		TexCoordAry[10 + i*12] = t_u + font_u;	TexCoordAry[11 + i*12] = t_v + font_v;
	}

	//`
	glVertexPointer(2, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_UNSIGNED_BYTE, 0, ColorAry);
	glTexCoordPointer(2, GL_FLOAT, 0, TexCoordAry);
	glDrawArrays(GL_TRIANGLE_STRIP, 1, strlens*6-2);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

	//2D`pݒ
	End2DRender();

	delete [] VertexAry;
	delete [] ColorAry;
	delete [] TexCoordAry;
}

#ifdef ENABLE_DEBUGCONSOLE
//! @brief \ifobNptHggpj
//! @param x xW
//! @param y yW
//! @param str @isR[hF<b>s</b>j
//! @param color F
//! @attention ꕶ̕э 8x16 ŒłB
//! @attention dɏd˂ė̊oȂƌɂȂ܂B
void D3DGraphics::Draw2DTextureDebugFontText(int x, int y, char *str, int color)
{
	int fontwidth = 8;
	int fontheight = 16;

	//eNX`tHg̎擾ɎsĂ΁AȂ
	if( TextureDebugFont == -1 ){ return; }

	int strlens = (int)strlen(str);

	float *VertexAry = new float [strlens*6*2];
	unsigned char *ColorAry = new unsigned char [strlens*6*4];
	float *TexCoordAry = new float [strlens*6*2];

	//2D`pݒKp
	Start2DRender();

	int w;
	float font_u, font_v;
	float t_u, t_v;

	//1UVWvZ
	font_u = 1.0f / 16;
	font_v = 1.0f / 8;

	//eNX`L
	glEnable(GL_TEXTURE_2D);

	//eNX`Zbg
	SetTexture(TextureDebugFont);

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	//Fzp
	ColorAry[0] = (color>>24)&0xFF;
	ColorAry[1] = (color>>16)&0xFF;
	ColorAry[2] = (color>>8)&0xFF;
	ColorAry[3] = color&0xFF;
	for(int i=1; i<strlens*6; i++){
		memcpy(&(ColorAry[i*4]), ColorAry, sizeof(unsigned char)*4);
	}

	// ^ꂽ[v
	for(int i=0; i<strlens; i++){
		//UVWvZ
		w = str[i];
		if( w < 0 ){ w = ' '; }
		t_u = (w % 16) * font_u;
		t_v = (w / 16) * font_v;

		VertexAry[0 + i*12] = (float)x + i*fontwidth;			VertexAry[1 + i*12] = (float)y;
		VertexAry[2 + i*12] = (float)x + i*fontwidth;			VertexAry[3 + i*12] = (float)y;
		VertexAry[4 + i*12] = (float)x + fontwidth + i*fontwidth;	VertexAry[5 + i*12] = (float)y;
		VertexAry[6 + i*12] = (float)x + i*fontwidth;			VertexAry[7 + i*12] = (float)y + fontheight;
		VertexAry[8 + i*12] = (float)x + fontwidth + i*fontwidth;	VertexAry[9 + i*12] = (float)y + fontheight;
		VertexAry[10 + i*12] = (float)x + fontwidth + i*fontwidth;	VertexAry[11 + i*12] = (float)y + fontheight;
		TexCoordAry[0 + i*12] = t_u;		TexCoordAry[1 + i*12] = t_v;
		TexCoordAry[2 + i*12] = t_u;		TexCoordAry[3 + i*12] = t_v;
		TexCoordAry[4 + i*12] = t_u + font_u;	TexCoordAry[5 + i*12] = t_v;
		TexCoordAry[6 + i*12] = t_u;		TexCoordAry[7 + i*12] = t_v + font_v;
		TexCoordAry[8 + i*12] = t_u + font_u;	TexCoordAry[9 + i*12] = t_v + font_v;
		TexCoordAry[10 + i*12] = t_u + font_u;	TexCoordAry[11 + i*12] = t_v + font_v;
	}

	//`
	glVertexPointer(2, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_UNSIGNED_BYTE, 0, ColorAry);
	glTexCoordPointer(2, GL_FLOAT, 0, TexCoordAry);
	glDrawArrays(GL_TRIANGLE_STRIP, 1, strlens*6-2);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

	//2D`pݒ
	End2DRender();

	delete [] VertexAry;
	delete [] ColorAry;
	delete [] TexCoordAry;
}
#endif

//! @brief `
//! @param x1 n_ xW
//! @param y1 n_ yW
//! @param x2 I_ xW
//! @param y2 I_ yW
//! @param color F
void D3DGraphics::Draw2DLine(int x1, int y1, int x2, int y2, int color)
{
	float VertexAry[2*2];
	unsigned char ColorAry[2*4];

	//2D`pݒKp
	Start2DRender();

	//eNX`
	glDisable(GL_TEXTURE_2D);

	//_zp
	VertexAry[0] = (float)x1;	VertexAry[1] = (float)y1;
	VertexAry[2] = (float)x2;	VertexAry[3] = (float)y2;

	//Fzp
	ColorAry[0] = (color>>24)&0xFF;
	ColorAry[1] = (color>>16)&0xFF;
	ColorAry[2] = (color>>8)&0xFF;
	ColorAry[3] = color&0xFF;
	memcpy(&(ColorAry[4]), ColorAry, sizeof(unsigned char)*4);

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);

	//`
	glVertexPointer(2, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_UNSIGNED_BYTE, 0, ColorAry);
	glDrawArrays(GL_LINE_STRIP, 0, 2);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);

	//2D`pݒ
	End2DRender();
}

//! @brief ~i16p`j`
//! @param x S xW
//! @param y S yW
//! @param r a
//! @param color F
void D3DGraphics::Draw2DCycle(int x, int y, int r, int color)
{
	float VertexAry[(16+1)*2];
	unsigned char ColorAry[(16+1)*4];

	//2D`pݒKp
	Start2DRender();

	//eNX`
	glDisable(GL_TEXTURE_2D);

	//_Wݒ
	for(int i=0; i<16+1; i++){
		float x2, y2;
		x2 = (float)x + cos((float)M_PI*2/16 * i) * r;
		y2 = (float)y + sin((float)M_PI*2/16 * i) * r;
		VertexAry[i*2] = x2;	VertexAry[i*2+1] = y2;
	}

	//Fzp
	ColorAry[0] = (color>>24)&0xFF;
	ColorAry[1] = (color>>16)&0xFF;
	ColorAry[2] = (color>>8)&0xFF;
	ColorAry[3] = color&0xFF;
	for(int i=1; i<16+1; i++){
		memcpy(&(ColorAry[i*4]), ColorAry, sizeof(unsigned char)*4);
	}

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);

	//`
	glVertexPointer(2, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_UNSIGNED_BYTE, 0, ColorAry);
	glDrawArrays(GL_LINE_STRIP, 0, 16+1);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);

	//2D`pݒ
	End2DRender();
}

//! @brief lp``
//! @param x1  xW
//! @param y1  yW
//! @param x2 E xW
//! @param y2 E yW
//! @param color F
void D3DGraphics::Draw2DBox(int x1, int y1, int x2, int y2, int color)
{
	float VertexAry[4*2];
	unsigned char ColorAry[4*4];

	//2D`pݒKp
	Start2DRender();

	//eNX`
	glDisable(GL_TEXTURE_2D);

	//_zp
	VertexAry[0] = (float)x1;	VertexAry[1] = (float)y1;
	VertexAry[2] = (float)x2;	VertexAry[3] = (float)y1;
	VertexAry[4] = (float)x1;	VertexAry[5] = (float)y2;
	VertexAry[6] = (float)x2;	VertexAry[7] = (float)y2;

	//Fzp
	ColorAry[0] = (color>>24)&0xFF;
	ColorAry[1] = (color>>16)&0xFF;
	ColorAry[2] = (color>>8)&0xFF;
	ColorAry[3] = color&0xFF;
	for(int i=1; i<4; i++){
		memcpy(&(ColorAry[i*4]), ColorAry, sizeof(unsigned char)*4);
	}

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);

	//`
	glVertexPointer(2, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_UNSIGNED_BYTE, 0, ColorAry);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);

	//2D`pݒ
	End2DRender();
}

//! @brief 摜`
//! @param x xW
//! @param y yW
//! @param id eNX`Fԍ
//! @param width 
//! @param height 
//! @param alpha xi0.0`1.0j
void D3DGraphics::Draw2DTexture(int x, int y, int id, int width, int height, float alpha)
{
	//ȃeNX`ԍw肳ĂΏȂ
	if( id == -1 ){ return; }

	float VertexAry[4*2];
	float ColorAry[4*4];
	float TexCoordAry[4*2];

	//2D`pݒKp
	Start2DRender();

	//eNX`L
	glEnable(GL_TEXTURE_2D);

	//eNX`Zbg
	SetTexture(id);

	//_zp
	VertexAry[0] = (float)x;		VertexAry[1] = (float)y;
	VertexAry[2] = (float)x+width;	VertexAry[3] = (float)y;
	VertexAry[4] = (float)x;		VertexAry[5] = (float)y+height;
	VertexAry[6] = (float)x+width;	VertexAry[7] = (float)y+height;

	//Fzp
	ColorAry[0] = 1.0f;
	ColorAry[1] = 1.0f;
	ColorAry[2] = 1.0f;
	ColorAry[3] = alpha;
	for(int i=1; i<4; i++){
		memcpy(&(ColorAry[i*4]), ColorAry, sizeof(float)*4);
	}

	//UVWzp
	TexCoordAry[0] = 0.0f;	TexCoordAry[1] = 0.0f;
	TexCoordAry[2] = 1.0f;	TexCoordAry[3] = 0.0f;
	TexCoordAry[4] = 0.0f;	TexCoordAry[5] = 1.0f;
	TexCoordAry[6] = 1.0f;	TexCoordAry[7] = 1.0f;

	//zL
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);

	//`
	glVertexPointer(2, GL_FLOAT, 0, VertexAry);
	glColorPointer(4, GL_FLOAT, 0, ColorAry);
	glTexCoordPointer(2, GL_FLOAT, 0, TexCoordAry);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

	//z񖳌
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

	//2D`pݒ
	End2DRender();
}

//! @brief 2D`pݒ
void D3DGraphics::End2DRender()
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glPopMatrix();

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);
}

//! @brief ʂ̃XN[Vbgۑ
//! @param filename t@C
//! @return Ftrue@sFfalse
bool D3DGraphics::SaveScreenShot(char* filename)
{
	HDC hDC;
	FILE *fp;
	unsigned char header[54];
	unsigned char pixel[3];

	unsigned char *dataBuffer = new unsigned char [SCREEN_WIDTH * SCREEN_HEIGHT * 3];

	//foCXReLXgݒ
	hDC = GetDC(hWnd);
	wglMakeCurrent(hDC, hGLRC);

	//obt@Ɋi[
	glReadPixels(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, GL_RGB, GL_UNSIGNED_BYTE, dataBuffer);

	//t@Cۑ
	fp = fopen(filename, "wb");
	if( fp == NULL ){
		delete [] dataBuffer;
		return false;		//t@CۑłȂ
	}

	//wb_[𐶐
	for(int i=0; i<54; i++){
		header[i] = 0x00;
	}
	header[0x00] = 'B';
	header[0x01] = 'M';
	header[0x0E] = 40;
	header[0x12] = (unsigned char)(SCREEN_WIDTH&0x000000FF);
	header[0x13] = (unsigned char)((SCREEN_WIDTH&0x0000FF00) >> 8);
	header[0x14] = (unsigned char)((SCREEN_WIDTH&0x00FF0000) >> 16);
	header[0x15] = (unsigned char)((SCREEN_WIDTH&0xFF000000) >> 24);
	header[0x16] = (unsigned char)(SCREEN_HEIGHT&0x000000FF);
	header[0x17] = (unsigned char)((SCREEN_HEIGHT&0x0000FF00) >> 8);
	header[0x18] = (unsigned char)((SCREEN_HEIGHT&0x00FF0000) >> 16);
	header[0x19] = (unsigned char)((SCREEN_HEIGHT&0xFF000000) >> 24);
	header[0x1C] = 24;

	//wb_[
	fwrite(header, 1, 54, fp);

	for(int h=0; h<SCREEN_HEIGHT; h++){
		for(int w=0; w<SCREEN_WIDTH; w++){
			pixel[2] = dataBuffer[(h*SCREEN_WIDTH+w)*3 + 0];
			pixel[1] = dataBuffer[(h*SCREEN_WIDTH+w)*3 + 1];
			pixel[0] = dataBuffer[(h*SCREEN_WIDTH+w)*3 + 2];

			fwrite(&pixel, 1, 3, fp);
		}
	}

	//t@Cnh
	fclose(fp);

	delete [] dataBuffer;

	ReleaseDC(hWnd, hDC);

	return true;
}

//! @brief J[R[h擾
//! @param red ԁi0.0f`1.0fj
//! @param green ΁i0.0f`1.0fj
//! @param blue i0.0f`1.0fj
//! @param alpha xi0.0f`1.0fj
//! @return J[R[h
int D3DGraphics::GetColorCode(float red, float green, float blue, float alpha)
{
	unsigned char red2, green2, blue2, alpha2;
	red2 = (unsigned char)(red*255);
	green2 = (unsigned char)(green*255);
	blue2 = (unsigned char)(blue*255);
	alpha2 = (unsigned char)(alpha*255);

	return (red2 << 24) | (green2 << 16) | (blue2 << 8) | alpha2;
}

#endif	//ENABLE_GRAPHICS_OPENGL