//! @file main.cpp
//! @brief WinMain()֐̒`уeXgvO 

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

//Doxygenݒt@C
#include "doxygen.h"

#include "main.h"

#ifdef _DEBUG
 #include <shlwapi.h>
 #pragma comment(lib, "Shlwapi.lib")
#endif

#ifdef ENABLE_DEBUGLOG
 //! Oo
 DebugLog OutputLog;
#endif

//! Xe[g}V
StateMachine GameState;

//! Q[ݒf[^
Config GameConfig;

//! CEChE
WindowControl MainWindow;

//! @brief WinMain()֐
int WINAPI WinMain(HINSTANCE hInstance,	HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	//gp΍
	UNREFERENCED_PARAMETER(hInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	//
	InitRand();

#ifdef _DEBUG
	//[Ňo
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	//st@ĈꏊAJgfBNgɂB
	char path[MAX_PATH];
	GetModuleFileName(NULL, path, MAX_PATH);
	PathRemoveFileSpec(path);
	SetCurrentDirectory(path);
#endif

#ifdef ENABLE_DEBUGLOG
	//FWindowsȂAlpCmdLineƂGetCommandLine()֐ł܂ǂˁEEB

	//𕪉
	for(int i=0; i<__argc; i++){

		//"log"^ĂAOo͂L
		if( strcmp(__argv[i], "log") == 0 ){
			//t@C쐬
			OutputLog.MakeLog();

			MainWindow.ErrorInfo("Enable Debug Log...");
		}
	}

	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "N", "Gg[|CgJn");
#endif

	//ݒt@Cǂݍ
	if( GameConfig.LoadFile("config.dat") == 1 ){
		MainWindow.ErrorInfo("config data open failed");
		return 1;
	}

#ifdef _DEBUG
	char str[24];
	GameConfig.GetPlayerName(str);
	MessageBox(NULL, str, "vC[", MB_OK);
#endif

	//EBhE
	MainWindow.SetParam(hPrevInstance, nCmdShow);
	MainWindow.InitWindow(GAMENAME, SCREEN_WIDTH, SCREEN_HEIGHT, GameConfig.GetFullscreenFlag());

	//{Iȏ
	if( InitGame(&MainWindow) ){
		return 1;
	}

	opening Opening;
	mainmenu MainMenu;
	briefing Briefing;
	maingame MainGame;
	result Result;
	InitScreen(&Opening, &MainMenu, &Briefing, &MainGame, &Result);


#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "N", "C[v˓");
#endif

	unsigned int framecnt = 0;

	for(int flag = 0; flag != -1; flag = MainWindow.CheckMainLoop()){
		if( flag == 1 ){
			//C
			ProcessScreen(&MainWindow, &Opening, &MainMenu, &Briefing, &MainGame, &Result, framecnt);

			//FPS
			ControlFps();

			framecnt++;
		}
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "I", "C[vEo");
#endif


	//{Iȉ
	CleanupGame();

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_CHECK, "I", "Gg[|CgI");
#endif
	return 0;
}