//! @file debug.cpp
//! @brief DebugLogNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "debug.h"

#ifdef ENABLE_DEBUGLOG

//! @brief RXgN^
DebugLog::DebugLog()
{
	OutputFlag = false;
	strcpy(fname, GAMENAME"_log.html");
	error = false;
}

//! @brief fBXgN^
DebugLog::~DebugLog()
{
	//o̓tOLȂ΁At@CɃtb^[ǉ
	if( OutputFlag == true ){
		FILE *fp;

		fp = fopen(fname, "a");
		if( fp == NULL ){
			return;
		}

		fprintf(fp, "</table>\n");
		fprintf(fp, "</body>\n");
		fprintf(fp, "</html>\n");

		fclose(fp);
	}
}

//! @brief Ot@C̃t@CύX
//! @param name t@C
void DebugLog::SetLogName(char* name)
{
	strcpy(fname, name);
}

//! @brief Ot@CVK쐬
//! @return Ffalse@s:true
//! @warning ̊֐𐳂sȂƁANX̂삵܂B
//! @attention Ƀt@C݂ꍇA㏑ۑ܂B̃t@C͎܂B
bool DebugLog::MakeLog()
{
	FILE *fp;

	time_t timer;
	struct tm *local;

	//擾
	timer = time(NULL);
	local = localtime(&timer);


	fp = fopen(fname, "w");
	if( fp == NULL ){
		return true;
	}

	//wb_[
	fprintf(fp, "<html>\n");
	fprintf(fp, "<head>\n");
	fprintf(fp, "<title>%s %s Debug Log</title>\n", GAMENAME, GAMEVERSION);
	fprintf(fp, "<style type=text/css>\n");
	fprintf(fp, "<!--//\n");
	fprintf(fp, "body{ font-size : 12px; }\n");
	fprintf(fp, "table { font-size : 12px; }\n");
	fprintf(fp, "//-->\n");
	fprintf(fp, "</style>\n");
	fprintf(fp, "</head>\n");

	fprintf(fp, "<body>\n");

	//y[W㕔
	fprintf(fp, "<p>\n");
	fprintf(fp, "<b>%s %s sO</b><br>\n", GAMENAME, GAMEVERSION);
	fprintf(fp, "F%04dN%02d%02d@%02d%02d%02db<br>\n", local->tm_year + 1900, local->tm_mon + 1, local->tm_mday, local->tm_hour, local->tm_min, local->tm_sec);
	fprintf(fp, "</p>\n");

	fprintf(fp, "<table>\n");

	fclose(fp);

	//o̓tOL
	OutputFlag = true;

	return false;
}

//! @brief Ot@CɒǋL
//! @param tag o̓[h\萔
//! @param title ^Cg
//! @param id ID
//! @return Ffalse@s:true
//! @attention WriteLog(int tag, char* title, char* text)֐I[o[[h܂B
bool DebugLog::WriteLog(int tag, char* title, int id)
{
	//o̓tOLȂΏȂ
	if( OutputFlag == false ){ return true; }

	char str[16];
	sprintf(str, "IDF%d", id);

	//I[o[[h
	return WriteLog(tag, title, str);
}

//! @brief Ot@CɒǋL
//! @param tag o̓[h\萔
//! @param title ^Cg
//! @param text {
//! @return Ffalse@s:true
//! @attention OAiLOG_INITjǂݍ݁iLOG_LOADjw肳ꂽԂŁAiLOG_COMPLETEjw肳ȂꍇAɃG[iLOG_ERRORjL܂B
//! @attention Ȃ킿Aǂݍ݂L^ꍇAɊL^Ȃ΁AIɃG[ƂċL^܂B
bool DebugLog::WriteLog(int tag, char* title, char* text)
{
	//o̓tOLȂΏȂ
	if( OutputFlag == false ){ return true; }

	FILE *fp;

	char tagcolor[32];
	char tagstr[32];

	//񂩑fɃG[`ĂȂAG[tO
	if( (tag == LOG_COMPLETE)||(tag == LOG_ERROR) ){
		error = false;
	}

	//G[tOLȂ΁AG[̂ƂċL^B
	if( error == true ){
		error = false;
		WriteLog(LOG_ERROR, "", "");
	}

	//萔當ƐF߂
	switch(tag){
		case LOG_CHECK:
			strcpy(tagcolor, "008000");
			strcpy(tagstr, "");
			break;
		case LOG_INIT:
			strcpy(tagcolor, "FF0080");
			strcpy(tagstr, "");
			break;
		case LOG_LOAD:
			strcpy(tagcolor, "0000FF");
			strcpy(tagstr, "ǂݍ");
			break;
		case LOG_CLEANUP:
			strcpy(tagcolor, "FF8000");
			strcpy(tagstr, "");
			break;
		case LOG_COMPLETE:
			strcpy(tagcolor, "008000");
			strcpy(tagstr, "");
			break;
		case LOG_ERROR:
			strcpy(tagcolor, "FF0000");
			strcpy(tagstr, "s");
			break;
		default:
			strcpy(tagcolor, "000000");
			strcpy(tagstr, "");
	}

	fp = fopen(fname, "a");
	if( fp == NULL ){
		return true;
	}

	//݂̃~b
	fprintf(fp, "<tr><td>@%d@</td>", GetTimeMS());

	if( (tag != LOG_COMPLETE)&&(tag != LOG_ERROR) ){
		//ʏ̏
		fprintf(fp, "<td width=100><b><font color=#%s>%s</font></b></td>", tagcolor, tagstr);
		fprintf(fp, "<td width=100>%s</td><td colspan=3>%s</td>", title, text);
	}
	else{
		//EG[
		fprintf(fp, "<td colspan=2></td><td width=100><b><font color=#%s>%s</font></b></td>", tagcolor, tagstr);
		fprintf(fp, "<td>%s</td><td>%s</td>", title, text);
	}

	fprintf(fp, "</tr>\n");

	fclose(fp);

	//ǂݍ݂ȂAG[tO𗧂Ă
	if( (tag == LOG_INIT)||(tag == LOG_LOAD) ){
		error = true;
	}

	return false;
}

#endif	//ENABLE_DEBUGLOG