//! @file parameter.h
//! @brief ParameterInfoNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2016, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

// lEE ݒf[^̊mF
// @Manda@i2014N12j

#ifndef PARAMETER_H
#define PARAMETER_H

#define TOTAL_PARAMETERINFO_HUMAN 43			//!< l̐ݒ萔
#define TOTAL_HUMANTEXTURE 30					//!< l̃eNX`̍v
#define TOTAL_PARAMETERINFO_WEAPON 23			//!< ̐ݒ萔
#define TOTAL_PARAMETERINFO_SMALLOBJECT 12	//!< ̐ݒ萔
#define TOTAL_PARAMETERINFO_BULLET 2		//!< eeIuWFNg̐ݒ萔
#define TOTAL_OFFICIALMISSION 58			//!< W~bV̐
#define TOTAL_PARAMETERINFO_AILEVEL 6		//!< AIx̐ݒ萔

#define ID_WEAPON_NONE 0		//!< FȂ ƂĎ舵ԍ
#define ID_WEAPON_GRENADE 13	//!< ֒eƂĎ舵ԍ
#define ID_WEAPON_CASE 15		//!< P[XƂĎ舵ԍ

#define SMALLOBJECT_SCALE 5.0f				//!< ̕\{

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 1		//!< Select include file.
#endif
#include "main.h"

//! lݒp̍\
struct HumanParameter{
	int texture;	//!< eNX`ԍ
	int model;		//!< fԍ
	int hp;			//!< ̗
	int AIlevel;	//!< AIx
	int Weapon[TOTAL_HAVEWEAPON];	//!< 
	int type;		//!< 
};

//! ݒp̍\
struct WeaponParameter{
	char *name;		//!< 햼
	char *model;	//!< ft@C
	char *texture;	//!< eNX`t@C
	int attacks;	//!< U
	int penetration;	//!< ђʗ
	int blazings;	//!< AˊԊu
	int speed;		//!< e
	int nbsmax;		//!< e
	int reloads;	//!< [h
	int reaction;		//!< px
	int ErrorRangeMIN;	//!< e덷 ŏ
	int ErrorRangeMAX;	//!< e덷 ő
	float mx;		//!< ëʒuFX
	float my;		//!< ëʒuFY
	float mz;		//!< ëʒuFZ
	float flashx;	//!< }YtbV̈ʒuFX
	float flashy;	//!< }YtbV̈ʒuFY
	float flashz;	//!< }YtbV̈ʒuFZ
	float yakkyou_px;	//!< 䰔ro ʒuFX
	float yakkyou_py;	//!< 䰔ro ʒuFY
	float yakkyou_pz;	//!< 䰔ro ʒuFZ
	float yakkyou_sx;	//!< 䰔ro FX
	float yakkyou_sy;	//!< 䰔ro FY
	bool blazingmode;	//!< A
	int scopemode;	//!< XR[v[h
	float size;		//!< \{
	int soundid;	//!< C̔ԍ
	int soundvolume;	//!< C̉
	bool silencer;	//!< TCT[̗L
	int WeaponP;	//!< @
	int ChangeWeapon;	//!< ؂ւ镐Ώ
	int burst;			//!< ˒e
};

//! ݒp̍\
struct SmallObjectParameter{
	char *model;	//!< f
	char *texture;	//!< eNX`
	int decide;		//!< 蔻̑傫
	int hp;			//!< ϋv
	int sound;		//!< ̌ʉԍ
	int jump;		//!< ы
};

//! eeIuWFNgp̍\
struct BulletParameter{
	char *model;	//!< f
	char *texture;	//!< eNX`
	float size;		//!< \{
};

//! AIxɂݒi\ljp\
struct AIParameter{
	int aiming;			//!< GC~O\
	int attack;			//!< U
	int search;			//!< \
	int limitserror;	//!< e덷
};

//! @brief ݒ肳ꂽlǗNX
//! @details \ߌŒ肳ꂽݒlǗ܂B
//! @details ̓Iɂ́AlEEAW~bVɊ֌WݒlȂǂłB
class ParameterInfo
{
	HumanParameter *Human;						//!< l̏i[|C^
	char *HumanTexturePath[TOTAL_HUMANTEXTURE];		//!< l̃eNX`i[|C^
	WeaponParameter *Weapon;						//!< ̏i[|C^
#ifdef ENABLE_BUG_HUMANWEAPON
	WeaponParameter *BugWeapon;						//!< oȌi[|C^
#endif
	SmallObjectParameter *SmallObject;			//!< ̏i[|C^
	BulletParameter *Bullet;						//!< eeIuWFNg̏i[|C^
	char *missionname[TOTAL_OFFICIALMISSION];		//!< W~bṼ~bVʖ
	char *missionfullname[TOTAL_OFFICIALMISSION];	//!< W~bṼ~bV
	char *missiondirectory[TOTAL_OFFICIALMISSION];	//!< W~bṼf[^fBNg
	char *missiontxt[TOTAL_OFFICIALMISSION];		//!< W~bṼt@Ci.pd1/.txtj
	AIParameter *AIlevel;						//!< AI̐\l

public:
	ParameterInfo();
	~ParameterInfo();
	void InitInfo();
	void DestroyInfo();
	int GetHuman(int id, HumanParameter *out_data);
	int GetHumanTexturePath(int id, char *out_str);
	int GetWeapon(int id, WeaponParameter *out_data);
#ifdef ENABLE_BUG_HUMANWEAPON
	int GetBugWeapon(int id, WeaponParameter *out_data);
#endif
	int GetSmallObject(int id, SmallObjectParameter *out_data);
	int GetBullet(int id, BulletParameter *out_data);
	int GetOfficialMission(int id, char *name, char *fullname, char* directory, char *txt);
	int GetAIlevel(int level, AIParameter **out_AIlevel);
};

#endif