//! @file d3dgraphics.h
//! @brief D3DGraphicsNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef DIRECTX_H
#define DIRECTX_H

#define MAX_MODEL 96		//!< ő僂f
#define MAX_TEXTURE 64		//!< őeNX`

#define CLIPPINGPLANE_NEAR 0.1f		//!< ߃Nbvʁi`悷ŏj
#define CLIPPINGPLANE_FAR 800.0f	//!< Nbvʁi`悷ő勗j

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 1		//!< Select include file.
#endif
#include "main.h"

#define BLOCKDATA_GPUMEMORY	//!< @brief ubNf[^i[郁[I @details 萔錾LFGPU[@萔錾iRgjFC[

#pragma warning(disable:4819)		//VC++xh~
#include <d3dx9.h>
#pragma warning(default:4819)

#pragma comment(lib, "d3d9.lib")
#pragma comment(lib, "d3dx9.lib")

//! 3D|S`p\
struct VERTEXTXTA
{
	D3DXVECTOR3 position;	//!< The position
	DWORD       color;		//!< The color 
	FLOAT       tu;			//!< The texture coordinates
	FLOAT       tv;			//!< The texture coordinates
};

//! 2D|S`p\
struct TLVERTX {
	FLOAT    x;		//!< position
	FLOAT    y;		//!< position
	FLOAT    z;		//!< position
	FLOAT    rhw;	//!< vector
	D3DCOLOR color;	//!< color
	FLOAT    tu;	//!< texture coordinates
	FLOAT    tv;	//!< texture coordinates
};

//! @brief ʕ`sNX
//! @details ʂ̕`@\₻ɒڊ֘A鏈s܂B
//! @details ̓IɁA3D`E2D`Eft@CeNX`Ǘ@s@\܂B
//! @details łDirectX 9gpĂ܂B
class D3DGraphics
{
	LPDIRECT3D9 pD3D;					//!< DIRECT3D9̃|C^
	LPDIRECT3DDEVICE9 pd3dDevice;		//!< DIRECT3DDEVICE9̃|C^
	float aspect;						//!< ʂ̃AXyNg
	bool fullscreenflag;				//!< tXN[\
	LPD3DXMESH pmesh[MAX_MODEL];				//!< iXt@CpjD3DXMESH̃|C^
	D3DMATERIAL9* pmaterials[MAX_MODEL];		//!< iXt@CpjD3DMATERIAL9̃|C^
	DWORD nummaterials[MAX_MODEL];				//!< iXt@Cpj}eA
	LPDIRECT3DTEXTURE9 ptextures[MAX_TEXTURE];	//!< eNX`i[

	class BlockDataInterface* blockdata;		//!< ǂݍ񂾃ubNf[^i[NXւ̃|C^
	int bs;										//!< ubN
	int mapTextureID[TOTAL_BLOCKTEXTURE];		//!< eNX`ԍ
#ifdef BLOCKDATA_GPUMEMORY
	LPDIRECT3DVERTEXBUFFER9 g_pVB;				//!< _iGPUǗj
#else
	VERTEXTXTA g_pVertices[MAX_BLOCKS][6][4];	//!< _iCPUǗj
#endif

	bool StartRenderFlag;			//!< StartRender()֐ s\tO

	LPD3DXSPRITE ptextsprite;		//!< 2DeNX`XvCg
	LPD3DXFONT pxmsfont;			//!< VXetHg
	int TextureFont;				//!< eNX`tHg̃eNX`ID
	int TextureFont_width;			//!< eNX`tHgt@C̉
	int TextureFont_height;			//!< eNX`tHgt@C̍

	void Start2DMSFontTextRender();
	void End2DMSFontTextRender();
	void Start2DRender();
	void End2DRender();

public:
	D3DGraphics();
	~D3DGraphics();
	int InitD3D(HWND hWnd, char *TextureFontFilename, bool fullscreen);
	//int ResetD3D(HWND hWnd);
	int LoadModel(char* filename);
	int MorphingModel(int idA, int idB);
	void CleanupModel(int id);
	int LoadTexture(char* filename, bool texturefont, bool BlackTransparent);
	int GetTextureSize(int id, int *width, int *height);
	void CleanupTexture(int id);
	int StartRender();
	void EndRender();
	void ResetZbuffer();
	void ResetWorldTransform();
	void SetWorldTransform(float x, float y, float z, float rx, float ry, float size);
	void SetWorldTransform(float x, float y, float z, float rx, float ry1, float ry2, float size);
	void SetWorldTransformEffect(float x, float y, float z, float rx, float ry, float rt, float size);
	void SetWorldTransformHumanWeapon(float x, float y, float z, float mx, float my, float mz, float rx, float ry, float size);
	void SetWorldTransformPlayerWeapon(bool rotation, float camera_x, float camera_y, float camera_z, float camera_rx, float camera_ry, float rx, float size);
	void GetWorldTransformPos(float *x, float *y, float *z);
	void SetFog(int skynumber);
	void SetCamera(float camera_x, float camera_y, float camera_z, float camera_rx, float camera_ry, float viewangle);
	void LoadMapdata(class BlockDataInterface* in_blockdata, char *directory);
	void DrawMapdata();
	int GetMapTextureID(int id);
	void CleanupMapdata();
	void RenderModel(int id_model, int id_texture);
	void RenderBoard(int id_texture, float alpha);
	void ScreenBrightness(int Width, int Height, int Brightness);
	void Centerline();
	void Drawline(float x1, float y1, float z1, float x2, float y2, float z2);
	void Draw2DMSFontText(int x, int y, char *str, int color);
	void Draw2DMSFontTextCenter(int x, int y, int w, int h, char *str, int color);
	void Draw2DTextureFontText(int x, int y, char *str, int color, int fontwidth, int fontheight);
	void Draw2DLine(int x1, int y1, int x2, int y2, int color);
	void Draw2DBox(int x1, int y1, int x2, int y2, int color);
	void Draw2DTexture(int x, int y, int id, int width, int height, float alpha);
};

#endif