//! @file		pf_types.h
//! @brief		プラットフォーム 標準型定義ファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_TYPES_H
#define PF_TYPES_H

// C99以降のC言語標準を前提とする
#if !defined(__STDC_VERSION__) || (__STDC_VERSION__ < 199901L)
#error C99 or later is required.
#endif // !defined(__STDC_VERSION__) || (__STDC_VERSION__ < 199901L)

// 基本型
#include <stdint.h>

//! 論理型
typedef _Bool		BOOL;

//! 論理型(TRUE)
#define TRUE		(1)

//! 論理型(FALSE)
#define FALSE		(0)

//! NULLポインタ
#ifndef NULL
#define NULL		((void*)0)
#endif	// NULL

//! 符号なし8bit整数型
typedef uint8_t		u1;

//! 符号なし16bit整数型
typedef uint16_t	u2;

//! 符号なし32bit整数型
typedef uint32_t	u4;

//! 符号つき8bit整数型
typedef int8_t		s1;

//! 符号つき16bit整数型
typedef int16_t		s2;

//! 符号つき32bit整数型
typedef int32_t		s4;

//! 浮動小数点型(単精度)
typedef float		f4;

//! 浮動小数点型(倍精度)
typedef double		f8;

#endif	// PF_TYPES_H
