//! @file		pf_neopixel.h
//! @brief		プラットフォーム(NeoPixel)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_NEOPIXEL_H
#define PF_NEOPIXEL_H

#include "pf_types.h"

//! @brief		NeoPixelカラー構造体
//! @details	消費電力を考慮し7bitとしているが、各々32以下の値に設定することを推奨する
typedef struct PF_NEOPIXEL_COLOR_Tag
{
	u1				r;						//!< R(赤色レベル)(0～127)
	u1				g;						//!< G(緑色レベル)(0～127)
	u1				b;						//!< B(青色レベル)(0～127)
} PF_NEOPIXEL_COLOR;

//! @brief		NeoPixelのID
typedef enum PF_NEOPIXEL_ID_Tag
{
	PF_NEOPIXEL_ID_RGB0,					//!< 前方左側
	PF_NEOPIXEL_ID_RGB1,					//!< 後方左側
	PF_NEOPIXEL_ID_RGB2,					//!< 後方右側
	PF_NEOPIXEL_ID_RGB3,					//!< 前方右側
	PF_NEOPIXEL_ID_MAX,						//!< (IDの個数を表す)
} PF_NEOPIXEL_ID;

//! @brief		NeoPixel初期化
//! @remarks	プラットフォーム初期化処理から呼び出すこと
void pf_neopixel_init(void);

//! @brief		NeoPixel定期タスク
//! @remarks	プラットフォーム定期タスク(出力系)処理から呼び出すこと
void pf_neopixel_task(void);

//! @brief		NeoPixel制御
//! @param		[in] id			NeoPixelのID
//! @param		[in] color		NeoPixelカラー構造体へのポインタ
void pf_neopixel_ctrl(PF_NEOPIXEL_ID id, const PF_NEOPIXEL_COLOR *color);

#endif  // PF_NEXOPIXEL_H
