//! @file		pf_music.h
//! @brief		プラットフォーム(音楽演奏)ヘッダファイル

// The MIT License (MIT)
// Copyright (c) 2023 @xm6_original
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef PF_MUSIC_H
#define PF_MUSIC_H

#include "pf_types.h"

//! @brief		音楽演奏デバイス
typedef enum PF_MUSIC_DEVICE_Tag
{
	PF_MUSIC_DEVICE_INTERNAL,				//!< 内蔵スピーカー
	PF_MUSIC_DEVICE_MAQUEEN,				//!< MAQUEENスピーカー(スイッチでON/OFF可)
	PF_MUSIC_DEVICE_MAX,					//!< (デバイスの個数を表す)
} PF_MUSIC_DEVICE;

//! @brief		音楽演奏初期化
//! @remarks	プラットフォーム初期化処理から呼び出すこと
//! @attention	GPIO初期化およびTimer初期化の後に呼び出すこと
void pf_music_init(void);

//! @brief		音楽演奏開始
void pf_music_play(void);

//! @brief		音楽演奏停止
void pf_music_stop(void);

#endif  // PF_MUSIC_H
