/***********************************************************************/
/*                                                                     */
/*                                                                     */
/*                                                                     */
/*  DESCRIPTION :define the sfr register. (for C language)             */
/*                                                                     */
/*                                                                     */
/*  This file is generated by Renesas Project Generator.               */
/*                                                                     */
/***********************************************************************/
/*******************************************************************************
*
* Device     : M16C/5M
*
* File Name  : sfr5m.h
*
* Abstract   : Definition of I/O Register.
*
* History    : 0.12  (2009-03-18) [Hardware Manual Revision : 0.12]
*            : 0.13  (2009-10-30) [Hardware Manual Revision : 0.13]
*            : 0.20  (2010-03-08) [Hardware Manual Revision : 0.20]
*            : 1.00  (2010-05-06) [Hardware Manual Revision : 1.00]
*            : 1.01  (2010-06-01) [Hardware Manual Revision : 1.00]
*            : 1.02  (2010-06-30) [Hardware Manual Revision : 1.01]
*
* NOTE       : THIS IS A TYPICAL EXAMPLE.
*
*  Copyright (C) 2009(2010) Renesas Electronics Corporation and
*  Renesas Solutions Corp. All rights reserved.
*
*******************************************************************************/
#ifndef     _SFR5M_H_
#define     _SFR5M_H_

/********************************************************************************/
/*  Definition of access type                                                   */
/********************************************************************************/
/*------------------------------------------------------------------------------*/
/*  Common body definition of BYTE(8bit) type                                   */
/*------------------------------------------------------------------------------*/
union BYTE_DEF
{
    struct {
        char    b0:1;
        char    b1:1;
        char    b2:1;
        char    b3:1;
        char    b4:1;
        char    b5:1;
        char    b6:1;
        char    b7:1;
    } bit;
    unsigned char   byte;
};

/*------------------------------------------------------------------------------*/
/*  Common body definition of WORD(16bit) type                                  */
/*------------------------------------------------------------------------------*/
union WORD_DEF
{
    struct {
        char    b0:1;
        char    b1:1;
        char    b2:1;
        char    b3:1;
        char    b4:1;
        char    b5:1;
        char    b6:1;
        char    b7:1;
        char    b8:1;
        char    b9:1;
        char    b10:1;
        char    b11:1;
        char    b12:1;
        char    b13:1;
        char    b14:1;
        char    b15:1;
    } bit;
    struct {
        unsigned char   low;                        /* low  8 bit */
        unsigned char   high;                       /* high 8 bit */
    } byte;
    unsigned short  word;
};

/*------------------------------------------------------------------------------*/
/*  Common body definition of DWORD(32bit) type                                 */
/*------------------------------------------------------------------------------*/
union DWORD_DEF
{
    struct {
        char    b0:1;
        char    b1:1;
        char    b2:1;
        char    b3:1;
        char    b4:1;
        char    b5:1;
        char    b6:1;
        char    b7:1;
        char    b8:1;
        char    b9:1;
        char    b10:1;
        char    b11:1;
        char    b12:1;
        char    b13:1;
        char    b14:1;
        char    b15:1;
        char    b16:1;
        char    b17:1;
        char    b18:1;
        char    b19:1;
        char    b20:1;
        char    b21:1;
        char    b22:1;
        char    b23:1;
        char    b24:1;
        char    b25:1;
        char    b26:1;
        char    b27:1;
        char    b28:1;
        char    b29:1;
        char    b30:1;
        char    b31:1;
    } bit;
    struct {
        unsigned char   lowlow;                     /* N + 0 address data 8 bit */
        unsigned char   lowhigh;                    /* N + 1 address data 8 bit */
        unsigned char   highlow;                    /* N + 2 address data 8 bit */
        unsigned char   highhigh;                   /* N + 3 address data 8 bit */
    } byte;
    struct {
        unsigned short  low;                        /* N + 0 address data 16 bit */
        unsigned short  high;                       /* N + 2 address data 16 bit */
    } word;
    unsigned long   dword;
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN mailbox register type                                     */
/*------------------------------------------------------------------------------*/
union CANMB_DEF
{
    struct {
        unsigned char    eidll:8;                   /* EID0 -EID7  bit */
        unsigned char    eidlh:8;                   /* EID8 -EID15 bit */
        unsigned char    eidhl:2;                   /* EID16-EID17 bit */
        unsigned char    sidl:6;                    /* SID0-SID5  bit */
        unsigned char    sidh:5;                    /* SID6-SID10 bit */
        unsigned char    cdummy01:1;                /* Reserved (1bit) */
        unsigned char    rtr:1;                     /* Remote Frame Request Bit */
        unsigned char    ide:1;                     /* ID Extension Bit */
        unsigned char    cdummy02;                  /* Reserved (8bit) */
        unsigned char    dlc:4;                     /* Data Length Code */
        unsigned char    cdummy03:4;                /* Reserved (4bit) */
        unsigned char    data[8];                   /* DATA0-DATA7 byte */
        unsigned char    tsl;                       /* Time Stamp Lower Byte */
        unsigned char    tsh;                       /* Time Stamp Higher Byte */
    } mc;
    struct {
        unsigned long    eid:18;                    /* Extended ID */
        unsigned long    sid:11;                    /* Standard ID */
        unsigned long    ldummy01:3;                /* Dummy (3bit) */
        unsigned long    ldummy02;                  /* Dummy (32bit) */
        unsigned long    ldummy03;                  /* Dummy (32bit) */
        unsigned long    ldummy04;                  /* Dummy (32bit) */
    } ml;
    unsigned char   byte[16];                       /* for Byte ( 8bit) access */
    unsigned short  word[8];                        /* for Word (16bit) access */
    unsigned long   dword[4];                       /* for Dword(32bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN message control register type                             */
/*------------------------------------------------------------------------------*/
union CANMC_DEF
{
    struct {
        char    newdata:1;                          /* Successful reception flag */
        char    invaldata:1;                        /* Reception-in-progress Status Flag */
        char    msglost:1;                          /* Message Lost Flag */
        char    dummyb3:1;
        char    oneshot:1;                          /* One-shot Enable Bit */
        char    dummyb5:1;
        char    recreq:1;                           /* Receiver Mailbox Request Bit */
        char    dummyb7:1;
    } rcv;
    struct {
        char    sentdata:1;                         /* Successful transmission flag */
        char    trmactive:1;                        /* Transmission-in-progress Status Flag */
        char    trmabt:1;                           /* Successful Transmission Abort Flag */
        char    dummyb3:1;
        char    oneshot:1;                          /* One-shot Enable Bit */
        char    dummyb5:1;
        char    dummyb6:1;
        char    trmreq:1;                           /* Transmitter Mailbox Request Bit */
    } trn;
    unsigned char   byte;                           /* for Byte ( 8bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN acceptance mask register type                             */
/*------------------------------------------------------------------------------*/
union CANMK_DEF
{
    struct {
        unsigned long    eid:18;                    /* Extended ID Bit */
        unsigned long    sid:11;                    /* Standard ID Bit */
        unsigned long    ldummy01:3;                /* Reserved (3bit) */
    } ml;
    unsigned char   byte[4];                        /* for Byte ( 8bit) access */
    unsigned short  word[2];                        /* for Word (16bit) access */
    unsigned long   dword;                          /* for Dword(32bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN FIFO Received ID compare register type                    */
/*------------------------------------------------------------------------------*/
union CANRC_DEF
{
    struct {
        unsigned long    eid:18;                    /* Extended ID Bit */
        unsigned long    sid:11;                    /* Standard ID Bit */
        unsigned long    ldummy01:1;                /* Reserved (1bit) */
        unsigned long    rtr:1;                     /* Remote Frame Request Bit */
        unsigned long    ide:1;                     /* ID Extension Bit */
    } ml;
    unsigned char   byte[4];                        /* for Byte ( 8bit) access */
    unsigned short  word[2];                        /* for Word (16bit) access */
    unsigned long   dword;                          /* for Dword(32bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN DWORD(32bit) register type                                */
/*------------------------------------------------------------------------------*/
union CANDW_DEF
{
    unsigned char   byte[4];                        /* for Byte ( 8bit) access */
    unsigned short  word[2];                        /* for Word (16bit) access */
    unsigned long   dword;                          /* for Dword(32bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN control register type                                     */
/*------------------------------------------------------------------------------*/
union CANCT_DEF
{
    struct {
        unsigned char    canm:2;                    /* CAN Operating Mode Select Bit */
        unsigned char    slpm:1;                    /* CAN Sleep Mode Bit */
        unsigned char    bom:2;                     /* Bus-Off Recovery Mode Select Bit */
        unsigned char    rboc:1;                    /* Forcible Return From Bus-Off Bit */
        unsigned char    cdummy01:1;                /* Reserved (1bit) */
        unsigned char    cpe:1;                     /* CAN Port Enable Bit */
        unsigned char    mbm:1;                     /* CAN Mailbox Mode Bit */
        unsigned char    idfm:2;                    /* ID Format Mode Bit */
        unsigned char    mlm:1;                     /* Message Lost Mode Select Bit */
        unsigned char    tpm:1;                     /* Transmit Priority Mode Select Bit */
        unsigned char    tsrc:1;                    /* Time Stamp Counter Reset Bit */
        unsigned char    tsps:2;                    /* Time Stamp Prescaler Select Bit */
    } mc;
    unsigned char   byte[2];                        /* for Byte ( 8bit) access */
    unsigned short  word;                           /* for Word (16bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN Bit configuration register type                           */
/*------------------------------------------------------------------------------*/
union CANBC_DEF
{
    struct {
        unsigned char    brpl:8;
        unsigned char    brph:2;
        unsigned char    cdummy01:2;                /* Reserved (2bits) */
        unsigned char    tseg1:4;                   /* Time Segment 1 Control Bit */
        unsigned char    tseg2:3;                   /* Time Segment 2 Control Bit */
        unsigned char    cdummy02:1;                /* Reserved (1bit) */
        unsigned char    sjw:2;                     /* Resynchronization Jump Width Control Bit */
        unsigned char    cdummy03:2;                /* Reserved (2bits) */
    } mc;
    struct {
        unsigned short   brp:10;                    /* Prescaler Division Ratio Select Bit(10 bits) */
        unsigned short   sdummy01:14;               /* Dummy (14bits) */
    } ms;
    struct {
        unsigned long    bcr:24;                    /* CAN0 bit configuration register(24bits) */
    } byte3;
    unsigned char   byte[3];                        /* for Byte ( 8bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN receive FIFO control register type                        */
/*------------------------------------------------------------------------------*/
union CANRF_DEF
{
    struct {
        unsigned char    rfe:1;                     /* Receive FIFO Enable Bit */
        unsigned char    rfust:3;                   /* Receive FIFO Unread Message Number Status Bit */
        unsigned char    rfmlf:1;                   /* Receive FIFO Message Lost Flag */
        unsigned char    rffst:1;                   /* Receive FIFO Full Status Bit */
        unsigned char    rfwst:1;                   /* Receive FIFO Buffer Warning Status Bit */
        unsigned char    rfest:1;                   /* Receive FIFO Empty Status Bit */
    } mc;
    unsigned char   byte;                           /* for Byte ( 8bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN transmit FIFO control register type                       */
/*------------------------------------------------------------------------------*/
union CANTF_DEF
{
    struct {
        unsigned char    tfe:1;                     /* Transmit FIFO Enable Bit */
        unsigned char    tfust:3;                   /* Transmit FIFO Unsent Message Number Status Bit */
        unsigned char    cdummy01:2;                /* Reserved (2bits) */
        unsigned char    tffst:1;                   /* Transmit FIFO Full Status Bit */
        unsigned char    tfest:1;                   /* Transmit FIFO Empty Status Bit */
    } mc;
    unsigned char   byte;                           /* for Byte ( 8bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN mailbox search status register type                       */
/*------------------------------------------------------------------------------*/
union CANMS_DEF
{
    struct {
        unsigned char    mbnst:5;                   /* Search Result Mailbox Number Status Bit */
        unsigned char    cdummy01:2;                /* Reserved (2bits) */
        unsigned char    sest:1;                    /* Search Result Status Bit */
    } mc;
    unsigned char   byte;                           /* for Byte ( 8bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN mailbox search mode register type                         */
/*------------------------------------------------------------------------------*/
union CANSM_DEF
{
    struct {
        unsigned char    mbsm:2;                    /* Mailbox Search Mode Bit */
        unsigned char    cdummy01:6;                /* Reserved (6bits) */
    } mc;
    unsigned char   byte;                           /* for Byte ( 8bit) access */
};

/*------------------------------------------------------------------------------*/
/*  Definition of CAN test control register type                                */
/*------------------------------------------------------------------------------*/
union CANTS_DEF
{
    struct {
        unsigned char    tste:1;                    /* CAN Test Mode Enable Bit */
        unsigned char    tstm:2;                    /* CAN Test Mode Select Bit */
        unsigned char    cdummy01:5;                /* Reserved (5bits) */
    } mc;
    unsigned char   byte;                           /* for Byte ( 8bit) access */
};

/********************************************************************************/
/*  Definition of SFR                                                           */
/********************************************************************************/
/*------------------------------------------------------------------------------*/
/*  Processor Mode Register 0                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pm0_addr		0004h
union BYTE_DEF	pm0_addr;
#define		pm0				pm0_addr.byte

#define		pm03			pm0_addr.bit.b3				/* Software reset bit */

/*------------------------------------------------------------------------------*/
/*  Processor Mode Register 1                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pm1_addr		0005h
union BYTE_DEF	pm1_addr;
#define		pm1				pm1_addr.byte

#define		pm10			pm1_addr.bit.b0				/* Data flash enable bit */
#define		pm12			pm1_addr.bit.b2				/* Watchdog timer function select bit */
#define		pm17			pm1_addr.bit.b7				/* Wait bit */

/*------------------------------------------------------------------------------*/
/*  System Clock Control Register 0                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		cm0_addr		0006h
union BYTE_DEF	cm0_addr;
#define		cm0				cm0_addr.byte

#define		cm00			cm0_addr.bit.b0				/* Clock output function select bit */
#define		cm01			cm0_addr.bit.b1				/* Clock output function select bit */
#define		cm02			cm0_addr.bit.b2				/* Wait mode peripheral function clock stop bit */
#define		cm03			cm0_addr.bit.b3				/* XCIN-XCOUT drive capacity select bit */
#define		cm04			cm0_addr.bit.b4				/* Port XC select bit */
#define		cm05			cm0_addr.bit.b5				/* Main clock stop bit */
#define		cm06			cm0_addr.bit.b6				/* Main clock division select bit 0 */
#define		cm07			cm0_addr.bit.b7				/* System clock select bit */

/*------------------------------------------------------------------------------*/
/*  System Clock Control Register 1                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		cm1_addr		0007h
union BYTE_DEF	cm1_addr;
#define		cm1				cm1_addr.byte

#define		cm10			cm1_addr.bit.b0				/* All clock stop control bit */
#define		cm11			cm1_addr.bit.b1				/* System clock select bit 1 */
#define		cm13			cm1_addr.bit.b3				/* XIN-XOUT feedback register select bit */
#define		cm14			cm1_addr.bit.b4				/* 125kHz on-chip oscillator stop bit */
#define		cm15			cm1_addr.bit.b5				/* XIN-XOUT drive capacity select bit */
#define		cm16			cm1_addr.bit.b6				/* Main clock division select bit 1 */
#define		cm17			cm1_addr.bit.b7				/* Main clock division select bit 1 */

/*------------------------------------------------------------------------------*/
/*  Protect Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		prcr_addr		000Ah
union BYTE_DEF	prcr_addr;
#define		prcr			prcr_addr.byte

#define		prc0			prcr_addr.bit.b0			/* Protect bit 0 */
#define		prc1			prcr_addr.bit.b1			/* Protect bit 1 */
#define		prc2			prcr_addr.bit.b2			/* Protect bit 2 */
#define		prc3			prcr_addr.bit.b3			/* Protect bit 3 */
#define		prc6			prcr_addr.bit.b6			/* Protect bit 6 */
#define		prc7			prcr_addr.bit.b7			/* Protect bit 7 */

/*------------------------------------------------------------------------------*/
/*  Oscillation Stop Detection Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		cm2_addr		000Ch
union BYTE_DEF	cm2_addr;
#define		cm2				cm2_addr.byte

#define		cm20			cm2_addr.bit.b0				/* Oscillator stop/restart detect enable bit */
#define		cm21			cm2_addr.bit.b1				/* System clock select bit 2 */
#define		cm22			cm2_addr.bit.b2				/* Oscillator stop/restart detect flag */
#define		cm23			cm2_addr.bit.b3				/* XIN monitor flag */
#define		cm27			cm2_addr.bit.b7				/* Operation select bit(when an oscillator stop/restart is detected) */

/*------------------------------------------------------------------------------*/
/*  Program 2 Area Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		prg2c_addr		0010h
union BYTE_DEF	prg2c_addr;
#define		prg2c			prg2c_addr.byte

#define		prg2c0			prg2c_addr.bit.b0			/* Program ROM 2 disable bit */

/*------------------------------------------------------------------------------*/
/*  Peripheral Clock Select Register                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pclkr_addr		0012h
union BYTE_DEF	pclkr_addr;
#define		pclkr			pclkr_addr.byte

#define		pclk0			pclkr_addr.bit.b0			/* Timers A, B, S, multi-master I2C bus interface clock select bit(clock source for timers A , B, S,dead time timer, and multi-master I2C bus interface) */
#define		pclk1			pclkr_addr.bit.b1			/* SI/O clock select bit(clock source for UART0 to UART4) */
#define		pclk5			pclkr_addr.bit.b5			/* Clock output function extension bit */

/*------------------------------------------------------------------------------*/
/*  Clock Prescaler Reset Flag                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		cpsrf_addr		0015h
union BYTE_DEF	cpsrf_addr;
#define		cpsrf			cpsrf_addr.byte

#define		cpsr			cpsrf_addr.bit.b7			/* Clock prescaler reset flag */

/*------------------------------------------------------------------------------*/
/*  Reset Source Determine Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rstfr_addr		0018h
union BYTE_DEF	rstfr_addr;
#define		rstfr			rstfr_addr.byte

#define		hwr				rstfr_addr.bit.b1			/* Hardware reset detection flag */
#define		swr				rstfr_addr.bit.b2			/* Software reset detection flag */
#define		wdr				rstfr_addr.bit.b3			/* Watchdog timer reset detection flag */
#define		lvd2r			rstfr_addr.bit.b5			/* Voltage monitor 2 reset detection flag */
#define		osdr			rstfr_addr.bit.b6			/* Oscillation stop detection reset detection flag */

/*------------------------------------------------------------------------------*/
/*  Voltage Detector 2 Flag Register                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vcr1_addr		0019h
union BYTE_DEF	vcr1_addr;
#define		vcr1			vcr1_addr.byte

#define		vc13			vcr1_addr.bit.b3			/* Low-voltage monitor flag */

/*------------------------------------------------------------------------------*/
/*  Voltage Detector Operation Enable Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vcr2_addr		001Ah
union BYTE_DEF	vcr2_addr;
#define		vcr2			vcr2_addr.byte

#define		vc25			vcr2_addr.bit.b5			/* Voltage detector 0 enable bit */
#define		vc27			vcr2_addr.bit.b7			/* Voltage detector 2 enable bit */

/*------------------------------------------------------------------------------*/
/*  PLL Control Register 0                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		plc0_addr		001Ch
union BYTE_DEF	plc0_addr;
#define		plc0			plc0_addr.byte

#define		plc00			plc0_addr.bit.b0			/* PLL multiplying factor select bit */
#define		plc01			plc0_addr.bit.b1			/* PLL multiplying factor select bit */
#define		plc02			plc0_addr.bit.b2			/* PLL multiplying factor select bit */
#define		plc04			plc0_addr.bit.b4			/* Reference frequency counter set bit */
#define		plc05			plc0_addr.bit.b5			/* Reference frequency counter set bit */
#define		plc07			plc0_addr.bit.b7			/* Operation enable bit */

/*------------------------------------------------------------------------------*/
/*  Processor Mode Register 2                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pm2_addr		001Eh
union BYTE_DEF	pm2_addr;
#define		pm2				pm2_addr.byte

#define		pm21			pm2_addr.bit.b1				/* System clock protection bit */
#define		pm24			pm2_addr.bit.b4				/* NMI~ interrupt enable bit */
#define		pm25			pm2_addr.bit.b5				/* Peripheral clock fC provide bit */

/*------------------------------------------------------------------------------*/
/*  40 MHz On-Chip Oscillator Control Register 0                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		fra0_addr		0022h
union BYTE_DEF	fra0_addr;
#define		fra0			fra0_addr.byte

#define		fra00			fra0_addr.bit.b0			/* 40 MHz on-chip oscillator start bit */
#define		fra01			fra0_addr.bit.b1			/* On-chip oscillator select bit */

/*------------------------------------------------------------------------------*/
/*  40 MHz On-Chip Oscillator Control Register 2                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		fra2_addr		0024h
union BYTE_DEF	fra2_addr;
#define		fra2			fra2_addr.byte

#define		fra20			fra2_addr.bit.b0			/* 40 MHz on-chip oscillator division select bit */
#define		fra21			fra2_addr.bit.b1			/* 40 MHz on-chip oscillator division select bit */
#define		fra22			fra2_addr.bit.b2			/* 40 MHz on-chip oscillator division select bit */

/*------------------------------------------------------------------------------*/
/*  Voltage Monitor Function Select Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vwce_addr		0026h
union BYTE_DEF	vwce_addr;
#define		vwce			vwce_addr.byte

#define		vw12e			vwce_addr.bit.b0			/* Voltage monitor 2 enable bit */

/*------------------------------------------------------------------------------*/
/*  Voltage Detector 2 Level Select Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vd2ls_addr		0028h
union BYTE_DEF	vd2ls_addr;
#define		vd2ls			vd2ls_addr.byte

#define		vd2ls0			vd2ls_addr.bit.b0			/* Vdet2 select bit */
#define		vd2ls1			vd2ls_addr.bit.b1			/* Vdet2 select bit */
#define		vd2ls2			vd2ls_addr.bit.b2			/* Vdet2 select bit */
#define		vd2ls3			vd2ls_addr.bit.b3			/* Vdet2 select bit */

/*------------------------------------------------------------------------------*/
/*  Voltage Monitor 0 Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vw0c_addr		002Ah
union BYTE_DEF	vw0c_addr;
#define		vw0c			vw0c_addr.byte

#define		vw0c0			vw0c_addr.bit.b0			/* Voltage monitor 0 reset enable bit */

/*------------------------------------------------------------------------------*/
/*  Voltage Monitor 2 Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vw2c_addr		002Ch
union BYTE_DEF	vw2c_addr;
#define		vw2c			vw2c_addr.byte

#define		vw2c0			vw2c_addr.bit.b0			/* Voltage monitor 2 interrupt/reset enable bit */
#define		vw2c1			vw2c_addr.bit.b1			/* Voltage monitor 2 digital filter disable mode select bit */
#define		vw2c2			vw2c_addr.bit.b2			/* Voltage change detection flag */
#define		vw2c3			vw2c_addr.bit.b3			/* Watchdog timer detection flag */
#define		vw2f0			vw2c_addr.bit.b4			/* Sampling clock select bit */
#define		vw2f1			vw2c_addr.bit.b5			/* Sampling clock select bit */
#define		vw2c6			vw2c_addr.bit.b6			/* Voltage monitor 2 mode select bit */
#define		vw2c7			vw2c_addr.bit.b7			/* Voltage monitor 2 interrupt/reset generation condition select bit */

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Interrupt Control Register                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fic_addr		0041h
union BYTE_DEF	e2fic_addr;
#define		e2fic			e2fic_addr.byte

#define		ilvl0_e2fic		e2fic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_e2fic		e2fic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_e2fic		e2fic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_e2fic		e2fic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  INT7 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int7ic_addr		0042h
union BYTE_DEF	int7ic_addr;
#define		int7ic			int7ic_addr.byte

#define		ilvl0_int7ic	int7ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int7ic	int7ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int7ic	int7ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int7ic		int7ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int7ic		int7ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  Serial Bus Interface 0 Interrupt Control Register                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0ic_addr		0042h
union BYTE_DEF	ss0ic_addr;
#define		ss0ic			ss0ic_addr.byte

#define		ilvl0_ss0ic		ss0ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_ss0ic		ss0ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_ss0ic		ss0ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_ss0ic		ss0ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_ss0ic		ss0ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  INT6 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int6ic_addr		0043h
union BYTE_DEF	int6ic_addr;
#define		int6ic			int6ic_addr.byte

#define		ilvl0_int6ic	int6ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int6ic	int6ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int6ic	int6ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int6ic		int6ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int6ic		int6ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		lin0ic_addr		0043h
union BYTE_DEF	lin0ic_addr;
#define		lin0ic			lin0ic_addr.byte

#define		ilvl0_lin0ic	lin0ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_lin0ic	lin0ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_lin0ic	lin0ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_lin0ic		lin0ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_lin0ic		lin0ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  INT3 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int3ic_addr		0044h
union BYTE_DEF	int3ic_addr;
#define		int3ic			int3ic_addr.byte

#define		ilvl0_int3ic	int3ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int3ic	int3ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int3ic	int3ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int3ic		int3ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int3ic		int3ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  Timer B5 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb5ic_addr		0045h
union BYTE_DEF	tb5ic_addr;
#define		tb5ic			tb5ic_addr.byte

#define		ilvl0_tb5ic		tb5ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_tb5ic		tb5ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_tb5ic		tb5ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_tb5ic		tb5ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer B4 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb4ic_addr		0046h
union BYTE_DEF	tb4ic_addr;
#define		tb4ic			tb4ic_addr.byte

#define		ilvl0_tb4ic		tb4ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_tb4ic		tb4ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_tb4ic		tb4ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_tb4ic		tb4ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer B3 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb3ic_addr		0047h
union BYTE_DEF	tb3ic_addr;
#define		tb3ic			tb3ic_addr.byte

#define		ilvl0_tb3ic		tb3ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_tb3ic		tb3ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_tb3ic		tb3ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_tb3ic		tb3ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  INT5 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int5ic_addr		0048h
union BYTE_DEF	int5ic_addr;
#define		int5ic			int5ic_addr.byte

#define		ilvl0_int5ic	int5ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int5ic	int5ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int5ic	int5ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int5ic		int5ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int5ic		int5ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  INT4 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int4ic_addr		0049h
union BYTE_DEF	int4ic_addr;
#define		int4ic			int4ic_addr.byte

#define		ilvl0_int4ic	int4ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int4ic	int4ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int4ic	int4ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int4ic		int4ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int4ic		int4ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Bus Collision Detection Interrupt Control Register                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		bcnic_addr		004Ah
union BYTE_DEF	bcnic_addr;
#define		bcnic			bcnic_addr.byte

#define		ilvl0_bcnic		bcnic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_bcnic		bcnic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_bcnic		bcnic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_bcnic		bcnic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Task Monitoring Timer Interrupt Control Register                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tmosic_addr		004Ah
union BYTE_DEF	tmosic_addr;
#define		tmosic			tmosic_addr.byte

#define		ilvl0_tmosic	tmosic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_tmosic	tmosic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_tmosic	tmosic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_tmosic		tmosic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  DMA0 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm0ic_addr		004Bh
union BYTE_DEF	dm0ic_addr;
#define		dm0ic			dm0ic_addr.byte

#define		ilvl0_dm0ic		dm0ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_dm0ic		dm0ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_dm0ic		dm0ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_dm0ic		dm0ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  DMA1 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm1ic_addr		004Ch
union BYTE_DEF	dm1ic_addr;
#define		dm1ic			dm1ic_addr.byte

#define		ilvl0_dm1ic		dm1ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_dm1ic		dm1ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_dm1ic		dm1ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_dm1ic		dm1ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Key Input Interrupt Control Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		kupic_addr		004Dh
union BYTE_DEF	kupic_addr;
#define		kupic			kupic_addr.byte

#define		ilvl0_kupic		kupic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_kupic		kupic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_kupic		kupic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_kupic		kupic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  A/D Conversion Interrupt Control Register                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		adic_addr		004Eh
union BYTE_DEF	adic_addr;
#define		adic			adic_addr.byte

#define		ilvl0_adic		adic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_adic		adic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_adic		adic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_adic			adic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Transmit Interrupt Control Register                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s2tic_addr		004Fh
union BYTE_DEF	s2tic_addr;
#define		s2tic			s2tic_addr.byte

#define		ilvl0_s2tic		s2tic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s2tic		s2tic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s2tic		s2tic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s2tic		s2tic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Receive Interrupt Control Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s2ric_addr		0050h
union BYTE_DEF	s2ric_addr;
#define		s2ric			s2ric_addr.byte

#define		ilvl0_s2ric		s2ric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s2ric		s2ric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s2ric		s2ric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s2ric		s2ric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART0 Transmit Interrupt Control Register                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s0tic_addr		0051h
union BYTE_DEF	s0tic_addr;
#define		s0tic			s0tic_addr.byte

#define		ilvl0_s0tic		s0tic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s0tic		s0tic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s0tic		s0tic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s0tic		s0tic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Low Detection Interrupt Control Register                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0wic_addr		0051h
union BYTE_DEF	l0wic_addr;
#define		l0wic			l0wic_addr.byte

#define		ilvl0_l0wic		l0wic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_l0wic		l0wic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_l0wic		l0wic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_l0wic		l0wic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART0 Receive Interrupt Control Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s0ric_addr		0052h
union BYTE_DEF	s0ric_addr;
#define		s0ric			s0ric_addr.byte

#define		ilvl0_s0ric		s0ric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s0ric		s0ric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s0ric		s0ric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s0ric		s0ric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART1 Transmit Interrupt Control Register                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s1tic_addr		0053h
union BYTE_DEF	s1tic_addr;
#define		s1tic			s1tic_addr.byte

#define		ilvl0_s1tic		s1tic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s1tic		s1tic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s1tic		s1tic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s1tic		s1tic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART1 Receive Interrupt Control Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s1ric_addr		0054h
union BYTE_DEF	s1ric_addr;
#define		s1ric			s1ric_addr.byte

#define		ilvl0_s1ric		s1ric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s1ric		s1ric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s1ric		s1ric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s1ric		s1ric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer A0 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta0ic_addr		0055h
union BYTE_DEF	ta0ic_addr;
#define		ta0ic			ta0ic_addr.byte

#define		ilvl0_ta0ic		ta0ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_ta0ic		ta0ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_ta0ic		ta0ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_ta0ic		ta0ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer A1 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta1ic_addr		0056h
union BYTE_DEF	ta1ic_addr;
#define		ta1ic			ta1ic_addr.byte

#define		ilvl0_ta1ic		ta1ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_ta1ic		ta1ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_ta1ic		ta1ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_ta1ic		ta1ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer A2 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta2ic_addr		0057h
union BYTE_DEF	ta2ic_addr;
#define		ta2ic			ta2ic_addr.byte

#define		ilvl0_ta2ic		ta2ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_ta2ic		ta2ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_ta2ic		ta2ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_ta2ic		ta2ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer A3 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta3ic_addr		0058h
union BYTE_DEF	ta3ic_addr;
#define		ta3ic			ta3ic_addr.byte

#define		ilvl0_ta3ic		ta3ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_ta3ic		ta3ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_ta3ic		ta3ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_ta3ic		ta3ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer A4 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta4ic_addr		0059h
union BYTE_DEF	ta4ic_addr;
#define		ta4ic			ta4ic_addr.byte

#define		ilvl0_ta4ic		ta4ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_ta4ic		ta4ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_ta4ic		ta4ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_ta4ic		ta4ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer B0 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb0ic_addr		005Ah
union BYTE_DEF	tb0ic_addr;
#define		tb0ic			tb0ic_addr.byte

#define		ilvl0_tb0ic		tb0ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_tb0ic		tb0ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_tb0ic		tb0ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_tb0ic		tb0ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer B1 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb1ic_addr		005Bh
union BYTE_DEF	tb1ic_addr;
#define		tb1ic			tb1ic_addr.byte

#define		ilvl0_tb1ic		tb1ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_tb1ic		tb1ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_tb1ic		tb1ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_tb1ic		tb1ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Timer B2 Interrupt Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb2ic_addr		005Ch
union BYTE_DEF	tb2ic_addr;
#define		tb2ic			tb2ic_addr.byte

#define		ilvl0_tb2ic		tb2ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_tb2ic		tb2ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_tb2ic		tb2ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_tb2ic		tb2ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  INT0 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int0ic_addr		005Dh
union BYTE_DEF	int0ic_addr;
#define		int0ic			int0ic_addr.byte

#define		ilvl0_int0ic	int0ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int0ic	int0ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int0ic	int0ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int0ic		int0ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int0ic		int0ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  INT1 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int1ic_addr		005Eh
union BYTE_DEF	int1ic_addr;
#define		int1ic			int1ic_addr.byte

#define		ilvl0_int1ic	int1ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int1ic	int1ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int1ic	int1ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int1ic		int1ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int1ic		int1ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  INT2 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		int2ic_addr		005Fh
union BYTE_DEF	int2ic_addr;
#define		int2ic			int2ic_addr.byte

#define		ilvl0_int2ic	int2ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_int2ic	int2ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_int2ic	int2ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_int2ic		int2ic_addr.bit.b3			/* Interrupt request bit */
#define		pol_int2ic		int2ic_addr.bit.b4			/* Polarity select bit */

/*------------------------------------------------------------------------------*/
/*  DMA2 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm2ic_addr		0069h
union BYTE_DEF	dm2ic_addr;
#define		dm2ic			dm2ic_addr.byte

#define		ilvl0_dm2ic		dm2ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_dm2ic		dm2ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_dm2ic		dm2ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_dm2ic		dm2ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  DMA3 Interrupt Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm3ic_addr		006Ah
union BYTE_DEF	dm3ic_addr;
#define		dm3ic			dm3ic_addr.byte

#define		ilvl0_dm3ic		dm3ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_dm3ic		dm3ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_dm3ic		dm3ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_dm3ic		dm3ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Receive Interrupt Control Register                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1ric_addr		006Bh
union BYTE_DEF	c1ric_addr;
#define		c1ric			c1ric_addr.byte

#define		ilvl0_c1ric		c1ric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c1ric		c1ric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c1ric		c1ric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c1ric		c1ric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Transmit Interrupt Control Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1tic_addr		006Ch
union BYTE_DEF	c1tic_addr;
#define		c1tic			c1tic_addr.byte

#define		ilvl0_c1tic		c1tic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c1tic		c1tic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c1tic		c1tic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c1tic		c1tic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Receive FIFO Interrupt Control Register                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1fric_addr		006Dh
union BYTE_DEF	c1fric_addr;
#define		c1fric			c1fric_addr.byte

#define		ilvl0_c1fric	c1fric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c1fric	c1fric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c1fric	c1fric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c1fric		c1fric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Transmit FIFO Interrupt Control Register                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1ftic_addr		006Eh
union BYTE_DEF	c1ftic_addr;
#define		c1ftic			c1ftic_addr.byte

#define		ilvl0_c1ftic	c1ftic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c1ftic	c1ftic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c1ftic	c1ftic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c1ftic		c1ftic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART4 Transmit Interrupt Control Register                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s4tic_addr		006Fh
union BYTE_DEF	s4tic_addr;
#define		s4tic			s4tic_addr.byte

#define		ilvl0_s4tic		s4tic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s4tic		s4tic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s4tic		s4tic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s4tic		s4tic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Compare Interrupt Control Register                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtccic_addr		006Fh
union BYTE_DEF	rtccic_addr;
#define		rtccic			rtccic_addr.byte

#define		ilvl0_rtccic	rtccic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_rtccic	rtccic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_rtccic	rtccic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_rtccic		rtccic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART4 Receive Interrupt Control Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s4ric_addr		0070h
union BYTE_DEF	s4ric_addr;
#define		s4ric			s4ric_addr.byte

#define		ilvl0_s4ric		s4ric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s4ric		s4ric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s4ric		s4ric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s4ric		s4ric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Wakeup Interrupt Control Register                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0wic_addr		0071h
union BYTE_DEF	c0wic_addr;
#define		c0wic			c0wic_addr.byte

#define		ilvl0_c0wic		c0wic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c0wic		c0wic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c0wic		c0wic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c0wic		c0wic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART3 Transmit Interrupt Control Register                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s3tic_addr		0072h
union BYTE_DEF	s3tic_addr;
#define		s3tic			s3tic_addr.byte

#define		ilvl0_s3tic		s3tic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s3tic		s3tic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s3tic		s3tic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s3tic		s3tic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Error Interrupt Control Register                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0eic_addr		0072h
union BYTE_DEF	c0eic_addr;
#define		c0eic			c0eic_addr.byte

#define		ilvl0_c0eic		c0eic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c0eic		c0eic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c0eic		c0eic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c0eic		c0eic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  UART3 Receive Interrupt Control Register                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s3ric_addr		0073h
union BYTE_DEF	s3ric_addr;
#define		s3ric			s3ric_addr.byte

#define		ilvl0_s3ric		s3ric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_s3ric		s3ric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_s3ric		s3ric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_s3ric		s3ric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Wakeup Interrupt Control Register                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1wic_addr		0073h
union BYTE_DEF	c1wic_addr;
#define		c1wic			c1wic_addr.byte

#define		ilvl0_c1wic		c1wic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c1wic		c1wic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c1wic		c1wic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c1wic		c1wic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Cycle Interrupt Control Register                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtctic_addr		0074h
union BYTE_DEF	rtctic_addr;
#define		rtctic			rtctic_addr.byte

#define		ilvl0_rtctic	rtctic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_rtctic	rtctic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_rtctic	rtctic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_rtctic		rtctic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Error Interrupt Control Register                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1eic_addr		0074h
union BYTE_DEF	c1eic_addr;
#define		c1eic			c1eic_addr.byte

#define		ilvl0_c1eic		c1eic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c1eic		c1eic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c1eic		c1eic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c1eic		c1eic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Receive Completion Interrupt Control Register                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0ric_addr		0075h
union BYTE_DEF	c0ric_addr;
#define		c0ric			c0ric_addr.byte

#define		ilvl0_c0ric		c0ric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c0ric		c0ric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c0ric		c0ric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c0ric		c0ric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Transmit Completion Interrupt Control Register                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0tic_addr		0076h
union BYTE_DEF	c0tic_addr;
#define		c0tic			c0tic_addr.byte

#define		ilvl0_c0tic		c0tic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c0tic		c0tic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c0tic		c0tic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c0tic		c0tic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Receive FIFO Interrupt Control Register                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0fric_addr		0077h
union BYTE_DEF	c0fric_addr;
#define		c0fric			c0fric_addr.byte

#define		ilvl0_c0fric	c0fric_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c0fric	c0fric_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c0fric	c0fric_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c0fric		c0fric_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Transmit FIFO Interrupt Control Register                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0ftic_addr		0078h
union BYTE_DEF	c0ftic_addr;
#define		c0ftic			c0ftic_addr.byte

#define		ilvl0_c0ftic	c0ftic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_c0ftic	c0ftic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_c0ftic	c0ftic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_c0ftic		c0ftic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  IC/OC Interrupt 0 Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		icoc0ic_addr	0079h
union BYTE_DEF	icoc0ic_addr;
#define		icoc0ic			icoc0ic_addr.byte

#define		ilvl0_icoc0ic	icoc0ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_icoc0ic	icoc0ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_icoc0ic	icoc0ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_icoc0ic		icoc0ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  IC/OC Channel 0 Interrupt Control Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		icoch0ic_addr	007Ah
union BYTE_DEF	icoch0ic_addr;
#define		icoch0ic		icoch0ic_addr.byte

#define		ilvl0_icoch0ic	icoch0ic_addr.bit.b0		/* Interrupt priority level select bit */
#define		ilvl1_icoch0ic	icoch0ic_addr.bit.b1		/* Interrupt priority level select bit */
#define		ilvl2_icoch0ic	icoch0ic_addr.bit.b2		/* Interrupt priority level select bit */
#define		ir_icoch0ic		icoch0ic_addr.bit.b3		/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  IC/OC Interrupt 1 Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		icoc1ic_addr	007Bh
union BYTE_DEF	icoc1ic_addr;
#define		icoc1ic			icoc1ic_addr.byte

#define		ilvl0_icoc1ic	icoc1ic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_icoc1ic	icoc1ic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_icoc1ic	icoc1ic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_icoc1ic		icoc1ic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  I2C-bus Interface Interrupt Control Register                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		iicic_addr		007Bh
union BYTE_DEF	iicic_addr;
#define		iicic			iicic_addr.byte

#define		ilvl0_iicic		iicic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_iicic		iicic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_iicic		iicic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_iicic		iicic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  IC/OC Channel 1 Interrupt Control Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		icoch1ic_addr	007Ch
union BYTE_DEF	icoch1ic_addr;
#define		icoch1ic		icoch1ic_addr.byte

#define		ilvl0_icoch1ic	icoch1ic_addr.bit.b0		/* Interrupt priority level select bit */
#define		ilvl1_icoch1ic	icoch1ic_addr.bit.b1		/* Interrupt priority level select bit */
#define		ilvl2_icoch1ic	icoch1ic_addr.bit.b2		/* Interrupt priority level select bit */
#define		ir_icoch1ic		icoch1ic_addr.bit.b3		/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  SCL/SDA Interrupt Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		scldaic_addr	007Ch
union BYTE_DEF	scldaic_addr;
#define		scldaic			scldaic_addr.byte

#define		ilvl0_scldaic	scldaic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_scldaic	scldaic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_scldaic	scldaic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_scldaic		scldaic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  IC/OC Channel 2 Interrupt Control Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		icoch2ic_addr	007Dh
union BYTE_DEF	icoch2ic_addr;
#define		icoch2ic		icoch2ic_addr.byte

#define		ilvl0_icoch2ic	icoch2ic_addr.bit.b0		/* Interrupt priority level select bit */
#define		ilvl1_icoch2ic	icoch2ic_addr.bit.b1		/* Interrupt priority level select bit */
#define		ilvl2_icoch2ic	icoch2ic_addr.bit.b2		/* Interrupt priority level select bit */
#define		ir_icoch2ic		icoch2ic_addr.bit.b3		/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  IC/OC Channel 3 Interrupt Control Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		icoch3ic_addr	007Eh
union BYTE_DEF	icoch3ic_addr;
#define		icoch3ic		icoch3ic_addr.byte

#define		ilvl0_icoch3ic	icoch3ic_addr.bit.b0		/* Interrupt priority level select bit */
#define		ilvl1_icoch3ic	icoch3ic_addr.bit.b1		/* Interrupt priority level select bit */
#define		ilvl2_icoch3ic	icoch3ic_addr.bit.b2		/* Interrupt priority level select bit */
#define		ir_icoch3ic		icoch3ic_addr.bit.b3		/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  IC/OC Base Timer Interrupt Control Register                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		btic_addr		007Fh
union BYTE_DEF	btic_addr;
#define		btic			btic_addr.byte

#define		ilvl0_btic		btic_addr.bit.b0			/* Interrupt priority level select bit */
#define		ilvl1_btic		btic_addr.bit.b1			/* Interrupt priority level select bit */
#define		ilvl2_btic		btic_addr.bit.b2			/* Interrupt priority level select bit */
#define		ir_btic			btic_addr.bit.b3			/* Interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Address Register                                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fa_addr		0080h
union DWORD_DEF	e2fa_addr;
#define		e2fa			e2fa_addr.dword
#define		e2fal			e2fa_addr.word.low			/* E2dataFlash Address Register(low 16bit) */
#define		e2fah			e2fa_addr.word.high			/* E2dataFlash Address Register(high 16bit) */
#define		e2fall			e2fa_addr.byte.lowlow		/* E2dataFlash Address Register(lowlow 8bit) */
#define		e2falh			e2fa_addr.byte.lowhigh		/* E2dataFlash Address Register(lowhigh 8bit) */
#define		e2fahl			e2fa_addr.byte.highlow		/* E2dataFlash Address Register(highlow 8bit) */
#define		e2fahh			e2fa_addr.byte.highhigh		/* E2dataFlash Address Register(highhigh 8bit) */

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Command Register                                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fi_addr		0088h
union WORD_DEF	e2fi_addr;
#define		e2fi			e2fi_addr.word

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Data Register                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fd_addr		008Ch
union WORD_DEF	e2fd_addr;
#define		e2fd			e2fd_addr.word

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Mode Register                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fm_addr		0090h
union BYTE_DEF	e2fm_addr;
#define		e2fm			e2fm_addr.byte

#define		om_e2fm			e2fm_addr.bit.b0			/* Operating mode select bit */
#define		rst_e2fm		e2fm_addr.bit.b1			/* E2dataFlash reset bit */
#define		ewm_e2fm		e2fm_addr.bit.b2			/* EW mode setting bit */
#define		ecc_e2fm		e2fm_addr.bit.b7			/* ECC control bit */

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Control Register                                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fc_addr		0092h
union BYTE_DEF	e2fc_addr;
#define		e2fc			e2fc_addr.byte

#define		rie_e2fc		e2fc_addr.bit.b0			/* Ready interrupt enable bit */

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Status Register 1                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fs1_addr		0094h
union BYTE_DEF	e2fs1_addr;
#define		e2fs1			e2fs1_addr.byte

#define		omm_e2fs1		e2fs1_addr.bit.b0			/* Operating mode monitor flag */

/*------------------------------------------------------------------------------*/
/*  E2dataFlash Status Register 0                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		e2fs0_addr		00A1h
union BYTE_DEF	e2fs0_addr;
#define		e2fs0			e2fs0_addr.byte

#define		werr_e2fs0		e2fs0_addr.bit.b4			/* Program error flag */
#define		eerr_e2fs0		e2fs0_addr.bit.b5			/* Erase error flag */
#define		rdy_e2fs0		e2fs0_addr.bit.b7			/* Ready flag */

/*------------------------------------------------------------------------------*/
/*  LIN Wake-Up Baud Rate Select Register                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		lwbr_addr		0161h
union BYTE_DEF	lwbr_addr;
#define		lwbr			lwbr_addr.byte

#define		lwbr0_lwbr		lwbr_addr.bit.b0			/* Wake-up Baud Rate Select Bit */

/*------------------------------------------------------------------------------*/
/*  LIN Baud Rate Prescaler 0 Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		lbrp0_addr		0162h
union BYTE_DEF	lbrp0_addr;
#define		lbrp0			lbrp0_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN Baud Rate Prescaler 1 Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		lbrp1_addr		0163h
union BYTE_DEF	lbrp1_addr;
#define		lbrp1			lbrp1_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN Self-test Control Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		lstc_addr		0164h
union BYTE_DEF	lstc_addr;
#define		lstc			lstc_addr.byte

#define		lstm_lstc		lstc_addr.bit.b0			/* Self-test Mode Bit */

/*------------------------------------------------------------------------------*/
/*  LIN Port Clock Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		lpc_addr		0165h
union BYTE_DEF	lpc_addr;
#define		lpc				lpc_addr.byte

#define		pcks_lpc		lpc_addr.bit.b0				/* LIN Clock Source Select Bit */
#define		lpe_lpc			lpc_addr.bit.b2				/* LIN Port Enable Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Mode Register                                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0md_addr		0168h
union BYTE_DEF	l0md_addr;
#define		l0md			l0md_addr.byte

#define		lcks0_l0md		l0md_addr.bit.b2			/* LIN System Clock Select Bit */
#define		lcks1_l0md		l0md_addr.bit.b3			/* LIN System Clock Select Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Break Field Setting Register                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0brk_addr		0169h
union BYTE_DEF	l0brk_addr;
#define		l0brk			l0brk_addr.byte

#define		blt0_l0brk		l0brk_addr.bit.b0			/* Break Transmission Setting Bit */
#define		blt1_l0brk		l0brk_addr.bit.b1			/* Break Transmission Setting Bit */
#define		blt2_l0brk		l0brk_addr.bit.b2			/* Break Transmission Setting Bit */
#define		blt3_l0brk		l0brk_addr.bit.b3			/* Break Transmission Setting Bit */
#define		bdt0_l0brk		l0brk_addr.bit.b4			/* Break Delimiter Transmission Setting Bit */
#define		bdt1_l0brk		l0brk_addr.bit.b5			/* Break Delimiter Transmission Setting Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Space Setting Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0spc_addr		016Ah
union BYTE_DEF	l0spc_addr;
#define		l0spc			l0spc_addr.byte

#define		ibsh0_l0spc		l0spc_addr.bit.b0			/* Interbyte Space (Header)/Response Space Setting Bit */
#define		ibsh1_l0spc		l0spc_addr.bit.b1			/* Interbyte Space (Header)/Response Space Setting Bit */
#define		ibsh2_l0spc		l0spc_addr.bit.b2			/* Interbyte Space (Header)/Response Space Setting Bit */
#define		ibs0_l0spc		l0spc_addr.bit.b4			/* Interbyte Space Setting Bit */
#define		ibs1_l0spc		l0spc_addr.bit.b5			/* Interbyte Space Setting Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Wake-Up Setting Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0wup_addr		016Bh
union BYTE_DEF	l0wup_addr;
#define		l0wup			l0wup_addr.byte

#define		wutl0_l0wup		l0wup_addr.bit.b4			/* Wake-up Transmission Low Time Pulse Width Setting Bit */
#define		wutl1_l0wup		l0wup_addr.bit.b5			/* Wake-up Transmission Low Time Pulse Width Setting Bit */
#define		wutl2_l0wup		l0wup_addr.bit.b6			/* Wake-up Transmission Low Time Pulse Width Setting Bit */
#define		wutl3_l0wup		l0wup_addr.bit.b7			/* Wake-up Transmission Low Time Pulse Width Setting Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Interrupt Enable Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0ie_addr		016Ch
union BYTE_DEF	l0ie_addr;
#define		l0ie			l0ie_addr.byte

#define		ftcie_l0ie		l0ie_addr.bit.b0			/* Frame/Wake-up Transmit Completion Interrupt Enable Bit */
#define		frcie_l0ie		l0ie_addr.bit.b1			/* Frame/Wake-up Receive Completion Interrupt Enable Bit */
#define		errie_l0ie		l0ie_addr.bit.b2			/* Error Detection Interrupt Enable Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Error Detection Enable Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0ede_addr		016Dh
union BYTE_DEF	l0ede_addr;
#define		l0ede			l0ede_addr.byte

#define		bere_l0ede		l0ede_addr.bit.b0			/* Bit Error Detection Enable Bit */
#define		pbere_l0ede		l0ede_addr.bit.b1			/* Physical Bus Error Detection Enable Bit */
#define		ftere_l0ede		l0ede_addr.bit.b2			/* Frame Timeout Error Detection Enable Bit */
#define		fere_l0ede		l0ede_addr.bit.b3			/* Framing Error Detection Enable Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0c_addr		016Eh
union BYTE_DEF	l0c_addr;
#define		l0c				l0c_addr.byte

#define		om0_l0c			l0c_addr.bit.b0				/* LIN Reset Bit */
#define		om1_l0c			l0c_addr.bit.b1				/* LIN Mode Select Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Transmission Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0tc_addr		0170h
union BYTE_DEF	l0tc_addr;
#define		l0tc			l0tc_addr.byte

#define		fts_l0tc		l0tc_addr.bit.b0			/* Frame Transmission/Wake-up Transmission and Reception Start Bit */
#define		rts_l0tc		l0tc_addr.bit.b1			/* Response Transmission Start Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Mode Status Register                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0mst_addr		0171h
union BYTE_DEF	l0mst_addr;
#define		l0mst			l0mst_addr.byte

#define		omm0_l0mst		l0mst_addr.bit.b0			/* LIN0 Reset Status Monitor */
#define		omm1_l0mst		l0mst_addr.bit.b1			/* LIN0 Mode Status Monitor */

/*------------------------------------------------------------------------------*/
/*  LIN0 Status Register                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0st_addr		0172h
union BYTE_DEF	l0st_addr;
#define		l0st			l0st_addr.byte

#define		ftc_l0st		l0st_addr.bit.b0			/* Frame/Wake-up Transmit Completion Flag */
#define		frc_l0st		l0st_addr.bit.b1			/* Frame/Wake-up Receive Completion Flag */
#define		err_l0st		l0st_addr.bit.b3			/* Error Detection Flag */
#define		d1rc_l0st		l0st_addr.bit.b6			/* Data 1 Receive Completion Flag */
#define		htrc_l0st		l0st_addr.bit.b7			/* Header Transmit Completion Flag */

/*------------------------------------------------------------------------------*/
/*  LIN0 Error Status Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0est_addr		0173h
union BYTE_DEF	l0est_addr;
#define		l0est			l0est_addr.byte

#define		ber_l0est		l0est_addr.bit.b0			/* Bit Error Flag */
#define		pber_l0est		l0est_addr.bit.b1			/* Physical Bus Error Flag */
#define		fter_l0est		l0est_addr.bit.b2			/* Frame Timeout Error Flag */
#define		fer_l0est		l0est_addr.bit.b3			/* Framing Error Flag */
#define		cser_l0est		l0est_addr.bit.b5			/* Check Sum Error Flag */

/*------------------------------------------------------------------------------*/
/*  LIN0 Response Field Setting Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0rfc_addr		0174h
union BYTE_DEF	l0rfc_addr;
#define		l0rfc			l0rfc_addr.byte

#define		rfdl0_l0rfc		l0rfc_addr.bit.b0			/* Response Field Data Length Setting Bit */
#define		rfdl1_l0rfc		l0rfc_addr.bit.b1			/* Response Field Data Length Setting Bit */
#define		rfdl2_l0rfc		l0rfc_addr.bit.b2			/* Response Field Data Length Setting Bit */
#define		rfdl3_l0rfc		l0rfc_addr.bit.b3			/* Response Field Data Length Setting Bit */
#define		rft_l0rfc		l0rfc_addr.bit.b4			/* Response Field Transmit/Receive Direction Setting Bit */
#define		csm_l0rfc		l0rfc_addr.bit.b5			/* Check Sum Model Select Bit */
#define		fsm_l0rfc		l0rfc_addr.bit.b6			/* Frame Separate Mode Select Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 ID Buffer Register                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0idb_addr		0175h
union BYTE_DEF	l0idb_addr;
#define		l0idb			l0idb_addr.byte

#define		id0_l0idb		l0idb_addr.bit.b0			/* ID Setting Bit */
#define		id1_l0idb		l0idb_addr.bit.b1			/* ID Setting Bit */
#define		id2_l0idb		l0idb_addr.bit.b2			/* ID Setting Bit */
#define		id3_l0idb		l0idb_addr.bit.b3			/* ID Setting Bit */
#define		id4_l0idb		l0idb_addr.bit.b4			/* ID Setting Bit */
#define		id5_l0idb		l0idb_addr.bit.b5			/* ID Setting Bit */
#define		idp0_l0idb		l0idb_addr.bit.b6			/* Parity Setting Bit */
#define		idp1_l0idb		l0idb_addr.bit.b7			/* Parity Setting Bit */

/*------------------------------------------------------------------------------*/
/*  LIN0 Check Sum Buffer Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0cb_addr		0176h
union BYTE_DEF	l0cb_addr;
#define		l0cb			l0cb_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data1 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db1_addr		0178h
union BYTE_DEF	l0db1_addr;
#define		l0db1			l0db1_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data2 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db2_addr		0179h
union BYTE_DEF	l0db2_addr;
#define		l0db2			l0db2_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data3 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db3_addr		017Ah
union BYTE_DEF	l0db3_addr;
#define		l0db3			l0db3_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data4 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db4_addr		017Bh
union BYTE_DEF	l0db4_addr;
#define		l0db4			l0db4_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data5 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db5_addr		017Ch
union BYTE_DEF	l0db5_addr;
#define		l0db5			l0db5_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data6 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db6_addr		017Dh
union BYTE_DEF	l0db6_addr;
#define		l0db6			l0db6_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data7 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db7_addr		017Eh
union BYTE_DEF	l0db7_addr;
#define		l0db7			l0db7_addr.byte

/*------------------------------------------------------------------------------*/
/*  LIN0 Data8 Buffer Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		l0db8_addr		017Fh
union BYTE_DEF	l0db8_addr;
#define		l0db8			l0db8_addr.byte

/*------------------------------------------------------------------------------*/
/*  DMA0 Source Pointer                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		sar0_addr		0180h
union DWORD_DEF	sar0_addr;
#define		sar0			sar0_addr.dword
#define		sar0l			sar0_addr.byte.lowlow		/* DMA0 source address(low 8bit) */
#define		sar0m			sar0_addr.byte.lowhigh		/* DMA0 source address(mid 8bit) */
#define		sar0h			sar0_addr.byte.highlow		/* DMA0 source address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA0 Destination Pointer                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dar0_addr		0184h
union DWORD_DEF	dar0_addr;
#define		dar0			dar0_addr.dword
#define		dar0l			dar0_addr.byte.lowlow		/* DMA0 destination address(low 8bit) */
#define		dar0m			dar0_addr.byte.lowhigh		/* DMA0 destination address(mid 8bit) */
#define		dar0h			dar0_addr.byte.highlow		/* DMA0 destination address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA0 Transfer Counter                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tcr0_addr		0188h
union WORD_DEF	tcr0_addr;
#define		tcr0			tcr0_addr.word
#define		tcr0l			tcr0_addr.byte.low			/* DMA0 transfer count(low 8bit) */
#define		tcr0h			tcr0_addr.byte.high			/* DMA0 transfer count(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA0 Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm0con_addr		018Ch
union BYTE_DEF	dm0con_addr;
#define		dm0con			dm0con_addr.byte

#define		dmbit_dm0con	dm0con_addr.bit.b0			/* Transfer unit bit select bit */
#define		dmasl_dm0con	dm0con_addr.bit.b1			/* Repeat transfer mode select bit */
#define		dmas_dm0con		dm0con_addr.bit.b2			/* DMA request bit */
#define		dmae_dm0con		dm0con_addr.bit.b3			/* DMA enable bit */
#define		dsd_dm0con		dm0con_addr.bit.b4			/* Source address direction select bit */
#define		dad_dm0con		dm0con_addr.bit.b5			/* Destination address direction select bit */

/*------------------------------------------------------------------------------*/
/*  DMA1 Source Pointer                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		sar1_addr		0190h
union DWORD_DEF	sar1_addr;
#define		sar1			sar1_addr.dword
#define		sar1l			sar1_addr.byte.lowlow		/* DMA1 source address(low 8bit) */
#define		sar1m			sar1_addr.byte.lowhigh		/* DMA1 source address(mid 8bit) */
#define		sar1h			sar1_addr.byte.highlow		/* DMA1 source address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA1 Destination Pointer                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dar1_addr		0194h
union DWORD_DEF	dar1_addr;
#define		dar1			dar1_addr.dword
#define		dar1l			dar1_addr.byte.lowlow		/* DMA1 destination address(low 8bit) */
#define		dar1m			dar1_addr.byte.lowhigh		/* DMA1 destination address(mid 8bit) */
#define		dar1h			dar1_addr.byte.highlow		/* DMA1 destination address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA1 Transfer Counter                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tcr1_addr		0198h
union WORD_DEF	tcr1_addr;
#define		tcr1			tcr1_addr.word
#define		tcr1l			tcr1_addr.byte.low			/* DMA1 transfer count(low 8bit) */
#define		tcr1h			tcr1_addr.byte.high			/* DMA1 transfer count(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA1 Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm1con_addr		019Ch
union BYTE_DEF	dm1con_addr;
#define		dm1con			dm1con_addr.byte

#define		dmbit_dm1con	dm1con_addr.bit.b0			/* Transfer unit bit select bit */
#define		dmasl_dm1con	dm1con_addr.bit.b1			/* Repeat transfer mode select bit */
#define		dmas_dm1con		dm1con_addr.bit.b2			/* DMA request bit */
#define		dmae_dm1con		dm1con_addr.bit.b3			/* DMA enable bit */
#define		dsd_dm1con		dm1con_addr.bit.b4			/* Source address direction select bit */
#define		dad_dm1con		dm1con_addr.bit.b5			/* Destination address direction select bit */

/*------------------------------------------------------------------------------*/
/*  DMA2 Source Pointer                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		sar2_addr		01A0h
union DWORD_DEF	sar2_addr;
#define		sar2			sar2_addr.dword
#define		sar2l			sar2_addr.byte.lowlow		/* DMA2 source address(low 8bit) */
#define		sar2m			sar2_addr.byte.lowhigh		/* DMA2 source address(mid 8bit) */
#define		sar2h			sar2_addr.byte.highlow		/* DMA2 source address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA2 Destination Pointer                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dar2_addr		01A4h
union DWORD_DEF	dar2_addr;
#define		dar2			dar2_addr.dword
#define		dar2l			dar2_addr.byte.lowlow		/* DMA2 destination address(low 8bit) */
#define		dar2m			dar2_addr.byte.lowhigh		/* DMA2 destination address(mid 8bit) */
#define		dar2h			dar2_addr.byte.highlow		/* DMA2 destination address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA2 Transfer Counter                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tcr2_addr		01A8h
union WORD_DEF	tcr2_addr;
#define		tcr2			tcr2_addr.word
#define		tcr2l			tcr2_addr.byte.low			/* DMA2 transfer count(low 8bit) */
#define		tcr2h			tcr2_addr.byte.high			/* DMA2 transfer count(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA2 Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm2con_addr		01ACh
union BYTE_DEF	dm2con_addr;
#define		dm2con			dm2con_addr.byte

#define		dmbit_dm2con	dm2con_addr.bit.b0			/* Transfer unit bit select bit */
#define		dmasl_dm2con	dm2con_addr.bit.b1			/* Repeat transfer mode select bit */
#define		dmas_dm2con		dm2con_addr.bit.b2			/* DMA request bit */
#define		dmae_dm2con		dm2con_addr.bit.b3			/* DMA enable bit */
#define		dsd_dm2con		dm2con_addr.bit.b4			/* Source address direction select bit */
#define		dad_dm2con		dm2con_addr.bit.b5			/* Destination address direction select bit */

/*------------------------------------------------------------------------------*/
/*  DMA3 Source Pointer                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		sar3_addr		01B0h
union DWORD_DEF	sar3_addr;
#define		sar3			sar3_addr.dword
#define		sar3l			sar3_addr.byte.lowlow		/* DMA3 source address(low 8bit) */
#define		sar3m			sar3_addr.byte.lowhigh		/* DMA3 source address(mid 8bit) */
#define		sar3h			sar3_addr.byte.highlow		/* DMA3 source address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA3 Destination Pointer                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dar3_addr		01B4h
union DWORD_DEF	dar3_addr;
#define		dar3			dar3_addr.dword
#define		dar3l			dar3_addr.byte.lowlow		/* DMA3 destination address(low 8bit) */
#define		dar3m			dar3_addr.byte.lowhigh		/* DMA3 destination address(mid 8bit) */
#define		dar3h			dar3_addr.byte.highlow		/* DMA3 destination address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA3 Transfer Counter                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tcr3_addr		01B8h
union WORD_DEF	tcr3_addr;
#define		tcr3			tcr3_addr.word
#define		tcr3l			tcr3_addr.byte.low			/* DMA3 transfer count(low 8bit) */
#define		tcr3h			tcr3_addr.byte.high			/* DMA3 transfer count(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  DMA3 Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm3con_addr		01BCh
union BYTE_DEF	dm3con_addr;
#define		dm3con			dm3con_addr.byte

#define		dmbit_dm3con	dm3con_addr.bit.b0			/* Transfer unit bit select bit */
#define		dmasl_dm3con	dm3con_addr.bit.b1			/* Repeat transfer mode select bit */
#define		dmas_dm3con		dm3con_addr.bit.b2			/* DMA request bit */
#define		dmae_dm3con		dm3con_addr.bit.b3			/* DMA enable bit */
#define		dsd_dm3con		dm3con_addr.bit.b4			/* Source address direction select bit */
#define		dad_dm3con		dm3con_addr.bit.b5			/* Destination address direction select bit */

/*------------------------------------------------------------------------------*/
/*  Timer B0-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb01_addr		01C0h
union WORD_DEF	tb01_addr;
#define		tb01			tb01_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B1-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb11_addr		01C2h
union WORD_DEF	tb11_addr;
#define		tb11			tb11_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B2-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb21_addr		01C4h
union WORD_DEF	tb21_addr;
#define		tb21			tb21_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse Period/Pulse Width Measurement Mode Function Select Register 1        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ppwfs1_addr		01C6h
union BYTE_DEF	ppwfs1_addr;
#define		ppwfs1			ppwfs1_addr.byte

#define		ppwfs10			ppwfs1_addr.bit.b0			/* Timer B0 pulse period/pulse width measurement mode function select bit */
#define		ppwfs11			ppwfs1_addr.bit.b1			/* Timer B1 pulse period/pulse width measurement mode function select bit */
#define		ppwfs12			ppwfs1_addr.bit.b2			/* Timer B2 pulse period/pulse width measurement mode function select bit */

/*------------------------------------------------------------------------------*/
/*  Timer B Count Source Select Register 0                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tbcs0_addr		01C8h
union BYTE_DEF	tbcs0_addr;
#define		tbcs0			tbcs0_addr.byte

#define		tcs0_tbcs0		tbcs0_addr.bit.b0			/* TB0 count source select bit */
#define		tcs1_tbcs0		tbcs0_addr.bit.b1			/* TB0 count source select bit */
#define		tcs2_tbcs0		tbcs0_addr.bit.b2			/* TB0 count source select bit */
#define		tcs3_tbcs0		tbcs0_addr.bit.b3			/* TB0 count source option specified bit */
#define		tcs4_tbcs0		tbcs0_addr.bit.b4			/* TB1 count source select bit */
#define		tcs5_tbcs0		tbcs0_addr.bit.b5			/* TB1 count source select bit */
#define		tcs6_tbcs0		tbcs0_addr.bit.b6			/* TB1 count source select bit */
#define		tcs7_tbcs0		tbcs0_addr.bit.b7			/* TB1 count source option specified bit */

/*------------------------------------------------------------------------------*/
/*  Timer B Count Source Select Register 1                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tbcs1_addr		01C9h
union BYTE_DEF	tbcs1_addr;
#define		tbcs1			tbcs1_addr.byte

#define		tcs0_tbcs1		tbcs1_addr.bit.b0			/* TB2 count source select bit */
#define		tcs1_tbcs1		tbcs1_addr.bit.b1			/* TB2 count source select bit */
#define		tcs2_tbcs1		tbcs1_addr.bit.b2			/* TB2 count source select bit */
#define		tcs3_tbcs1		tbcs1_addr.bit.b3			/* TB2 count source option specified bit */

/*------------------------------------------------------------------------------*/
/*  Timer AB Division Control Register 0                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tckdivc0_addr	01CBh
union BYTE_DEF	tckdivc0_addr;
#define		tckdivc0		tckdivc0_addr.byte

#define		tcdiv00			tckdivc0_addr.bit.b0		/* Clock select prior to timer AB division bit */

/*------------------------------------------------------------------------------*/
/*  Timer A Count Source Select Register 0                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tacs0_addr		01D0h
union BYTE_DEF	tacs0_addr;
#define		tacs0			tacs0_addr.byte

#define		tcs0_tacs0		tacs0_addr.bit.b0			/* TA0 count source select bit */
#define		tcs1_tacs0		tacs0_addr.bit.b1			/* TA0 count source select bit */
#define		tcs2_tacs0		tacs0_addr.bit.b2			/* TA0 count source select bit */
#define		tcs3_tacs0		tacs0_addr.bit.b3			/* TA0 count source option specified bit */
#define		tcs4_tacs0		tacs0_addr.bit.b4			/* TA1 count source select bit */
#define		tcs5_tacs0		tacs0_addr.bit.b5			/* TA1 count source select bit */
#define		tcs6_tacs0		tacs0_addr.bit.b6			/* TA1 count source select bit */
#define		tcs7_tacs0		tacs0_addr.bit.b7			/* TA1 count source option specified bit */

/*------------------------------------------------------------------------------*/
/*  Timer A Count Source Select Register 1                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tacs1_addr		01D1h
union BYTE_DEF	tacs1_addr;
#define		tacs1			tacs1_addr.byte

#define		tcs0_tacs1		tacs1_addr.bit.b0			/* TA2 count source select bit */
#define		tcs1_tacs1		tacs1_addr.bit.b1			/* TA2 count source select bit */
#define		tcs2_tacs1		tacs1_addr.bit.b2			/* TA2 count source select bit */
#define		tcs3_tacs1		tacs1_addr.bit.b3			/* TA2 count source option specified bit */
#define		tcs4_tacs1		tacs1_addr.bit.b4			/* TA3 count source select bit */
#define		tcs5_tacs1		tacs1_addr.bit.b5			/* TA3 count source select bit */
#define		tcs6_tacs1		tacs1_addr.bit.b6			/* TA3 count source select bit */
#define		tcs7_tacs1		tacs1_addr.bit.b7			/* TA3 count source option specified bit */

/*------------------------------------------------------------------------------*/
/*  Timer A Count Source Select Register 2                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tacs2_addr		01D2h
union BYTE_DEF	tacs2_addr;
#define		tacs2			tacs2_addr.byte

#define		tcs0_tacs2		tacs2_addr.bit.b0			/* TA4 count source select bit */
#define		tcs1_tacs2		tacs2_addr.bit.b1			/* TA4 count source select bit */
#define		tcs2_tacs2		tacs2_addr.bit.b2			/* TA4 count source select bit */
#define		tcs3_tacs2		tacs2_addr.bit.b3			/* TA4 count source option specified bit */

/*------------------------------------------------------------------------------*/
/*  16-bit Pulse Width Modulation Mode Function Select Register                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pwmfs_addr		01D4h
union BYTE_DEF	pwmfs_addr;
#define		pwmfs			pwmfs_addr.byte

#define		pwmfs1			pwmfs_addr.bit.b1			/* Timer A1 programmable output mode select bit */
#define		pwmfs2			pwmfs_addr.bit.b2			/* Timer A2 programmable output mode select bit */
#define		pwmfs4			pwmfs_addr.bit.b4			/* Timer A4 programmable output mode select bit */

/*------------------------------------------------------------------------------*/
/*  Timer A Waveform Output Function Select Register                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tapofs_addr		01D5h
union BYTE_DEF	tapofs_addr;
#define		tapofs			tapofs_addr.byte

#define		pofs0			tapofs_addr.bit.b0			/* TA0OUT output polar control bit */
#define		pofs1			tapofs_addr.bit.b1			/* TA1OUT output polar control bit */
#define		pofs2			tapofs_addr.bit.b2			/* TA2OUT output polar control bit */
#define		pofs3			tapofs_addr.bit.b3			/* TA3OUT output polar control bit */
#define		pofs4			tapofs_addr.bit.b4			/* TA4OUT output polar control bit */

/*------------------------------------------------------------------------------*/
/*  Timer A Output Waveform Change Enable Register                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		taow_addr		01D8h
union BYTE_DEF	taow_addr;
#define		taow			taow_addr.byte

#define		ta1ow			taow_addr.bit.b1			/* Timer A1 output waveform change enable bit */
#define		ta2ow			taow_addr.bit.b2			/* Timer A2 output waveform change enable bit */
#define		ta4ow			taow_addr.bit.b4			/* Timer A4 output waveform change enable bit */

/*------------------------------------------------------------------------------*/
/*  Three-phase Protect Control Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tprc_addr		01DAh
union BYTE_DEF	tprc_addr;
#define		tprc			tprc_addr.byte

#define		tprc0			tprc_addr.bit.b0			/* Three-phase protect control bit */

/*------------------------------------------------------------------------------*/
/*  Timer B3-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb31_addr		01E0h
union WORD_DEF	tb31_addr;
#define		tb31			tb31_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B4-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb41_addr		01E2h
union WORD_DEF	tb41_addr;
#define		tb41			tb41_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B5-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb51_addr		01E4h
union WORD_DEF	tb51_addr;
#define		tb51			tb51_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse Period/Pulse Width Measurement Mode Function Select Register 2        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ppwfs2_addr		01E6h
union BYTE_DEF	ppwfs2_addr;
#define		ppwfs2			ppwfs2_addr.byte

#define		ppwfs20			ppwfs2_addr.bit.b0			/* Timer B3 pulse period/pulse width measurement mode function select bit */
#define		ppwfs21			ppwfs2_addr.bit.b1			/* Timer B4 pulse period/pulse width measurement mode function select bit */
#define		ppwfs22			ppwfs2_addr.bit.b2			/* Timer B5 pulse period/pulse width measurement mode function select bit */

/*------------------------------------------------------------------------------*/
/*  Timer B Count Source Select Register 2                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tbcs2_addr		01E8h
union BYTE_DEF	tbcs2_addr;
#define		tbcs2			tbcs2_addr.byte

#define		tcs0_tbcs2		tbcs2_addr.bit.b0			/* TB3 count source select bit */
#define		tcs1_tbcs2		tbcs2_addr.bit.b1			/* TB3 count source select bit */
#define		tcs2_tbcs2		tbcs2_addr.bit.b2			/* TB3 count source select bit */
#define		tcs3_tbcs2		tbcs2_addr.bit.b3			/* TB3 count source option specified bit */
#define		tcs4_tbcs2		tbcs2_addr.bit.b4			/* TB4 count source select bit */
#define		tcs5_tbcs2		tbcs2_addr.bit.b5			/* TB4 count source select bit */
#define		tcs6_tbcs2		tbcs2_addr.bit.b6			/* TB4 count source select bit */
#define		tcs7_tbcs2		tbcs2_addr.bit.b7			/* TB4 count source option specified bit */

/*------------------------------------------------------------------------------*/
/*  Timer B Count Source Select Register 3                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tbcs3_addr		01E9h
union BYTE_DEF	tbcs3_addr;
#define		tbcs3			tbcs3_addr.byte

#define		tcs0_tbcs3		tbcs3_addr.bit.b0			/* TB5 count source select bit */
#define		tcs1_tbcs3		tbcs3_addr.bit.b1			/* TB5 count source select bit */
#define		tcs2_tbcs3		tbcs3_addr.bit.b2			/* TB5 count source select bit */
#define		tcs3_tbcs3		tbcs3_addr.bit.b3			/* TB5 count source option specified bit */

/*------------------------------------------------------------------------------*/
/*  Task Monitor Timer Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tmos_addr		01F0h
union WORD_DEF	tmos_addr;
#define		tmos			tmos_addr.word

/*------------------------------------------------------------------------------*/
/*  Task Monitor Timer Count Start Flag                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tmossr_addr		01F2h
union BYTE_DEF	tmossr_addr;
#define		tmossr			tmossr_addr.byte

#define		tmos0s			tmossr_addr.bit.b0			/* Task monitor timer count start flag */

/*------------------------------------------------------------------------------*/
/*  Task Monitor Timer Count Source Select Register                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tmoscs_addr		01F3h
union BYTE_DEF	tmoscs_addr;
#define		tmoscs			tmoscs_addr.byte

#define		tmos0cs			tmoscs_addr.bit.b0			/* Task monitor timer count source select bit */
#define		tmos1cs			tmoscs_addr.bit.b1			/* Task monitor timer count source select bit */
#define		tmos2cs			tmoscs_addr.bit.b2			/* Task monitor timer count source select bit */

/*------------------------------------------------------------------------------*/
/*  Task Monitor Timer Protect Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tmospr_addr		01F4h
union BYTE_DEF	tmospr_addr;
#define		tmospr			tmospr_addr.byte

/*------------------------------------------------------------------------------*/
/*  Interrupt Source Select Register 4                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ifsr4a_addr		0204h
union BYTE_DEF	ifsr4a_addr;
#define		ifsr4a			ifsr4a_addr.byte

#define		ifsr43			ifsr4a_addr.bit.b3			/* Interrupt Request Source Select bit */
#define		ifsr44			ifsr4a_addr.bit.b4			/* Interrupt Request Source Select bit */
#define		ifsr45			ifsr4a_addr.bit.b5			/* Interrupt Request Source Select bit */
#define		ifsr46			ifsr4a_addr.bit.b6			/* Interrupt Request Source Select bit */
#define		ifsr47			ifsr4a_addr.bit.b7			/* Interrupt Request Source Select bit */

/*------------------------------------------------------------------------------*/
/*  Interrupt Source Select Register 3                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ifsr3a_addr		0205h
union BYTE_DEF	ifsr3a_addr;
#define		ifsr3a			ifsr3a_addr.byte

#define		ifsr30			ifsr3a_addr.bit.b0			/* INT6~ interrupt priority select bit */
#define		ifsr31			ifsr3a_addr.bit.b1			/* INT7~ interrupt priority select bit */
#define		ifsr32			ifsr3a_addr.bit.b2			/* Interrupt Request Source Select bit */
#define		ifsr33			ifsr3a_addr.bit.b3			/* Interrupt Request Source Select bit */
#define		ifsr34			ifsr3a_addr.bit.b4			/* Interrupt Request Source Select bit */
#define		ifsr35			ifsr3a_addr.bit.b5			/* Interrupt Request Source Select bit */
#define		ifsr36			ifsr3a_addr.bit.b6			/* Interrupt Request Source Select bit */

/*------------------------------------------------------------------------------*/
/*  Interrupt Source Select Register 2                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ifsr2a_addr		0206h
union BYTE_DEF	ifsr2a_addr;
#define		ifsr2a			ifsr2a_addr.byte

#define		ifsr20			ifsr2a_addr.bit.b0			/* Interrupt request source select bit */
#define		ifsr22			ifsr2a_addr.bit.b2			/* Interrupt request source select bit */
#define		ifsr23			ifsr2a_addr.bit.b3			/* Interrupt request source select bit */
#define		ifsr24			ifsr2a_addr.bit.b4			/* Interrupt request source select bit */
#define		ifsr25			ifsr2a_addr.bit.b5			/* Interrupt request source select bit */

/*------------------------------------------------------------------------------*/
/*  Interrupt Source Select Register                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ifsr_addr		0207h
union BYTE_DEF	ifsr_addr;
#define		ifsr			ifsr_addr.byte

#define		ifsr0			ifsr_addr.bit.b0			/* INT0~ interrupt polarity switch bit */
#define		ifsr1			ifsr_addr.bit.b1			/* INT1~ interrupt polarity switch bit */
#define		ifsr2			ifsr_addr.bit.b2			/* INT2~ interrupt polarity switch bit */
#define		ifsr3			ifsr_addr.bit.b3			/* INT3~ interrupt polarity switch bit */
#define		ifsr4			ifsr_addr.bit.b4			/* INT4~ interrupt polarity switch bit */
#define		ifsr5			ifsr_addr.bit.b5			/* INT5~ interrupt polarity switch bit */
#define		ifsr6			ifsr_addr.bit.b6			/* Interrupt request source select bit */
#define		ifsr7			ifsr_addr.bit.b7			/* Interrupt request source select bit */

/*------------------------------------------------------------------------------*/
/*  Address Match Interrupt Enable Register                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		aier_addr		020Eh
union BYTE_DEF	aier_addr;
#define		aier			aier_addr.byte

#define		aier0			aier_addr.bit.b0			/* Address match interrupt 0 enable bit */
#define		aier1			aier_addr.bit.b1			/* Address match interrupt 1 enable bit */

/*------------------------------------------------------------------------------*/
/*  Address Match Interrupt Enable Register 2                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		aier2_addr		020Fh
union BYTE_DEF	aier2_addr;
#define		aier2			aier2_addr.byte

#define		aier20			aier2_addr.bit.b0			/* Address match interrupt 2 enable bit */
#define		aier21			aier2_addr.bit.b1			/* Address match interrupt 3 enable bit */

/*------------------------------------------------------------------------------*/
/*  Address Match Interrupt Register 0                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rmad0_addr		0210h
union DWORD_DEF	rmad0_addr;
#define		rmad0			rmad0_addr.dword
#define		rmad0l			rmad0_addr.byte.lowlow		/* RMAD0 address(low 8bit) */
#define		rmad0m			rmad0_addr.byte.lowhigh		/* RMAD0 address(mid 8bit) */
#define		rmad0h			rmad0_addr.byte.highlow		/* RMAD0 address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  Address Match Interrupt Register 1                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rmad1_addr		0214h
union DWORD_DEF	rmad1_addr;
#define		rmad1			rmad1_addr.dword
#define		rmad1l			rmad1_addr.byte.lowlow		/* RMAD1 address(low 8bit) */
#define		rmad1m			rmad1_addr.byte.lowhigh		/* RMAD1 address(mid 8bit) */
#define		rmad1h			rmad1_addr.byte.highlow		/* RMAD1 address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  Address Match Interrupt Register 2                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rmad2_addr		0218h
union DWORD_DEF	rmad2_addr;
#define		rmad2			rmad2_addr.dword
#define		rmad2l			rmad2_addr.byte.lowlow		/* RMAD2 address(low 8bit) */
#define		rmad2m			rmad2_addr.byte.lowhigh		/* RMAD2 address(mid 8bit) */
#define		rmad2h			rmad2_addr.byte.highlow		/* RMAD2 address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  Address Match Interrupt Register 3                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rmad3_addr		021Ch
union DWORD_DEF	rmad3_addr;
#define		rmad3			rmad3_addr.dword
#define		rmad3l			rmad3_addr.byte.lowlow		/* RMAD3 address(low 8bit) */
#define		rmad3m			rmad3_addr.byte.lowhigh		/* RMAD3 address(mid 8bit) */
#define		rmad3h			rmad3_addr.byte.highlow		/* RMAD3 address(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  Flash Memory Control Register 0                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		fmr0_addr		0220h
union BYTE_DEF	fmr0_addr;
#define		fmr0			fmr0_addr.byte

#define		fmr00			fmr0_addr.bit.b0			/* RY / BY~ status flag */
#define		fmr01			fmr0_addr.bit.b1			/* CPU rewrite mode select bit */
#define		fmr02			fmr0_addr.bit.b2			/* Lock bit disable select bit */
#define		fmstp			fmr0_addr.bit.b3			/* Flash memory stop bit */
#define		fmr06			fmr0_addr.bit.b6			/* Program status flag */
#define		fmr07			fmr0_addr.bit.b7			/* Erase Status Flag */

/*------------------------------------------------------------------------------*/
/*  Flash Memory Control Register 1                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		fmr1_addr		0221h
union BYTE_DEF	fmr1_addr;
#define		fmr1			fmr1_addr.byte

#define		fmr11			fmr1_addr.bit.b1			/* Write to FMR6 register enable bit */
#define		fmr16			fmr1_addr.bit.b6			/* Lock bit status flag */
#define		fmr17			fmr1_addr.bit.b7			/* Data flash wait bit */

/*------------------------------------------------------------------------------*/
/*  Flash Memory Control Register 2                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		fmr2_addr		0222h
union BYTE_DEF	fmr2_addr;
#define		fmr2			fmr2_addr.byte

#define		fmr22			fmr2_addr.bit.b2			/* Slow read mode enable bit */
#define		fmr23			fmr2_addr.bit.b3			/* Low current consumption read mode enable bit */

/*------------------------------------------------------------------------------*/
/*  Flash Memory Control Register 3                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		fmr3_addr		0223h
union BYTE_DEF	fmr3_addr;
#define		fmr3			fmr3_addr.byte

#define		fmr30			fmr3_addr.bit.b0			/* Suspend function enable bit */
#define		fmr31			fmr3_addr.bit.b1			/* Suspend request bit */
#define		fmr32			fmr3_addr.bit.b2			/* Erase suspend status flag */
#define		fmr33			fmr3_addr.bit.b3			/* Program suspend status flag */

/*------------------------------------------------------------------------------*/
/*  Flash Memory Control Register 6                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		fmr6_addr		0230h
union BYTE_DEF	fmr6_addr;
#define		fmr6			fmr6_addr.byte

#define		fmr60			fmr6_addr.bit.b0			/* EW1 mode select bit */
#define		fmr61			fmr6_addr.bit.b1			/* Reserved bit */

/*------------------------------------------------------------------------------*/
/*  UART0 Transmit/Receive Mode Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u0mr_addr		0248h
union BYTE_DEF	u0mr_addr;
#define		u0mr			u0mr_addr.byte

#define		smd0_u0mr		u0mr_addr.bit.b0			/* Serial I/O mode select bit */
#define		smd1_u0mr		u0mr_addr.bit.b1			/* Serial I/O mode select bit */
#define		smd2_u0mr		u0mr_addr.bit.b2			/* Serial I/O mode select bit */
#define		ckdir_u0mr		u0mr_addr.bit.b3			/* Internal/external clock select bit */
#define		stps_u0mr		u0mr_addr.bit.b4			/* Stop bit length select bit */
#define		pry_u0mr		u0mr_addr.bit.b5			/* Odd/even parity select bit */
#define		prye_u0mr		u0mr_addr.bit.b6			/* Parity enable bit */
#define		iopol_u0mr		u0mr_addr.bit.b7			/* TXD, RXD I/O polarity inverse bit */

/*------------------------------------------------------------------------------*/
/*  UART0 Bit Rate Register                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u0brg_addr		0249h
union BYTE_DEF	u0brg_addr;
#define		u0brg			u0brg_addr.byte

/*------------------------------------------------------------------------------*/
/*  UART0 Transmit Buffer Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u0tb_addr		024Ah
union WORD_DEF	u0tb_addr;
#define		u0tb			u0tb_addr.word
#define		u0tbl			u0tb_addr.byte.low			/* UART0 Transmit buffer register(low 8bit) */
#define		u0tbh			u0tb_addr.byte.high			/* UART0 Transmit buffer register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  UART0 Transmit/Receive Control Register 0                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u0c0_addr		024Ch
union BYTE_DEF	u0c0_addr;
#define		u0c0			u0c0_addr.byte

#define		clk0_u0c0		u0c0_addr.bit.b0			/* U0BRG count source select bit */
#define		clk1_u0c0		u0c0_addr.bit.b1			/* U0BRG count source select bit */
#define		crs_u0c0		u0c0_addr.bit.b2			/* CTS~/RTS~ function select bit */
#define		txept_u0c0		u0c0_addr.bit.b3			/* Transmit register empty flag */
#define		crd_u0c0		u0c0_addr.bit.b4			/* CTS~/RTS~ disable bit */
#define		nch_u0c0		u0c0_addr.bit.b5			/* Data output select bit */
#define		ckpol_u0c0		u0c0_addr.bit.b6			/* CLK polarity select bit */
#define		uform_u0c0		u0c0_addr.bit.b7			/* Bit order select bit */

/*------------------------------------------------------------------------------*/
/*  UART0 Transmit/Receive Control Register 1                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u0c1_addr		024Dh
union BYTE_DEF	u0c1_addr;
#define		u0c1			u0c1_addr.byte

#define		te_u0c1			u0c1_addr.bit.b0			/* Transmit enable bit */
#define		ti_u0c1			u0c1_addr.bit.b1			/* Transmit buffer empty flag */
#define		re_u0c1			u0c1_addr.bit.b2			/* Receive enable bit */
#define		ri_u0c1			u0c1_addr.bit.b3			/* Receive complete flag */
#define		u0irs			u0c1_addr.bit.b4			/* UART0 transmit interrupt source select bit */
#define		u0rrm			u0c1_addr.bit.b5			/* UART0 continuous receive mode enable bit */
#define		u0lch			u0c1_addr.bit.b6			/* Data logic select bit */
#define		u0ere			u0c1_addr.bit.b7			/* Error signal output enable bit */

/*------------------------------------------------------------------------------*/
/*  UART0 Receive Buffer Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u0rb_addr		024Eh
union WORD_DEF	u0rb_addr;
#define		u0rb			u0rb_addr.word
#define		u0rbl			u0rb_addr.byte.low			/* UART0 receive buffer register(low 8bit) */
#define		u0rbh			u0rb_addr.byte.high			/* UART0 receive buffer register(high 8bit) */

#define		abt_u0rb		u0rb_addr.bit.b11			/* Arbitration lost detect flag */
#define		oer_u0rb		u0rb_addr.bit.b12			/* Overrun error flag */
#define		fer_u0rb		u0rb_addr.bit.b13			/* Framing error flag */
#define		per_u0rb		u0rb_addr.bit.b14			/* Parity error flag */
#define		sum_u0rb		u0rb_addr.bit.b15			/* Error sum flag */

/*------------------------------------------------------------------------------*/
/*  UART Clock Select Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		uclksel0_addr	0252h
union BYTE_DEF	uclksel0_addr;
#define		uclksel0		uclksel0_addr.byte

#define		ocosel0			uclksel0_addr.bit.b2		/* UART0 to UART2 clock prior to division select bit */
#define		ocosel1			uclksel0_addr.bit.b3		/* UART3 to UART4 clock prior to division select bit */

/*------------------------------------------------------------------------------*/
/*  UART1 Transmit/Receive Mode Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u1mr_addr		0258h
union BYTE_DEF	u1mr_addr;
#define		u1mr			u1mr_addr.byte

#define		smd0_u1mr		u1mr_addr.bit.b0			/* Serial I/O mode select bit */
#define		smd1_u1mr		u1mr_addr.bit.b1			/* Serial I/O mode select bit */
#define		smd2_u1mr		u1mr_addr.bit.b2			/* Serial I/O mode select bit */
#define		ckdir_u1mr		u1mr_addr.bit.b3			/* Internal/external clock select bit */
#define		stps_u1mr		u1mr_addr.bit.b4			/* Stop bit length select bit */
#define		pry_u1mr		u1mr_addr.bit.b5			/* Odd/even parity select bit */
#define		prye_u1mr		u1mr_addr.bit.b6			/* Parity enable bit */
#define		iopol_u1mr		u1mr_addr.bit.b7			/* TXD, RXD I/O polarity inverse bit */

/*------------------------------------------------------------------------------*/
/*  UART1 Bit Rate Register                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u1brg_addr		0259h
union BYTE_DEF	u1brg_addr;
#define		u1brg			u1brg_addr.byte

/*------------------------------------------------------------------------------*/
/*  UART1 Transmit Buffer Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u1tb_addr		025Ah
union WORD_DEF	u1tb_addr;
#define		u1tb			u1tb_addr.word
#define		u1tbl			u1tb_addr.byte.low			/* UART1 Transmit buffer register(low 8bit) */
#define		u1tbh			u1tb_addr.byte.high			/* UART1 Transmit buffer register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  UART1 Transmit/Receive Control Register 0                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u1c0_addr		025Ch
union BYTE_DEF	u1c0_addr;
#define		u1c0			u1c0_addr.byte

#define		clk0_u1c0		u1c0_addr.bit.b0			/* U1BRG count source select bit */
#define		clk1_u1c0		u1c0_addr.bit.b1			/* U1BRG count source select bit */
#define		crs_u1c0		u1c0_addr.bit.b2			/* CTS~/RTS~ function select bit */
#define		txept_u1c0		u1c0_addr.bit.b3			/* Transmit register empty flag */
#define		crd_u1c0		u1c0_addr.bit.b4			/* CTS~/RTS~ disable bit */
#define		nch_u1c0		u1c0_addr.bit.b5			/* Data output select bit */
#define		ckpol_u1c0		u1c0_addr.bit.b6			/* CLK polarity select bit */
#define		uform_u1c0		u1c0_addr.bit.b7			/* Bit order select bit */

/*------------------------------------------------------------------------------*/
/*  UART1 Transmit/Receive Control Register 1                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u1c1_addr		025Dh
union BYTE_DEF	u1c1_addr;
#define		u1c1			u1c1_addr.byte

#define		te_u1c1			u1c1_addr.bit.b0			/* Transmit enable bit */
#define		ti_u1c1			u1c1_addr.bit.b1			/* Transmit buffer empty flag */
#define		re_u1c1			u1c1_addr.bit.b2			/* Receive enable bit */
#define		ri_u1c1			u1c1_addr.bit.b3			/* Receive complete flag */
#define		u1irs			u1c1_addr.bit.b4			/* UART1 transmit interrupt source select bit */
#define		u1rrm			u1c1_addr.bit.b5			/* UART1 continuous receive mode enable bit */
#define		u1lch			u1c1_addr.bit.b6			/* Data logic select bit */
#define		u1ere			u1c1_addr.bit.b7			/* Error signal output enable bit */

/*------------------------------------------------------------------------------*/
/*  UART1 Receive Buffer Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u1rb_addr		025Eh
union WORD_DEF	u1rb_addr;
#define		u1rb			u1rb_addr.word
#define		u1rbl			u1rb_addr.byte.low			/* UART1 receive buffer register(low 8bit) */
#define		u1rbh			u1rb_addr.byte.high			/* UART1 receive buffer register(high 8bit) */

#define		abt_u1rb		u1rb_addr.bit.b11			/* Arbitration lost detect flag */
#define		oer_u1rb		u1rb_addr.bit.b12			/* Overrun error flag */
#define		fer_u1rb		u1rb_addr.bit.b13			/* Framing error flag */
#define		per_u1rb		u1rb_addr.bit.b14			/* Parity error flag */
#define		sum_u1rb		u1rb_addr.bit.b15			/* Error sum flag */

/*------------------------------------------------------------------------------*/
/*  UART2 Special Mode Register 4                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2smr4_addr		0264h
union BYTE_DEF	u2smr4_addr;
#define		u2smr4			u2smr4_addr.byte

#define		stareq_u2smr4	u2smr4_addr.bit.b0			/* Start condition generate bit */
#define		rstareq_u2smr4	u2smr4_addr.bit.b1			/* Restart condition generate bit */
#define		stpreq_u2smr4	u2smr4_addr.bit.b2			/* Stop condition generate bit */
#define		stspsel_u2smr4	u2smr4_addr.bit.b3			/* SCL, SDA output select bit */
#define		ackd_u2smr4		u2smr4_addr.bit.b4			/* ACK data bit */
#define		ackc_u2smr4		u2smr4_addr.bit.b5			/* ACK data output enable bit */
#define		sclhi_u2smr4	u2smr4_addr.bit.b6			/* SCL output stop enable bit */
#define		swc9_u2smr4		u2smr4_addr.bit.b7			/* SCL wait bit 3 */

/*------------------------------------------------------------------------------*/
/*  UART2 Special Mode Register 3                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2smr3_addr		0265h
union BYTE_DEF	u2smr3_addr;
#define		u2smr3			u2smr3_addr.byte

#define		ckph_u2smr3		u2smr3_addr.bit.b1			/* Clock phase set bit */
#define		nodc_u2smr3		u2smr3_addr.bit.b3			/* Clock output select bit */
#define		dl0_u2smr3		u2smr3_addr.bit.b5			/* SDA2 digital delay setup bit */
#define		dl1_u2smr3		u2smr3_addr.bit.b6			/* SDA2 digital delay setup bit */
#define		dl2_u2smr3		u2smr3_addr.bit.b7			/* SDA2 digital delay setup bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Special Mode Register 2                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2smr2_addr		0266h
union BYTE_DEF	u2smr2_addr;
#define		u2smr2			u2smr2_addr.byte

#define		iicm2_u2smr2	u2smr2_addr.bit.b0			/* I2C mode select bit 2 */
#define		csc_u2smr2		u2smr2_addr.bit.b1			/* Clock synchronization bit */
#define		swc_u2smr2		u2smr2_addr.bit.b2			/* SCL wait output bit */
#define		als_u2smr2		u2smr2_addr.bit.b3			/* SDA output stop bit */
#define		stac_u2smr2		u2smr2_addr.bit.b4			/* UART2 initialization bit */
#define		swc2_u2smr2		u2smr2_addr.bit.b5			/* SCL wait output bit 2 */
#define		sdhi_u2smr2		u2smr2_addr.bit.b6			/* SDA output disable bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Special Mode Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2smr_addr		0267h
union BYTE_DEF	u2smr_addr;
#define		u2smr			u2smr_addr.byte

#define		iicm_u2smr		u2smr_addr.bit.b0			/* I2C mode select bit */
#define		abc_u2smr		u2smr_addr.bit.b1			/* Arbitration lost detect flag control bit */
#define		bbs_u2smr		u2smr_addr.bit.b2			/* Bus busy flag */
#define		abscs_u2smr		u2smr_addr.bit.b4			/* Bus collision detect sampling clock select bit */
#define		acse_u2smr		u2smr_addr.bit.b5			/* Auto clear function select bit of transmit enable bit */
#define		sss_u2smr		u2smr_addr.bit.b6			/* Transmit start condition select bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Transmit/Receive Mode Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2mr_addr		0268h
union BYTE_DEF	u2mr_addr;
#define		u2mr			u2mr_addr.byte

#define		smd0_u2mr		u2mr_addr.bit.b0			/* Serial I/O mode select bit */
#define		smd1_u2mr		u2mr_addr.bit.b1			/* Serial I/O mode select bit */
#define		smd2_u2mr		u2mr_addr.bit.b2			/* Serial I/O mode select bit */
#define		ckdir_u2mr		u2mr_addr.bit.b3			/* Internal/external clock select bit */
#define		stps_u2mr		u2mr_addr.bit.b4			/* Stop bit length select bit */
#define		pry_u2mr		u2mr_addr.bit.b5			/* Odd/even parity select bit */
#define		prye_u2mr		u2mr_addr.bit.b6			/* Parity enable bit */
#define		iopol_u2mr		u2mr_addr.bit.b7			/* TXD, RXD I/O polarity inverse bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Bit Rate Register                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2brg_addr		0269h
union BYTE_DEF	u2brg_addr;
#define		u2brg			u2brg_addr.byte

/*------------------------------------------------------------------------------*/
/*  UART2 Transmit Buffer Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2tb_addr		026Ah
union WORD_DEF	u2tb_addr;
#define		u2tb			u2tb_addr.word
#define		u2tbl			u2tb_addr.byte.low			/* UART2 Transmit buffer register(low 8bit) */
#define		u2tbh			u2tb_addr.byte.high			/* UART2 Transmit buffer register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  UART2 Transmit/Receive Control Register 0                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2c0_addr		026Ch
union BYTE_DEF	u2c0_addr;
#define		u2c0			u2c0_addr.byte

#define		clk0_u2c0		u2c0_addr.bit.b0			/* U2BRG count source select bit */
#define		clk1_u2c0		u2c0_addr.bit.b1			/* U2BRG count source select bit */
#define		crs_u2c0		u2c0_addr.bit.b2			/* CTS~/RTS~ function select bit */
#define		txept_u2c0		u2c0_addr.bit.b3			/* Transmit register empty flag */
#define		crd_u2c0		u2c0_addr.bit.b4			/* CTS~/RTS~ disable bit */
#define		nch_u2c0		u2c0_addr.bit.b5			/* Data output select bit */
#define		ckpol_u2c0		u2c0_addr.bit.b6			/* CLK polarity select bit */
#define		uform_u2c0		u2c0_addr.bit.b7			/* Bit order select bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Transmit/Receive Control Register 1                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2c1_addr		026Dh
union BYTE_DEF	u2c1_addr;
#define		u2c1			u2c1_addr.byte

#define		te_u2c1			u2c1_addr.bit.b0			/* Transmit enable bit */
#define		ti_u2c1			u2c1_addr.bit.b1			/* Transmit buffer empty flag */
#define		re_u2c1			u2c1_addr.bit.b2			/* Receive enable bit */
#define		ri_u2c1			u2c1_addr.bit.b3			/* Receive complete flag */
#define		u2irs			u2c1_addr.bit.b4			/* UART2 transmit interrupt source select bit */
#define		u2rrm			u2c1_addr.bit.b5			/* UART2 continuous receive mode enable bit */
#define		u2lch			u2c1_addr.bit.b6			/* Data logic select bit */
#define		u2ere			u2c1_addr.bit.b7			/* Error signal output enable bit */

/*------------------------------------------------------------------------------*/
/*  UART2 Receive Buffer Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u2rb_addr		026Eh
union WORD_DEF	u2rb_addr;
#define		u2rb			u2rb_addr.word
#define		u2rbl			u2rb_addr.byte.low			/* UART2 receive buffer register(low 8bit) */
#define		u2rbh			u2rb_addr.byte.high			/* UART2 receive buffer register(high 8bit) */

#define		abt_u2rb		u2rb_addr.bit.b11			/* Arbitration lost detect flag */
#define		oer_u2rb		u2rb_addr.bit.b12			/* Overrun error flag */
#define		fer_u2rb		u2rb_addr.bit.b13			/* Framing error flag */
#define		per_u2rb		u2rb_addr.bit.b14			/* Parity error flag */
#define		sum_u2rb		u2rb_addr.bit.b15			/* Error sum flag */

/*------------------------------------------------------------------------------*/
/*  UART4 Transmit/Receive Mode Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u4mr_addr		0298h
union BYTE_DEF	u4mr_addr;
#define		u4mr			u4mr_addr.byte

#define		smd0_u4mr		u4mr_addr.bit.b0			/* Serial I/O mode select bit */
#define		smd1_u4mr		u4mr_addr.bit.b1			/* Serial I/O mode select bit */
#define		smd2_u4mr		u4mr_addr.bit.b2			/* Serial I/O mode select bit */
#define		ckdir_u4mr		u4mr_addr.bit.b3			/* Internal/external clock select bit */
#define		stps_u4mr		u4mr_addr.bit.b4			/* Stop bit length select bit */
#define		pry_u4mr		u4mr_addr.bit.b5			/* Odd/even parity select bit */
#define		prye_u4mr		u4mr_addr.bit.b6			/* Parity enable bit */
#define		iopol_u4mr		u4mr_addr.bit.b7			/* TXD, RXD I/O polarity inverse bit */

/*------------------------------------------------------------------------------*/
/*  UART4 Bit Rate Register                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u4brg_addr		0299h
union BYTE_DEF	u4brg_addr;
#define		u4brg			u4brg_addr.byte

/*------------------------------------------------------------------------------*/
/*  UART4 Transmit Buffer Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u4tb_addr		029Ah
union WORD_DEF	u4tb_addr;
#define		u4tb			u4tb_addr.word
#define		u4tbl			u4tb_addr.byte.low			/* UART4 Transmit buffer register(low 8bit) */
#define		u4tbh			u4tb_addr.byte.high			/* UART4 Transmit buffer register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  UART4 Transmit/Receive Control Register 0                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u4c0_addr		029Ch
union BYTE_DEF	u4c0_addr;
#define		u4c0			u4c0_addr.byte

#define		clk0_u4c0		u4c0_addr.bit.b0			/* U4BRG count source select bit */
#define		clk1_u4c0		u4c0_addr.bit.b1			/* U4BRG count source select bit */
#define		crs_u4c0		u4c0_addr.bit.b2			/* CTS~/RTS~ function select bit */
#define		txept_u4c0		u4c0_addr.bit.b3			/* Transmit register empty flag */
#define		crd_u4c0		u4c0_addr.bit.b4			/* CTS~/RTS~ disable bit */
#define		nch_u4c0		u4c0_addr.bit.b5			/* Data output select bit */
#define		ckpol_u4c0		u4c0_addr.bit.b6			/* CLK polarity select bit */
#define		uform_u4c0		u4c0_addr.bit.b7			/* Bit order select bit */

/*------------------------------------------------------------------------------*/
/*  UART4 Transmit/Receive Control Register 1                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u4c1_addr		029Dh
union BYTE_DEF	u4c1_addr;
#define		u4c1			u4c1_addr.byte

#define		te_u4c1			u4c1_addr.bit.b0			/* Transmit enable bit */
#define		ti_u4c1			u4c1_addr.bit.b1			/* Transmit buffer empty flag */
#define		re_u4c1			u4c1_addr.bit.b2			/* Receive enable bit */
#define		ri_u4c1			u4c1_addr.bit.b3			/* Receive complete flag */
#define		u4irs			u4c1_addr.bit.b4			/* UART4 transmit interrupt source select bit */
#define		u4rrm			u4c1_addr.bit.b5			/* UART4 continuous receive mode enable bit */
#define		u4lch			u4c1_addr.bit.b6			/* Data logic select bit */
#define		u4ere			u4c1_addr.bit.b7			/* Error signal output enable bit */

/*------------------------------------------------------------------------------*/
/*  UART4 Receive Buffer Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u4rb_addr		029Eh
union WORD_DEF	u4rb_addr;
#define		u4rb			u4rb_addr.word
#define		u4rbl			u4rb_addr.byte.low			/* UART4 receive buffer register(low 8bit) */
#define		u4rbh			u4rb_addr.byte.high			/* UART4 receive buffer register(high 8bit) */

#define		abt_u4rb		u4rb_addr.bit.b11			/* Arbitration lost detect flag */
#define		oer_u4rb		u4rb_addr.bit.b12			/* Overrun error flag */
#define		fer_u4rb		u4rb_addr.bit.b13			/* Framing error flag */
#define		per_u4rb		u4rb_addr.bit.b14			/* Parity error flag */
#define		sum_u4rb		u4rb_addr.bit.b15			/* Error sum flag */

/*------------------------------------------------------------------------------*/
/*  UART3 Transmit/Receive Mode Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u3mr_addr		02A8h
union BYTE_DEF	u3mr_addr;
#define		u3mr			u3mr_addr.byte

#define		smd0_u3mr		u3mr_addr.bit.b0			/* Serial I/O mode select bit */
#define		smd1_u3mr		u3mr_addr.bit.b1			/* Serial I/O mode select bit */
#define		smd2_u3mr		u3mr_addr.bit.b2			/* Serial I/O mode select bit */
#define		ckdir_u3mr		u3mr_addr.bit.b3			/* Internal/external clock select bit */
#define		stps_u3mr		u3mr_addr.bit.b4			/* Stop bit length select bit */
#define		pry_u3mr		u3mr_addr.bit.b5			/* Odd/even parity select bit */
#define		prye_u3mr		u3mr_addr.bit.b6			/* Parity enable bit */
#define		iopol_u3mr		u3mr_addr.bit.b7			/* TXD, RXD I/O polarity inverse bit */

/*------------------------------------------------------------------------------*/
/*  UART3 Bit Rate Register                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u3brg_addr		02A9h
union BYTE_DEF	u3brg_addr;
#define		u3brg			u3brg_addr.byte

/*------------------------------------------------------------------------------*/
/*  UART3 Transmit Buffer Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u3tb_addr		02AAh
union WORD_DEF	u3tb_addr;
#define		u3tb			u3tb_addr.word
#define		u3tbl			u3tb_addr.byte.low			/* UART3 Transmit buffer register(low 8bit) */
#define		u3tbh			u3tb_addr.byte.high			/* UART3 Transmit buffer register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  UART3 Transmit/Receive Control Register 0                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u3c0_addr		02ACh
union BYTE_DEF	u3c0_addr;
#define		u3c0			u3c0_addr.byte

#define		clk0_u3c0		u3c0_addr.bit.b0			/* U3BRG count source select bit */
#define		clk1_u3c0		u3c0_addr.bit.b1			/* U3BRG count source select bit */
#define		crs_u3c0		u3c0_addr.bit.b2			/* CTS~/RTS~ function select bit */
#define		txept_u3c0		u3c0_addr.bit.b3			/* Transmit register empty flag */
#define		crd_u3c0		u3c0_addr.bit.b4			/* CTS~/RTS~ disable bit */
#define		nch_u3c0		u3c0_addr.bit.b5			/* Data output select bit */
#define		ckpol_u3c0		u3c0_addr.bit.b6			/* CLK polarity select bit */
#define		uform_u3c0		u3c0_addr.bit.b7			/* Bit order select bit */

/*------------------------------------------------------------------------------*/
/*  UART3 Transmit/Receive Control Register 1                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u3c1_addr		02ADh
union BYTE_DEF	u3c1_addr;
#define		u3c1			u3c1_addr.byte

#define		te_u3c1			u3c1_addr.bit.b0			/* Transmit enable bit */
#define		ti_u3c1			u3c1_addr.bit.b1			/* Transmit buffer empty flag */
#define		re_u3c1			u3c1_addr.bit.b2			/* Receive enable bit */
#define		ri_u3c1			u3c1_addr.bit.b3			/* Receive complete flag */
#define		u3irs			u3c1_addr.bit.b4			/* UART3 transmit interrupt source select bit */
#define		u3rrm			u3c1_addr.bit.b5			/* UART3 continuous receive mode enable bit */
#define		u3lch			u3c1_addr.bit.b6			/* Data logic select bit */
#define		u3ere			u3c1_addr.bit.b7			/* Error signal output enable bit */

/*------------------------------------------------------------------------------*/
/*  UART3 Receive Buffer Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		u3rb_addr		02AEh
union WORD_DEF	u3rb_addr;
#define		u3rb			u3rb_addr.word
#define		u3rbl			u3rb_addr.byte.low			/* UART3 receive buffer register(low 8bit) */
#define		u3rbh			u3rb_addr.byte.high			/* UART3 receive buffer register(high 8bit) */

#define		abt_u3rb		u3rb_addr.bit.b11			/* Arbitration lost detect flag */
#define		oer_u3rb		u3rb_addr.bit.b12			/* Overrun error flag */
#define		fer_u3rb		u3rb_addr.bit.b13			/* Framing error flag */
#define		per_u3rb		u3rb_addr.bit.b14			/* Parity error flag */
#define		sum_u3rb		u3rb_addr.bit.b15			/* Error sum flag */

/*------------------------------------------------------------------------------*/
/*  I2C0 Data Shift Register                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s00_addr		02B0h
union BYTE_DEF	s00_addr;
#define		s00				s00_addr.byte

/*------------------------------------------------------------------------------*/
/*  I2C0 Address Register 0                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s0d0_addr		02B2h
union BYTE_DEF	s0d0_addr;
#define		s0d0			s0d0_addr.byte

#define		sad0_s0d0		s0d0_addr.bit.b1			/* Slave address */
#define		sad1_s0d0		s0d0_addr.bit.b2			/* Slave address */
#define		sad2_s0d0		s0d0_addr.bit.b3			/* Slave address */
#define		sad3_s0d0		s0d0_addr.bit.b4			/* Slave address */
#define		sad4_s0d0		s0d0_addr.bit.b5			/* Slave address */
#define		sad5_s0d0		s0d0_addr.bit.b6			/* Slave address */
#define		sad6_s0d0		s0d0_addr.bit.b7			/* Slave address */

/*------------------------------------------------------------------------------*/
/*  I2C0 Control Register 0                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s1d0_addr		02B3h
union BYTE_DEF	s1d0_addr;
#define		s1d0			s1d0_addr.byte

#define		bc0				s1d0_addr.bit.b0			/* Bit counter(number of transmitted/received bits) */
#define		bc1				s1d0_addr.bit.b1			/* Bit counter(number of transmitted/received bits) */
#define		bc2				s1d0_addr.bit.b2			/* Bit counter(number of transmitted/received bits) */
#define		es0				s1d0_addr.bit.b3			/* I2C-bus interface enable bit */
#define		als				s1d0_addr.bit.b4			/* Data format selection bit */
#define		ihr				s1d0_addr.bit.b6			/* I2C-bus interface reset bit */
#define		tiss			s1d0_addr.bit.b7			/* I2C-bus interface pin input level select bit */

/*------------------------------------------------------------------------------*/
/*  I2C0 Clock Control Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s20_addr		02B4h
union BYTE_DEF	s20_addr;
#define		s20				s20_addr.byte

#define		ccr0			s20_addr.bit.b0				/* Bit rate control bit */
#define		ccr1			s20_addr.bit.b1				/* Bit rate control bit */
#define		ccr2			s20_addr.bit.b2				/* Bit rate control bit */
#define		ccr3			s20_addr.bit.b3				/* Bit rate control bit */
#define		ccr4			s20_addr.bit.b4				/* Bit rate control bit */
#define		fastmode		s20_addr.bit.b5				/* SCL mode select bit */
#define		ackbit			s20_addr.bit.b6				/* ACK bit */
#define		ackclk			s20_addr.bit.b7				/* ACK clock bit */

/*------------------------------------------------------------------------------*/
/*  I2C0 Start/Stop Condition Control Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s2d0_addr		02B5h
union BYTE_DEF	s2d0_addr;
#define		s2d0			s2d0_addr.byte

#define		ssc0			s2d0_addr.bit.b0			/* Start/stop condition setting bit */
#define		ssc1			s2d0_addr.bit.b1			/* Start/stop condition setting bit */
#define		ssc2			s2d0_addr.bit.b2			/* Start/stop condition setting bit */
#define		ssc3			s2d0_addr.bit.b3			/* Start/stop condition setting bit */
#define		ssc4			s2d0_addr.bit.b4			/* Start/stop condition setting bit */
#define		sip				s2d0_addr.bit.b5			/* SCL/SDA interrupt pin polarity select bit */
#define		sis				s2d0_addr.bit.b6			/* SCL/SDA interrupt pin select bit */
#define		stspsel			s2d0_addr.bit.b7			/* Start/stop condition generation select bit */

/*------------------------------------------------------------------------------*/
/*  I2C0 Control Register 1                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s3d0_addr		02B6h
union BYTE_DEF	s3d0_addr;
#define		s3d0			s3d0_addr.byte

#define		sim				s3d0_addr.bit.b0			/* Stop condition detect interrupt enable bit */
#define		wit				s3d0_addr.bit.b1			/* Data receive interrupt enable bit */
#define		sdam			s3d0_addr.bit.b4			/* Internal SDA output monitor bit */
#define		sclm			s3d0_addr.bit.b5			/* Internal SCL output monitor bit */
#define		ick0			s3d0_addr.bit.b6			/* I2C-bus system clock select bit(Enabled when bits ICK4 to ICK2 in the S4D0 register are 000b) */
#define		ick1			s3d0_addr.bit.b7			/* I2C-bus system clock select bit(Enabled when bits ICK4 to ICK2 in the S4D0 register are 000b) */

/*------------------------------------------------------------------------------*/
/*  I2C0 Control Register 2                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s4d0_addr		02B7h
union BYTE_DEF	s4d0_addr;
#define		s4d0			s4d0_addr.byte

#define		toe				s4d0_addr.bit.b0			/* Timeout detect function enable bit */
#define		tof				s4d0_addr.bit.b1			/* Timeout detect flag */
#define		tosel			s4d0_addr.bit.b2			/* Timeout detect time select bit */
#define		ick2			s4d0_addr.bit.b3			/* I2C-bus system clock select bit */
#define		ick3			s4d0_addr.bit.b4			/* I2C-bus system clock select bit */
#define		ick4			s4d0_addr.bit.b5			/* I2C-bus system clock select bit */
#define		mslad			s4d0_addr.bit.b6			/* Slave address control bit */
#define		scpin			s4d0_addr.bit.b7			/* Stop condition detect interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  I2C0 Status Register 0                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s10_addr		02B8h
union BYTE_DEF	s10_addr;
#define		s10				s10_addr.byte

#define		lrb				s10_addr.bit.b0				/* Last receive bit */
#define		adr0			s10_addr.bit.b1				/* General call detect flag */
#define		aas				s10_addr.bit.b2				/* Slave address compare flag */
#define		al				s10_addr.bit.b3				/* Arbitration lost detect flag */
#define		pin				s10_addr.bit.b4				/* I2C-Bus interface interrupt request bit */
#define		bb				s10_addr.bit.b5				/* Bus busy flag */
#define		trx				s10_addr.bit.b6				/* Communication mode select bit 0 */
#define		mst				s10_addr.bit.b7				/* Communication mode select bit 1 */

/*------------------------------------------------------------------------------*/
/*  I2C0 Status Register 1                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s11_addr		02B9h
union BYTE_DEF	s11_addr;
#define		s11				s11_addr.byte

#define		aas0			s11_addr.bit.b0				/* Slave address 0 compare flag */
#define		aas1			s11_addr.bit.b1				/* Slave address 1 compare flag */
#define		aas2			s11_addr.bit.b2				/* Slave address 2 compare flag */

/*------------------------------------------------------------------------------*/
/*  I2C0 Address Register 1                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s0d1_addr		02BAh
union BYTE_DEF	s0d1_addr;
#define		s0d1			s0d1_addr.byte

#define		sad0_s0d1		s0d1_addr.bit.b1			/* Slave address */
#define		sad1_s0d1		s0d1_addr.bit.b2			/* Slave address */
#define		sad2_s0d1		s0d1_addr.bit.b3			/* Slave address */
#define		sad3_s0d1		s0d1_addr.bit.b4			/* Slave address */
#define		sad4_s0d1		s0d1_addr.bit.b5			/* Slave address */
#define		sad5_s0d1		s0d1_addr.bit.b6			/* Slave address */
#define		sad6_s0d1		s0d1_addr.bit.b7			/* Slave address */

/*------------------------------------------------------------------------------*/
/*  I2C0 Address Register 2                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		s0d2_addr		02BBh
union BYTE_DEF	s0d2_addr;
#define		s0d2			s0d2_addr.byte

#define		sad0_s0d2		s0d2_addr.bit.b1			/* Slave address */
#define		sad1_s0d2		s0d2_addr.bit.b2			/* Slave address */
#define		sad2_s0d2		s0d2_addr.bit.b3			/* Slave address */
#define		sad3_s0d2		s0d2_addr.bit.b4			/* Slave address */
#define		sad4_s0d2		s0d2_addr.bit.b5			/* Slave address */
#define		sad5_s0d2		s0d2_addr.bit.b6			/* Slave address */
#define		sad6_s0d2		s0d2_addr.bit.b7			/* Slave address */

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 0                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm0_addr		02C0h
union WORD_DEF	g1tm0_addr;
#define		g1tm0			g1tm0_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 0                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po0_addr		02C0h
union WORD_DEF	g1po0_addr;
#define		g1po0			g1po0_addr.word

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 1                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm1_addr		02C2h
union WORD_DEF	g1tm1_addr;
#define		g1tm1			g1tm1_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 1                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po1_addr		02C2h
union WORD_DEF	g1po1_addr;
#define		g1po1			g1po1_addr.word

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 2                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm2_addr		02C4h
union WORD_DEF	g1tm2_addr;
#define		g1tm2			g1tm2_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 2                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po2_addr		02C4h
union WORD_DEF	g1po2_addr;
#define		g1po2			g1po2_addr.word

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 3                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm3_addr		02C6h
union WORD_DEF	g1tm3_addr;
#define		g1tm3			g1tm3_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 3                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po3_addr		02C6h
union WORD_DEF	g1po3_addr;
#define		g1po3			g1po3_addr.word

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 4                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm4_addr		02C8h
union WORD_DEF	g1tm4_addr;
#define		g1tm4			g1tm4_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 4                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po4_addr		02C8h
union WORD_DEF	g1po4_addr;
#define		g1po4			g1po4_addr.word

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 5                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm5_addr		02CAh
union WORD_DEF	g1tm5_addr;
#define		g1tm5			g1tm5_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 5                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po5_addr		02CAh
union WORD_DEF	g1po5_addr;
#define		g1po5			g1po5_addr.word

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 6                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm6_addr		02CCh
union WORD_DEF	g1tm6_addr;
#define		g1tm6			g1tm6_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 6                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po6_addr		02CCh
union WORD_DEF	g1po6_addr;
#define		g1po6			g1po6_addr.word

/*------------------------------------------------------------------------------*/
/*  Time measurement Register 7                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tm7_addr		02CEh
union WORD_DEF	g1tm7_addr;
#define		g1tm7			g1tm7_addr.word

/*------------------------------------------------------------------------------*/
/*  Pulse generation register 7                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1po7_addr		02CEh
union WORD_DEF	g1po7_addr;
#define		g1po7			g1po7_addr.word

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 0                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr0_addr	02D0h
union BYTE_DEF	g1pocr0_addr;
#define		g1pocr0			g1pocr0_addr.byte

#define		mod0_g1pocr0	g1pocr0_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr0	g1pocr0_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr0		g1pocr0_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr0		g1pocr0_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr0		g1pocr0_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 1                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr1_addr	02D1h
union BYTE_DEF	g1pocr1_addr;
#define		g1pocr1			g1pocr1_addr.byte

#define		mod0_g1pocr1	g1pocr1_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr1	g1pocr1_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr1		g1pocr1_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr1		g1pocr1_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr1		g1pocr1_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 2                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr2_addr	02D2h
union BYTE_DEF	g1pocr2_addr;
#define		g1pocr2			g1pocr2_addr.byte

#define		mod0_g1pocr2	g1pocr2_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr2	g1pocr2_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr2		g1pocr2_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr2		g1pocr2_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr2		g1pocr2_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 3                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr3_addr	02D3h
union BYTE_DEF	g1pocr3_addr;
#define		g1pocr3			g1pocr3_addr.byte

#define		mod0_g1pocr3	g1pocr3_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr3	g1pocr3_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr3		g1pocr3_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr3		g1pocr3_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr3		g1pocr3_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 4                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr4_addr	02D4h
union BYTE_DEF	g1pocr4_addr;
#define		g1pocr4			g1pocr4_addr.byte

#define		mod0_g1pocr4	g1pocr4_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr4	g1pocr4_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr4		g1pocr4_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr4		g1pocr4_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr4		g1pocr4_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 5                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr5_addr	02D5h
union BYTE_DEF	g1pocr5_addr;
#define		g1pocr5			g1pocr5_addr.byte

#define		mod0_g1pocr5	g1pocr5_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr5	g1pocr5_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr5		g1pocr5_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr5		g1pocr5_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr5		g1pocr5_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 6                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr6_addr	02D6h
union BYTE_DEF	g1pocr6_addr;
#define		g1pocr6			g1pocr6_addr.byte

#define		mod0_g1pocr6	g1pocr6_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr6	g1pocr6_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr6		g1pocr6_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr6		g1pocr6_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr6		g1pocr6_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Waveform Generation Control Register 7                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1pocr7_addr	02D7h
union BYTE_DEF	g1pocr7_addr;
#define		g1pocr7			g1pocr7_addr.byte

#define		mod0_g1pocr7	g1pocr7_addr.bit.b0			/* Operating mode select bit */
#define		mod1_g1pocr7	g1pocr7_addr.bit.b1			/* Operating mode select bit */
#define		ivl_g1pocr7		g1pocr7_addr.bit.b4			/* Default output value select bit */
#define		rld_g1pocr7		g1pocr7_addr.bit.b5			/* G1PO0 register value reload timing select bit */
#define		inv_g1pocr7		g1pocr7_addr.bit.b7			/* Output level inversion select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 0                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr0_addr	02D8h
union BYTE_DEF	g1tmcr0_addr;
#define		g1tmcr0			g1tmcr0_addr.byte

#define		cts0_g1tmcr0	g1tmcr0_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr0	g1tmcr0_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr0		g1tmcr0_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr0		g1tmcr0_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr0		g1tmcr0_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr0		g1tmcr0_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr0		g1tmcr0_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr0		g1tmcr0_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 1                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr1_addr	02D9h
union BYTE_DEF	g1tmcr1_addr;
#define		g1tmcr1			g1tmcr1_addr.byte

#define		cts0_g1tmcr1	g1tmcr1_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr1	g1tmcr1_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr1		g1tmcr1_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr1		g1tmcr1_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr1		g1tmcr1_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr1		g1tmcr1_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr1		g1tmcr1_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr1		g1tmcr1_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 2                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr2_addr	02DAh
union BYTE_DEF	g1tmcr2_addr;
#define		g1tmcr2			g1tmcr2_addr.byte

#define		cts0_g1tmcr2	g1tmcr2_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr2	g1tmcr2_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr2		g1tmcr2_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr2		g1tmcr2_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr2		g1tmcr2_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr2		g1tmcr2_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr2		g1tmcr2_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr2		g1tmcr2_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 3                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr3_addr	02DBh
union BYTE_DEF	g1tmcr3_addr;
#define		g1tmcr3			g1tmcr3_addr.byte

#define		cts0_g1tmcr3	g1tmcr3_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr3	g1tmcr3_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr3		g1tmcr3_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr3		g1tmcr3_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr3		g1tmcr3_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr3		g1tmcr3_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr3		g1tmcr3_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr3		g1tmcr3_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 4                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr4_addr	02DCh
union BYTE_DEF	g1tmcr4_addr;
#define		g1tmcr4			g1tmcr4_addr.byte

#define		cts0_g1tmcr4	g1tmcr4_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr4	g1tmcr4_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr4		g1tmcr4_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr4		g1tmcr4_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr4		g1tmcr4_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr4		g1tmcr4_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr4		g1tmcr4_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr4		g1tmcr4_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 5                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr5_addr	02DDh
union BYTE_DEF	g1tmcr5_addr;
#define		g1tmcr5			g1tmcr5_addr.byte

#define		cts0_g1tmcr5	g1tmcr5_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr5	g1tmcr5_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr5		g1tmcr5_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr5		g1tmcr5_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr5		g1tmcr5_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr5		g1tmcr5_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr5		g1tmcr5_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr5		g1tmcr5_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 6                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr6_addr	02DEh
union BYTE_DEF	g1tmcr6_addr;
#define		g1tmcr6			g1tmcr6_addr.byte

#define		cts0_g1tmcr6	g1tmcr6_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr6	g1tmcr6_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr6		g1tmcr6_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr6		g1tmcr6_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr6		g1tmcr6_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr6		g1tmcr6_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr6		g1tmcr6_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr6		g1tmcr6_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Control Register 7                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tmcr7_addr	02DFh
union BYTE_DEF	g1tmcr7_addr;
#define		g1tmcr7			g1tmcr7_addr.byte

#define		cts0_g1tmcr7	g1tmcr7_addr.bit.b0			/* Time measurement trigger select bit */
#define		cts1_g1tmcr7	g1tmcr7_addr.bit.b1			/* Time measurement trigger select bit */
#define		df0_g1tmcr7		g1tmcr7_addr.bit.b2			/* Digital filter function select bit */
#define		df1_g1tmcr7		g1tmcr7_addr.bit.b3			/* Digital filter function select bit */
#define		gt_g1tmcr7		g1tmcr7_addr.bit.b4			/* Gate function select bit */
#define		goc_g1tmcr7		g1tmcr7_addr.bit.b5			/* Gate function release select bit */
#define		gsc_g1tmcr7		g1tmcr7_addr.bit.b6			/* Gate function release bit */
#define		pr_g1tmcr7		g1tmcr7_addr.bit.b7			/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  Base Timer Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1bt_addr		02E0h
union WORD_DEF	g1bt_addr;
#define		g1bt			g1bt_addr.word

/*------------------------------------------------------------------------------*/
/*  Base Timer Control Register 0                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1bcr0_addr		02E2h
union BYTE_DEF	g1bcr0_addr;
#define		g1bcr0			g1bcr0_addr.byte

#define		bck0_g1bcr0		g1bcr0_addr.bit.b0			/* Count source select bit */
#define		bck1_g1bcr0		g1bcr0_addr.bit.b1			/* Count source select bit */
#define		rst4_g1bcr0		g1bcr0_addr.bit.b2			/* Base timer reset source select bit4 */
#define		ch7insel_g1bcr0	g1bcr0_addr.bit.b6			/* Channel 7 input select bit */
#define		it_g1bcr0		g1bcr0_addr.bit.b7			/* Base timer interrupt select bit */

/*------------------------------------------------------------------------------*/
/*  Base Timer Control Register 1                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1bcr1_addr		02E3h
union BYTE_DEF	g1bcr1_addr;
#define		g1bcr1			g1bcr1_addr.byte

#define		rst1_g1bcr1		g1bcr1_addr.bit.b1			/* Base timer reset source select bit1 */
#define		rst2_g1bcr1		g1bcr1_addr.bit.b2			/* Base timer reset source select bit2 */
#define		bts_g1bcr1		g1bcr1_addr.bit.b4			/* Base timer start bit */
#define		ud0_g1bcr1		g1bcr1_addr.bit.b5			/* Increment/decrement control bit */
#define		ud1_g1bcr1		g1bcr1_addr.bit.b6			/* Increment/decrement control bit */

/*------------------------------------------------------------------------------*/
/*  Time Measurement Prescale Register 6                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tpr6_addr		02E4h
union BYTE_DEF	g1tpr6_addr;
#define		g1tpr6			g1tpr6_addr.byte

/*------------------------------------------------------------------------------*/
/*  Time Measurement Prescale Register 7                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1tpr7_addr		02E5h
union BYTE_DEF	g1tpr7_addr;
#define		g1tpr7			g1tpr7_addr.byte

/*------------------------------------------------------------------------------*/
/*  Function Enable Register                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1fe_addr		02E6h
union BYTE_DEF	g1fe_addr;
#define		g1fe			g1fe_addr.byte

#define		ife0_g1fe		g1fe_addr.bit.b0			/* Channel 0 function enable bit */
#define		ife1_g1fe		g1fe_addr.bit.b1			/* Channel 1 function enable bit */
#define		ife2_g1fe		g1fe_addr.bit.b2			/* Channel 2 function enable bit */
#define		ife3_g1fe		g1fe_addr.bit.b3			/* Channel 3 function enable bit */
#define		ife4_g1fe		g1fe_addr.bit.b4			/* Channel 4 function enable bit */
#define		ife5_g1fe		g1fe_addr.bit.b5			/* Channel 5 function enable bit */
#define		ife6_g1fe		g1fe_addr.bit.b6			/* Channel 6 function enable bit */
#define		ife7_g1fe		g1fe_addr.bit.b7			/* Channel 7 function enable bit */

/*------------------------------------------------------------------------------*/
/*  Function Select Register                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1fs_addr		02E7h
union BYTE_DEF	g1fs_addr;
#define		g1fs			g1fs_addr.byte

#define		fsc0_g1fs		g1fs_addr.bit.b0			/* Channel 0 time measurement/waveform generation function select bit */
#define		fsc1_g1fs		g1fs_addr.bit.b1			/* Channel 1 time measurement/waveform generation function select bit */
#define		fsc2_g1fs		g1fs_addr.bit.b2			/* Channel 2 time measurement/waveform generation function select bit */
#define		fsc3_g1fs		g1fs_addr.bit.b3			/* Channel 3 time measurement/waveform generation function select bit */
#define		fsc4_g1fs		g1fs_addr.bit.b4			/* Channel 4 time measurement/waveform generation function select bit */
#define		fsc5_g1fs		g1fs_addr.bit.b5			/* Channel 5 time measurement/waveform generation function select bit */
#define		fsc6_g1fs		g1fs_addr.bit.b6			/* Channel 6 time measurement/waveform generation function select bit */
#define		fsc7_g1fs		g1fs_addr.bit.b7			/* Channel 7 time measurement/waveform generation function select bit */

/*------------------------------------------------------------------------------*/
/*  Base Timer Reset Register                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1btrr_addr		02E8h
union WORD_DEF	g1btrr_addr;
#define		g1btrr			g1btrr_addr.word

/*------------------------------------------------------------------------------*/
/*  Count Source Divide Register                                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1dv_addr		02EAh
union BYTE_DEF	g1dv_addr;
#define		g1dv			g1dv_addr.byte

/*------------------------------------------------------------------------------*/
/*  Waveform Output Master Enable Register                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1oer_addr		02ECh
union BYTE_DEF	g1oer_addr;
#define		g1oer			g1oer_addr.byte

#define		eoc0			g1oer_addr.bit.b0			/* OUTC1_0 output disable bit */
#define		eoc1			g1oer_addr.bit.b1			/* OUTC1_1 output disable bit */
#define		eoc2			g1oer_addr.bit.b2			/* OUTC1_2 output disable bit */
#define		eoc3			g1oer_addr.bit.b3			/* OUTC1_3 output disable bit */
#define		eoc4			g1oer_addr.bit.b4			/* OUTC1_4 output disable bit */
#define		eoc5			g1oer_addr.bit.b5			/* OUTC1_5 output disable bit */
#define		eoc6			g1oer_addr.bit.b6			/* OUTC1_6 output disable bit */
#define		eoc7			g1oer_addr.bit.b7			/* OUTC1_7 output disable bit */

/*------------------------------------------------------------------------------*/
/*  Timer S I/O Control Register 0                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1ior0_addr		02EEh
union BYTE_DEF	g1ior0_addr;
#define		g1ior0			g1ior0_addr.byte

#define		io00			g1ior0_addr.bit.b0			/* OUTC1_0 output control bit */
#define		io01			g1ior0_addr.bit.b1			/* OUTC1_0 output control bit */
#define		io10			g1ior0_addr.bit.b2			/* OUTC1_1 output control bit */
#define		io11			g1ior0_addr.bit.b3			/* OUTC1_1 output control bit */
#define		io20			g1ior0_addr.bit.b4			/* OUTC1_2 output control bit */
#define		io21			g1ior0_addr.bit.b5			/* OUTC1_2 output control bit */
#define		io30			g1ior0_addr.bit.b6			/* OUTC1_3 output control bit */
#define		io31			g1ior0_addr.bit.b7			/* OUTC1_3 output control bit */

/*------------------------------------------------------------------------------*/
/*  Timer S I/O Control Register 1                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1ior1_addr		02EFh
union BYTE_DEF	g1ior1_addr;
#define		g1ior1			g1ior1_addr.byte

#define		io40			g1ior1_addr.bit.b0			/* OUTC1_4 output control bit */
#define		io41			g1ior1_addr.bit.b1			/* OUTC1_4 output control bit */
#define		io50			g1ior1_addr.bit.b2			/* OUTC1_5 output control bit */
#define		io51			g1ior1_addr.bit.b3			/* OUTC1_5 output control bit */
#define		io60			g1ior1_addr.bit.b4			/* OUTC1_6 output control bit */
#define		io61			g1ior1_addr.bit.b5			/* OUTC1_6 output control bit */
#define		io70			g1ior1_addr.bit.b6			/* OUTC1_7 output control bit */
#define		io71			g1ior1_addr.bit.b7			/* OUTC1_7 output control bit */

/*------------------------------------------------------------------------------*/
/*  Interrupt Request Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1ir_addr		02F0h
union BYTE_DEF	g1ir_addr;
#define		g1ir			g1ir_addr.byte

#define		g1ir0			g1ir_addr.bit.b0			/* Channel 0 interrupt request bit */
#define		g1ir1			g1ir_addr.bit.b1			/* Channel 1 interrupt request bit */
#define		g1ir2			g1ir_addr.bit.b2			/* Channel 2 interrupt request bit */
#define		g1ir3			g1ir_addr.bit.b3			/* Channel 3 interrupt request bit */
#define		g1ir4			g1ir_addr.bit.b4			/* Channel 4 interrupt request bit */
#define		g1ir5			g1ir_addr.bit.b5			/* Channel 5 interrupt request bit */
#define		g1ir6			g1ir_addr.bit.b6			/* Channel 6 interrupt request bit */
#define		g1ir7			g1ir_addr.bit.b7			/* Channel 7 interrupt request bit */

/*------------------------------------------------------------------------------*/
/*  Interrupt Enable Register 0                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1ie0_addr		02F1h
union BYTE_DEF	g1ie0_addr;
#define		g1ie0			g1ie0_addr.byte

#define		g1ie00			g1ie0_addr.bit.b0			/* Channel 0 interrupt enable 0 bit */
#define		g1ie01			g1ie0_addr.bit.b1			/* Channel 1 interrupt enable 0 bit */
#define		g1ie02			g1ie0_addr.bit.b2			/* Channel 2 interrupt enable 0 bit */
#define		g1ie03			g1ie0_addr.bit.b3			/* Channel 3 interrupt enable 0 bit */
#define		g1ie04			g1ie0_addr.bit.b4			/* Channel 4 interrupt enable 0 bit */
#define		g1ie05			g1ie0_addr.bit.b5			/* Channel 5 interrupt enable 0 bit */
#define		g1ie06			g1ie0_addr.bit.b6			/* Channel 6 interrupt enable 0 bit */
#define		g1ie07			g1ie0_addr.bit.b7			/* Channel 7 interrupt enable 0 bit */

/*------------------------------------------------------------------------------*/
/*  Interrupt Enable Register 1                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		g1ie1_addr		02F2h
union BYTE_DEF	g1ie1_addr;
#define		g1ie1			g1ie1_addr.byte

#define		g1ie10			g1ie1_addr.bit.b0			/* Channel 0 interrupt enable 1 bit */
#define		g1ie11			g1ie1_addr.bit.b1			/* Channel 1 interrupt enable 1 bit */
#define		g1ie12			g1ie1_addr.bit.b2			/* Channel 2 interrupt enable 1 bit */
#define		g1ie13			g1ie1_addr.bit.b3			/* Channel 3 interrupt enable 1 bit */
#define		g1ie14			g1ie1_addr.bit.b4			/* Channel 4 interrupt enable 1 bit */
#define		g1ie15			g1ie1_addr.bit.b5			/* Channel 5 interrupt enable 1 bit */
#define		g1ie16			g1ie1_addr.bit.b6			/* Channel 6 interrupt enable 1 bit */
#define		g1ie17			g1ie1_addr.bit.b7			/* Channel 7 interrupt enable 1 bit */

/*------------------------------------------------------------------------------*/
/*  NMI Digital Debounce Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		nddr_addr		02FEh
union BYTE_DEF	nddr_addr;
#define		nddr			nddr_addr.byte

/*------------------------------------------------------------------------------*/
/*  P17 Digital Debounce Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p17ddr_addr		02FFh
union BYTE_DEF	p17ddr_addr;
#define		p17ddr			p17ddr_addr.byte

/*------------------------------------------------------------------------------*/
/*  Timer B3/B4/B5 Count Start Flag                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tbsr_addr		0300h
union BYTE_DEF	tbsr_addr;
#define		tbsr			tbsr_addr.byte

#define		tb3s			tbsr_addr.bit.b5			/* Timer B3 count start flag */
#define		tb4s			tbsr_addr.bit.b6			/* Timer B4 count start flag */
#define		tb5s			tbsr_addr.bit.b7			/* Timer B5 count start flag */

/*------------------------------------------------------------------------------*/
/*  Timer A1-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta11_addr		0302h
union WORD_DEF	ta11_addr;
#define		ta11			ta11_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer A2-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta21_addr		0304h
union WORD_DEF	ta21_addr;
#define		ta21			ta21_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer A4-1 Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta41_addr		0306h
union WORD_DEF	ta41_addr;
#define		ta41			ta41_addr.word

/*------------------------------------------------------------------------------*/
/*  Three-Phase PWM Control Register 0                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		invc0_addr		0308h
union BYTE_DEF	invc0_addr;
#define		invc0			invc0_addr.byte

#define		inv00			invc0_addr.bit.b0			/* ICTB2 count condition select bit */
#define		inv01			invc0_addr.bit.b1			/* ICTB2 count condition select bit */
#define		inv02			invc0_addr.bit.b2			/* Three-phase motor control timer function enable bit */
#define		inv03			invc0_addr.bit.b3			/* Three-phase motor control timer output control bit */
#define		inv04			invc0_addr.bit.b4			/* High- and low-side simultaneous turn-on disable */
#define		inv05			invc0_addr.bit.b5			/* High- and low-side simultaneous turn-on detect flag */
#define		inv06			invc0_addr.bit.b6			/* Modulation mode select bit */
#define		inv07			invc0_addr.bit.b7			/* Software trigger select bit */

/*------------------------------------------------------------------------------*/
/*  Three-Phase PWM Control Register 1                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		invc1_addr		0309h
union BYTE_DEF	invc1_addr;
#define		invc1			invc1_addr.byte

#define		inv10			invc1_addr.bit.b0			/* Timer A1, A2 and A4 start trigger select bit */
#define		inv11			invc1_addr.bit.b1			/* Timer A1-1, A2-1 and A4-1 control bit */
#define		inv12			invc1_addr.bit.b2			/* Dead time timer count source select bit */
#define		inv13			invc1_addr.bit.b3			/* Carrier wave rise/fall detect flag */
#define		inv14			invc1_addr.bit.b4			/* Active level control bit */
#define		inv15			invc1_addr.bit.b5			/* Dead time disable bit */
#define		inv16			invc1_addr.bit.b6			/* Dead time timer trigger select bit */

/*------------------------------------------------------------------------------*/
/*  Three-Phase Output Buffer Register 0                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		idb0_addr		030Ah
union BYTE_DEF	idb0_addr;
#define		idb0			idb0_addr.byte

#define		du0				idb0_addr.bit.b0			/* U-phase output buffer 0 */
#define		dub0			idb0_addr.bit.b1			/* U~-phase output buffer 0 */
#define		dv0				idb0_addr.bit.b2			/* V-phase output buffer 0 */
#define		dvb0			idb0_addr.bit.b3			/* V~-phase output buffer 0 */
#define		dw0				idb0_addr.bit.b4			/* W-phase output buffer 0 */
#define		dwb0			idb0_addr.bit.b5			/* W~-phase output buffer 0 */

/*------------------------------------------------------------------------------*/
/*  Three-Phase Output Buffer Register 1                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		idb1_addr		030Bh
union BYTE_DEF	idb1_addr;
#define		idb1			idb1_addr.byte

#define		du1				idb1_addr.bit.b0			/* U-phase output buffer 1 */
#define		dub1			idb1_addr.bit.b1			/* U~-phase output buffer 1 */
#define		dv1				idb1_addr.bit.b2			/* V-phase output buffer 1 */
#define		dvb1			idb1_addr.bit.b3			/* V~-phase output buffer 1 */
#define		dw1				idb1_addr.bit.b4			/* W-phase output buffer 1 */
#define		dwb1			idb1_addr.bit.b5			/* W~-phase output buffer 1 */

/*------------------------------------------------------------------------------*/
/*  Dead Time Timer                                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dtt_addr		030Ch
union BYTE_DEF	dtt_addr;
#define		dtt				dtt_addr.byte

/*------------------------------------------------------------------------------*/
/*  Timer B2 Interrupt Generation Frequency Set Counter                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ictb2_addr		030Dh
union BYTE_DEF	ictb2_addr;
#define		ictb2			ictb2_addr.byte

/*------------------------------------------------------------------------------*/
/*  Position-Data-Retain Function Control Register                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pdrf_addr		030Eh
union BYTE_DEF	pdrf_addr;
#define		pdrf			pdrf_addr.byte

#define		pdrw			pdrf_addr.bit.b0			/* W-phase position data retain bit */
#define		pdrv			pdrf_addr.bit.b1			/* V-phase position data retain bit */
#define		pdru			pdrf_addr.bit.b2			/* U-phase position data retain bit */
#define		pdrt			pdrf_addr.bit.b3			/* Retain-trigger polarity select bit */

/*------------------------------------------------------------------------------*/
/*  Timer B3 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb3_addr		0310h
union WORD_DEF	tb3_addr;
#define		tb3				tb3_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B4 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb4_addr		0312h
union WORD_DEF	tb4_addr;
#define		tb4				tb4_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B5 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb5_addr		0314h
union WORD_DEF	tb5_addr;
#define		tb5				tb5_addr.word

/*------------------------------------------------------------------------------*/
/*  Port Function Control Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pfcr_addr		0318h
union BYTE_DEF	pfcr_addr;
#define		pfcr			pfcr_addr.byte

#define		pfc0			pfcr_addr.bit.b0			/* Port P8_0 output function select bit */
#define		pfc1			pfcr_addr.bit.b1			/* Port P8_1 output function select bit */
#define		pfc2			pfcr_addr.bit.b2			/* Port P7_2 output function select bit */
#define		pfc3			pfcr_addr.bit.b3			/* Port P7_3 output function select bit */
#define		pfc4			pfcr_addr.bit.b4			/* Port P7_4 output function select bit */
#define		pfc5			pfcr_addr.bit.b5			/* Port P7_5 output function select bit */

/*------------------------------------------------------------------------------*/
/*  Timer B3 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb3mr_addr		031Bh
union BYTE_DEF	tb3mr_addr;
#define		tb3mr			tb3mr_addr.byte

#define		tmod0_tb3mr		tb3mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_tb3mr		tb3mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_tb3mr		tb3mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_tb3mr		tb3mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr3_tb3mr		tb3mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_tb3mr		tb3mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_tb3mr		tb3mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer B4 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb4mr_addr		031Ch
union BYTE_DEF	tb4mr_addr;
#define		tb4mr			tb4mr_addr.byte

#define		tmod0_tb4mr		tb4mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_tb4mr		tb4mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_tb4mr		tb4mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_tb4mr		tb4mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr3_tb4mr		tb4mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_tb4mr		tb4mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_tb4mr		tb4mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer B5 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb5mr_addr		031Dh
union BYTE_DEF	tb5mr_addr;
#define		tb5mr			tb5mr_addr.byte

#define		tmod0_tb5mr		tb5mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_tb5mr		tb5mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_tb5mr		tb5mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_tb5mr		tb5mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr3_tb5mr		tb5mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_tb5mr		tb5mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_tb5mr		tb5mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Count Start Flag                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tabsr_addr		0320h
union BYTE_DEF	tabsr_addr;
#define		tabsr			tabsr_addr.byte

#define		ta0s			tabsr_addr.bit.b0			/* Timer A0 count start flag */
#define		ta1s			tabsr_addr.bit.b1			/* Timer A1 count start flag */
#define		ta2s			tabsr_addr.bit.b2			/* Timer A2 count start flag */
#define		ta3s			tabsr_addr.bit.b3			/* Timer A3 count start flag */
#define		ta4s			tabsr_addr.bit.b4			/* Timer A4 count start flag */
#define		tb0s			tabsr_addr.bit.b5			/* Timer B0 count start flag */
#define		tb1s			tabsr_addr.bit.b6			/* Timer B1 count start flag */
#define		tb2s			tabsr_addr.bit.b7			/* Timer B2 count start flag */

/*------------------------------------------------------------------------------*/
/*  One-Shot Start Flag                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		onsf_addr		0322h
union BYTE_DEF	onsf_addr;
#define		onsf			onsf_addr.byte

#define		ta0os			onsf_addr.bit.b0			/* Timer A0 one-shot start flag */
#define		ta1os			onsf_addr.bit.b1			/* Timer A1 one-shot start flag */
#define		ta2os			onsf_addr.bit.b2			/* Timer A2 one-shot start flag */
#define		ta3os			onsf_addr.bit.b3			/* Timer A3 one-shot start flag */
#define		ta4os			onsf_addr.bit.b4			/* Timer A4 one-shot start flag */
#define		tazie			onsf_addr.bit.b5			/* Z-phase input enable bit */
#define		ta0tgl			onsf_addr.bit.b6			/* Timer A0 event/trigger select bit */
#define		ta0tgh			onsf_addr.bit.b7			/* Timer A0 event/trigger select bit */

/*------------------------------------------------------------------------------*/
/*  Trigger Select Register                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		trgsr_addr		0323h
union BYTE_DEF	trgsr_addr;
#define		trgsr			trgsr_addr.byte

#define		ta1tgl			trgsr_addr.bit.b0			/* Timer A1 event/trigger select bit */
#define		ta1tgh			trgsr_addr.bit.b1			/* Timer A1 event/trigger select bit */
#define		ta2tgl			trgsr_addr.bit.b2			/* Timer A2 event/trigger select bit */
#define		ta2tgh			trgsr_addr.bit.b3			/* Timer A2 event/trigger select bit */
#define		ta3tgl			trgsr_addr.bit.b4			/* Timer A3 event/trigger select bit */
#define		ta3tgh			trgsr_addr.bit.b5			/* Timer A3 event/trigger select bit */
#define		ta4tgl			trgsr_addr.bit.b6			/* Timer A4 event/trigger select bit */
#define		ta4tgh			trgsr_addr.bit.b7			/* Timer A4 event/trigger select bit */

/*------------------------------------------------------------------------------*/
/*  Increment/Decrement Flag                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		udf_addr		0324h
union BYTE_DEF	udf_addr;
#define		udf				udf_addr.byte

#define		ta0ud			udf_addr.bit.b0				/* Timer A0 increment/decrement flag */
#define		ta1ud			udf_addr.bit.b1				/* Timer A1 increment/decrement flag */
#define		ta2ud			udf_addr.bit.b2				/* Timer A2 increment/decrement flag */
#define		ta3ud			udf_addr.bit.b3				/* Timer A3 increment/decrement flag */
#define		ta4ud			udf_addr.bit.b4				/* Timer A4 increment/decrement flag */
#define		ta2p			udf_addr.bit.b5				/* Timer A2 two-phase pulse signal processing select bit */
#define		ta3p			udf_addr.bit.b6				/* Timer A3 two-phase pulse signal processing select bit */
#define		ta4p			udf_addr.bit.b7				/* Timer A4 two-phase pulse signal processing select bit */

/*------------------------------------------------------------------------------*/
/*  Timer A0 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta0_addr		0326h
union WORD_DEF	ta0_addr;
#define		ta0				ta0_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer A1 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta1_addr		0328h
union WORD_DEF	ta1_addr;
#define		ta1				ta1_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer A2 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta2_addr		032Ah
union WORD_DEF	ta2_addr;
#define		ta2				ta2_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer A3 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta3_addr		032Ch
union WORD_DEF	ta3_addr;
#define		ta3				ta3_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer A4 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta4_addr		032Eh
union WORD_DEF	ta4_addr;
#define		ta4				ta4_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B0 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb0_addr		0330h
union WORD_DEF	tb0_addr;
#define		tb0				tb0_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B1 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb1_addr		0332h
union WORD_DEF	tb1_addr;
#define		tb1				tb1_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer B2 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb2_addr		0334h
union WORD_DEF	tb2_addr;
#define		tb2				tb2_addr.word

/*------------------------------------------------------------------------------*/
/*  Timer A0 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta0mr_addr		0336h
union BYTE_DEF	ta0mr_addr;
#define		ta0mr			ta0mr_addr.byte

#define		tmod0_ta0mr		ta0mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_ta0mr		ta0mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_ta0mr		ta0mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_ta0mr		ta0mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr2_ta0mr		ta0mr_addr.bit.b4			/* Function varies with each operation mode */
#define		mr3_ta0mr		ta0mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_ta0mr		ta0mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_ta0mr		ta0mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer A1 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta1mr_addr		0337h
union BYTE_DEF	ta1mr_addr;
#define		ta1mr			ta1mr_addr.byte

#define		tmod0_ta1mr		ta1mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_ta1mr		ta1mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_ta1mr		ta1mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_ta1mr		ta1mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr2_ta1mr		ta1mr_addr.bit.b4			/* Function varies with each operation mode */
#define		mr3_ta1mr		ta1mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_ta1mr		ta1mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_ta1mr		ta1mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer A2 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta2mr_addr		0338h
union BYTE_DEF	ta2mr_addr;
#define		ta2mr			ta2mr_addr.byte

#define		tmod0_ta2mr		ta2mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_ta2mr		ta2mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_ta2mr		ta2mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_ta2mr		ta2mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr2_ta2mr		ta2mr_addr.bit.b4			/* Function varies with each operation mode */
#define		mr3_ta2mr		ta2mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_ta2mr		ta2mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_ta2mr		ta2mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer A3 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta3mr_addr		0339h
union BYTE_DEF	ta3mr_addr;
#define		ta3mr			ta3mr_addr.byte

#define		tmod0_ta3mr		ta3mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_ta3mr		ta3mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_ta3mr		ta3mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_ta3mr		ta3mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr2_ta3mr		ta3mr_addr.bit.b4			/* Function varies with each operation mode */
#define		mr3_ta3mr		ta3mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_ta3mr		ta3mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_ta3mr		ta3mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer A4 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ta4mr_addr		033Ah
union BYTE_DEF	ta4mr_addr;
#define		ta4mr			ta4mr_addr.byte

#define		tmod0_ta4mr		ta4mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_ta4mr		ta4mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_ta4mr		ta4mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_ta4mr		ta4mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr2_ta4mr		ta4mr_addr.bit.b4			/* Function varies with each operation mode */
#define		mr3_ta4mr		ta4mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_ta4mr		ta4mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_ta4mr		ta4mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer B0 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb0mr_addr		033Bh
union BYTE_DEF	tb0mr_addr;
#define		tb0mr			tb0mr_addr.byte

#define		tmod0_tb0mr		tb0mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_tb0mr		tb0mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_tb0mr		tb0mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_tb0mr		tb0mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr3_tb0mr		tb0mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_tb0mr		tb0mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_tb0mr		tb0mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer B1 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb1mr_addr		033Ch
union BYTE_DEF	tb1mr_addr;
#define		tb1mr			tb1mr_addr.byte

#define		tmod0_tb1mr		tb1mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_tb1mr		tb1mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_tb1mr		tb1mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_tb1mr		tb1mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr3_tb1mr		tb1mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_tb1mr		tb1mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_tb1mr		tb1mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer B2 Mode Register                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb2mr_addr		033Dh
union BYTE_DEF	tb2mr_addr;
#define		tb2mr			tb2mr_addr.byte

#define		tmod0_tb2mr		tb2mr_addr.bit.b0			/* Operation mode select bit */
#define		tmod1_tb2mr		tb2mr_addr.bit.b1			/* Operation mode select bit */
#define		mr0_tb2mr		tb2mr_addr.bit.b2			/* Function varies with each operation mode */
#define		mr1_tb2mr		tb2mr_addr.bit.b3			/* Function varies with each operation mode */
#define		mr3_tb2mr		tb2mr_addr.bit.b5			/* Function varies with each operation mode */
#define		tck0_tb2mr		tb2mr_addr.bit.b6			/* Count source select bit(Function varies with each operation mode) */
#define		tck1_tb2mr		tb2mr_addr.bit.b7			/* Count source select bit(Function varies with each operation mode) */

/*------------------------------------------------------------------------------*/
/*  Timer B2 Special Mode Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		tb2sc_addr		033Eh
union BYTE_DEF	tb2sc_addr;
#define		tb2sc			tb2sc_addr.byte

#define		pwcon			tb2sc_addr.bit.b0			/* Timer B2 reload timing switch bit */
#define		ivpcr1			tb2sc_addr.bit.b1			/* Three-phase output port SD~ control bit 1 */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Second Data Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtcsec_addr		0340h
union BYTE_DEF	rtcsec_addr;
#define		rtcsec			rtcsec_addr.byte

#define		sc00			rtcsec_addr.bit.b0			/* First digit of second count bit */
#define		sc01			rtcsec_addr.bit.b1			/* First digit of second count bit */
#define		sc02			rtcsec_addr.bit.b2			/* First digit of second count bit */
#define		sc03			rtcsec_addr.bit.b3			/* First digit of second count bit */
#define		sc10			rtcsec_addr.bit.b4			/* Second digit of second count bit */
#define		sc11			rtcsec_addr.bit.b5			/* Second digit of second count bit */
#define		sc12			rtcsec_addr.bit.b6			/* Second digit of second count bit */
#define		bsy				rtcsec_addr.bit.b7			/* Real-time clock busy flag */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Minute Data Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtcmin_addr		0341h
union BYTE_DEF	rtcmin_addr;
#define		rtcmin			rtcmin_addr.byte

#define		mn00			rtcmin_addr.bit.b0			/* First digit of minute count bit */
#define		mn01			rtcmin_addr.bit.b1			/* First digit of minute count bit */
#define		mn02			rtcmin_addr.bit.b2			/* First digit of minute count bit */
#define		mn03			rtcmin_addr.bit.b3			/* First digit of minute count bit */
#define		mn10			rtcmin_addr.bit.b4			/* Second digit of minute count bit */
#define		mn11			rtcmin_addr.bit.b5			/* Second digit of minute count bit */
#define		mn12			rtcmin_addr.bit.b6			/* Second digit of minute count bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Hour Data Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtchr_addr		0342h
union BYTE_DEF	rtchr_addr;
#define		rtchr			rtchr_addr.byte

#define		hr00			rtchr_addr.bit.b0			/* First digit of hour count bit */
#define		hr01			rtchr_addr.bit.b1			/* First digit of hour count bit */
#define		hr02			rtchr_addr.bit.b2			/* First digit of hour count bit */
#define		hr03			rtchr_addr.bit.b3			/* First digit of hour count bit */
#define		hr10			rtchr_addr.bit.b4			/* Second digit of hour count bit */
#define		hr11			rtchr_addr.bit.b5			/* Second digit of hour count bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Day Data Register                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtcwk_addr		0343h
union BYTE_DEF	rtcwk_addr;
#define		rtcwk			rtcwk_addr.byte

#define		wk0				rtcwk_addr.bit.b0			/* Day count bit */
#define		wk1				rtcwk_addr.bit.b1			/* Day count bit */
#define		wk2				rtcwk_addr.bit.b2			/* Day count bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Control Register 1                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtccr1_addr		0344h
union BYTE_DEF	rtccr1_addr;
#define		rtccr1			rtccr1_addr.byte

#define		tcstf			rtccr1_addr.bit.b1			/* Real-time clock count status flag */
#define		toena			rtccr1_addr.bit.b2			/* RTCOUT pin output bit */
#define		rtcrst			rtccr1_addr.bit.b4			/* Real-time clock reset bit */
#define		rtcpm			rtccr1_addr.bit.b5			/* a.m./p.m. bit */
#define		h12h24			rtccr1_addr.bit.b6			/* Operating mode select bit */
#define		tstart			rtccr1_addr.bit.b7			/* Real-time clock count start bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Control Register 2                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtccr2_addr		0345h
union BYTE_DEF	rtccr2_addr;
#define		rtccr2			rtccr2_addr.byte

#define		seie			rtccr2_addr.bit.b0			/* Periodic interrupt triggered every second enable bit */
#define		mnie			rtccr2_addr.bit.b1			/* Periodic interrupt triggered every minute enable bit */
#define		hrie			rtccr2_addr.bit.b2			/* Periodic interrupt triggered every hour enable bit */
#define		dyie			rtccr2_addr.bit.b3			/* Periodic interrupt triggered every day enable bit */
#define		wkie			rtccr2_addr.bit.b4			/* Periodic interrupt triggered every week enable bit */
#define		rtccmp0			rtccr2_addr.bit.b5			/* Compare mode select bit */
#define		rtccmp1			rtccr2_addr.bit.b6			/* Compare mode select bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Count Source Select Register                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtccsr_addr		0346h
union BYTE_DEF	rtccsr_addr;
#define		rtccsr			rtccsr_addr.byte

#define		rcs0			rtccsr_addr.bit.b0			/* Count source select bit */
#define		rcs1			rtccsr_addr.bit.b1			/* Count source select bit */
#define		rcs2			rtccsr_addr.bit.b2			/* Count source frequency select bit */
#define		rcs3			rtccsr_addr.bit.b3			/* Count source frequency select bit */
#define		rcs4			rtccsr_addr.bit.b4			/* Count source frequency select bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Second Compare Data Register                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtccsec_addr	0348h
union BYTE_DEF	rtccsec_addr;
#define		rtccsec			rtccsec_addr.byte

#define		scmp00			rtccsec_addr.bit.b0			/* First digit of second compare data bit */
#define		scmp01			rtccsec_addr.bit.b1			/* First digit of second compare data bit */
#define		scmp02			rtccsec_addr.bit.b2			/* First digit of second compare data bit */
#define		scmp03			rtccsec_addr.bit.b3			/* First digit of second compare data bit */
#define		scmp10			rtccsec_addr.bit.b4			/* Second digit of second compare data bit */
#define		scmp11			rtccsec_addr.bit.b5			/* Second digit of second compare data bit */
#define		scmp12			rtccsec_addr.bit.b6			/* Second digit of second compare data bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Minute Compare Data Register                                */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtccmin_addr	0349h
union BYTE_DEF	rtccmin_addr;
#define		rtccmin			rtccmin_addr.byte

#define		mcmp00			rtccmin_addr.bit.b0			/* First digit of minute compare data bit */
#define		mcmp01			rtccmin_addr.bit.b1			/* First digit of minute compare data bit */
#define		mcmp02			rtccmin_addr.bit.b2			/* First digit of minute compare data bit */
#define		mcmp03			rtccmin_addr.bit.b3			/* First digit of minute compare data bit */
#define		mcmp10			rtccmin_addr.bit.b4			/* Second digit of minute compare data bit */
#define		mcmp11			rtccmin_addr.bit.b5			/* Second digit of minute compare data bit */
#define		mcmp12			rtccmin_addr.bit.b6			/* Second digit of minute compare data bit */

/*------------------------------------------------------------------------------*/
/*  Real-Time Clock Hour Compare Data Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		rtcchr_addr		034Ah
union BYTE_DEF	rtcchr_addr;
#define		rtcchr			rtcchr_addr.byte

#define		hcmp00			rtcchr_addr.bit.b0			/* First digit of hour compare data bit */
#define		hcmp01			rtcchr_addr.bit.b1			/* First digit of hour compare data bit */
#define		hcmp02			rtcchr_addr.bit.b2			/* First digit of hour compare data bit */
#define		hcmp03			rtcchr_addr.bit.b3			/* First digit of hour compare data bit */
#define		hcmp10			rtcchr_addr.bit.b4			/* Second digit of hour compare data bit */
#define		hcmp11			rtcchr_addr.bit.b5			/* Second digit of hour compare data bit */
#define		pmcmp			rtcchr_addr.bit.b6			/* a.m./p.m. compare bit */

/*------------------------------------------------------------------------------*/
/*  SS0 Bit Counter Register                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0br_addr		0353h
union BYTE_DEF	ss0br_addr;
#define		ss0br			ss0br_addr.byte

#define		bs0_ss0br		ss0br_addr.bit.b0			/* Serial bus interface data transfer length bit */
#define		bs1_ss0br		ss0br_addr.bit.b1			/* Serial bus interface data transfer length bit */
#define		bs2_ss0br		ss0br_addr.bit.b2			/* Serial bus interface data transfer length bit */
#define		bs3_ss0br		ss0br_addr.bit.b3			/* Serial bus interface data transfer length bit */

/*------------------------------------------------------------------------------*/
/*  SS0 Transmit Data Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0tdr_addr		0354h
union WORD_DEF	ss0tdr_addr;
#define		ss0tdr			ss0tdr_addr.word
#define		ss0tdrl			ss0tdr_addr.byte.low		/* SS0 transmit data register(low 8bit) */
#define		ss0tdrh			ss0tdr_addr.byte.high		/* SS0 transmit data register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  SS0 Receive Data Register                                                   */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0rdr_addr		0356h
union WORD_DEF	ss0rdr_addr;
#define		ss0rdr			ss0rdr_addr.word
#define		ss0rdrl			ss0rdr_addr.byte.low		/* SS0 receive data register(low 8bit) */
#define		ss0rdrh			ss0rdr_addr.byte.high		/* SS0 receive data register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  SS0 Control Register H                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0crh_addr		0358h
union BYTE_DEF	ss0crh_addr;
#define		ss0crh			ss0crh_addr.byte

#define		cks0_ss0crh		ss0crh_addr.bit.b0			/* Transmit/Receive Clock Rate Select Bit */
#define		cks1_ss0crh		ss0crh_addr.bit.b1			/* Transmit/Receive Clock Rate Select Bit */
#define		cks2_ss0crh		ss0crh_addr.bit.b2			/* Transmit/Receive Clock Rate Select Bit */
#define		mss_ss0crh		ss0crh_addr.bit.b5			/* Master/Slave Mode Select Bit */
#define		rsstp_ss0crh	ss0crh_addr.bit.b6			/* Receive Single Stop bit */

/*------------------------------------------------------------------------------*/
/*  SS0L Control Register L                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0crl_addr		0359h
union BYTE_DEF	ss0crl_addr;
#define		ss0crl			ss0crl_addr.byte

#define		sres_ss0crl		ss0crl_addr.bit.b1			/* Synchronous Serial Interface Controller Reset Bit */
#define		solp_ss0crl		ss0crl_addr.bit.b4			/* SOL Write Protect Bit */
#define		sol_ss0crl		ss0crl_addr.bit.b5			/* Serial Data Output Setting Bit */

/*------------------------------------------------------------------------------*/
/*  SS0 Mode Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0mr_addr		035Ah
union BYTE_DEF	ss0mr_addr;
#define		ss0mr			ss0mr_addr.byte

#define		bc0_ss0mr		ss0mr_addr.bit.b0			/* Bit counter */
#define		bc1_ss0mr		ss0mr_addr.bit.b1			/* Bit counter */
#define		bc2_ss0mr		ss0mr_addr.bit.b2			/* Bit counter */
#define		bc3_ss0mr		ss0mr_addr.bit.b3			/* Bit counter */
#define		cphs_ss0mr		ss0mr_addr.bit.b5			/* SSCK0 Clock Phase Select Bit */
#define		cpos_ss0mr		ss0mr_addr.bit.b6			/* SSCK0 Clock Polarity Select Bit */
#define		mls_ss0mr		ss0mr_addr.bit.b7			/* Bit Order Select Bit */

/*------------------------------------------------------------------------------*/
/*  SS0 Enable Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0er_addr		035Bh
union BYTE_DEF	ss0er_addr;
#define		ss0er			ss0er_addr.byte

#define		ceie_ss0er		ss0er_addr.bit.b0			/* Conflict Error Interrupt Enable Bit */
#define		re_ss0er		ss0er_addr.bit.b3			/* Receive Enable Bit */
#define		te_ss0er		ss0er_addr.bit.b4			/* Transmit Enable Bit */
#define		rie_ss0er		ss0er_addr.bit.b5			/* Receive Interrupt Enable Bit */
#define		teie_ss0er		ss0er_addr.bit.b6			/* Transmit End Interrupt Enable Bit */
#define		tie_ss0er		ss0er_addr.bit.b7			/* Transmit Interrupt Enable Bit */

/*------------------------------------------------------------------------------*/
/*  SS0 Status Register                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0sr_addr		035Ch
union BYTE_DEF	ss0sr_addr;
#define		ss0sr			ss0sr_addr.byte

#define		ce_ss0sr		ss0sr_addr.bit.b0			/* Conflict Error Flag */
#define		orer_ss0sr		ss0sr_addr.bit.b2			/* Overrun Error Flag */
#define		rdrf_ss0sr		ss0sr_addr.bit.b5			/* Receive Data Register Full Flag */
#define		tend_ss0sr		ss0sr_addr.bit.b6			/* Transmit End Flag */
#define		tdre_ss0sr		ss0sr_addr.bit.b7			/* Transmit Data Register Empty Flag */

/*------------------------------------------------------------------------------*/
/*  SS0 Mode Register 2                                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ss0mr2_addr		035Dh
union BYTE_DEF	ss0mr2_addr;
#define		ss0mr2			ss0mr2_addr.byte

#define		ssums_ss0mr2	ss0mr2_addr.bit.b0			/* Mode select bit */
#define		csos_ss0mr2		ss0mr2_addr.bit.b1			/* SCS0~ Pin Open Drain Output Select Bit */
#define		soos_ss0mr2		ss0mr2_addr.bit.b2			/* Serial Data Open Drain output Select Bit */
#define		sckos_ss0mr2	ss0mr2_addr.bit.b3			/* SSCK0 Pin Open Drain Output Select Bit */
#define		css0_ss0mr2		ss0mr2_addr.bit.b4			/* SCS0~ Pin Function Select Bit */
#define		css1_ss0mr2		ss0mr2_addr.bit.b5			/* SCS0~ Pin Function Select Bit */
#define		scks_ss0mr2		ss0mr2_addr.bit.b6			/* SSCK0 Pin Function Select Bit */
#define		bide_ss0mr2		ss0mr2_addr.bit.b7			/* Bidirectional mode Enable Bit */

/*------------------------------------------------------------------------------*/
/*  Pull-Up Control Register 0                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pur0_addr		0360h
union BYTE_DEF	pur0_addr;
#define		pur0			pur0_addr.byte

#define		pu00			pur0_addr.bit.b0			/* P0_0 to P0_3 pull-up */
#define		pu01			pur0_addr.bit.b1			/* P0_4 to P0_7 pull-up */
#define		pu02			pur0_addr.bit.b2			/* P1_0 to P1_3 pull-up */
#define		pu03			pur0_addr.bit.b3			/* P1_4 to P1_7 pull-up */
#define		pu04			pur0_addr.bit.b4			/* P2_0 to P2_3 pull-up */
#define		pu05			pur0_addr.bit.b5			/* P2_4 to P2_7 pull-up */
#define		pu06			pur0_addr.bit.b6			/* P3_0 to P3_3 pull-up */
#define		pu07			pur0_addr.bit.b7			/* P3_4 to P3_7 pull-up */

/*------------------------------------------------------------------------------*/
/*  Pull-Up Control Register 1                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pur1_addr		0361h
union BYTE_DEF	pur1_addr;
#define		pur1			pur1_addr.byte

#define		pu10			pur1_addr.bit.b0			/* P4_0 to P4_3 pull-up */
#define		pu11			pur1_addr.bit.b1			/* P4_4 to P4_7 pull-up */
#define		pu12			pur1_addr.bit.b2			/* P5_0 to P5_3 pull-up */
#define		pu13			pur1_addr.bit.b3			/* P5_4 to P5_7 pull-up */
#define		pu14			pur1_addr.bit.b4			/* P6_0 to P6_3 pull-up */
#define		pu15			pur1_addr.bit.b5			/* P6_4 to P6_7 pull-up */
#define		pu16			pur1_addr.bit.b6			/* P7_2 to P7_3 pull-up */
#define		pu17			pur1_addr.bit.b7			/* P7_4 to P7_7 pull-up */

/*------------------------------------------------------------------------------*/
/*  Pull-Up Control Register 2                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pur2_addr		0362h
union BYTE_DEF	pur2_addr;
#define		pur2			pur2_addr.byte

#define		pu20			pur2_addr.bit.b0			/* P8_0 to P8_3 pull-up */
#define		pu21			pur2_addr.bit.b1			/* P8_4 to P8_7 pull-up */
#define		pu22			pur2_addr.bit.b2			/* P9_0 to P9_3 pull-up */
#define		pu23			pur2_addr.bit.b3			/* P9_4 to P9_7 pull-up */
#define		pu24			pur2_addr.bit.b4			/* P10_0 to P10_3 pull-up */
#define		pu25			pur2_addr.bit.b5			/* P10_4 to P10_7 pull-up */

/*------------------------------------------------------------------------------*/
/*  Port Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pcr_addr		0366h
union BYTE_DEF	pcr_addr;
#define		pcr				pcr_addr.byte

#define		pcr0			pcr_addr.bit.b0				/* Port P1 control bit */

/*------------------------------------------------------------------------------*/
/*  Input Threshold Select Register 0                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vlt0_addr		036Ch
union BYTE_DEF	vlt0_addr;
#define		vlt0			vlt0_addr.byte

#define		vlt00			vlt0_addr.bit.b0			/* P0 input level select bit */
#define		vlt01			vlt0_addr.bit.b1			/* P0 input level select bit */
#define		vlt02			vlt0_addr.bit.b2			/* P1 input level select bit */
#define		vlt03			vlt0_addr.bit.b3			/* P1 input level select bit */
#define		vlt04			vlt0_addr.bit.b4			/* P2 input level select bit */
#define		vlt05			vlt0_addr.bit.b5			/* P2 input level select bit */
#define		vlt06			vlt0_addr.bit.b6			/* P3 input level select bit */
#define		vlt07			vlt0_addr.bit.b7			/* P3 input level select bit */

/*------------------------------------------------------------------------------*/
/*  Input Threshold Select Register 1                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vlt1_addr		036Dh
union BYTE_DEF	vlt1_addr;
#define		vlt1			vlt1_addr.byte

#define		vlt10			vlt1_addr.bit.b0			/* P4 input level select bit */
#define		vlt11			vlt1_addr.bit.b1			/* P4 input level select bit */
#define		vlt12			vlt1_addr.bit.b2			/* P5 input level select bit */
#define		vlt13			vlt1_addr.bit.b3			/* P5 input level select bit */
#define		vlt14			vlt1_addr.bit.b4			/* P6 input level select bit */
#define		vlt15			vlt1_addr.bit.b5			/* P6 input level select bit */
#define		vlt16			vlt1_addr.bit.b6			/* P7 input level select bit */
#define		vlt17			vlt1_addr.bit.b7			/* P7 input level select bit */

/*------------------------------------------------------------------------------*/
/*  Input Threshold Select Register 2                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		vlt2_addr		036Eh
union BYTE_DEF	vlt2_addr;
#define		vlt2			vlt2_addr.byte

#define		vlt20			vlt2_addr.bit.b0			/* P8 input level select bit */
#define		vlt21			vlt2_addr.bit.b1			/* P8 input level select bit */
#define		vlt22			vlt2_addr.bit.b2			/* P9 input level select bit */
#define		vlt23			vlt2_addr.bit.b3			/* P9 input level select bit */
#define		vlt24			vlt2_addr.bit.b4			/* P10 input level select bit */
#define		vlt25			vlt2_addr.bit.b5			/* P10 input level select bit */

/*------------------------------------------------------------------------------*/
/*  Pin Assignment Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pacr_addr		0370h
union BYTE_DEF	pacr_addr;
#define		pacr			pacr_addr.byte

#define		pacr0			pacr_addr.bit.b0			/* Pin enabling bit */
#define		pacr1			pacr_addr.bit.b1			/* Pin enabling bit */
#define		pacr2			pacr_addr.bit.b2			/* Pin enabling bit */
#define		u1map			pacr_addr.bit.b7			/* UART1 pin remapping bit */

/*------------------------------------------------------------------------------*/
/*  Count Source Protection Mode Register                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		cspr_addr		037Ch
union BYTE_DEF	cspr_addr;
#define		cspr			cspr_addr.byte

#define		cspro			cspr_addr.bit.b7			/* Count source protection mode select bit */

/*------------------------------------------------------------------------------*/
/*  Watchdog Timer Refresh Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		wdtr_addr		037Dh
union BYTE_DEF	wdtr_addr;
#define		wdtr			wdtr_addr.byte

/*------------------------------------------------------------------------------*/
/*  Watchdog Timer Start Register                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		wdts_addr		037Eh
union BYTE_DEF	wdts_addr;
#define		wdts			wdts_addr.byte

/*------------------------------------------------------------------------------*/
/*  Watchdog Timer Control Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		wdc_addr		037Fh
union BYTE_DEF	wdc_addr;
#define		wdc				wdc_addr.byte

#define		wdc0			wdc_addr.bit.b0				/* The contents of the watchdog timer counter, b10 to b5, can be read. */
#define		wdc1			wdc_addr.bit.b1				/* The contents of the watchdog timer counter, b10 to b5, can be read. */
#define		wdc2			wdc_addr.bit.b2				/* The contents of the watchdog timer counter, b10 to b5, can be read. */
#define		wdc3			wdc_addr.bit.b3				/* The contents of the watchdog timer counter, b10 to b5, can be read. */
#define		wdc4			wdc_addr.bit.b4				/* The contents of the watchdog timer counter, b10 to b5, can be read. */
#define		wdc5			wdc_addr.bit.b5				/* The contents of the watchdog timer counter, b10 to b5, can be read. */
#define		wdc7			wdc_addr.bit.b7				/* Prescaler select bit */

/*------------------------------------------------------------------------------*/
/*  DMA2 Source Select Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm2sl_addr		0390h
union BYTE_DEF	dm2sl_addr;
#define		dm2sl			dm2sl_addr.byte

#define		dsel0_dm2sl		dm2sl_addr.bit.b0			/* DMA request source select bit */
#define		dsel1_dm2sl		dm2sl_addr.bit.b1			/* DMA request source select bit */
#define		dsel2_dm2sl		dm2sl_addr.bit.b2			/* DMA request source select bit */
#define		dsel3_dm2sl		dm2sl_addr.bit.b3			/* DMA request source select bit */
#define		dsel4_dm2sl		dm2sl_addr.bit.b4			/* DMA request source select bit */
#define		dms_dm2sl		dm2sl_addr.bit.b6			/* DMA request source expansion select bit */
#define		dsr_dm2sl		dm2sl_addr.bit.b7			/* Software DMA request bit */

/*------------------------------------------------------------------------------*/
/*  DMA3 Source Select Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm3sl_addr		0392h
union BYTE_DEF	dm3sl_addr;
#define		dm3sl			dm3sl_addr.byte

#define		dsel0_dm3sl		dm3sl_addr.bit.b0			/* DMA request source select bit */
#define		dsel1_dm3sl		dm3sl_addr.bit.b1			/* DMA request source select bit */
#define		dsel2_dm3sl		dm3sl_addr.bit.b2			/* DMA request source select bit */
#define		dsel3_dm3sl		dm3sl_addr.bit.b3			/* DMA request source select bit */
#define		dsel4_dm3sl		dm3sl_addr.bit.b4			/* DMA request source select bit */
#define		dms_dm3sl		dm3sl_addr.bit.b6			/* DMA request source expansion select bit */
#define		dsr_dm3sl		dm3sl_addr.bit.b7			/* Software DMA request bit */

/*------------------------------------------------------------------------------*/
/*  DMA0 Source Select Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm0sl_addr		0398h
union BYTE_DEF	dm0sl_addr;
#define		dm0sl			dm0sl_addr.byte

#define		dsel0_dm0sl		dm0sl_addr.bit.b0			/* DMA request source select bit */
#define		dsel1_dm0sl		dm0sl_addr.bit.b1			/* DMA request source select bit */
#define		dsel2_dm0sl		dm0sl_addr.bit.b2			/* DMA request source select bit */
#define		dsel3_dm0sl		dm0sl_addr.bit.b3			/* DMA request source select bit */
#define		dsel4_dm0sl		dm0sl_addr.bit.b4			/* DMA request source select bit */
#define		dms_dm0sl		dm0sl_addr.bit.b6			/* DMA request source expansion select bit */
#define		dsr_dm0sl		dm0sl_addr.bit.b7			/* Software DMA request bit */

/*------------------------------------------------------------------------------*/
/*  DMA1 Source Select Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dm1sl_addr		039Ah
union BYTE_DEF	dm1sl_addr;
#define		dm1sl			dm1sl_addr.byte

#define		dsel0_dm1sl		dm1sl_addr.bit.b0			/* DMA request source select bit */
#define		dsel1_dm1sl		dm1sl_addr.bit.b1			/* DMA request source select bit */
#define		dsel2_dm1sl		dm1sl_addr.bit.b2			/* DMA request source select bit */
#define		dsel3_dm1sl		dm1sl_addr.bit.b3			/* DMA request source select bit */
#define		dsel4_dm1sl		dm1sl_addr.bit.b4			/* DMA request source select bit */
#define		dms_dm1sl		dm1sl_addr.bit.b6			/* DMA request source expansion select bit */
#define		dsr_dm1sl		dm1sl_addr.bit.b7			/* Software DMA request bit */

/*------------------------------------------------------------------------------*/
/*  Open-Circuit Detection Assist Function Register                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ainrst_addr		03A2h
union BYTE_DEF	ainrst_addr;
#define		ainrst			ainrst_addr.byte

#define		ainrst0			ainrst_addr.bit.b4			/* Open-circuit detection assist function enable bit */
#define		ainrst1			ainrst_addr.bit.b5			/* Open-circuit detection assist function enable bit */

/*------------------------------------------------------------------------------*/
/*  SFR Snoop Address Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		crcsar_addr		03B4h
union WORD_DEF	crcsar_addr;
#define		crcsar			crcsar_addr.word
#define		crcsarl			crcsar_addr.byte.low		/* SFR Snoop Address Register(low 8bit) */
#define		crcsarh			crcsar_addr.byte.high		/* SFR Snoop Address Register(high 8bit) */

#define		crcsar0			crcsar_addr.bit.b0			/* SFR snoop address bit */
#define		crcsar1			crcsar_addr.bit.b1			/* SFR snoop address bit */
#define		crcsar2			crcsar_addr.bit.b2			/* SFR snoop address bit */
#define		crcsar3			crcsar_addr.bit.b3			/* SFR snoop address bit */
#define		crcsar4			crcsar_addr.bit.b4			/* SFR snoop address bit */
#define		crcsar5			crcsar_addr.bit.b5			/* SFR snoop address bit */
#define		crcsar6			crcsar_addr.bit.b6			/* SFR snoop address bit */
#define		crcsar7			crcsar_addr.bit.b7			/* SFR snoop address bit */
#define		crcsar8			crcsar_addr.bit.b8			/* SFR snoop address bit */
#define		crcsar9			crcsar_addr.bit.b9			/* SFR snoop address bit */
#define		crcsr			crcsar_addr.bit.b14			/* Snoop-on-read enable bit */
#define		crcsw			crcsar_addr.bit.b15			/* Snoop-on-write enable bit */

/*------------------------------------------------------------------------------*/
/*  CRC Mode Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		crcmr_addr		03B6h
union BYTE_DEF	crcmr_addr;
#define		crcmr			crcmr_addr.byte

#define		crcps			crcmr_addr.bit.b0			/* CRC polynomial select bit */
#define		crcms			crcmr_addr.bit.b7			/* CRC mode select bit */

/*------------------------------------------------------------------------------*/
/*  CRC Data Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		crcd_addr		03BCh
union WORD_DEF	crcd_addr;
#define		crcd			crcd_addr.word
#define		crcdl			crcd_addr.byte.low			/* CRC Data Register(low 8bit) */
#define		crcdh			crcd_addr.byte.high			/* CRC Data Register(high 8bit) */

/*------------------------------------------------------------------------------*/
/*  CRC Input Register                                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		crcin_addr		03BEh
union BYTE_DEF	crcin_addr;
#define		crcin			crcin_addr.byte

/*------------------------------------------------------------------------------*/
/*  A/D Register 0                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad0_addr		03C0h
union WORD_DEF	ad0_addr;
#define		ad0				ad0_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Register 1                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad1_addr		03C2h
union WORD_DEF	ad1_addr;
#define		ad1				ad1_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Register 2                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad2_addr		03C4h
union WORD_DEF	ad2_addr;
#define		ad2				ad2_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Register 3                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad3_addr		03C6h
union WORD_DEF	ad3_addr;
#define		ad3				ad3_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Register 4                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad4_addr		03C8h
union WORD_DEF	ad4_addr;
#define		ad4				ad4_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Register 5                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad5_addr		03CAh
union WORD_DEF	ad5_addr;
#define		ad5				ad5_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Register 6                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad6_addr		03CCh
union WORD_DEF	ad6_addr;
#define		ad6				ad6_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Register 7                                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		ad7_addr		03CEh
union WORD_DEF	ad7_addr;
#define		ad7				ad7_addr.word

/*------------------------------------------------------------------------------*/
/*  A/D Control Register 2                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		adcon2_addr		03D4h
union BYTE_DEF	adcon2_addr;
#define		adcon2			adcon2_addr.byte

#define		adgsel0			adcon2_addr.bit.b1			/* A/D input group select bit */
#define		adgsel1			adcon2_addr.bit.b2			/* A/D input group select bit */
#define		cks2			adcon2_addr.bit.b4			/* Frequency select bit 2 */
#define		cks3			adcon2_addr.bit.b7			/* fAD select bit */

/*------------------------------------------------------------------------------*/
/*  A/D Control Register 0                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		adcon0_addr		03D6h
union BYTE_DEF	adcon0_addr;
#define		adcon0			adcon0_addr.byte

#define		ch0				adcon0_addr.bit.b0			/* Analog input pin select bit */
#define		ch1				adcon0_addr.bit.b1			/* Analog input pin select bit */
#define		ch2				adcon0_addr.bit.b2			/* Analog input pin select bit */
#define		md0				adcon0_addr.bit.b3			/* A/D operation mode select bit 0 */
#define		md1				adcon0_addr.bit.b4			/* A/D operation mode select bit 0 */
#define		trg				adcon0_addr.bit.b5			/* Trigger select bit */
#define		adst			adcon0_addr.bit.b6			/* A/D conversion start flag */
#define		cks0			adcon0_addr.bit.b7			/* Frequency select bit 0 */

/*------------------------------------------------------------------------------*/
/*  A/D Control Register 1                                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		adcon1_addr		03D7h
union BYTE_DEF	adcon1_addr;
#define		adcon1			adcon1_addr.byte

#define		scan0			adcon1_addr.bit.b0			/* A/D sweep pin select bit */
#define		scan1			adcon1_addr.bit.b1			/* A/D sweep pin select bit */
#define		cks1			adcon1_addr.bit.b4			/* Frequency select bit 1 */
#define		adstby			adcon1_addr.bit.b5			/* A/D standby bit */

/*------------------------------------------------------------------------------*/
/*  D/A0 register                                                               */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		da0_addr		03D8h
union BYTE_DEF	da0_addr;
#define		da0				da0_addr.byte

/*------------------------------------------------------------------------------*/
/*  D/A control register                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		dacon_addr		03DCh
union BYTE_DEF	dacon_addr;
#define		dacon			dacon_addr.byte

#define		da0e			dacon_addr.bit.b0			/* D/A0 output enable bit */

/*------------------------------------------------------------------------------*/
/*  Port P0 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p0_addr			03E0h
union BYTE_DEF	p0_addr;
#define		p0				p0_addr.byte

#define		p0_0			p0_addr.bit.b0				/* Port P0_0 bit */
#define		p0_1			p0_addr.bit.b1				/* Port P0_1 bit */
#define		p0_2			p0_addr.bit.b2				/* Port P0_2 bit */
#define		p0_3			p0_addr.bit.b3				/* Port P0_3 bit */
#define		p0_4			p0_addr.bit.b4				/* Port P0_4 bit */
#define		p0_5			p0_addr.bit.b5				/* Port P0_5 bit */
#define		p0_6			p0_addr.bit.b6				/* Port P0_6 bit */
#define		p0_7			p0_addr.bit.b7				/* Port P0_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P1 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p1_addr			03E1h
union BYTE_DEF	p1_addr;
#define		p1				p1_addr.byte

#define		p1_0			p1_addr.bit.b0				/* Port P1_0 bit */
#define		p1_1			p1_addr.bit.b1				/* Port P1_1 bit */
#define		p1_2			p1_addr.bit.b2				/* Port P1_2 bit */
#define		p1_3			p1_addr.bit.b3				/* Port P1_3 bit */
#define		p1_4			p1_addr.bit.b4				/* Port P1_4 bit */
#define		p1_5			p1_addr.bit.b5				/* Port P1_5 bit */
#define		p1_6			p1_addr.bit.b6				/* Port P1_6 bit */
#define		p1_7			p1_addr.bit.b7				/* Port P1_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P0 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd0_addr		03E2h
union BYTE_DEF	pd0_addr;
#define		pd0				pd0_addr.byte

#define		pd0_0			pd0_addr.bit.b0				/* Port P0_0 direction bit */
#define		pd0_1			pd0_addr.bit.b1				/* Port P0_1 direction bit */
#define		pd0_2			pd0_addr.bit.b2				/* Port P0_2 direction bit */
#define		pd0_3			pd0_addr.bit.b3				/* Port P0_3 direction bit */
#define		pd0_4			pd0_addr.bit.b4				/* Port P0_4 direction bit */
#define		pd0_5			pd0_addr.bit.b5				/* Port P0_5 direction bit */
#define		pd0_6			pd0_addr.bit.b6				/* Port P0_6 direction bit */
#define		pd0_7			pd0_addr.bit.b7				/* Port P0_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P1 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd1_addr		03E3h
union BYTE_DEF	pd1_addr;
#define		pd1				pd1_addr.byte

#define		pd1_0			pd1_addr.bit.b0				/* Port P1_0 direction bit */
#define		pd1_1			pd1_addr.bit.b1				/* Port P1_1 direction bit */
#define		pd1_2			pd1_addr.bit.b2				/* Port P1_2 direction bit */
#define		pd1_3			pd1_addr.bit.b3				/* Port P1_3 direction bit */
#define		pd1_4			pd1_addr.bit.b4				/* Port P1_4 direction bit */
#define		pd1_5			pd1_addr.bit.b5				/* Port P1_5 direction bit */
#define		pd1_6			pd1_addr.bit.b6				/* Port P1_6 direction bit */
#define		pd1_7			pd1_addr.bit.b7				/* Port P1_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P2 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p2_addr			03E4h
union BYTE_DEF	p2_addr;
#define		p2				p2_addr.byte

#define		p2_0			p2_addr.bit.b0				/* Port P2_0 bit */
#define		p2_1			p2_addr.bit.b1				/* Port P2_1 bit */
#define		p2_2			p2_addr.bit.b2				/* Port P2_2 bit */
#define		p2_3			p2_addr.bit.b3				/* Port P2_3 bit */
#define		p2_4			p2_addr.bit.b4				/* Port P2_4 bit */
#define		p2_5			p2_addr.bit.b5				/* Port P2_5 bit */
#define		p2_6			p2_addr.bit.b6				/* Port P2_6 bit */
#define		p2_7			p2_addr.bit.b7				/* Port P2_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P3 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p3_addr			03E5h
union BYTE_DEF	p3_addr;
#define		p3				p3_addr.byte

#define		p3_0			p3_addr.bit.b0				/* Port P3_0 bit */
#define		p3_1			p3_addr.bit.b1				/* Port P3_1 bit */
#define		p3_2			p3_addr.bit.b2				/* Port P3_2 bit */
#define		p3_3			p3_addr.bit.b3				/* Port P3_3 bit */
#define		p3_4			p3_addr.bit.b4				/* Port P3_4 bit */
#define		p3_5			p3_addr.bit.b5				/* Port P3_5 bit */
#define		p3_6			p3_addr.bit.b6				/* Port P3_6 bit */
#define		p3_7			p3_addr.bit.b7				/* Port P3_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P2 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd2_addr		03E6h
union BYTE_DEF	pd2_addr;
#define		pd2				pd2_addr.byte

#define		pd2_0			pd2_addr.bit.b0				/* Port P2_0 direction bit */
#define		pd2_1			pd2_addr.bit.b1				/* Port P2_1 direction bit */
#define		pd2_2			pd2_addr.bit.b2				/* Port P2_2 direction bit */
#define		pd2_3			pd2_addr.bit.b3				/* Port P2_3 direction bit */
#define		pd2_4			pd2_addr.bit.b4				/* Port P2_4 direction bit */
#define		pd2_5			pd2_addr.bit.b5				/* Port P2_5 direction bit */
#define		pd2_6			pd2_addr.bit.b6				/* Port P2_6 direction bit */
#define		pd2_7			pd2_addr.bit.b7				/* Port P2_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P3 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd3_addr		03E7h
union BYTE_DEF	pd3_addr;
#define		pd3				pd3_addr.byte

#define		pd3_0			pd3_addr.bit.b0				/* Port P3_0 direction bit */
#define		pd3_1			pd3_addr.bit.b1				/* Port P3_1 direction bit */
#define		pd3_2			pd3_addr.bit.b2				/* Port P3_2 direction bit */
#define		pd3_3			pd3_addr.bit.b3				/* Port P3_3 direction bit */
#define		pd3_4			pd3_addr.bit.b4				/* Port P3_4 direction bit */
#define		pd3_5			pd3_addr.bit.b5				/* Port P3_5 direction bit */
#define		pd3_6			pd3_addr.bit.b6				/* Port P3_6 direction bit */
#define		pd3_7			pd3_addr.bit.b7				/* Port P3_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P4 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p4_addr			03E8h
union BYTE_DEF	p4_addr;
#define		p4				p4_addr.byte

#define		p4_0			p4_addr.bit.b0				/* Port P4_0 bit */
#define		p4_1			p4_addr.bit.b1				/* Port P4_1 bit */
#define		p4_2			p4_addr.bit.b2				/* Port P4_2 bit */
#define		p4_3			p4_addr.bit.b3				/* Port P4_3 bit */
#define		p4_4			p4_addr.bit.b4				/* Port P4_4 bit */
#define		p4_5			p4_addr.bit.b5				/* Port P4_5 bit */
#define		p4_6			p4_addr.bit.b6				/* Port P4_6 bit */
#define		p4_7			p4_addr.bit.b7				/* Port P4_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P5 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p5_addr			03E9h
union BYTE_DEF	p5_addr;
#define		p5				p5_addr.byte

#define		p5_0			p5_addr.bit.b0				/* Port P5_0 bit */
#define		p5_1			p5_addr.bit.b1				/* Port P5_1 bit */
#define		p5_2			p5_addr.bit.b2				/* Port P5_2 bit */
#define		p5_3			p5_addr.bit.b3				/* Port P5_3 bit */
#define		p5_4			p5_addr.bit.b4				/* Port P5_4 bit */
#define		p5_5			p5_addr.bit.b5				/* Port P5_5 bit */
#define		p5_6			p5_addr.bit.b6				/* Port P5_6 bit */
#define		p5_7			p5_addr.bit.b7				/* Port P5_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P4 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd4_addr		03EAh
union BYTE_DEF	pd4_addr;
#define		pd4				pd4_addr.byte

#define		pd4_0			pd4_addr.bit.b0				/* Port P4_0 direction bit */
#define		pd4_1			pd4_addr.bit.b1				/* Port P4_1 direction bit */
#define		pd4_2			pd4_addr.bit.b2				/* Port P4_2 direction bit */
#define		pd4_3			pd4_addr.bit.b3				/* Port P4_3 direction bit */
#define		pd4_4			pd4_addr.bit.b4				/* Port P4_4 direction bit */
#define		pd4_5			pd4_addr.bit.b5				/* Port P4_5 direction bit */
#define		pd4_6			pd4_addr.bit.b6				/* Port P4_6 direction bit */
#define		pd4_7			pd4_addr.bit.b7				/* Port P4_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P5 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd5_addr		03EBh
union BYTE_DEF	pd5_addr;
#define		pd5				pd5_addr.byte

#define		pd5_0			pd5_addr.bit.b0				/* Port P5_0 direction bit */
#define		pd5_1			pd5_addr.bit.b1				/* Port P5_1 direction bit */
#define		pd5_2			pd5_addr.bit.b2				/* Port P5_2 direction bit */
#define		pd5_3			pd5_addr.bit.b3				/* Port P5_3 direction bit */
#define		pd5_4			pd5_addr.bit.b4				/* Port P5_4 direction bit */
#define		pd5_5			pd5_addr.bit.b5				/* Port P5_5 direction bit */
#define		pd5_6			pd5_addr.bit.b6				/* Port P5_6 direction bit */
#define		pd5_7			pd5_addr.bit.b7				/* Port P5_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P6 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p6_addr			03ECh
union BYTE_DEF	p6_addr;
#define		p6				p6_addr.byte

#define		p6_0			p6_addr.bit.b0				/* Port P6_0 bit */
#define		p6_1			p6_addr.bit.b1				/* Port P6_1 bit */
#define		p6_2			p6_addr.bit.b2				/* Port P6_2 bit */
#define		p6_3			p6_addr.bit.b3				/* Port P6_3 bit */
#define		p6_4			p6_addr.bit.b4				/* Port P6_4 bit */
#define		p6_5			p6_addr.bit.b5				/* Port P6_5 bit */
#define		p6_6			p6_addr.bit.b6				/* Port P6_6 bit */
#define		p6_7			p6_addr.bit.b7				/* Port P6_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P7 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p7_addr			03EDh
union BYTE_DEF	p7_addr;
#define		p7				p7_addr.byte

#define		p7_0			p7_addr.bit.b0				/* Port P7_0 bit */
#define		p7_1			p7_addr.bit.b1				/* Port P7_1 bit */
#define		p7_2			p7_addr.bit.b2				/* Port P7_2 bit */
#define		p7_3			p7_addr.bit.b3				/* Port P7_3 bit */
#define		p7_4			p7_addr.bit.b4				/* Port P7_4 bit */
#define		p7_5			p7_addr.bit.b5				/* Port P7_5 bit */
#define		p7_6			p7_addr.bit.b6				/* Port P7_6 bit */
#define		p7_7			p7_addr.bit.b7				/* Port P7_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P6 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd6_addr		03EEh
union BYTE_DEF	pd6_addr;
#define		pd6				pd6_addr.byte

#define		pd6_0			pd6_addr.bit.b0				/* Port P6_0 direction bit */
#define		pd6_1			pd6_addr.bit.b1				/* Port P6_1 direction bit */
#define		pd6_2			pd6_addr.bit.b2				/* Port P6_2 direction bit */
#define		pd6_3			pd6_addr.bit.b3				/* Port P6_3 direction bit */
#define		pd6_4			pd6_addr.bit.b4				/* Port P6_4 direction bit */
#define		pd6_5			pd6_addr.bit.b5				/* Port P6_5 direction bit */
#define		pd6_6			pd6_addr.bit.b6				/* Port P6_6 direction bit */
#define		pd6_7			pd6_addr.bit.b7				/* Port P6_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P7 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd7_addr		03EFh
union BYTE_DEF	pd7_addr;
#define		pd7				pd7_addr.byte

#define		pd7_0			pd7_addr.bit.b0				/* Port P7_0 direction bit */
#define		pd7_1			pd7_addr.bit.b1				/* Port P7_1 direction bit */
#define		pd7_2			pd7_addr.bit.b2				/* Port P7_2 direction bit */
#define		pd7_3			pd7_addr.bit.b3				/* Port P7_3 direction bit */
#define		pd7_4			pd7_addr.bit.b4				/* Port P7_4 direction bit */
#define		pd7_5			pd7_addr.bit.b5				/* Port P7_5 direction bit */
#define		pd7_6			pd7_addr.bit.b6				/* Port P7_6 direction bit */
#define		pd7_7			pd7_addr.bit.b7				/* Port P7_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P8 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p8_addr			03F0h
union BYTE_DEF	p8_addr;
#define		p8				p8_addr.byte

#define		p8_0			p8_addr.bit.b0				/* Port P8_0 bit */
#define		p8_1			p8_addr.bit.b1				/* Port P8_1 bit */
#define		p8_2			p8_addr.bit.b2				/* Port P8_2 bit */
#define		p8_3			p8_addr.bit.b3				/* Port P8_3 bit */
#define		p8_4			p8_addr.bit.b4				/* Port P8_4 bit */
#define		p8_5			p8_addr.bit.b5				/* Port P8_5 bit */
#define		p8_6			p8_addr.bit.b6				/* Port P8_6 bit */
#define		p8_7			p8_addr.bit.b7				/* Port P8_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P9 Register                                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p9_addr			03F1h
union BYTE_DEF	p9_addr;
#define		p9				p9_addr.byte

#define		p9_0			p9_addr.bit.b0				/* Port P9_0 bit */
#define		p9_1			p9_addr.bit.b1				/* Port P9_1 bit */
#define		p9_2			p9_addr.bit.b2				/* Port P9_2 bit */
#define		p9_3			p9_addr.bit.b3				/* Port P9_3 bit */
#define		p9_4			p9_addr.bit.b4				/* Port P9_4 bit */
#define		p9_5			p9_addr.bit.b5				/* Port P9_5 bit */
#define		p9_6			p9_addr.bit.b6				/* Port P9_6 bit */
#define		p9_7			p9_addr.bit.b7				/* Port P9_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P8 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd8_addr		03F2h
union BYTE_DEF	pd8_addr;
#define		pd8				pd8_addr.byte

#define		pd8_0			pd8_addr.bit.b0				/* Port P8_0 direction bit */
#define		pd8_1			pd8_addr.bit.b1				/* Port P8_1 direction bit */
#define		pd8_2			pd8_addr.bit.b2				/* Port P8_2 direction bit */
#define		pd8_3			pd8_addr.bit.b3				/* Port P8_3 direction bit */
#define		pd8_4			pd8_addr.bit.b4				/* Port P8_4 direction bit */
#define		pd8_5			pd8_addr.bit.b5				/* Port P8_5 direction bit */
#define		pd8_6			pd8_addr.bit.b6				/* Port P8_6 direction bit */
#define		pd8_7			pd8_addr.bit.b7				/* Port P8_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P9 Direction Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd9_addr		03F3h
union BYTE_DEF	pd9_addr;
#define		pd9				pd9_addr.byte

#define		pd9_0			pd9_addr.bit.b0				/* Port P9_0 direction bit */
#define		pd9_1			pd9_addr.bit.b1				/* Port P9_1 direction bit */
#define		pd9_2			pd9_addr.bit.b2				/* Port P9_2 direction bit */
#define		pd9_3			pd9_addr.bit.b3				/* Port P9_3 direction bit */
#define		pd9_4			pd9_addr.bit.b4				/* Port P9_4 direction bit */
#define		pd9_5			pd9_addr.bit.b5				/* Port P9_5 direction bit */
#define		pd9_6			pd9_addr.bit.b6				/* Port P9_6 direction bit */
#define		pd9_7			pd9_addr.bit.b7				/* Port P9_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  Port P10 Register                                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		p10_addr		03F4h
union BYTE_DEF	p10_addr;
#define		p10				p10_addr.byte

#define		p10_0			p10_addr.bit.b0				/* Port P10_0 bit */
#define		p10_1			p10_addr.bit.b1				/* Port P10_1 bit */
#define		p10_2			p10_addr.bit.b2				/* Port P10_2 bit */
#define		p10_3			p10_addr.bit.b3				/* Port P10_3 bit */
#define		p10_4			p10_addr.bit.b4				/* Port P10_4 bit */
#define		p10_5			p10_addr.bit.b5				/* Port P10_5 bit */
#define		p10_6			p10_addr.bit.b6				/* Port P10_6 bit */
#define		p10_7			p10_addr.bit.b7				/* Port P10_7 bit */

/*------------------------------------------------------------------------------*/
/*  Port P10 Direction Register                                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		pd10_addr		03F6h
union BYTE_DEF	pd10_addr;
#define		pd10			pd10_addr.byte

#define		pd10_0			pd10_addr.bit.b0			/* Port P10_0 direction bit */
#define		pd10_1			pd10_addr.bit.b1			/* Port P10_1 direction bit */
#define		pd10_2			pd10_addr.bit.b2			/* Port P10_2 direction bit */
#define		pd10_3			pd10_addr.bit.b3			/* Port P10_3 direction bit */
#define		pd10_4			pd10_addr.bit.b4			/* Port P10_4 direction bit */
#define		pd10_5			pd10_addr.bit.b5			/* Port P10_5 direction bit */
#define		pd10_6			pd10_addr.bit.b6			/* Port P10_6 direction bit */
#define		pd10_7			pd10_addr.bit.b7			/* Port P10_7 direction bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 0                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb0_addr		0D200h
union CANMB_DEF	c1mb0_addr;
#define		c1mb0			c1mb0_addr

#define		eid_c1mb0		c1mb0_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb0		c1mb0_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb0		c1mb0_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb0		c1mb0_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb0		c1mb0_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb0		c1mb0_addr.word[7]			/* Time stamp */
#define		tsl_c1mb0		c1mb0_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb0		c1mb0_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 1                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb1_addr		0D210h
union CANMB_DEF	c1mb1_addr;
#define		c1mb1			c1mb1_addr

#define		eid_c1mb1		c1mb1_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb1		c1mb1_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb1		c1mb1_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb1		c1mb1_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb1		c1mb1_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb1		c1mb1_addr.word[7]			/* Time stamp */
#define		tsl_c1mb1		c1mb1_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb1		c1mb1_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 2                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb2_addr		0D220h
union CANMB_DEF	c1mb2_addr;
#define		c1mb2			c1mb2_addr

#define		eid_c1mb2		c1mb2_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb2		c1mb2_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb2		c1mb2_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb2		c1mb2_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb2		c1mb2_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb2		c1mb2_addr.word[7]			/* Time stamp */
#define		tsl_c1mb2		c1mb2_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb2		c1mb2_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 3                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb3_addr		0D230h
union CANMB_DEF	c1mb3_addr;
#define		c1mb3			c1mb3_addr

#define		eid_c1mb3		c1mb3_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb3		c1mb3_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb3		c1mb3_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb3		c1mb3_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb3		c1mb3_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb3		c1mb3_addr.word[7]			/* Time stamp */
#define		tsl_c1mb3		c1mb3_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb3		c1mb3_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 4                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb4_addr		0D240h
union CANMB_DEF	c1mb4_addr;
#define		c1mb4			c1mb4_addr

#define		eid_c1mb4		c1mb4_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb4		c1mb4_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb4		c1mb4_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb4		c1mb4_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb4		c1mb4_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb4		c1mb4_addr.word[7]			/* Time stamp */
#define		tsl_c1mb4		c1mb4_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb4		c1mb4_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 5                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb5_addr		0D250h
union CANMB_DEF	c1mb5_addr;
#define		c1mb5			c1mb5_addr

#define		eid_c1mb5		c1mb5_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb5		c1mb5_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb5		c1mb5_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb5		c1mb5_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb5		c1mb5_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb5		c1mb5_addr.word[7]			/* Time stamp */
#define		tsl_c1mb5		c1mb5_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb5		c1mb5_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 6                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb6_addr		0D260h
union CANMB_DEF	c1mb6_addr;
#define		c1mb6			c1mb6_addr

#define		eid_c1mb6		c1mb6_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb6		c1mb6_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb6		c1mb6_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb6		c1mb6_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb6		c1mb6_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb6		c1mb6_addr.word[7]			/* Time stamp */
#define		tsl_c1mb6		c1mb6_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb6		c1mb6_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 7                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb7_addr		0D270h
union CANMB_DEF	c1mb7_addr;
#define		c1mb7			c1mb7_addr

#define		eid_c1mb7		c1mb7_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb7		c1mb7_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb7		c1mb7_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb7		c1mb7_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb7		c1mb7_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb7		c1mb7_addr.word[7]			/* Time stamp */
#define		tsl_c1mb7		c1mb7_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb7		c1mb7_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 8                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb8_addr		0D280h
union CANMB_DEF	c1mb8_addr;
#define		c1mb8			c1mb8_addr

#define		eid_c1mb8		c1mb8_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb8		c1mb8_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb8		c1mb8_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb8		c1mb8_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb8		c1mb8_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb8		c1mb8_addr.word[7]			/* Time stamp */
#define		tsl_c1mb8		c1mb8_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb8		c1mb8_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 9                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb9_addr		0D290h
union CANMB_DEF	c1mb9_addr;
#define		c1mb9			c1mb9_addr

#define		eid_c1mb9		c1mb9_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb9		c1mb9_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb9		c1mb9_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb9		c1mb9_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb9		c1mb9_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb9		c1mb9_addr.word[7]			/* Time stamp */
#define		tsl_c1mb9		c1mb9_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb9		c1mb9_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 10                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb10_addr		0D2A0h
union CANMB_DEF	c1mb10_addr;
#define		c1mb10			c1mb10_addr

#define		eid_c1mb10		c1mb10_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb10		c1mb10_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb10		c1mb10_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb10		c1mb10_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb10		c1mb10_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb10		c1mb10_addr.word[7]			/* Time stamp */
#define		tsl_c1mb10		c1mb10_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb10		c1mb10_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 11                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb11_addr		0D2B0h
union CANMB_DEF	c1mb11_addr;
#define		c1mb11			c1mb11_addr

#define		eid_c1mb11		c1mb11_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb11		c1mb11_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb11		c1mb11_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb11		c1mb11_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb11		c1mb11_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb11		c1mb11_addr.word[7]			/* Time stamp */
#define		tsl_c1mb11		c1mb11_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb11		c1mb11_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 12                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb12_addr		0D2C1h
union CANMB_DEF	c1mb12_addr;
#define		c1mb12			c1mb12_addr

#define		eid_c1mb12		c1mb12_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb12		c1mb12_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb12		c1mb12_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb12		c1mb12_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb12		c1mb12_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb12		c1mb12_addr.word[7]			/* Time stamp */
#define		tsl_c1mb12		c1mb12_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb12		c1mb12_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 13                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb13_addr		0D2D0h
union CANMB_DEF	c1mb13_addr;
#define		c1mb13			c1mb13_addr

#define		eid_c1mb13		c1mb13_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb13		c1mb13_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb13		c1mb13_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb13		c1mb13_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb13		c1mb13_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb13		c1mb13_addr.word[7]			/* Time stamp */
#define		tsl_c1mb13		c1mb13_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb13		c1mb13_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 14                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb14_addr		0D2E0h
union CANMB_DEF	c1mb14_addr;
#define		c1mb14			c1mb14_addr

#define		eid_c1mb14		c1mb14_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb14		c1mb14_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb14		c1mb14_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb14		c1mb14_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb14		c1mb14_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb14		c1mb14_addr.word[7]			/* Time stamp */
#define		tsl_c1mb14		c1mb14_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb14		c1mb14_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 15                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb15_addr		0D2F0h
union CANMB_DEF	c1mb15_addr;
#define		c1mb15			c1mb15_addr

#define		eid_c1mb15		c1mb15_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb15		c1mb15_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb15		c1mb15_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb15		c1mb15_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb15		c1mb15_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb15		c1mb15_addr.word[7]			/* Time stamp */
#define		tsl_c1mb15		c1mb15_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb15		c1mb15_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 16                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb16_addr		0D300h
union CANMB_DEF	c1mb16_addr;
#define		c1mb16			c1mb16_addr

#define		eid_c1mb16		c1mb16_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb16		c1mb16_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb16		c1mb16_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb16		c1mb16_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb16		c1mb16_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb16		c1mb16_addr.word[7]			/* Time stamp */
#define		tsl_c1mb16		c1mb16_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb16		c1mb16_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 17                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb17_addr		0D310h
union CANMB_DEF	c1mb17_addr;
#define		c1mb17			c1mb17_addr

#define		eid_c1mb17		c1mb17_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb17		c1mb17_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb17		c1mb17_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb17		c1mb17_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb17		c1mb17_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb17		c1mb17_addr.word[7]			/* Time stamp */
#define		tsl_c1mb17		c1mb17_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb17		c1mb17_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 18                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb18_addr		0D320h
union CANMB_DEF	c1mb18_addr;
#define		c1mb18			c1mb18_addr

#define		eid_c1mb18		c1mb18_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb18		c1mb18_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb18		c1mb18_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb18		c1mb18_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb18		c1mb18_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb18		c1mb18_addr.word[7]			/* Time stamp */
#define		tsl_c1mb18		c1mb18_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb18		c1mb18_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 19                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb19_addr		0D330h
union CANMB_DEF	c1mb19_addr;
#define		c1mb19			c1mb19_addr

#define		eid_c1mb19		c1mb19_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb19		c1mb19_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb19		c1mb19_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb19		c1mb19_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb19		c1mb19_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb19		c1mb19_addr.word[7]			/* Time stamp */
#define		tsl_c1mb19		c1mb19_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb19		c1mb19_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 20                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb20_addr		0D340h
union CANMB_DEF	c1mb20_addr;
#define		c1mb20			c1mb20_addr

#define		eid_c1mb20		c1mb20_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb20		c1mb20_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb20		c1mb20_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb20		c1mb20_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb20		c1mb20_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb20		c1mb20_addr.word[7]			/* Time stamp */
#define		tsl_c1mb20		c1mb20_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb20		c1mb20_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 21                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb21_addr		0D350h
union CANMB_DEF	c1mb21_addr;
#define		c1mb21			c1mb21_addr

#define		eid_c1mb21		c1mb21_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb21		c1mb21_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb21		c1mb21_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb21		c1mb21_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb21		c1mb21_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb21		c1mb21_addr.word[7]			/* Time stamp */
#define		tsl_c1mb21		c1mb21_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb21		c1mb21_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 22                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb22_addr		0D360h
union CANMB_DEF	c1mb22_addr;
#define		c1mb22			c1mb22_addr

#define		eid_c1mb22		c1mb22_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb22		c1mb22_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb22		c1mb22_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb22		c1mb22_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb22		c1mb22_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb22		c1mb22_addr.word[7]			/* Time stamp */
#define		tsl_c1mb22		c1mb22_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb22		c1mb22_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 23                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb23_addr		0D370h
union CANMB_DEF	c1mb23_addr;
#define		c1mb23			c1mb23_addr

#define		eid_c1mb23		c1mb23_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb23		c1mb23_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb23		c1mb23_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb23		c1mb23_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb23		c1mb23_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb23		c1mb23_addr.word[7]			/* Time stamp */
#define		tsl_c1mb23		c1mb23_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb23		c1mb23_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 24                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb24_addr		0D380h
union CANMB_DEF	c1mb24_addr;
#define		c1mb24			c1mb24_addr

#define		eid_c1mb24		c1mb24_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb24		c1mb24_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb24		c1mb24_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb24		c1mb24_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb24		c1mb24_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb24		c1mb24_addr.word[7]			/* Time stamp */
#define		tsl_c1mb24		c1mb24_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb24		c1mb24_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 25                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb25_addr		0D390h
union CANMB_DEF	c1mb25_addr;
#define		c1mb25			c1mb25_addr

#define		eid_c1mb25		c1mb25_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb25		c1mb25_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb25		c1mb25_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb25		c1mb25_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb25		c1mb25_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb25		c1mb25_addr.word[7]			/* Time stamp */
#define		tsl_c1mb25		c1mb25_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb25		c1mb25_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 26                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb26_addr		0D3A0h
union CANMB_DEF	c1mb26_addr;
#define		c1mb26			c1mb26_addr

#define		eid_c1mb26		c1mb26_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb26		c1mb26_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb26		c1mb26_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb26		c1mb26_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb26		c1mb26_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb26		c1mb26_addr.word[7]			/* Time stamp */
#define		tsl_c1mb26		c1mb26_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb26		c1mb26_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 27                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb27_addr		0D3B0h
union CANMB_DEF	c1mb27_addr;
#define		c1mb27			c1mb27_addr

#define		eid_c1mb27		c1mb27_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb27		c1mb27_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb27		c1mb27_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb27		c1mb27_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb27		c1mb27_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb27		c1mb27_addr.word[7]			/* Time stamp */
#define		tsl_c1mb27		c1mb27_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb27		c1mb27_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 28                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb28_addr		0D3C1h
union CANMB_DEF	c1mb28_addr;
#define		c1mb28			c1mb28_addr

#define		eid_c1mb28		c1mb28_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb28		c1mb28_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb28		c1mb28_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb28		c1mb28_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb28		c1mb28_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb28		c1mb28_addr.word[7]			/* Time stamp */
#define		tsl_c1mb28		c1mb28_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb28		c1mb28_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 29                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb29_addr		0D3D0h
union CANMB_DEF	c1mb29_addr;
#define		c1mb29			c1mb29_addr

#define		eid_c1mb29		c1mb29_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb29		c1mb29_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb29		c1mb29_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb29		c1mb29_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb29		c1mb29_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb29		c1mb29_addr.word[7]			/* Time stamp */
#define		tsl_c1mb29		c1mb29_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb29		c1mb29_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 30                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb30_addr		0D3E0h
union CANMB_DEF	c1mb30_addr;
#define		c1mb30			c1mb30_addr

#define		eid_c1mb30		c1mb30_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb30		c1mb30_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb30		c1mb30_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb30		c1mb30_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb30		c1mb30_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb30		c1mb30_addr.word[7]			/* Time stamp */
#define		tsl_c1mb30		c1mb30_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb30		c1mb30_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Register 31                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mb31_addr		0D3F0h
union CANMB_DEF	c1mb31_addr;
#define		c1mb31			c1mb31_addr

#define		eid_c1mb31		c1mb31_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mb31		c1mb31_addr.ml.sid			/* Standard ID bits */
#define		rtr_c1mb31		c1mb31_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c1mb31		c1mb31_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c1mb31		c1mb31_addr.mc.dlc			/* Data Length Code */
#define		ts_c1mb31		c1mb31_addr.word[7]			/* Time stamp */
#define		tsl_c1mb31		c1mb31_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c1mb31		c1mb31_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mask Register 0                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr0_addr		0D400h
union CANMK_DEF	c1mkr0_addr;
#define		c1mkr0			c1mkr0_addr.dword			/* CAN1 mask register 0(32bit) */
#define		c1mkr0l			c1mkr0_addr.word[0]			/* CAN1 mask register 0(low-order word) */
#define		c1mkr0h			c1mkr0_addr.word[1]			/* CAN1 mask register 0(high-order word) */

#define		eid_c1mkr0		c1mkr0_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr0		c1mkr0_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mask Register 1                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr1_addr		0D404h
union CANMK_DEF	c1mkr1_addr;
#define		c1mkr1			c1mkr1_addr.dword			/* CAN1 mask register 1(32bit) */
#define		c1mkr1l			c1mkr1_addr.word[0]			/* CAN1 mask register 1(low-order word) */
#define		c1mkr1h			c1mkr1_addr.word[1]			/* CAN1 mask register 1(high-order word) */

#define		eid_c1mkr1		c1mkr1_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr1		c1mkr1_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mask Register 2                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr2_addr		0D408h
union CANMK_DEF	c1mkr2_addr;
#define		c1mkr2			c1mkr2_addr.dword			/* CAN1 mask register 2(32bit) */
#define		c1mkr2l			c1mkr2_addr.word[0]			/* CAN1 mask register 2(low-order word) */
#define		c1mkr2h			c1mkr2_addr.word[1]			/* CAN1 mask register 2(high-order word) */

#define		eid_c1mkr2		c1mkr2_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr2		c1mkr2_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 mask register 3                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr3_addr		0D40Ch
union CANMK_DEF	c1mkr3_addr;
#define		c1mkr3			c1mkr3_addr.dword			/* CAN1 mask register 3(32bit) */
#define		c1mkr3l			c1mkr3_addr.word[0]			/* CAN1 mask register 3(low-order word) */
#define		c1mkr3h			c1mkr3_addr.word[1]			/* CAN1 mask register 3(high-order word) */

#define		eid_c1mkr3		c1mkr3_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr3		c1mkr3_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 mask register 4                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr4_addr		0D410h
union CANMK_DEF	c1mkr4_addr;
#define		c1mkr4			c1mkr4_addr.dword			/* CAN1 mask register 4(32bit) */
#define		c1mkr4l			c1mkr4_addr.word[0]			/* CAN1 mask register 4(low-order word) */
#define		c1mkr4h			c1mkr4_addr.word[1]			/* CAN1 mask register 4(high-order word) */

#define		eid_c1mkr4		c1mkr4_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr4		c1mkr4_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mask Register 5                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr5_addr		0D414h
union CANMK_DEF	c1mkr5_addr;
#define		c1mkr5			c1mkr5_addr.dword			/* CAN1 mask register 5(32bit) */
#define		c1mkr5l			c1mkr5_addr.word[0]			/* CAN1 mask register 5(low-order word) */
#define		c1mkr5h			c1mkr5_addr.word[1]			/* CAN1 mask register 5(high-order word) */

#define		eid_c1mkr5		c1mkr5_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr5		c1mkr5_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mask Register 6                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr6_addr		0D418h
union CANMK_DEF	c1mkr6_addr;
#define		c1mkr6			c1mkr6_addr.dword			/* CAN1 mask register 6(32bit) */
#define		c1mkr6l			c1mkr6_addr.word[0]			/* CAN1 mask register 6(low-order word) */
#define		c1mkr6h			c1mkr6_addr.word[1]			/* CAN1 mask register 6(high-order word) */

#define		eid_c1mkr6		c1mkr6_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr6		c1mkr6_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mask Register 7                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkr7_addr		0D41Ch
union CANMK_DEF	c1mkr7_addr;
#define		c1mkr7			c1mkr7_addr.dword			/* CAN1 mask register 7(32bit) */
#define		c1mkr7l			c1mkr7_addr.word[0]			/* CAN1 mask register 7(low-order word) */
#define		c1mkr7h			c1mkr7_addr.word[1]			/* CAN1 mask register 7(high-order word) */

#define		eid_c1mkr7		c1mkr7_addr.ml.eid			/* Extended ID bits */
#define		sid_c1mkr7		c1mkr7_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN1 FIFO Receive ID Compare Register 0                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1fidcr0_addr	0D420h
union CANRC_DEF	c1fidcr0_addr;
#define		c1fidcr0		c1fidcr0_addr.dword			/* CAN1 FIFO Receive ID Compare Register 0(32bit) */
#define		c1fidcr0l		c1fidcr0_addr.word[0]		/* CAN1 FIFO Receive ID Compare Register 0(low-order word) */
#define		c1fidcr0h		c1fidcr0_addr.word[1]		/* CAN1 FIFO Receive ID Compare Register 0(high-order word) */

#define		eid_c1fidcr0	c1fidcr0_addr.ml.eid		/* Extended ID bits */
#define		sid_c1fidcr0	c1fidcr0_addr.ml.sid		/* Standard ID bits */
#define		rtr_c1fidcr0	c1fidcr0_addr.ml.rtr		/* Remote Frame Request Bit */
#define		ide_c1fidcr0	c1fidcr0_addr.ml.ide		/* ID Extension Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 FIFO Receive ID Compare Register 1                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1fidcr1_addr	0D424h
union CANRC_DEF	c1fidcr1_addr;
#define		c1fidcr1		c1fidcr1_addr.dword			/* CAN1 FIFO Receive ID Compare Register 1(32bit) */
#define		c1fidcr1l		c1fidcr1_addr.word[0]		/* CAN1 FIFO Receive ID Compare Register 1(low-order word) */
#define		c1fidcr1h		c1fidcr1_addr.word[1]		/* CAN1 FIFO Receive ID Compare Register 1(high-order word) */

#define		eid_c1fidcr1	c1fidcr1_addr.ml.eid		/* Extended ID bits */
#define		sid_c1fidcr1	c1fidcr1_addr.ml.sid		/* Standard ID bits */
#define		rtr_c1fidcr1	c1fidcr1_addr.ml.rtr		/* Remote Frame Request Bit */
#define		ide_c1fidcr1	c1fidcr1_addr.ml.ide		/* ID Extension Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mask Invalid Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mkivlr_addr	0D428h
union CANDW_DEF	c1mkivlr_addr;
#define		c1mkivlr		c1mkivlr_addr.dword			/* CAN1 mask invalid register(32bit) */
#define		c1mkivlrl		c1mkivlr_addr.word[0]		/* CAN1 mask invalid register(low-order word) */
#define		c1mkivlrh		c1mkivlr_addr.word[1]		/* CAN1 mask invalid register(high-order word) */
#define		c1mkivlrll		c1mkivlr_addr.byte[0]		/* CAN1 mask invalid register(low-order byte) */
#define		c1mkivlrlh		c1mkivlr_addr.byte[1]		/* CAN1 mask invalid register(mid-order byte) */
#define		c1mkivlrhl		c1mkivlr_addr.byte[2]		/* CAN1 mask invalid register(high-order byte) */
#define		c1mkivlrhh		c1mkivlr_addr.byte[3]		/* CAN1 mask invalid register(highest-order byte) */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Interrupt Enable Register                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mier_addr		0D42Ch
union CANDW_DEF	c1mier_addr;
#define		c1mier			c1mier_addr.dword			/* CAN1 Mailbox Interrupt Enable Register(32bit) */
#define		c1mierl			c1mier_addr.word[0]			/* CAN1 Mailbox Interrupt Enable Register(low-order word) */
#define		c1mierh			c1mier_addr.word[1]			/* CAN1 Mailbox Interrupt Enable Register(high-order word) */
#define		c1mierll		c1mier_addr.byte[0]			/* CAN1 Mailbox Interrupt Enable Register(low-order byte) */
#define		c1mierlh		c1mier_addr.byte[1]			/* CAN1 Mailbox Interrupt Enable Register(mid-order byte) */
#define		c1mierhl		c1mier_addr.byte[2]			/* CAN1 Mailbox Interrupt Enable Register(high-order byte) */
#define		c1mierhh		c1mier_addr.byte[3]			/* CAN1 Mailbox Interrupt Enable Register(highest-order byte) */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 0                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl0_addr	0D4A0h
union BYTE_DEF	c1mctl0_addr;
#define		c1mctl0			c1mctl0_addr.byte

#define		newdata_c1mctl0	c1mctl0_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl0	c1mctl0_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl0	c1mctl0_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl0	c1mctl0_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl0	c1mctl0_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl0	c1mctl0_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl0	c1mctl0_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl0	c1mctl0_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl0	c1mctl0_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 1                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl1_addr	0D4A1h
union BYTE_DEF	c1mctl1_addr;
#define		c1mctl1			c1mctl1_addr.byte

#define		newdata_c1mctl1	c1mctl1_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl1	c1mctl1_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl1	c1mctl1_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl1	c1mctl1_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl1	c1mctl1_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl1	c1mctl1_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl1	c1mctl1_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl1	c1mctl1_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl1	c1mctl1_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 2                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl2_addr	0D4A2h
union BYTE_DEF	c1mctl2_addr;
#define		c1mctl2			c1mctl2_addr.byte

#define		newdata_c1mctl2	c1mctl2_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl2	c1mctl2_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl2	c1mctl2_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl2	c1mctl2_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl2	c1mctl2_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl2	c1mctl2_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl2	c1mctl2_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl2	c1mctl2_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl2	c1mctl2_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 3                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl3_addr	0D4A3h
union BYTE_DEF	c1mctl3_addr;
#define		c1mctl3			c1mctl3_addr.byte

#define		newdata_c1mctl3	c1mctl3_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl3	c1mctl3_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl3	c1mctl3_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl3	c1mctl3_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl3	c1mctl3_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl3	c1mctl3_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl3	c1mctl3_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl3	c1mctl3_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl3	c1mctl3_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 4                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl4_addr	0D4A4h
union BYTE_DEF	c1mctl4_addr;
#define		c1mctl4			c1mctl4_addr.byte

#define		newdata_c1mctl4	c1mctl4_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl4	c1mctl4_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl4	c1mctl4_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl4	c1mctl4_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl4	c1mctl4_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl4	c1mctl4_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl4	c1mctl4_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl4	c1mctl4_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl4	c1mctl4_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 5                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl5_addr	0D4A5h
union BYTE_DEF	c1mctl5_addr;
#define		c1mctl5			c1mctl5_addr.byte

#define		newdata_c1mctl5	c1mctl5_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl5	c1mctl5_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl5	c1mctl5_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl5	c1mctl5_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl5	c1mctl5_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl5	c1mctl5_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl5	c1mctl5_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl5	c1mctl5_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl5	c1mctl5_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 6                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl6_addr	0D4A6h
union BYTE_DEF	c1mctl6_addr;
#define		c1mctl6			c1mctl6_addr.byte

#define		newdata_c1mctl6	c1mctl6_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl6	c1mctl6_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl6	c1mctl6_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl6	c1mctl6_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl6	c1mctl6_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl6	c1mctl6_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl6	c1mctl6_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl6	c1mctl6_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl6	c1mctl6_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 7                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl7_addr	0D4A7h
union BYTE_DEF	c1mctl7_addr;
#define		c1mctl7			c1mctl7_addr.byte

#define		newdata_c1mctl7	c1mctl7_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl7	c1mctl7_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl7	c1mctl7_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl7	c1mctl7_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl7	c1mctl7_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl7	c1mctl7_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl7	c1mctl7_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl7	c1mctl7_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl7	c1mctl7_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 8                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl8_addr	0D4A8h
union BYTE_DEF	c1mctl8_addr;
#define		c1mctl8			c1mctl8_addr.byte

#define		newdata_c1mctl8	c1mctl8_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl8	c1mctl8_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl8	c1mctl8_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl8	c1mctl8_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl8	c1mctl8_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl8	c1mctl8_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl8	c1mctl8_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl8	c1mctl8_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl8	c1mctl8_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 9                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl9_addr	0D4A9h
union BYTE_DEF	c1mctl9_addr;
#define		c1mctl9			c1mctl9_addr.byte

#define		newdata_c1mctl9	c1mctl9_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c1mctl9	c1mctl9_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c1mctl9	c1mctl9_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl9	c1mctl9_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl9	c1mctl9_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c1mctl9	c1mctl9_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl9	c1mctl9_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c1mctl9	c1mctl9_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl9	c1mctl9_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 10                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl10_addr	0D4AAh
union BYTE_DEF	c1mctl10_addr;
#define		c1mctl10		c1mctl10_addr.byte

#define		newdata_c1mctl10	c1mctl10_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl10	c1mctl10_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl10	c1mctl10_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl10	c1mctl10_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl10	c1mctl10_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl10	c1mctl10_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl10	c1mctl10_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl10	c1mctl10_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl10	c1mctl10_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 11                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl11_addr	0D4ABh
union BYTE_DEF	c1mctl11_addr;
#define		c1mctl11		c1mctl11_addr.byte

#define		newdata_c1mctl11	c1mctl11_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl11	c1mctl11_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl11	c1mctl11_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl11	c1mctl11_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl11	c1mctl11_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl11	c1mctl11_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl11	c1mctl11_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl11	c1mctl11_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl11	c1mctl11_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 12                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl12_addr	0D4ACh
union BYTE_DEF	c1mctl12_addr;
#define		c1mctl12		c1mctl12_addr.byte

#define		newdata_c1mctl12	c1mctl12_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl12	c1mctl12_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl12	c1mctl12_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl12	c1mctl12_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl12	c1mctl12_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl12	c1mctl12_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl12	c1mctl12_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl12	c1mctl12_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl12	c1mctl12_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 13                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl13_addr	0D4ADh
union BYTE_DEF	c1mctl13_addr;
#define		c1mctl13		c1mctl13_addr.byte

#define		newdata_c1mctl13	c1mctl13_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl13	c1mctl13_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl13	c1mctl13_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl13	c1mctl13_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl13	c1mctl13_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl13	c1mctl13_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl13	c1mctl13_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl13	c1mctl13_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl13	c1mctl13_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 14                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl14_addr	0D4AEh
union BYTE_DEF	c1mctl14_addr;
#define		c1mctl14		c1mctl14_addr.byte

#define		newdata_c1mctl14	c1mctl14_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl14	c1mctl14_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl14	c1mctl14_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl14	c1mctl14_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl14	c1mctl14_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl14	c1mctl14_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl14	c1mctl14_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl14	c1mctl14_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl14	c1mctl14_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 15                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl15_addr	0D4AFh
union BYTE_DEF	c1mctl15_addr;
#define		c1mctl15		c1mctl15_addr.byte

#define		newdata_c1mctl15	c1mctl15_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl15	c1mctl15_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl15	c1mctl15_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl15	c1mctl15_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl15	c1mctl15_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl15	c1mctl15_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl15	c1mctl15_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl15	c1mctl15_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl15	c1mctl15_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 16                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl16_addr	0D4B0h
union BYTE_DEF	c1mctl16_addr;
#define		c1mctl16		c1mctl16_addr.byte

#define		newdata_c1mctl16	c1mctl16_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl16	c1mctl16_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl16	c1mctl16_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl16	c1mctl16_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl16	c1mctl16_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl16	c1mctl16_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl16	c1mctl16_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl16	c1mctl16_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl16	c1mctl16_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 17                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl17_addr	0D4B1h
union BYTE_DEF	c1mctl17_addr;
#define		c1mctl17		c1mctl17_addr.byte

#define		newdata_c1mctl17	c1mctl17_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl17	c1mctl17_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl17	c1mctl17_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl17	c1mctl17_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl17	c1mctl17_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl17	c1mctl17_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl17	c1mctl17_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl17	c1mctl17_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl17	c1mctl17_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 18                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl18_addr	0D4B2h
union BYTE_DEF	c1mctl18_addr;
#define		c1mctl18		c1mctl18_addr.byte

#define		newdata_c1mctl18	c1mctl18_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl18	c1mctl18_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl18	c1mctl18_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl18	c1mctl18_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl18	c1mctl18_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl18	c1mctl18_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl18	c1mctl18_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl18	c1mctl18_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl18	c1mctl18_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 19                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl19_addr	0D4B3h
union BYTE_DEF	c1mctl19_addr;
#define		c1mctl19		c1mctl19_addr.byte

#define		newdata_c1mctl19	c1mctl19_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl19	c1mctl19_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl19	c1mctl19_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl19	c1mctl19_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl19	c1mctl19_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl19	c1mctl19_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl19	c1mctl19_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl19	c1mctl19_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl19	c1mctl19_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 20                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl20_addr	0D4B4h
union BYTE_DEF	c1mctl20_addr;
#define		c1mctl20		c1mctl20_addr.byte

#define		newdata_c1mctl20	c1mctl20_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl20	c1mctl20_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl20	c1mctl20_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl20	c1mctl20_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl20	c1mctl20_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl20	c1mctl20_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl20	c1mctl20_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl20	c1mctl20_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl20	c1mctl20_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 21                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl21_addr	0D4B5h
union BYTE_DEF	c1mctl21_addr;
#define		c1mctl21		c1mctl21_addr.byte

#define		newdata_c1mctl21	c1mctl21_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl21	c1mctl21_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl21	c1mctl21_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl21	c1mctl21_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl21	c1mctl21_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl21	c1mctl21_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl21	c1mctl21_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl21	c1mctl21_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl21	c1mctl21_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 22                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl22_addr	0D4B6h
union BYTE_DEF	c1mctl22_addr;
#define		c1mctl22		c1mctl22_addr.byte

#define		newdata_c1mctl22	c1mctl22_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl22	c1mctl22_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl22	c1mctl22_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl22	c1mctl22_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl22	c1mctl22_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl22	c1mctl22_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl22	c1mctl22_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl22	c1mctl22_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl22	c1mctl22_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 23                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl23_addr	0D4B7h
union BYTE_DEF	c1mctl23_addr;
#define		c1mctl23		c1mctl23_addr.byte

#define		newdata_c1mctl23	c1mctl23_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl23	c1mctl23_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl23	c1mctl23_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl23	c1mctl23_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl23	c1mctl23_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl23	c1mctl23_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl23	c1mctl23_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl23	c1mctl23_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl23	c1mctl23_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 24                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl24_addr	0D4B8h
union BYTE_DEF	c1mctl24_addr;
#define		c1mctl24		c1mctl24_addr.byte

#define		newdata_c1mctl24	c1mctl24_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl24	c1mctl24_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl24	c1mctl24_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl24	c1mctl24_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl24	c1mctl24_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl24	c1mctl24_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl24	c1mctl24_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl24	c1mctl24_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl24	c1mctl24_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 25                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl25_addr	0D4B9h
union BYTE_DEF	c1mctl25_addr;
#define		c1mctl25		c1mctl25_addr.byte

#define		newdata_c1mctl25	c1mctl25_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl25	c1mctl25_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl25	c1mctl25_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl25	c1mctl25_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl25	c1mctl25_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl25	c1mctl25_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl25	c1mctl25_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl25	c1mctl25_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl25	c1mctl25_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 26                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl26_addr	0D4BAh
union BYTE_DEF	c1mctl26_addr;
#define		c1mctl26		c1mctl26_addr.byte

#define		newdata_c1mctl26	c1mctl26_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl26	c1mctl26_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl26	c1mctl26_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl26	c1mctl26_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl26	c1mctl26_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl26	c1mctl26_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl26	c1mctl26_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl26	c1mctl26_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl26	c1mctl26_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 27                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl27_addr	0D4BBh
union BYTE_DEF	c1mctl27_addr;
#define		c1mctl27		c1mctl27_addr.byte

#define		newdata_c1mctl27	c1mctl27_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl27	c1mctl27_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl27	c1mctl27_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl27	c1mctl27_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl27	c1mctl27_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl27	c1mctl27_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl27	c1mctl27_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl27	c1mctl27_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl27	c1mctl27_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 28                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl28_addr	0D4BCh
union BYTE_DEF	c1mctl28_addr;
#define		c1mctl28		c1mctl28_addr.byte

#define		newdata_c1mctl28	c1mctl28_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl28	c1mctl28_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl28	c1mctl28_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl28	c1mctl28_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl28	c1mctl28_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl28	c1mctl28_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl28	c1mctl28_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl28	c1mctl28_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl28	c1mctl28_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 29                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl29_addr	0D4BDh
union BYTE_DEF	c1mctl29_addr;
#define		c1mctl29		c1mctl29_addr.byte

#define		newdata_c1mctl29	c1mctl29_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl29	c1mctl29_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl29	c1mctl29_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl29	c1mctl29_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl29	c1mctl29_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl29	c1mctl29_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl29	c1mctl29_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl29	c1mctl29_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl29	c1mctl29_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 30                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl30_addr	0D4BEh
union BYTE_DEF	c1mctl30_addr;
#define		c1mctl30		c1mctl30_addr.byte

#define		newdata_c1mctl30	c1mctl30_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl30	c1mctl30_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl30	c1mctl30_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl30	c1mctl30_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl30	c1mctl30_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl30	c1mctl30_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl30	c1mctl30_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl30	c1mctl30_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl30	c1mctl30_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Message Control Register 31                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mctl31_addr	0D4BFh
union BYTE_DEF	c1mctl31_addr;
#define		c1mctl31		c1mctl31_addr.byte

#define		newdata_c1mctl31	c1mctl31_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c1mctl31	c1mctl31_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c1mctl31	c1mctl31_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c1mctl31	c1mctl31_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c1mctl31	c1mctl31_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c1mctl31	c1mctl31_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c1mctl31	c1mctl31_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c1mctl31	c1mctl31_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c1mctl31	c1mctl31_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1ctlr_addr		0D4C0h
union CANCT_DEF	c1ctlr_addr;
#define		c1ctlr			c1ctlr_addr.word			/* CAN1 Control Register(16bits) */
#define		c1ctlrl			c1ctlr_addr.byte[0]			/* CAN1 Control Register(low-order byte) */
#define		c1ctlrh			c1ctlr_addr.byte[1]			/* CAN1 Control Register(high-order byte) */

#define		canm_c1ctlr		c1ctlr_addr.mc.canm			/* CAN Operating Mode Select Bit */
#define		slpm_c1ctlr		c1ctlr_addr.mc.slpm			/* CAN Sleep Mode Bit */
#define		bom_c1ctlr		c1ctlr_addr.mc.bom			/* Bus-Off Recovery Mode Select Bit */
#define		rboc_c1ctlr		c1ctlr_addr.mc.rboc			/* Forcible Return From Bus-Off Bit */
#define		cpe_c1ctlr		c1ctlr_addr.mc.cpe			/* CAN Port Enable Bit */
#define		mbm_c1ctlr		c1ctlr_addr.mc.mbm			/* CAN Mailbox Mode Select Bit */
#define		idfm_c1ctlr		c1ctlr_addr.mc.idfm			/* ID Format Mode Select Bit */
#define		mlm_c1ctlr		c1ctlr_addr.mc.mlm			/* Message Lost Mode Select Bit */
#define		tpm_c1ctlr		c1ctlr_addr.mc.tpm			/* Transmit Priority Mode Select Bit */
#define		tsrc_c1ctlr		c1ctlr_addr.mc.tsrc			/* Time Stamp Counter Reset Bit */
#define		tsps_c1ctlr		c1ctlr_addr.mc.tsps			/* Time Stamp Prescaler Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Status Register                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1str_addr		0D4C2h
union WORD_DEF	c1str_addr;
#define		c1str			c1str_addr.word
#define		c1strl			c1str_addr.byte.low			/* CAN1 Status Register(low-order byte) */
#define		c1strh			c1str_addr.byte.high		/* CAN1 Status Register(high-order byte) */

#define		rstst_c1str		c1str_addr.bit.b0			/* CAN Reset Status Flag */
#define		hltst_c1str		c1str_addr.bit.b1			/* CAN Halt Status Flag */
#define		slpst_c1str		c1str_addr.bit.b2			/* CAN Sleep Status Flag */
#define		epst_c1str		c1str_addr.bit.b3			/* Error-Passive Status Flag */
#define		bost_c1str		c1str_addr.bit.b4			/* Bus-Off Status Flag */
#define		trmst_c1str		c1str_addr.bit.b5			/* Transmit Status Flag(transmitter) */
#define		recst_c1str		c1str_addr.bit.b6			/* Receive Status Flag(receiver) */
#define		ndst_c1str		c1str_addr.bit.b8			/* NEWDATA Status Flag */
#define		sdst_c1str		c1str_addr.bit.b9			/* SENTDATA Status Flag */
#define		rfst_c1str		c1str_addr.bit.b10			/* Receive FIFO Status Flag */
#define		tfst_c1str		c1str_addr.bit.b11			/* Transmit FIFO Status Flag */
#define		nmlst_c1str		c1str_addr.bit.b12			/* Normal Mailbox Message Lost Status Flag */
#define		fmlst_c1str		c1str_addr.bit.b13			/* FIFO Mailbox Message Lost Status Flag */
#define		tabst_c1str		c1str_addr.bit.b14			/* Transmission Abort Status Flag */
#define		est_c1str		c1str_addr.bit.b15			/* Error Status Flag */

/*------------------------------------------------------------------------------*/
/*  CAN1 Bit Configuration Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1bcr_addr		0D4C4h
union CANBC_DEF	c1bcr_addr;

#define		c1bcr			c1bcr_addr.byte3.bcr		/* CAN1 bit configuration register(24bits) */
#define		c1bcrll			c1bcr_addr.byte[0]			/* CAN1 bit configuration register(low-order byte) */
#define		c1bcrlh			c1bcr_addr.byte[1]			/* CAN1 bit configuration register(mid-order byte) */
#define		c1bcrhl			c1bcr_addr.byte[2]			/* CAN1 bit configuration register(high-order byte) */
#define		brp_c1bcr		c1bcr_addr.ms.brp			/* Prescaler Division Ratio Select Bit(10 bits) */
#define		tseg1_c1bcr		c1bcr_addr.mc.tseg1			/* Time Segment 1 Control Bit */
#define		tseg2_c1bcr		c1bcr_addr.mc.tseg2			/* Time Segment 2 Control Bit */
#define		sjw_c1bcr		c1bcr_addr.mc.sjw			/* Resynchronization Jump Width Control Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Clock Select Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1clkr_addr		0D4C7h
union BYTE_DEF	c1clkr_addr;
#define		c1clkr			c1clkr_addr.byte

#define		cclks_c1clkr	c1clkr_addr.bit.b0			/* CAN Clock Source Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Receive FIFO Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1rfcr_addr		0D4C8h
union CANRF_DEF	c1rfcr_addr;
#define		c1rfcr			c1rfcr_addr.byte			/* CAN1 receive FIFO control register(8bits) */

#define		rfe_c1rfcr		c1rfcr_addr.mc.rfe			/* Receive FIFO Enable Bit */
#define		rfust_c1rfcr	c1rfcr_addr.mc.rfust		/* Receive FIFO Unread Message Number Status Bit */
#define		rfmlf_c1rfcr	c1rfcr_addr.mc.rfmlf		/* Receive FIFO Message Lost Flag */
#define		rffst_c1rfcr	c1rfcr_addr.mc.rffst		/* Receive FIFO Full Status Bit */
#define		rfwst_c1rfcr	c1rfcr_addr.mc.rfwst		/* Receive FIFO Buffer Warning Status Bit */
#define		rfest_c1rfcr	c1rfcr_addr.mc.rfest		/* Receive FIFO Empty Status Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Receive FIFO Pointer Control Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1rfpcr_addr	0D4C9h
union BYTE_DEF	c1rfpcr_addr;
#define		c1rfpcr			c1rfpcr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN1 Transmit FIFO Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1tfcr_addr		0D4CAh
union CANTF_DEF	c1tfcr_addr;
#define		c1tfcr			c1tfcr_addr.byte			/* CAN1 transmit FIFO control register(8bits) */

#define		tfe_c1tfcr		c1tfcr_addr.mc.tfe			/* Transmit FIFO Enable Bit */
#define		tfust_c1tfcr	c1tfcr_addr.mc.tfust		/* Transmit FIFO Unsent Message Number Status Bit */
#define		tffst_c1tfcr	c1tfcr_addr.mc.tffst		/* Transmit FIFO Full Status Bit */
#define		tfest_c1tfcr	c1tfcr_addr.mc.tfest		/* Transmit FIFO Empty Status Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Transmit FIFO Pointer Control Register                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1tfpcr_addr	0D4CBh
union BYTE_DEF	c1tfpcr_addr;
#define		c1tfpcr			c1tfpcr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN1 Error Interrupt Enable Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1eier_addr		0D4CCh
union BYTE_DEF	c1eier_addr;
#define		c1eier			c1eier_addr.byte

#define		beie_c1eier		c1eier_addr.bit.b0			/* Bus Error Interrupt Enable Bit */
#define		ewie_c1eier		c1eier_addr.bit.b1			/* Error Warning Interrupt Enable Bit */
#define		epie_c1eier		c1eier_addr.bit.b2			/* Error Passive Interrupt Enable Bit */
#define		boeie_c1eier	c1eier_addr.bit.b3			/* Bus-Off Entry Interrupt Enable Bit */
#define		borie_c1eier	c1eier_addr.bit.b4			/* Bus-Off Recovery Interrupt Enable Bit */
#define		orie_c1eier		c1eier_addr.bit.b5			/* Receive Overrun Interrupt Enable Bit */
#define		olie_c1eier		c1eier_addr.bit.b6			/* Overload Frame Transmit Interrupt Enable Bit */
#define		blie_c1eier		c1eier_addr.bit.b7			/* Bus Lock Interrupt Enable Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Error Interrupt Factor Judge Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1eifr_addr		0D4CDh
union BYTE_DEF	c1eifr_addr;
#define		c1eifr			c1eifr_addr.byte

#define		beif_c1eifr		c1eifr_addr.bit.b0			/* Bus Error Detect Flag */
#define		ewif_c1eifr		c1eifr_addr.bit.b1			/* Error Warning Detect Flag */
#define		epif_c1eifr		c1eifr_addr.bit.b2			/* Error Passive Detect Flag */
#define		boeif_c1eifr	c1eifr_addr.bit.b3			/* Bus-Off Entry Detect Flag */
#define		borif_c1eifr	c1eifr_addr.bit.b4			/* Bus-Off Recovery Detect Flag */
#define		orif_c1eifr		c1eifr_addr.bit.b5			/* Receive Overrun Detect Flag */
#define		olif_c1eifr		c1eifr_addr.bit.b6			/* Overload Frame Transmission Detect Flag */
#define		blif_c1eifr		c1eifr_addr.bit.b7			/* Bus Lock Detect Flag */

/*------------------------------------------------------------------------------*/
/*  CAN1 Receive Error Count Register                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1recr_addr		0D4CEh
union BYTE_DEF	c1recr_addr;
#define		c1recr			c1recr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN1 Transmit Error Count Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1tecr_addr		0D4CFh
union BYTE_DEF	c1tecr_addr;
#define		c1tecr			c1tecr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN1 Error Code Store Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1ecsr_addr		0D4D0h
union BYTE_DEF	c1ecsr_addr;
#define		c1ecsr			c1ecsr_addr.byte

#define		sef_c1ecsr		c1ecsr_addr.bit.b0			/* Stuff Error Flag */
#define		fef_c1ecsr		c1ecsr_addr.bit.b1			/* Form Error Flag */
#define		aef_c1ecsr		c1ecsr_addr.bit.b2			/* ACK Error Flag */
#define		cef_c1ecsr		c1ecsr_addr.bit.b3			/* CRC Error Flag */
#define		be1f_c1ecsr		c1ecsr_addr.bit.b4			/* Bit Error(recessive) Flag */
#define		be0f_c1ecsr		c1ecsr_addr.bit.b5			/* Bit Error(dominant) Flag */
#define		adef_c1ecsr		c1ecsr_addr.bit.b6			/* ACK Delimiter Error Bit */
#define		edpm_c1ecsr		c1ecsr_addr.bit.b7			/* Error Display Mode Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Channel Search Support Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1cssr_addr		0D4D1h
union BYTE_DEF	c1cssr_addr;
#define		c1cssr			c1cssr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Search Status Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1mssr_addr		0D4D2h
union CANMS_DEF	c1mssr_addr;
#define		c1mssr			c1mssr_addr.byte			/* CAN1 mailbox search status register(8bits) */

#define		mbnst_c1mssr	c1mssr_addr.mc.mbnst		/* Search Result Mailbox Number Status Bit */
#define		sest_c1mssr		c1mssr_addr.mc.sest			/* Search Result Status Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Mailbox Search Mode Register                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1msmr_addr		0D4D3h
union CANSM_DEF	c1msmr_addr;
#define		c1msmr			c1msmr_addr.byte			/* CAN1 mailbox search mode register(8bits) */

#define		mbsm_c1msmr		c1msmr_addr.mc.mbsm			/* Mailbox Search Mode Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN1 Time Stamp Register                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1tsr_addr		0D4D4h
union WORD_DEF	c1tsr_addr;
#define		c1tsr			c1tsr_addr.word

/*------------------------------------------------------------------------------*/
/*  CAN1 Acceptance Filter Support Register                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1afsr_addr		0D4D6h
union WORD_DEF	c1afsr_addr;
#define		c1afsr			c1afsr_addr.word
#define		c1afsrl			c1afsr_addr.byte.low		/* CAN1 acceptance filter support register(low-order byte) */
#define		c1afsrh			c1afsr_addr.byte.high		/* CAN1 acceptance filter support register(high-order byte) */

/*------------------------------------------------------------------------------*/
/*  CAN1 Test Control Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c1tcr_addr		0D4D8h
union CANTS_DEF	c1tcr_addr;
#define		c1tcr			c1tcr_addr.byte				/* CAN1 test control register(8bits) */

#define		tste_c1tcr		c1tcr_addr.mc.tste			/* CAN Test Mode Enable Bit */
#define		tstm_c1tcr		c1tcr_addr.mc.tstm			/* CAN Test Mode Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 0                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb0_addr		0D500h
union CANMB_DEF	c0mb0_addr;
#define		c0mb0			c0mb0_addr

#define		eid_c0mb0		c0mb0_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb0		c0mb0_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb0		c0mb0_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb0		c0mb0_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb0		c0mb0_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb0		c0mb0_addr.word[7]			/* Time stamp */
#define		tsl_c0mb0		c0mb0_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb0		c0mb0_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 1                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb1_addr		0D510h
union CANMB_DEF	c0mb1_addr;
#define		c0mb1			c0mb1_addr

#define		eid_c0mb1		c0mb1_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb1		c0mb1_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb1		c0mb1_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb1		c0mb1_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb1		c0mb1_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb1		c0mb1_addr.word[7]			/* Time stamp */
#define		tsl_c0mb1		c0mb1_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb1		c0mb1_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 2                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb2_addr		0D520h
union CANMB_DEF	c0mb2_addr;
#define		c0mb2			c0mb2_addr

#define		eid_c0mb2		c0mb2_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb2		c0mb2_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb2		c0mb2_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb2		c0mb2_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb2		c0mb2_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb2		c0mb2_addr.word[7]			/* Time stamp */
#define		tsl_c0mb2		c0mb2_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb2		c0mb2_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 3                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb3_addr		0D530h
union CANMB_DEF	c0mb3_addr;
#define		c0mb3			c0mb3_addr

#define		eid_c0mb3		c0mb3_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb3		c0mb3_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb3		c0mb3_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb3		c0mb3_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb3		c0mb3_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb3		c0mb3_addr.word[7]			/* Time stamp */
#define		tsl_c0mb3		c0mb3_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb3		c0mb3_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 4                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb4_addr		0D540h
union CANMB_DEF	c0mb4_addr;
#define		c0mb4			c0mb4_addr

#define		eid_c0mb4		c0mb4_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb4		c0mb4_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb4		c0mb4_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb4		c0mb4_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb4		c0mb4_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb4		c0mb4_addr.word[7]			/* Time stamp */
#define		tsl_c0mb4		c0mb4_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb4		c0mb4_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 5                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb5_addr		0D550h
union CANMB_DEF	c0mb5_addr;
#define		c0mb5			c0mb5_addr

#define		eid_c0mb5		c0mb5_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb5		c0mb5_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb5		c0mb5_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb5		c0mb5_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb5		c0mb5_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb5		c0mb5_addr.word[7]			/* Time stamp */
#define		tsl_c0mb5		c0mb5_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb5		c0mb5_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 6                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb6_addr		0D560h
union CANMB_DEF	c0mb6_addr;
#define		c0mb6			c0mb6_addr

#define		eid_c0mb6		c0mb6_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb6		c0mb6_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb6		c0mb6_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb6		c0mb6_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb6		c0mb6_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb6		c0mb6_addr.word[7]			/* Time stamp */
#define		tsl_c0mb6		c0mb6_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb6		c0mb6_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 7                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb7_addr		0D570h
union CANMB_DEF	c0mb7_addr;
#define		c0mb7			c0mb7_addr

#define		eid_c0mb7		c0mb7_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb7		c0mb7_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb7		c0mb7_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb7		c0mb7_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb7		c0mb7_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb7		c0mb7_addr.word[7]			/* Time stamp */
#define		tsl_c0mb7		c0mb7_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb7		c0mb7_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 8                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb8_addr		0D580h
union CANMB_DEF	c0mb8_addr;
#define		c0mb8			c0mb8_addr

#define		eid_c0mb8		c0mb8_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb8		c0mb8_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb8		c0mb8_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb8		c0mb8_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb8		c0mb8_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb8		c0mb8_addr.word[7]			/* Time stamp */
#define		tsl_c0mb8		c0mb8_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb8		c0mb8_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 9                                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb9_addr		0D590h
union CANMB_DEF	c0mb9_addr;
#define		c0mb9			c0mb9_addr

#define		eid_c0mb9		c0mb9_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb9		c0mb9_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb9		c0mb9_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb9		c0mb9_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb9		c0mb9_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb9		c0mb9_addr.word[7]			/* Time stamp */
#define		tsl_c0mb9		c0mb9_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb9		c0mb9_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 10                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb10_addr		0D5A0h
union CANMB_DEF	c0mb10_addr;
#define		c0mb10			c0mb10_addr

#define		eid_c0mb10		c0mb10_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb10		c0mb10_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb10		c0mb10_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb10		c0mb10_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb10		c0mb10_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb10		c0mb10_addr.word[7]			/* Time stamp */
#define		tsl_c0mb10		c0mb10_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb10		c0mb10_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 11                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb11_addr		0D5B0h
union CANMB_DEF	c0mb11_addr;
#define		c0mb11			c0mb11_addr

#define		eid_c0mb11		c0mb11_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb11		c0mb11_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb11		c0mb11_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb11		c0mb11_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb11		c0mb11_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb11		c0mb11_addr.word[7]			/* Time stamp */
#define		tsl_c0mb11		c0mb11_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb11		c0mb11_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 12                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb12_addr		0D5C0h
union CANMB_DEF	c0mb12_addr;
#define		c0mb12			c0mb12_addr

#define		eid_c0mb12		c0mb12_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb12		c0mb12_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb12		c0mb12_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb12		c0mb12_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb12		c0mb12_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb12		c0mb12_addr.word[7]			/* Time stamp */
#define		tsl_c0mb12		c0mb12_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb12		c0mb12_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 13                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb13_addr		0D5D0h
union CANMB_DEF	c0mb13_addr;
#define		c0mb13			c0mb13_addr

#define		eid_c0mb13		c0mb13_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb13		c0mb13_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb13		c0mb13_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb13		c0mb13_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb13		c0mb13_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb13		c0mb13_addr.word[7]			/* Time stamp */
#define		tsl_c0mb13		c0mb13_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb13		c0mb13_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 14                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb14_addr		0D5E0h
union CANMB_DEF	c0mb14_addr;
#define		c0mb14			c0mb14_addr

#define		eid_c0mb14		c0mb14_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb14		c0mb14_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb14		c0mb14_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb14		c0mb14_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb14		c0mb14_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb14		c0mb14_addr.word[7]			/* Time stamp */
#define		tsl_c0mb14		c0mb14_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb14		c0mb14_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 15                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb15_addr		0D5F0h
union CANMB_DEF	c0mb15_addr;
#define		c0mb15			c0mb15_addr

#define		eid_c0mb15		c0mb15_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb15		c0mb15_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb15		c0mb15_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb15		c0mb15_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb15		c0mb15_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb15		c0mb15_addr.word[7]			/* Time stamp */
#define		tsl_c0mb15		c0mb15_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb15		c0mb15_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 16                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb16_addr		0D600h
union CANMB_DEF	c0mb16_addr;
#define		c0mb16			c0mb16_addr

#define		eid_c0mb16		c0mb16_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb16		c0mb16_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb16		c0mb16_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb16		c0mb16_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb16		c0mb16_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb16		c0mb16_addr.word[7]			/* Time stamp */
#define		tsl_c0mb16		c0mb16_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb16		c0mb16_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 17                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb17_addr		0D610h
union CANMB_DEF	c0mb17_addr;
#define		c0mb17			c0mb17_addr

#define		eid_c0mb17		c0mb17_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb17		c0mb17_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb17		c0mb17_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb17		c0mb17_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb17		c0mb17_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb17		c0mb17_addr.word[7]			/* Time stamp */
#define		tsl_c0mb17		c0mb17_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb17		c0mb17_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 18                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb18_addr		0D620h
union CANMB_DEF	c0mb18_addr;
#define		c0mb18			c0mb18_addr

#define		eid_c0mb18		c0mb18_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb18		c0mb18_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb18		c0mb18_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb18		c0mb18_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb18		c0mb18_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb18		c0mb18_addr.word[7]			/* Time stamp */
#define		tsl_c0mb18		c0mb18_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb18		c0mb18_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 19                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb19_addr		0D630h
union CANMB_DEF	c0mb19_addr;
#define		c0mb19			c0mb19_addr

#define		eid_c0mb19		c0mb19_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb19		c0mb19_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb19		c0mb19_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb19		c0mb19_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb19		c0mb19_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb19		c0mb19_addr.word[7]			/* Time stamp */
#define		tsl_c0mb19		c0mb19_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb19		c0mb19_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 20                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb20_addr		0D640h
union CANMB_DEF	c0mb20_addr;
#define		c0mb20			c0mb20_addr

#define		eid_c0mb20		c0mb20_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb20		c0mb20_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb20		c0mb20_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb20		c0mb20_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb20		c0mb20_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb20		c0mb20_addr.word[7]			/* Time stamp */
#define		tsl_c0mb20		c0mb20_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb20		c0mb20_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 21                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb21_addr		0D650h
union CANMB_DEF	c0mb21_addr;
#define		c0mb21			c0mb21_addr

#define		eid_c0mb21		c0mb21_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb21		c0mb21_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb21		c0mb21_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb21		c0mb21_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb21		c0mb21_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb21		c0mb21_addr.word[7]			/* Time stamp */
#define		tsl_c0mb21		c0mb21_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb21		c0mb21_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 22                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb22_addr		0D660h
union CANMB_DEF	c0mb22_addr;
#define		c0mb22			c0mb22_addr

#define		eid_c0mb22		c0mb22_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb22		c0mb22_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb22		c0mb22_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb22		c0mb22_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb22		c0mb22_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb22		c0mb22_addr.word[7]			/* Time stamp */
#define		tsl_c0mb22		c0mb22_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb22		c0mb22_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 23                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb23_addr		0D670h
union CANMB_DEF	c0mb23_addr;
#define		c0mb23			c0mb23_addr

#define		eid_c0mb23		c0mb23_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb23		c0mb23_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb23		c0mb23_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb23		c0mb23_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb23		c0mb23_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb23		c0mb23_addr.word[7]			/* Time stamp */
#define		tsl_c0mb23		c0mb23_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb23		c0mb23_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 24                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb24_addr		0D680h
union CANMB_DEF	c0mb24_addr;
#define		c0mb24			c0mb24_addr

#define		eid_c0mb24		c0mb24_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb24		c0mb24_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb24		c0mb24_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb24		c0mb24_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb24		c0mb24_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb24		c0mb24_addr.word[7]			/* Time stamp */
#define		tsl_c0mb24		c0mb24_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb24		c0mb24_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 25                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb25_addr		0D690h
union CANMB_DEF	c0mb25_addr;
#define		c0mb25			c0mb25_addr

#define		eid_c0mb25		c0mb25_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb25		c0mb25_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb25		c0mb25_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb25		c0mb25_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb25		c0mb25_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb25		c0mb25_addr.word[7]			/* Time stamp */
#define		tsl_c0mb25		c0mb25_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb25		c0mb25_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 26                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb26_addr		0D6A0h
union CANMB_DEF	c0mb26_addr;
#define		c0mb26			c0mb26_addr

#define		eid_c0mb26		c0mb26_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb26		c0mb26_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb26		c0mb26_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb26		c0mb26_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb26		c0mb26_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb26		c0mb26_addr.word[7]			/* Time stamp */
#define		tsl_c0mb26		c0mb26_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb26		c0mb26_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 27                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb27_addr		0D6B0h
union CANMB_DEF	c0mb27_addr;
#define		c0mb27			c0mb27_addr

#define		eid_c0mb27		c0mb27_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb27		c0mb27_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb27		c0mb27_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb27		c0mb27_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb27		c0mb27_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb27		c0mb27_addr.word[7]			/* Time stamp */
#define		tsl_c0mb27		c0mb27_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb27		c0mb27_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 28                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb28_addr		0D6C0h
union CANMB_DEF	c0mb28_addr;
#define		c0mb28			c0mb28_addr

#define		eid_c0mb28		c0mb28_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb28		c0mb28_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb28		c0mb28_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb28		c0mb28_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb28		c0mb28_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb28		c0mb28_addr.word[7]			/* Time stamp */
#define		tsl_c0mb28		c0mb28_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb28		c0mb28_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 29                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb29_addr		0D6D0h
union CANMB_DEF	c0mb29_addr;
#define		c0mb29			c0mb29_addr

#define		eid_c0mb29		c0mb29_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb29		c0mb29_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb29		c0mb29_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb29		c0mb29_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb29		c0mb29_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb29		c0mb29_addr.word[7]			/* Time stamp */
#define		tsl_c0mb29		c0mb29_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb29		c0mb29_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 30                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb30_addr		0D6E0h
union CANMB_DEF	c0mb30_addr;
#define		c0mb30			c0mb30_addr

#define		eid_c0mb30		c0mb30_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb30		c0mb30_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb30		c0mb30_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb30		c0mb30_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb30		c0mb30_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb30		c0mb30_addr.word[7]			/* Time stamp */
#define		tsl_c0mb30		c0mb30_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb30		c0mb30_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Register 31                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mb31_addr		0D6F0h
union CANMB_DEF	c0mb31_addr;
#define		c0mb31			c0mb31_addr

#define		eid_c0mb31		c0mb31_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mb31		c0mb31_addr.ml.sid			/* Standard ID bits */
#define		rtr_c0mb31		c0mb31_addr.mc.rtr			/* Remote Frame Request Bit */
#define		ide_c0mb31		c0mb31_addr.mc.ide			/* ID Extension Bit */
#define		dlc_c0mb31		c0mb31_addr.mc.dlc			/* Data Length Code */
#define		ts_c0mb31		c0mb31_addr.word[7]			/* Time stamp */
#define		tsl_c0mb31		c0mb31_addr.mc.tsl			/* Time stamp low-order byte */
#define		tsh_c0mb31		c0mb31_addr.mc.tsh			/* Time stamp high-order byte */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Register 0                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr0_addr		0D700h
union CANMK_DEF	c0mkr0_addr;
#define		c0mkr0			c0mkr0_addr.dword			/* CAN0 mask register 0(32bit) */
#define		c0mkr0l			c0mkr0_addr.word[0]			/* CAN0 mask register 0(low-order word) */
#define		c0mkr0h			c0mkr0_addr.word[1]			/* CAN0 mask register 0(high-order word) */

#define		eid_c0mkr0		c0mkr0_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr0		c0mkr0_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Register 1                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr1_addr		0D704h
union CANMK_DEF	c0mkr1_addr;
#define		c0mkr1			c0mkr1_addr.dword			/* CAN0 mask register 1(32bit) */
#define		c0mkr1l			c0mkr1_addr.word[0]			/* CAN0 mask register 1(low-order word) */
#define		c0mkr1h			c0mkr1_addr.word[1]			/* CAN0 mask register 1(high-order word) */

#define		eid_c0mkr1		c0mkr1_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr1		c0mkr1_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 mask register 2                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr2_addr		0D708h
union CANMK_DEF	c0mkr2_addr;
#define		c0mkr2			c0mkr2_addr.dword			/* CAN0 mask register 2(32bit) */
#define		c0mkr2l			c0mkr2_addr.word[0]			/* CAN0 mask register 2(low-order word) */
#define		c0mkr2h			c0mkr2_addr.word[1]			/* CAN0 mask register 2(high-order word) */

#define		eid_c0mkr2		c0mkr2_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr2		c0mkr2_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Register 3                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr3_addr		0D70Ch
union CANMK_DEF	c0mkr3_addr;
#define		c0mkr3			c0mkr3_addr.dword			/* CAN0 mask register 3(32bit) */
#define		c0mkr3l			c0mkr3_addr.word[0]			/* CAN0 mask register 3(low-order word) */
#define		c0mkr3h			c0mkr3_addr.word[1]			/* CAN0 mask register 3(high-order word) */

#define		eid_c0mkr3		c0mkr3_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr3		c0mkr3_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Register 4                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr4_addr		0D710h
union CANMK_DEF	c0mkr4_addr;
#define		c0mkr4			c0mkr4_addr.dword			/* CAN0 mask register 4(32bit) */
#define		c0mkr4l			c0mkr4_addr.word[0]			/* CAN0 mask register 4(low-order word) */
#define		c0mkr4h			c0mkr4_addr.word[1]			/* CAN0 mask register 4(high-order word) */

#define		eid_c0mkr4		c0mkr4_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr4		c0mkr4_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Register 5                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr5_addr		0D714h
union CANMK_DEF	c0mkr5_addr;
#define		c0mkr5			c0mkr5_addr.dword			/* CAN0 mask register 5(32bit) */
#define		c0mkr5l			c0mkr5_addr.word[0]			/* CAN0 mask register 5(low-order word) */
#define		c0mkr5h			c0mkr5_addr.word[1]			/* CAN0 mask register 5(high-order word) */

#define		eid_c0mkr5		c0mkr5_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr5		c0mkr5_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Register 6                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr6_addr		0D718h
union CANMK_DEF	c0mkr6_addr;
#define		c0mkr6			c0mkr6_addr.dword			/* CAN0 mask register 6(32bit) */
#define		c0mkr6l			c0mkr6_addr.word[0]			/* CAN0 mask register 6(low-order word) */
#define		c0mkr6h			c0mkr6_addr.word[1]			/* CAN0 mask register 6(high-order word) */

#define		eid_c0mkr6		c0mkr6_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr6		c0mkr6_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Register 7                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkr7_addr		0D71Ch
union CANMK_DEF	c0mkr7_addr;
#define		c0mkr7			c0mkr7_addr.dword			/* CAN0 mask register 7(32bit) */
#define		c0mkr7l			c0mkr7_addr.word[0]			/* CAN0 mask register 7(low-order word) */
#define		c0mkr7h			c0mkr7_addr.word[1]			/* CAN0 mask register 7(high-order word) */

#define		eid_c0mkr7		c0mkr7_addr.ml.eid			/* Extended ID bits */
#define		sid_c0mkr7		c0mkr7_addr.ml.sid			/* Standard ID bits */

/*------------------------------------------------------------------------------*/
/*  CAN0 FIFO Receive ID Compare Register 0                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0fidcr0_addr	0D720h
union CANRC_DEF	c0fidcr0_addr;
#define		c0fidcr0		c0fidcr0_addr.dword			/* CAN0 FIFO Receive ID Compare Register 0(32bit) */
#define		c0fidcr0l		c0fidcr0_addr.word[0]		/* CAN0 FIFO Receive ID Compare Register 0(low-order word) */
#define		c0fidcr0h		c0fidcr0_addr.word[1]		/* CAN0 FIFO Receive ID Compare Register 0(high-order word) */

#define		eid_c0fidcr0	c0fidcr0_addr.ml.eid		/* Extended ID bits */
#define		sid_c0fidcr0	c0fidcr0_addr.ml.sid		/* Standard ID bits */
#define		rtr_c0fidcr0	c0fidcr0_addr.ml.rtr		/* Remote Frame Request Bit */
#define		ide_c0fidcr0	c0fidcr0_addr.ml.ide		/* ID Extension Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 FIFO Receive ID Compare Register 1                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0fidcr1_addr	0D724h
union CANRC_DEF	c0fidcr1_addr;
#define		c0fidcr1		c0fidcr1_addr.dword			/* CAN0 FIFO Receive ID Compare Register 1(32bit) */
#define		c0fidcr1l		c0fidcr1_addr.word[0]		/* CAN0 FIFO Receive ID Compare Register 1(low-order word) */
#define		c0fidcr1h		c0fidcr1_addr.word[1]		/* CAN0 FIFO Receive ID Compare Register 1(high-order word) */

#define		eid_c0fidcr1	c0fidcr1_addr.ml.eid		/* Extended ID bits */
#define		sid_c0fidcr1	c0fidcr1_addr.ml.sid		/* Standard ID bits */
#define		rtr_c0fidcr1	c0fidcr1_addr.ml.rtr		/* Remote Frame Request Bit */
#define		ide_c0fidcr1	c0fidcr1_addr.ml.ide		/* ID Extension Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mask Invalid Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mkivlr_addr	0D728h
union CANDW_DEF	c0mkivlr_addr;
#define		c0mkivlr		c0mkivlr_addr.dword			/* CAN0 mask invalid register(32bit) */
#define		c0mkivlrl		c0mkivlr_addr.word[0]		/* CAN0 mask invalid register(low-order word) */
#define		c0mkivlrh		c0mkivlr_addr.word[1]		/* CAN0 mask invalid register(high-order word) */
#define		c0mkivlrll		c0mkivlr_addr.byte[0]		/* CAN0 mask invalid register(low-order byte) */
#define		c0mkivlrlh		c0mkivlr_addr.byte[1]		/* CAN0 mask invalid register(mid-order byte) */
#define		c0mkivlrhl		c0mkivlr_addr.byte[2]		/* CAN0 mask invalid register(high-order byte) */
#define		c0mkivlrhh		c0mkivlr_addr.byte[3]		/* CAN0 mask invalid register(highest-order byte) */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Interrupt Enable Register                                      */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mier_addr		0D72Ch
union CANDW_DEF	c0mier_addr;
#define		c0mier			c0mier_addr.dword			/* CAN0 Mailbox Interrupt Enable Register(32bit) */
#define		c0mierl			c0mier_addr.word[0]			/* CAN0 Mailbox Interrupt Enable Register(low-order word) */
#define		c0mierh			c0mier_addr.word[1]			/* CAN0 Mailbox Interrupt Enable Register(high-order word) */
#define		c0mierll		c0mier_addr.byte[0]			/* CAN0 Mailbox Interrupt Enable Register(low-order byte) */
#define		c0mierlh		c0mier_addr.byte[1]			/* CAN0 Mailbox Interrupt Enable Register(mid-order byte) */
#define		c0mierhl		c0mier_addr.byte[2]			/* CAN0 Mailbox Interrupt Enable Register(high-order byte) */
#define		c0mierhh		c0mier_addr.byte[3]			/* CAN0 Mailbox Interrupt Enable Register(highest-order byte) */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 0                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl0_addr	0D7A0h
union BYTE_DEF	c0mctl0_addr;
#define		c0mctl0			c0mctl0_addr.byte

#define		newdata_c0mctl0	c0mctl0_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl0	c0mctl0_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl0	c0mctl0_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl0	c0mctl0_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl0	c0mctl0_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl0	c0mctl0_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl0	c0mctl0_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl0	c0mctl0_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl0	c0mctl0_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 1                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl1_addr	0D7A1h
union BYTE_DEF	c0mctl1_addr;
#define		c0mctl1			c0mctl1_addr.byte

#define		newdata_c0mctl1	c0mctl1_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl1	c0mctl1_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl1	c0mctl1_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl1	c0mctl1_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl1	c0mctl1_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl1	c0mctl1_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl1	c0mctl1_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl1	c0mctl1_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl1	c0mctl1_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 2                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl2_addr	0D7A2h
union BYTE_DEF	c0mctl2_addr;
#define		c0mctl2			c0mctl2_addr.byte

#define		newdata_c0mctl2	c0mctl2_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl2	c0mctl2_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl2	c0mctl2_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl2	c0mctl2_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl2	c0mctl2_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl2	c0mctl2_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl2	c0mctl2_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl2	c0mctl2_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl2	c0mctl2_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 3                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl3_addr	0D7A3h
union BYTE_DEF	c0mctl3_addr;
#define		c0mctl3			c0mctl3_addr.byte

#define		newdata_c0mctl3	c0mctl3_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl3	c0mctl3_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl3	c0mctl3_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl3	c0mctl3_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl3	c0mctl3_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl3	c0mctl3_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl3	c0mctl3_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl3	c0mctl3_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl3	c0mctl3_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 4                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl4_addr	0D7A4h
union BYTE_DEF	c0mctl4_addr;
#define		c0mctl4			c0mctl4_addr.byte

#define		newdata_c0mctl4	c0mctl4_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl4	c0mctl4_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl4	c0mctl4_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl4	c0mctl4_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl4	c0mctl4_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl4	c0mctl4_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl4	c0mctl4_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl4	c0mctl4_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl4	c0mctl4_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 5                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl5_addr	0D7A5h
union BYTE_DEF	c0mctl5_addr;
#define		c0mctl5			c0mctl5_addr.byte

#define		newdata_c0mctl5	c0mctl5_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl5	c0mctl5_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl5	c0mctl5_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl5	c0mctl5_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl5	c0mctl5_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl5	c0mctl5_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl5	c0mctl5_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl5	c0mctl5_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl5	c0mctl5_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 6                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl6_addr	0D7A6h
union BYTE_DEF	c0mctl6_addr;
#define		c0mctl6			c0mctl6_addr.byte

#define		newdata_c0mctl6	c0mctl6_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl6	c0mctl6_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl6	c0mctl6_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl6	c0mctl6_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl6	c0mctl6_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl6	c0mctl6_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl6	c0mctl6_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl6	c0mctl6_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl6	c0mctl6_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 7                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl7_addr	0D7A7h
union BYTE_DEF	c0mctl7_addr;
#define		c0mctl7			c0mctl7_addr.byte

#define		newdata_c0mctl7	c0mctl7_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl7	c0mctl7_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl7	c0mctl7_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl7	c0mctl7_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl7	c0mctl7_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl7	c0mctl7_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl7	c0mctl7_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl7	c0mctl7_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl7	c0mctl7_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 8                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl8_addr	0D7A8h
union BYTE_DEF	c0mctl8_addr;
#define		c0mctl8			c0mctl8_addr.byte

#define		newdata_c0mctl8	c0mctl8_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl8	c0mctl8_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl8	c0mctl8_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl8	c0mctl8_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl8	c0mctl8_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl8	c0mctl8_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl8	c0mctl8_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl8	c0mctl8_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl8	c0mctl8_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 9                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl9_addr	0D7A9h
union BYTE_DEF	c0mctl9_addr;
#define		c0mctl9			c0mctl9_addr.byte

#define		newdata_c0mctl9	c0mctl9_addr.bit.b0			/* Reception Complete Flag */
#define		sentdata_c0mctl9	c0mctl9_addr.bit.b0			/* Transmission Complete Flag */
#define		invaldata_c0mctl9	c0mctl9_addr.bit.b1			/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl9	c0mctl9_addr.bit.b1			/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl9	c0mctl9_addr.bit.b2			/* Message Lost Flag */
#define		trmabt_c0mctl9	c0mctl9_addr.bit.b2			/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl9	c0mctl9_addr.bit.b4			/* One-shot Enable Bit */
#define		recreq_c0mctl9	c0mctl9_addr.bit.b6			/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl9	c0mctl9_addr.bit.b7			/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 10                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl10_addr	0D7AAh
union BYTE_DEF	c0mctl10_addr;
#define		c0mctl10		c0mctl10_addr.byte

#define		newdata_c0mctl10	c0mctl10_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl10	c0mctl10_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl10	c0mctl10_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl10	c0mctl10_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl10	c0mctl10_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl10	c0mctl10_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl10	c0mctl10_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl10	c0mctl10_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl10	c0mctl10_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 11                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl11_addr	0D7ABh
union BYTE_DEF	c0mctl11_addr;
#define		c0mctl11		c0mctl11_addr.byte

#define		newdata_c0mctl11	c0mctl11_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl11	c0mctl11_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl11	c0mctl11_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl11	c0mctl11_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl11	c0mctl11_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl11	c0mctl11_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl11	c0mctl11_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl11	c0mctl11_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl11	c0mctl11_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 12                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl12_addr	0D7ACh
union BYTE_DEF	c0mctl12_addr;
#define		c0mctl12		c0mctl12_addr.byte

#define		newdata_c0mctl12	c0mctl12_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl12	c0mctl12_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl12	c0mctl12_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl12	c0mctl12_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl12	c0mctl12_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl12	c0mctl12_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl12	c0mctl12_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl12	c0mctl12_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl12	c0mctl12_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 13                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl13_addr	0D7ADh
union BYTE_DEF	c0mctl13_addr;
#define		c0mctl13		c0mctl13_addr.byte

#define		newdata_c0mctl13	c0mctl13_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl13	c0mctl13_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl13	c0mctl13_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl13	c0mctl13_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl13	c0mctl13_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl13	c0mctl13_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl13	c0mctl13_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl13	c0mctl13_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl13	c0mctl13_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 14                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl14_addr	0D7AEh
union BYTE_DEF	c0mctl14_addr;
#define		c0mctl14		c0mctl14_addr.byte

#define		newdata_c0mctl14	c0mctl14_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl14	c0mctl14_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl14	c0mctl14_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl14	c0mctl14_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl14	c0mctl14_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl14	c0mctl14_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl14	c0mctl14_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl14	c0mctl14_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl14	c0mctl14_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 15                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl15_addr	0D7AFh
union BYTE_DEF	c0mctl15_addr;
#define		c0mctl15		c0mctl15_addr.byte

#define		newdata_c0mctl15	c0mctl15_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl15	c0mctl15_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl15	c0mctl15_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl15	c0mctl15_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl15	c0mctl15_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl15	c0mctl15_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl15	c0mctl15_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl15	c0mctl15_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl15	c0mctl15_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 16                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl16_addr	0D7B0h
union BYTE_DEF	c0mctl16_addr;
#define		c0mctl16		c0mctl16_addr.byte

#define		newdata_c0mctl16	c0mctl16_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl16	c0mctl16_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl16	c0mctl16_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl16	c0mctl16_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl16	c0mctl16_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl16	c0mctl16_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl16	c0mctl16_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl16	c0mctl16_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl16	c0mctl16_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 17                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl17_addr	0D7B1h
union BYTE_DEF	c0mctl17_addr;
#define		c0mctl17		c0mctl17_addr.byte

#define		newdata_c0mctl17	c0mctl17_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl17	c0mctl17_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl17	c0mctl17_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl17	c0mctl17_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl17	c0mctl17_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl17	c0mctl17_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl17	c0mctl17_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl17	c0mctl17_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl17	c0mctl17_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 18                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl18_addr	0D7B2h
union BYTE_DEF	c0mctl18_addr;
#define		c0mctl18		c0mctl18_addr.byte

#define		newdata_c0mctl18	c0mctl18_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl18	c0mctl18_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl18	c0mctl18_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl18	c0mctl18_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl18	c0mctl18_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl18	c0mctl18_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl18	c0mctl18_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl18	c0mctl18_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl18	c0mctl18_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 19                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl19_addr	0D7B3h
union BYTE_DEF	c0mctl19_addr;
#define		c0mctl19		c0mctl19_addr.byte

#define		newdata_c0mctl19	c0mctl19_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl19	c0mctl19_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl19	c0mctl19_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl19	c0mctl19_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl19	c0mctl19_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl19	c0mctl19_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl19	c0mctl19_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl19	c0mctl19_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl19	c0mctl19_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 20                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl20_addr	0D7B4h
union BYTE_DEF	c0mctl20_addr;
#define		c0mctl20		c0mctl20_addr.byte

#define		newdata_c0mctl20	c0mctl20_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl20	c0mctl20_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl20	c0mctl20_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl20	c0mctl20_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl20	c0mctl20_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl20	c0mctl20_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl20	c0mctl20_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl20	c0mctl20_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl20	c0mctl20_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 21                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl21_addr	0D7B5h
union BYTE_DEF	c0mctl21_addr;
#define		c0mctl21		c0mctl21_addr.byte

#define		newdata_c0mctl21	c0mctl21_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl21	c0mctl21_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl21	c0mctl21_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl21	c0mctl21_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl21	c0mctl21_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl21	c0mctl21_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl21	c0mctl21_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl21	c0mctl21_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl21	c0mctl21_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 22                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl22_addr	0D7B6h
union BYTE_DEF	c0mctl22_addr;
#define		c0mctl22		c0mctl22_addr.byte

#define		newdata_c0mctl22	c0mctl22_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl22	c0mctl22_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl22	c0mctl22_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl22	c0mctl22_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl22	c0mctl22_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl22	c0mctl22_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl22	c0mctl22_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl22	c0mctl22_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl22	c0mctl22_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 23                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl23_addr	0D7B7h
union BYTE_DEF	c0mctl23_addr;
#define		c0mctl23		c0mctl23_addr.byte

#define		newdata_c0mctl23	c0mctl23_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl23	c0mctl23_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl23	c0mctl23_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl23	c0mctl23_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl23	c0mctl23_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl23	c0mctl23_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl23	c0mctl23_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl23	c0mctl23_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl23	c0mctl23_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 24                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl24_addr	0D7B8h
union BYTE_DEF	c0mctl24_addr;
#define		c0mctl24		c0mctl24_addr.byte

#define		newdata_c0mctl24	c0mctl24_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl24	c0mctl24_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl24	c0mctl24_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl24	c0mctl24_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl24	c0mctl24_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl24	c0mctl24_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl24	c0mctl24_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl24	c0mctl24_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl24	c0mctl24_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 25                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl25_addr	0D7B9h
union BYTE_DEF	c0mctl25_addr;
#define		c0mctl25		c0mctl25_addr.byte

#define		newdata_c0mctl25	c0mctl25_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl25	c0mctl25_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl25	c0mctl25_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl25	c0mctl25_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl25	c0mctl25_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl25	c0mctl25_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl25	c0mctl25_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl25	c0mctl25_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl25	c0mctl25_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 26                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl26_addr	0D7BAh
union BYTE_DEF	c0mctl26_addr;
#define		c0mctl26		c0mctl26_addr.byte

#define		newdata_c0mctl26	c0mctl26_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl26	c0mctl26_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl26	c0mctl26_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl26	c0mctl26_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl26	c0mctl26_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl26	c0mctl26_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl26	c0mctl26_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl26	c0mctl26_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl26	c0mctl26_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 27                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl27_addr	0D7BBh
union BYTE_DEF	c0mctl27_addr;
#define		c0mctl27		c0mctl27_addr.byte

#define		newdata_c0mctl27	c0mctl27_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl27	c0mctl27_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl27	c0mctl27_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl27	c0mctl27_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl27	c0mctl27_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl27	c0mctl27_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl27	c0mctl27_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl27	c0mctl27_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl27	c0mctl27_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 28                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl28_addr	0D7BCh
union BYTE_DEF	c0mctl28_addr;
#define		c0mctl28		c0mctl28_addr.byte

#define		newdata_c0mctl28	c0mctl28_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl28	c0mctl28_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl28	c0mctl28_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl28	c0mctl28_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl28	c0mctl28_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl28	c0mctl28_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl28	c0mctl28_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl28	c0mctl28_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl28	c0mctl28_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 29                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl29_addr	0D7BDh
union BYTE_DEF	c0mctl29_addr;
#define		c0mctl29		c0mctl29_addr.byte

#define		newdata_c0mctl29	c0mctl29_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl29	c0mctl29_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl29	c0mctl29_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl29	c0mctl29_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl29	c0mctl29_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl29	c0mctl29_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl29	c0mctl29_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl29	c0mctl29_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl29	c0mctl29_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 30                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl30_addr	0D7BEh
union BYTE_DEF	c0mctl30_addr;
#define		c0mctl30		c0mctl30_addr.byte

#define		newdata_c0mctl30	c0mctl30_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl30	c0mctl30_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl30	c0mctl30_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl30	c0mctl30_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl30	c0mctl30_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl30	c0mctl30_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl30	c0mctl30_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl30	c0mctl30_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl30	c0mctl30_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Message Control Register 31                                            */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mctl31_addr	0D7BFh
union BYTE_DEF	c0mctl31_addr;
#define		c0mctl31		c0mctl31_addr.byte

#define		newdata_c0mctl31	c0mctl31_addr.bit.b0		/* Reception Complete Flag */
#define		sentdata_c0mctl31	c0mctl31_addr.bit.b0		/* Transmission Complete Flag */
#define		invaldata_c0mctl31	c0mctl31_addr.bit.b1		/* Reception-in-Progress Status Flag */
#define		trmactive_c0mctl31	c0mctl31_addr.bit.b1		/* Transmission-in-Progress Status Flag */
#define		msglost_c0mctl31	c0mctl31_addr.bit.b2		/* Message Lost Flag */
#define		trmabt_c0mctl31	c0mctl31_addr.bit.b2		/* Transmission Abort Complete Flag */
#define		oneshot_c0mctl31	c0mctl31_addr.bit.b4		/* One-shot Enable Bit */
#define		recreq_c0mctl31	c0mctl31_addr.bit.b6		/* Receive Mailbox Set Bit */
#define		trmreq_c0mctl31	c0mctl31_addr.bit.b7		/* Transmit Mailbox Set Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Control Register                                                       */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0ctlr_addr		0D7C0h
union CANCT_DEF	c0ctlr_addr;
#define		c0ctlr			c0ctlr_addr.word			/* CAN0 control register(16bits) */
#define		c0ctlrl			c0ctlr_addr.byte[0]			/* CAN0 control register(low-order byte) */
#define		c0ctlrh			c0ctlr_addr.byte[1]			/* CAN0 control register(high-order byte) */

#define		canm_c0ctlr		c0ctlr_addr.mc.canm			/* CAN Operating Mode Select Bit */
#define		slpm_c0ctlr		c0ctlr_addr.mc.slpm			/* CAN Sleep Mode Bit */
#define		bom_c0ctlr		c0ctlr_addr.mc.bom			/* Bus-Off Recovery Mode Select Bit */
#define		rboc_c0ctlr		c0ctlr_addr.mc.rboc			/* Forcible Return From Bus-Off Bit */
#define		cpe_c0ctlr		c0ctlr_addr.mc.cpe			/* CAN Port Enable Bit */
#define		mbm_c0ctlr		c0ctlr_addr.mc.mbm			/* CAN Mailbox Mode Select Bit */
#define		idfm_c0ctlr		c0ctlr_addr.mc.idfm			/* ID Format Mode Select Bit */
#define		mlm_c0ctlr		c0ctlr_addr.mc.mlm			/* Message Lost Mode Select Bit */
#define		tpm_c0ctlr		c0ctlr_addr.mc.tpm			/* Transmit Priority Mode Select Bit */
#define		tsrc_c0ctlr		c0ctlr_addr.mc.tsrc			/* Time Stamp Counter Reset Bit */
#define		tsps_c0ctlr		c0ctlr_addr.mc.tsps			/* Time Stamp Prescaler Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Status Register                                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0str_addr		0D7C2h
union WORD_DEF	c0str_addr;
#define		c0str			c0str_addr.word
#define		c0strl			c0str_addr.byte.low			/* CAN0 Status Register(low-order byte) */
#define		c0strh			c0str_addr.byte.high		/* CAN0 Status Register(high-order byte) */

#define		rstst_c0str		c0str_addr.bit.b0			/* CAN Reset Status Flag */
#define		hltst_c0str		c0str_addr.bit.b1			/* CAN Halt Status Flag */
#define		slpst_c0str		c0str_addr.bit.b2			/* CAN Sleep Status Flag */
#define		epst_c0str		c0str_addr.bit.b3			/* Error-Passive Status Flag */
#define		bost_c0str		c0str_addr.bit.b4			/* Bus-Off Status Flag */
#define		trmst_c0str		c0str_addr.bit.b5			/* Transmit Status Flag(transmitter) */
#define		recst_c0str		c0str_addr.bit.b6			/* Receive Status Flag(receiver) */
#define		ndst_c0str		c0str_addr.bit.b8			/* NEWDATA Status Flag */
#define		sdst_c0str		c0str_addr.bit.b9			/* SENTDATA Status Flag */
#define		rfst_c0str		c0str_addr.bit.b10			/* Receive FIFO Status Flag */
#define		tfst_c0str		c0str_addr.bit.b11			/* Transmit FIFO Status Flag */
#define		nmlst_c0str		c0str_addr.bit.b12			/* Normal Mailbox Message Lost Status Flag */
#define		fmlst_c0str		c0str_addr.bit.b13			/* FIFO Mailbox Message Lost Status Flag */
#define		tabst_c0str		c0str_addr.bit.b14			/* Transmission Abort Status Flag */
#define		est_c0str		c0str_addr.bit.b15			/* Error Status Flag */

/*------------------------------------------------------------------------------*/
/*  CAN0 Bit Configuration Register                                             */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0bcr_addr		0D7C4h
union CANBC_DEF	c0bcr_addr;

#define		c0bcr			c0bcr_addr.byte3.bcr		/* CAN0 bit configuration register(24bits) */
#define		c0bcrll			c0bcr_addr.byte[0]			/* CAN0 bit configuration register(low-order byte) */
#define		c0bcrlh			c0bcr_addr.byte[1]			/* CAN0 bit configuration register(mid-order byte) */
#define		c0bcrhl			c0bcr_addr.byte[2]			/* CAN0 bit configuration register(high-order byte) */
#define		brp_c0bcr		c0bcr_addr.ms.brp			/* Prescaler Division Ratio Select Bit(10 bits) */
#define		tseg1_c0bcr		c0bcr_addr.mc.tseg1			/* Time Segment 1 Control Bit */
#define		tseg2_c0bcr		c0bcr_addr.mc.tseg2			/* Time Segment 2 Control Bit */
#define		sjw_c0bcr		c0bcr_addr.mc.sjw			/* Resynchronization Jump Width Control Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Clock Select Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0clkr_addr		0D7C7h
union BYTE_DEF	c0clkr_addr;
#define		c0clkr			c0clkr_addr.byte

#define		cclks_c0clkr	c0clkr_addr.bit.b0			/* CAN Clock Source Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Receive FIFO Control Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0rfcr_addr		0D7C8h
union CANRF_DEF	c0rfcr_addr;
#define		c0rfcr			c0rfcr_addr.byte			/* CAN0 receive FIFO control register(8bits) */

#define		rfe_c0rfcr		c0rfcr_addr.mc.rfe			/* Receive FIFO Enable Bit */
#define		rfust_c0rfcr	c0rfcr_addr.mc.rfust		/* Receive FIFO Unread Message Number Status Bit */
#define		rfmlf_c0rfcr	c0rfcr_addr.mc.rfmlf		/* Receive FIFO Message Lost Flag */
#define		rffst_c0rfcr	c0rfcr_addr.mc.rffst		/* Receive FIFO Full Status Bit */
#define		rfwst_c0rfcr	c0rfcr_addr.mc.rfwst		/* Receive FIFO Buffer Warning Status Bit */
#define		rfest_c0rfcr	c0rfcr_addr.mc.rfest		/* Receive FIFO Empty Status Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Receive FIFO Pointer Control Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0rfpcr_addr	0D7C9h
union BYTE_DEF	c0rfpcr_addr;
#define		c0rfpcr			c0rfpcr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN0 Transmit FIFO Control Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0tfcr_addr		0D7CAh
union CANTF_DEF	c0tfcr_addr;
#define		c0tfcr			c0tfcr_addr.byte			/* CAN0 transmit FIFO control register(8bits) */

#define		tfe_c0tfcr		c0tfcr_addr.mc.tfe			/* Transmit FIFO Enable Bit */
#define		tfust_c0tfcr	c0tfcr_addr.mc.tfust		/* Transmit FIFO Unsent Message Number Status Bit */
#define		tffst_c0tfcr	c0tfcr_addr.mc.tffst		/* Transmit FIFO Full Status Bit */
#define		tfest_c0tfcr	c0tfcr_addr.mc.tfest		/* Transmit FIFO Empty Status Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Transmit FIFO Pointer Control Register                                 */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0tfpcr_addr	0D7CBh
union BYTE_DEF	c0tfpcr_addr;
#define		c0tfpcr			c0tfpcr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN0 Error Interrupt Enable Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0eier_addr		0D7CCh
union BYTE_DEF	c0eier_addr;
#define		c0eier			c0eier_addr.byte

#define		beie_c0eier		c0eier_addr.bit.b0			/* Bus Error Interrupt Enable Bit */
#define		ewie_c0eier		c0eier_addr.bit.b1			/* Error Warning Interrupt Enable Bit */
#define		epie_c0eier		c0eier_addr.bit.b2			/* Error Passive Interrupt Enable Bit */
#define		boeie_c0eier	c0eier_addr.bit.b3			/* Bus-Off Entry Interrupt Enable Bit */
#define		borie_c0eier	c0eier_addr.bit.b4			/* Bus-Off Recovery Interrupt Enable Bit */
#define		orie_c0eier		c0eier_addr.bit.b5			/* Receive Overrun Interrupt Enable Bit */
#define		olie_c0eier		c0eier_addr.bit.b6			/* Overload Frame Transmit Interrupt Enable Bit */
#define		blie_c0eier		c0eier_addr.bit.b7			/* Bus Lock Interrupt Enable Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Error Interrupt Factor Judge Register                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0eifr_addr		0D7CDh
union BYTE_DEF	c0eifr_addr;
#define		c0eifr			c0eifr_addr.byte

#define		beif_c0eifr		c0eifr_addr.bit.b0			/* Bus Error Detect Flag */
#define		ewif_c0eifr		c0eifr_addr.bit.b1			/* Error Warning Detect Flag */
#define		epif_c0eifr		c0eifr_addr.bit.b2			/* Error Passive Detect Flag */
#define		boeif_c0eifr	c0eifr_addr.bit.b3			/* Bus-Off Entry Detect Flag */
#define		borif_c0eifr	c0eifr_addr.bit.b4			/* Bus-Off Recovery Detect Flag */
#define		orif_c0eifr		c0eifr_addr.bit.b5			/* Receive Overrun Detect Flag */
#define		olif_c0eifr		c0eifr_addr.bit.b6			/* Overload Frame Transmission Detect Flag */
#define		blif_c0eifr		c0eifr_addr.bit.b7			/* Bus Lock Detect Flag */

/*------------------------------------------------------------------------------*/
/*  CAN0 Receive Error Count Register                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0recr_addr		0D7CEh
union BYTE_DEF	c0recr_addr;
#define		c0recr			c0recr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN0 Transmit Error Count Register                                          */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0tecr_addr		0D7CFh
union BYTE_DEF	c0tecr_addr;
#define		c0tecr			c0tecr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN0 Error Code Store Register                                              */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0ecsr_addr		0D7D0h
union BYTE_DEF	c0ecsr_addr;
#define		c0ecsr			c0ecsr_addr.byte

#define		sef_c0ecsr		c0ecsr_addr.bit.b0			/* Stuff Error Flag */
#define		fef_c0ecsr		c0ecsr_addr.bit.b1			/* Form Error Flag */
#define		aef_c0ecsr		c0ecsr_addr.bit.b2			/* ACK Error Flag */
#define		cef_c0ecsr		c0ecsr_addr.bit.b3			/* CRC Error Flag */
#define		be1f_c0ecsr		c0ecsr_addr.bit.b4			/* Bit Error(recessive) Flag */
#define		be0f_c0ecsr		c0ecsr_addr.bit.b5			/* Bit Error(dominant) Flag */
#define		adef_c0ecsr		c0ecsr_addr.bit.b6			/* ACK Delimiter Error Bit */
#define		edpm_c0ecsr		c0ecsr_addr.bit.b7			/* Error Display Mode Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Channel Search Support Register                                        */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0cssr_addr		0D7D1h
union BYTE_DEF	c0cssr_addr;
#define		c0cssr			c0cssr_addr.byte

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Search Status Register                                         */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0mssr_addr		0D7D2h
union CANMS_DEF	c0mssr_addr;
#define		c0mssr			c0mssr_addr.byte			/* CAN0 mailbox search status register(8bits) */

#define		mbnst_c0mssr	c0mssr_addr.mc.mbnst		/* Search Result Mailbox Number Status Bit */
#define		sest_c0mssr		c0mssr_addr.mc.sest			/* Search Result Status Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Mailbox Search Mode Register                                           */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0msmr_addr		0D7D3h
union CANSM_DEF	c0msmr_addr;
#define		c0msmr			c0msmr_addr.byte			/* CAN0 mailbox search mode register(8bits) */

#define		mbsm_c0msmr		c0msmr_addr.mc.mbsm			/* Mailbox Search Mode Select Bit */

/*------------------------------------------------------------------------------*/
/*  CAN0 Time Stamp Register                                                    */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0tsr_addr		0D7D4h
union WORD_DEF	c0tsr_addr;
#define		c0tsr			c0tsr_addr.word

/*------------------------------------------------------------------------------*/
/*  CAN0 Acceptance Filter Support Register                                     */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0afsr_addr		0D7D6h
union WORD_DEF	c0afsr_addr;
#define		c0afsr			c0afsr_addr.word
#define		c0afsrl			c0afsr_addr.byte.low		/* CAN0 acceptance filter support register(low-order byte) */
#define		c0afsrh			c0afsr_addr.byte.high		/* CAN0 acceptance filter support register(high-order byte) */

/*------------------------------------------------------------------------------*/
/*  CAN0 Test Control Register                                                  */
/*------------------------------------------------------------------------------*/
#pragma ADDRESS		c0tcr_addr		0D7D8h
union CANTS_DEF	c0tcr_addr;
#define		c0tcr			c0tcr_addr.byte				/* CAN0 test control register(8bits) */

#define		tste_c0tcr		c0tcr_addr.mc.tste			/* CAN Test Mode Enable Bit */
#define		tstm_c0tcr		c0tcr_addr.mc.tstm			/* CAN Test Mode Select Bit */


/********************************************************************************/
/*  Special definition                                                          */
/********************************************************************************/
#pragma ADDRESS  l0db  0178h
union BYTE_DEF l0db[8];

#pragma ADDRESS  c1mb  0D200h
union CANMB_DEF c1mb[32];

#pragma ADDRESS  c0mb  0D500h
union CANMB_DEF c0mb[32];

#pragma ADDRESS  c1mctl  0D4A0h
union CANMC_DEF c1mctl[32];

#pragma ADDRESS  c0mctl  0D7A0h
union CANMC_DEF c0mctl[32];

#endif      /* #ifndef      _SFR5M_H_   */
/*** EOF ************************************************************************/
