/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ CvO ]
 */

#include "common.h"
#include "target.h"
#include "debug.h"
#include "clock.h"
#include "timer.h"
#include "led.h"
#include "sw.h"
#include "uart.h"
#include "log.h"
#include "can.h"
#include "canop.h"
#include "memmon.h"

/*
 * 
 */
static void init(void)
{
	/* hCow(ɒӂ) */
	target_init();
	clock_init();
	timer_init();
	led_init();
	sw_init();
	uart_init(0, 5000);
	uart_init(3, 5000);
	log_init();

	/* CAN͏Ȃ */

	/* AvP[Vw */
	canop_init();
	memmon_init();
}

/*
 * CvO
 */
void main(void)
{
	/*  */
	init();

	/* 荞݋ */
	cpu_force_ei();

	/* [v */
	for (;;) {
		/* hCow */
		led_task();
		sw_task();
		uart_task();
		can_task();

		/* AvP[Vw */
		canop_task();
		memmon_task();
	}
}
