/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ ^[Qbg` ]
 */

#ifndef TARGET_H
#define TARGET_H

/*
 * ^[Qbg`
 */
#define TARGET_HOKUTO				(1)
										/* kldqHSB16C29-64gpꍇA1ȊOƂ */

#if TARGET_HOKUTO != 0

/*
 * ^[Qbg:
 * kldqHSB16C29-64
 */
#define CLOCK_X1_MHZ				(16)
										/* X1NbN=16MHz */
#define MCU_PIN						(64)
										/* 64s */
#define LED_MAX						(8)
										/* LED */
#define SW_MAX						(4)
										/* SW */
#define INTR_DEF_LEVEL				(3)
										/* 荞݃x(ftHg) */

#else

/*
 * ^[Qbg:
 * lTXM3A-0256
 */
#define CLOCK_X1_MHZ				(8)
										/* X1NbN=8MHz */
#define MCU_PIN						(80)
										/* 80s */
#define LED_MAX						(3)
										/* LED */
#define SW_MAX						(2)
										/* SW */
#define INTR_DEF_LEVEL				(3)
										/* 荞݃x(ftHg) */

#endif /* TARGET_HOKUTO */

/*
 * ^[Qbg
 * PACRrbgݒ肷
 */
void target_init(void);

/*
 * CPU荞݋֎~
 */
uint8 cpu_di(void);

/*
 * CPU荞݋
 */
void cpu_ei(uint8 flg);

/*
 * CPU荞݋
 */
void cpu_force_ei(void);

/*
 * CPU NOP
 */
void cpu_nop(void);

#endif /* TARGET_H */
