/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ CAN ]
 */

#ifndef CAN_H
#define CAN_H

#include "list.h"

/*
 * CAN
 * PDU
 */
#define CAN_PDU_MAX					(20)
										/* PDU(24܂łɂ邱) */

/*
 * CAN
 * eXg[h
 */
#define CAN_TEST_NORMAL				(0)
										/* ʏ퓮샂[h */
#define CAN_TEST_LISTEN_ONLY		(1)
										/* bXI[h */
#define CAN_TEST_EXT_LOOPBACK		(2)
										/* ZteXg[h0(O[vobN) */
#define CAN_TEST_INT_LOOPBACK		(3)
										/* ZteXg[h1([vobN) */

/*
 * CAN
 * PDU
 */
#define CAN_STATE_NONE				(0x00)
										/* gp */
#define CAN_STATE_TX_REQ			(0x10)
										/* Mv */
#define CAN_STATE_TX_MB				(0x11)
										/* M[{bNXi[ */
#define CAN_STATE_TX_COMPLETED		(0x12)
										/* M */
#define CAN_STATE_TX_ABORTED		(0x13)
										/* MA{[g */
#define CAN_STATE_RX_COMPLETED		(0x20)
										/* M */

/*
 * CAN
 * PDU (Protocol Data Unit)
 */
typedef struct _can_pdu
{
	list_node list;
										/* oXg */
	uint8 mb;
										/* [{bNXNo. */
	uint8 state;
										/*  */
	uint16 sid;
										/* WID */
	uint8 dlc;
										/* DLC */
	uint8 data[8];
										/* f[^ */
} can_pdu;

/*
 * CAN
 * G[
 */
typedef struct _can_error_info
{
	uint16 be;
										/* oXG[o */
	uint16 ew;
										/* G[[jOo */
	uint16 ep;
										/* G[pbVuo */
	uint16 boe;
										/* oXItJno */
	uint16 bor;
										/* oXItAo */
	uint16 ror;
										/* MI[oo */
	uint16 ol;
										/* I[o[ht[Mo */
	uint16 bl;
										/* oXbNo */
	uint16 se;
										/* X^btG[o */
	uint16 fe;
										/* tH[G[o */
	uint16 ae;
										/* ACKG[o */
	uint16 ce;
										/* CRCG[o */
	uint16 be1;
										/* rbgG[(ZVu)o */
	uint16 be0;
										/* rbgG[(h~ig)o */
	uint16 ade;
										/* ACKf~^G[o */
	uint16 freerun;
										/* t[^C} */
	uint8 eifr;
										/* G[荞ݗv背WX^ */
	uint8 ecsr;
										/* G[R[hi[WX^ */
} can_error_info;

/*
 * CAN
 * Xe[^X
 */
typedef struct _can_status_info
{
	uint16 ep;
										/* G[pbVuo */
	uint16 bo;
										/* oXIto */
	uint16 nml;
										/* ʏ탁[{bNX bZ[WXgo */
	uint16 fml;
										/* FIFO[{bNX bZ[WXgo */
	uint16 str;
										/* Xe[^XWX^ */
} can_status_info;

/*
 * CAN
 * `l
 */
typedef struct _can_channel_info
{
	can_pdu pdu[CAN_PDU_MAX];
										/* PDU */
	can_pdu NEAR *empty;
										/* gpPDU */
	can_pdu NEAR *tx;
										/* MPDU */
	can_pdu NEAR *rx;
										/* MPDU */
	can_error_info error;
										/* G[ */
	can_status_info status;
										/* Xe[^X */
} can_channel_info;

/*
 * CAN
 * 
 * ^C}ōs
 */
void can_init(uint8 test_mode);

/*
 * CAN
 * X[v
 */
void can_sleep(void);

/*
 * CAN
 * ^XN
 */
void can_task(void);

/*
 * CAN
 * MPDU擾
 * ׂĂPDUgp̏ꍇNULLԂ
 */
can_pdu NEAR *can_tx_get(void);

/*
 * CAN
 * Mv
 */
BOOL can_tx_req(can_pdu NEAR *pdu);

/*
 * CAN
 * MPDU擾
 * MPDU݂ȂꍇNULLԂ
 */
can_pdu NEAR *can_rx_get(void);

/*
 * CAN
 * MPDU
 */
void can_rx_free(can_pdu NEAR *pdu);

/*
 * CAN
 * oXItXe[^X擾
 */
BOOL can_is_busoff(void);

#endif /* CAN_H */
