/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ NbN ]
 */

#include "common.h"
#include "target.h"
#include "sfr5m.h"
#include "clock.h"

/*
 * NbN
 * NOPɂEFCg
 */
static void clock_wait(uint16 count)
{
	uint16 loop;

	/* nop߂CCAZuŎw肵AœK̉e}~ */
	for (loop=0; loop<count; loop++) {
		asm("  nop");
	}
}

/*
 * NbN
 * 
 * PLLgpCPUNbN=32MHzƂ
 */
void clock_init(void)
{
	/* PRC0(veNgrbg)"1"() */
	prc0 = 1;

	/*
	 * CNbN(X1NbN8MHz or 16MHz)쓮
	 */

	/* CM15rbg"1"(쓮\High) */
	cm15 = 1;

	/* CM05rbg"0"(CNbNU) */
	cm05 = 0;

	/* CNbNU莞Ԃ҂ */
	clock_wait(0x0100);

	/*
	 * Zbg125kHzI`bvIV[^쓮Ȃ̂ŁACNbN쓮ɐ؂ւ
	 */

	/* CNbN͕Ȃ */
	cm16 = 0;
	cm17 = 0;
	cm06 = 0;

	/* CM11rbg"0"(VXeNbN̓CNbN) */
	cm11 = 0;
	
	/* CM21rbg"0"(VXeNbN̓CNbN܂PLLNbN) */
	cm21 = 0;
	
	/* CM07rbg"0"(VXeNbN̓TuNbNȊO) */
	cm07 = 0;

	/*
	 * PLL𔭐U
	 */

#if CLOCK_X1_MHZ == 16
	/* PLL4 */
	plc04 = 0;
	plc05 = 1;
#elif CLOCK_X1_MHZ == 8
	/* PLL2 */
	plc04 = 1;
	plc05 = 0;
#else
#error illegal CLOCK_X1_MHZ value
#endif /* CLOCK_X1_MHZ */

	/* PLL8{ */
	plc00 = 0;
	plc01 = 0;
	plc02 = 1;

	/* PLLUJn */
	plc07 = 1;

	/* PLLNbN̈҂ */
	clock_wait(0x1000);

	/*
	 * PLLNbN쓮ɐ؂ւ
	 */

	/* CM11rbg"1"(VXeNbNPLLNbN) */
	cm11 = 1;

	/* CM21rbg"0"(VXeNbN̓CNbN܂PLLNbN) */
	cm21 = 0;
	
	/* CM07rbg"0"(VXeNbN̓TuNbNȊO) */
	cm07 = 0;

	/* PRC0(veNgrbg)"0"(֎~) */
	prc0 = 0;
}
