/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ LED ]
 */

#ifndef LED_H
#define LED_H

/*
 * LED
 * `
 */
#define LED_CAN_TX					(0)
										/* LED(CANM) */
#define LED_CAN_RX					(1)
										/* LED(CANM) */
#define LED_UART_CMD				(2)
										/* LED(UARTR}hM) */
#define LED_ONESHOT_MS				(100)
										/* LEDVbg(ms) */

/*
 * LED
 * 
 * ^C}ōs
 */
void led_init(void);

/*
 * LED
 * Vbg_
 */
void led_oneshot(uint8 led_no, uint16 ms);

/*
 * LED
 * A_
 */
void led_on(uint8 led_no);

/*
 * LED
 * A
 */
void led_off(uint8 led_no);

/*
 * LED
 * ^XN
 */
void led_task(void);

#endif /* LED_H */
