/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ ^[Qbg` ]
 */

#include "common.h"
#include "sfr5m.h"
#include "target.h"

/*
 * ^[Qbg
 * PACRrbgݒ肷
 */
void target_init(void)
{
	/* PRC2(veNgrbg)Zbg(荞݋֎~ōs) */
	prc2 = 1;

#if MCU_PIN == 64
	/* PACR1oCgŏ(64sAUARTĔzuȂ) */
	pacr = 0x02;
#elif MCU_PIN == 80
	/* PACR1oCgŏ(80sAUARTĔzuȂ) */
	pacr = 0x03;
#else
#error illegal MCU_PIN
#endif /* MCU_PIN */
}

/*
 * FLGWX^`
 */
#define FLG_I_BIT					(0x40)
										/* FLGWX^Irbg̈ʒu */

/*
 * CPU荞݋֎~
 */
uint8 cpu_di(void)
{
	asm(" STC FLG,R0");
	asm(" FCLR I");
}

/*
 * CPU荞݋
 */
void cpu_ei(uint8 flg)
{
	/* FLGIrbg`FbN */
	if ((flg & FLG_I_BIT) != 0)
	{
		/* 荞݋ */
		asm(" NOP");
		asm(" NOP");
		asm(" FSET I");
	}
}

/*
 * CPU荞݋
 */
void cpu_force_ei(void)
{
	asm(" NOP");
	asm(" NOP");
	asm(" FSET I");
}

/*
 * CPU NOP
 */
void cpu_nop(void)
{
	asm(" NOP");
}
