/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ LED ]
 */

#include "common.h"
#include "target.h"
#include "sfr5m.h"
#include "timer.h"
#include "led.h"

/*
 * LED
 * 萔
 */
#define LED_ONESHOT_POWERON			(200)
										/* d̃Vbg_(ms) */

/*
 * LED
 * _
 */
typedef struct _led_info
{
	BOOL state;
										/* LED */
	BOOL oneshot;
										/* Vbg쒆tO */
	uint16 freerun;
										/* t[^C}(ms) */
	uint16 hold;
										/* Vbg z[h(ms) */
} led_info;

/*
 * LED
 * IuWFNg
 */
static led_info led_object[LED_MAX];
										/* LEDIuWFNg */

/*
 * LED
 * 
 * ^C}ōs
 */
void led_init(void)
{
	uint8 loop;
	led_info NEAR *object;

	/* LEDIuWFNg */
	for (loop=0; loop<_countof(led_object); loop++)
	{
		led_object[loop].state = FALSE;
		led_object[loop].oneshot = FALSE;
	}

#if LED_MAX == 8

	/* |[gݒ:kldqHSB16C29-64 */

	/* P3_0'H'xɏo(for SW isolation) */
	p3_0 = 1;

	/* P3_0o͕ɐݒ */
	pd3_0 = 1;

	/* P6_0'L'xɏo(for CLK control) */
	p6_0 = 0;

	/* P6_0o͕ɐݒ */
	pd6_0 = 1;

#elif LED_MAX == 3

	/* |[gݒ:lTXM3A-0256 */

	/* P7_0P7_2'H'xo */
	p7_0 = 1;
	p7_1 = 1;
	p7_2 = 1;

	/* P7_0P7_2o͕ɐݒ */
	pd7_0 = 1;
	pd7_1 = 1;
	pd7_2 = 1;

#endif /* LED_MAX */

	/* LEDׂē_(200ms) */
	for (loop=0; loop<_countof(led_object); loop++)
	{
		led_oneshot(loop, LED_ONESHOT_POWERON);
	}
}

/*
 * LED
 * Zbg
 */
static void led_set(void)
{
#if LED_MAX == 8
	uint8 dat;
	uint8 loop;

	/* f[^ */
	dat = 0x00;

	/* rbg쐬 */
	for (loop=0; loop<8; loop++)
	{
		/* ̃rbg */
		dat >>= 1;

		if (led_object[loop].state == TRUE)
		{
			/* 'L'xœ_ */
			dat &= ~(0x80);
		}
		else
		{
			/* 'H'xŏ */
			dat |= 0x80;
		}
	}

	/* P3_0'H'xɏo(for SW isolation) */
	p3_0 = 1;

	/* P6_0'L'xɏo */
	p6_0 = 0;

	/* P2Ƀf[^o */
	p2 = dat;

	/* P2o͕ɐݒ */
	pd2 = 0xFF;

	/* ԑ҂ */
	cpu_nop();

	/* P6_0'H'xɏo(Ńf[^m:74LV574f[^V[gQ) */
	p6_0 = 1;

#elif LED_MAX == 3

	/* D2 */
	if (led_object[0].state == FALSE)
	{
		p7_0 = 1;
	}
	else
	{
		p7_0 = 0;
	}

	/* D3 */
	if (led_object[1].state == FALSE)
	{
		p7_1 = 1;
	}
	else
	{
		p7_1 = 0;
	}

	/* D4 */
	if (led_object[2].state == FALSE)
	{
		p7_2 = 1;
	}
	else
	{
		p7_2 = 0;
	}
#endif /* LED_MAX */
}

/*
 * LED
 * A_
 */
void led_on(uint8 led_no)
{
	if (led_no < LED_MAX)
	{
		/* Vbg쒆łȂ */
		led_object[led_no].oneshot = FALSE;

		/* ݂ł */
		if (led_object[led_no].state == FALSE)
		{
			/* _ */
			led_object[led_no].state = TRUE;

			/* Zbg */
			led_set();
		}
	}
}


/*
 * LED
 * A
 */
void led_off(uint8 led_no)
{
	if (led_no < LED_MAX)
	{
		/* Vbg쒆łȂ */
		led_object[led_no].oneshot = FALSE;

		/* ݂_ł */
		if (led_object[led_no].state == TRUE)
		{
			/*  */
			led_object[led_no].state = FALSE;

			/* Zbg */
			led_set();
		}
	}
}

/*
 * LED
 * Vbg_
 */
void led_oneshot(uint8 led_no, uint16 ms)
{
	if (led_no < LED_MAX)
	{
		/* Vbg쒆łȂꍇ */
		if (led_object[led_no].oneshot == FALSE)
		{
			/* Vbg */
			led_object[led_no].oneshot = TRUE;

			/* ݂̃t[^C} */
			led_object[led_no].freerun = timer_freerun();

			/* z[h */
			led_object[led_no].hold = ms;

			/* _ */
			led_object[led_no].state = TRUE;

			/* Zbg */
			led_set();
		}
	}
}

/*
 * LED
 * ^XN
 */
void led_task(void)
{
	uint8 loop;
	uint16 diff;

	/* LED[v */
	for (loop=0; loop<_countof(led_object); loop++)
	{
		/* Vbg쒆̏ꍇ */
		if (led_object[loop].oneshot == TRUE)
		{
			/* ԍ𓾂 */
			diff = (uint16)(timer_freerun() - led_object[loop].freerun);

			/* diffholdȏł΃VbgXgbvď */
			if (diff >= led_object[loop].hold)
			{
				/* Vbg~ */
				led_object[loop].oneshot = FALSE;

				/*  */
				led_object[loop].state = FALSE;

				/* Zbg */
				led_set();
			}
		}
	}
}
