/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ CANIy[V ]
 */

#include "common.h"
#include "target.h"
#include "debug.h"
#include "timer.h"
#include "led.h"
#include "sw.h"
#include "log.h"
#include "can.h"
#include "canop.h"

/*
 * CANIy[V
 * [h؂ւSW
 */
#define CANOP_SW_MODE				(0)
										/* [h؂ւXCb` */

/*
 * CANIy[V
 * LED
 */
#define CANOP_LED_MODE				(7)
										/* LED */

/*
 * CANIy[V
 * [NGA
 */
static uint8 canop_mode;
										/* 샂[h */
static BOOL canop_sw;
										/* XCb` */
static uint16 canop_freerun;
										/* t[^C} */
static uint16 canop_id;
										/* MID */
static BOOL canop_led;
										/* LED */

/*
 * CANIy[V
 * 
 */
void canop_init(void)
{
	/* 샂[h(~) */
	canop_mode = CANOP_MODE_NONE;

	/* SW */
	canop_sw = sw_get(CANOP_SW_MODE);

	/* t[^C} */
	canop_freerun = timer_freerun();

	/* MID */
	canop_id = 0;

	/* LED */
	canop_led = FALSE;
}

/*
 * CANIy[V
 * ^XN(MTu)
 */
static void canop_interval_send(void)
{
	can_pdu NEAR *pdu;
	uint8 data;
	uint8 loop;

	/* PDU擾 */
	pdu = can_tx_get();

	/* PDU擾ł */
	if (pdu != NULL)
	{
		/* ID */
		pdu->sid = canop_id;

		/* DLC */
		pdu->dlc = (uint8)(((canop_id >> 4) & 0x0007) + 1);
		ASSERT((pdu->dlc >= 1) && (pdu->dlc <= 8));

		/* DATA */
		data = (uint8)(canop_id >> 4);
		for (loop=0; loop<pdu->dlc; loop++)
		{
			pdu->data[loop] = data++;
		}

		/* MNGXg */
		can_tx_req(pdu);

		/* ID֐i߂ */
		canop_id = (uint16)((canop_id  + 0x10) & 0x7f0); 
	}
}

/*
 * CANIy[V
 * ^XN(M[h)
 */
static void canop_interval(void)
{
	uint16 diff;

	/* t[^C}𓾂 */
	diff = timer_freerun() - canop_freerun;

	/* ΑM */
	if (diff >= 1000)
	{
		/* oXItԂłȂ */
		if (can_is_busoff() == FALSE)
		{
			/* M */
			canop_interval_send();
		}

		/* LED_ */
		if (canop_led == FALSE)
		{
			/* OFF->ON */
			led_on(CANOP_LED_MODE);
			canop_led = TRUE;
		}
		else
		{
			/* ON->OFF */
			led_off(CANOP_LED_MODE);
			canop_led = FALSE;
		}

		/* ԂZ */
		canop_freerun += 1000;
	}
}

/*
 * CANIy[V
 * ^XN(ԐM[h)
 */
static void canop_reply(void)
{
	can_pdu NEAR *pdu_rx;
	can_pdu NEAR *pdu_tx;
	uint8 loop;

	/* MPDU擾 */
	pdu_rx = can_rx_get();

	/* MPDU */
	while (pdu_rx != NULL)
	{
		/* MPDU擾 */
		pdu_tx = can_tx_get();

		/* ID */
		pdu_tx->sid = (uint16)(pdu_rx->sid ^ 0x0001);

		/* DLC */
		pdu_tx->dlc = pdu_rx->dlc;

		/* DATA */
		for (loop=0; loop<pdu_tx->dlc; loop++)
		{
			pdu_tx->data[loop] = pdu_rx->data[loop];
		}

		/* MNGXg */
		can_tx_req(pdu_tx);

		/* Mf[^p */
		can_rx_free(pdu_rx);

		/* ̎MPDU擾 */
		pdu_rx = can_rx_get();
	}
}

/*
 * CANIy[V
 * [hJ
 */
static void canop_task_mode(uint8 mode)
{
	/* CANX[v */
	if (canop_mode != CANOP_MODE_NONE)
	{
		can_sleep();
	}

	/* [hJ */
	canop_mode = mode;

	/* t[^C} */
	canop_freerun = timer_freerun();

	/* MID */
	canop_id = 0;

	/* LED */
	if (canop_mode == CANOP_MODE_NONE)
	{
		/* ~[ĥƂ́ALED */
		canop_led = FALSE;
		led_off(CANOP_LED_MODE);
	}
	else
	{
		/* ȊÓALED_ */
		canop_led = TRUE;
		led_on(CANOP_LED_MODE);
	}

	/* CAN */
	if (canop_mode != CANOP_MODE_NONE)
	{
		can_init(CAN_TEST_NORMAL);
	}
}

/*
 * CANIy[V
 * SW^XN
 */ 
static void canop_task_sw(void)
{
	BOOL sw;
	uint8 mode;

	/* SWxɃ[h؂ւ */
	sw = sw_get(CANOP_SW_MODE);

	/* 0->1̑Jڂ̂ݐ؂ւ */
	if ((canop_sw == FALSE) && (sw == TRUE))
	{
		/* SWꂽBJڐ̃[h */
		mode = (uint8)(canop_mode + 1);
		if (mode >= CANOP_MODE_MAX)
		{
			/* ԐM[h̎́A~[hɑJ */
			mode = CANOP_MODE_NONE;
		}

		/* [hJ */
		canop_task_mode(mode);
	}

	/* ݂SWL */
	canop_sw = sw;
}

/*
 * CANIy[V
 * M^XN
 */
static void canop_task_recv(void)
{
	can_pdu NEAR *pdu;

	/* REPLYȊOłΎM݂ */
	if (canop_mode != CANOP_MODE_REPLY)
	{
		/* MPDU擾 */
		pdu = can_rx_get();

		/* MPDU */
		while (pdu != NULL)
		{
			/* ǂݎ̂Ă */
			can_rx_free(pdu);

			/* ̎MPDU擾 */
			pdu = can_rx_get();
		}
	}
}

/*
 * CANIy[V
 * ^XN
 */
void canop_task(void)
{
	/* 샂[h */
	switch (canop_mode)
	{
		/* ~[h */
		case CANOP_MODE_NONE:
			break;

		/* M[h */
		case CANOP_MODE_INTERVAL:
			canop_interval();
			break;

		/* ԐM[h */
		case CANOP_MODE_REPLY:
			canop_reply();
			break;

		/* ɗ邱Ƃ͂Ȃ */
		default:
			ASSERT(FALSE);
			break;
	}

	/* SW^XN */
	canop_task_sw();

	/* M^XN */
	canop_task_recv();
}
