/*
nullptr Interpreter.
(C) 2015 VOSystems.
*/

#pragma once

#include<vector>
#include<string>
#include<regex>
#include<fstream>
#include"nullptr.h"

namespace VOSystemsNullptr
{
	namespace Core
	{
		class Interpreter : System::StringModule
		{
		private:
			std::vector<BasicTypes::IntManager> m_int;//IntϐXg
			std::vector<BasicTypes::String> m_string;//StringϐXg
			std::vector<BasicTypes::Bool> m_bool;//boolϐXg
			System::IdentifierList m_list;//ʎqXg

			std::string m_workline;//s̓e(Z~R̎Z~R܂)

			std::streamoff m_eip;//x86EIPƓA߃|C^
			std::string m_src;//\[Xt@C

			void LineLoad(void);//sǂݍ
			void Extract(void);//vvZbT[AWJ
			void Trim(void);//vvZbT[A

			
			std::string m_stdout,m_stdin,m_stderr;//Wo͌n̖O

			
			void Screen(std::string line);//x[VbNW[->Wo
			void Keyboard(std::string line);//x[VbNW[->W
			void EScreen(std::string line);//x[VbNW[WG[o

			bool NewInt(std::string name, BasicTypes::Int value);//Intϐ쐬
			bool AssignInt(std::string name, BasicTypes::Int value);//Intϐ
			bool GetInt(std::string name, BasicTypes::Int& target);//IntϐAl擾

			bool NewStr(std::string name, std::string value);//Stringϐ쐬
			bool AssignStr(std::string name, std::string value);//Stringϐ
			bool GetStr(std::string name, std::string& target);//StringϐAl擾

			bool NewVar(std::string line);//ϐ쐬

			bool If(std::string line);
			bool For(std::string line);
			bool While(std::string line);
			bool Loop(std::string line);
			bool Switch(std::string line);
			bool Goto(std::string line);
			bool GetBool(std::string judge);

			std::vector<std::string> Lex(std::string formula);
			std::vector<std::string> ReplaceVar2Num(std::vector<std::string> formula);
			BasicTypes::Int Calc(std::vector<std::string> lex);
			std::vector<std::string> ProcBrackets(std::vector<std::string> lex);
			std::string CalcBracket(std::string inBracket);
			/*o[W*/
			unsigned int 
				m_major=0,
				m_minor=0,
				m_build=12,
				m_revision=30;


		public:
			Nullptr(std::string file);
			~Nullptr(void);

			void Work(void);
		};
	}
}