/*
*Multi Task Common Header
*(C) 2014 VOSystems.
*/

#ifndef _TASK_H_VANE_
#define _TASK_H_VANE_

#include<Message.h>
#include<GDT_IDT.h>

#define MAX_TASKS		1000
#define TASK_GDT0		3
#define MAX_TASKS_LV	100
#define MAX_TASKLEVELS	10
#define ADR_GDT			0x00270000
#define AR_TSS32		0x0089
#define AR_LDT			0x0082

struct TSS32 {
	int backlink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
	int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
	int es, cs, ss, ds, fs, gs;
	int ldtr, iomap;
};

struct TASK {
	int sel, flags;
	int level, priority;
	struct msg_data fifo;
	struct TSS32 tss;
	SEGMENT_DESCRIPTOR ldt[2];
	struct CONSOLE *cons;
	int ds_base, cons_stack;
	//struct FILEHANDLE *fhandle;
	int *fat;
	char *cmdline;
	unsigned char langmode, langbyte1;
};

struct TASKLEVEL {
	int running;
	int now;
	struct TASK *tasks[MAX_TASKS_LV];
};

struct TASKCTL {
	int now_lv;
	char lv_change;
	struct TASKLEVEL level[MAX_TASKLEVELS];
	struct TASK tasks0[MAX_TASKS];
};
#endif
