#ifndef MULTIBOOT_HEADER
#define MULTIBOOT_HEADER 1
     
#define MULTIBOOT_SEARCH                        8192     
#define MULTIBOOT_HEADER_MAGIC                  0x1BADB002     
#define MULTIBOOT_BOOTLOADER_MAGIC              0x2BADB002     
#define MULTIBOOT_UNSUPPORTED                   0x0000fffc     
#define MULTIBOOT_MOD_ALIGN                     0x00001000     
#define MULTIBOOT_INFO_ALIGN                    0x00000004     
#define MULTIBOOT_PAGE_ALIGN                    0x00000001     
#define MULTIBOOT_MEMORY_INFO                   0x00000002     
#define MULTIBOOT_VIDEO_MODE                    0x00000004     
#define MULTIBOOT_AOUT_KLUDGE                   0x00010000
#define MULTIBOOT_INFO_MEMORY                   0x00000001
#define MULTIBOOT_INFO_BOOTDEV                  0x00000002
#define MULTIBOOT_INFO_CMDLINE                  0x00000004
#define MULTIBOOT_INFO_MODS                     0x00000008
#define MULTIBOOT_INFO_AOUT_SYMS                0x00000010
#define MULTIBOOT_INFO_ELF_SHDR                 0X00000020  
#define MULTIBOOT_INFO_MEM_MAP                  0x00000040
#define MULTIBOOT_INFO_DRIVE_INFO               0x00000080
#define MULTIBOOT_INFO_CONFIG_TABLE             0x00000100 
#define MULTIBOOT_INFO_BOOT_LOADER_NAME         0x00000200
#define MULTIBOOT_INFO_APM_TABLE                0x00000400
#define MULTIBOOT_INFO_VIDEO_INFO               0x00000800
  
#ifndef ASM_FILE
     
#define MULTIBOOT_HEADER_MAGIC          0x1BADB002
#define MULTIBOOT_HEADER_FLAGS          0x00000000
#define MULTIBOOT_HEADER_CHECKSUM       -(MULTIBOOT_HEADER_MAGIC+MULTIBOOT_HEADER_FLAGS)
#define KERNEL_STACK_SIZE               0x100000

#define MULTIBOOT_BOOTLOADER_MAGIC      0x2BADB002


typedef struct mbi_info {
  unsigned long flags;
  unsigned long mem_lower;
  unsigned long mem_upper;
  unsigned long boot_device;
  unsigned long cmdline;
  unsigned long mods_count;
  unsigned long mods_addr;

  // The section header table for ELF
  unsigned long num;
  unsigned long size;
  unsigned long addr;
  unsigned long shndx;

  unsigned long mmap_length;
  unsigned long mmap_addr;
} __attribute__((__packed__)) mbi_t;

// The memory map
typedef struct memory_map {
  unsigned long size;
  unsigned long base_addr_low;
  unsigned long base_addr_high;
  unsigned long length_low;
  unsigned long length_high;
  unsigned long type;
} __attribute__((__packed__)) memory_map;
     
#endif /* ! ASM_FILE */
     
#endif /* ! MULTIBOOT_HEADER */

