#ifndef _COMP_LZ_H_
#define _COMP_LZ_H_

#include<stdlib.h>
#include<string.h>
#include"comp.h"

#define COMP_LZ_RING_BUF_SIZE 4096
#define COMP_LZ_MATCH_LENGTH_MAX 18

typedef struct comp_lz COMP_lz;
struct comp_lz {
    int slide_dic_tree_parent[COMP_LZ_RING_BUF_SIZE + 1];
    int slide_dic_tree_left[COMP_LZ_RING_BUF_SIZE + 1];
    int slide_dic_tree_right[COMP_LZ_RING_BUF_SIZE + 257];
	int slide_dic_match_len;
	int slide_dic_match_pos;
	unsigned char slide_dic_text[COMP_LZ_RING_BUF_SIZE + COMP_LZ_MATCH_LENGTH_MAX - 1];
	unsigned char inbuf[COMP_INBUF_SIZE];
    size_t inbuf_data_size;
    size_t inbuf_byte_pos;
    size_t inbuf_bit_space;
    unsigned char outbuf[COMP_OUTBUF_SIZE];
    size_t outbuf_data_size;
    size_t outbuf_byte_pos;
    size_t outbuf_bit_space;
};

extern COMP_result COMP_createLz(COMP_lz **lz);
extern void COMP_disposeLz(COMP_lz *lz);
extern COMP_result COMP_encodeLzSlideDic(COMP_lz *lz);
extern COMP_result COMP_decodeLzSlideDic(COMP_lz *lz);

#endif /* _COMP_LZ_H_ */
