/*
 * Copyright (C) 2014 kgto.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
/*
 * $Id: SearchDataRW.java 74 2014-08-12 08:31:08Z tuna_p $
 */

package Form;

import WebScraping.SearchData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 *
 * @author kgto
 */
public class SearchDataRW {
    
    private final String splitchar = "\t";
    
    private String UrlAdress;
    private ArrayList slist;
    
    public void seturl(String UrlAdress) {
        this.UrlAdress = UrlAdress;
    }
    
    public void setslist(ArrayList slist) {
        this.slist = slist;
    }
    
    public String geturl() {
        return UrlAdress;
    }
    
    public ArrayList getslist() {
        return slist;
    }
    
    /**
     * 保存.
     * @param file 
     */
    public void save(File file) {
        //saveCsv(file);
        saveXml(file);
    }
    
    /**
     * 読込.
     * @param file 
     */
    public void load(File file) {
        //loadCsv(file);
        loadXml(file);
    }
    
    /**
     * 保存(CSV形式).
     * @param file 
     */
    public void saveCsv(File file) {
        
        try {
            //空のファイルを作成
            file.createNewFile();
            
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            OutputStreamWriter outputstreamwriter = new OutputStreamWriter(fileoutputstream, "UTF-8");
            BufferedWriter bufferedwriter = new BufferedWriter(outputstreamwriter);
            
            // ＵＲＬ
            bufferedwriter.write(UrlAdress);
            bufferedwriter.write("\n");
            // 検索情報
            for (Object slist1 : slist) {
                SearchData sdat = (SearchData) slist1;
                StringBuilder str = new StringBuilder();
                str.append(sdat.getitem()).append(splitchar);
                str.append(sdat.getHtmltag()).append(splitchar);
                str.append(sdat.getHtmlid()).append(splitchar);
                str.append(sdat.getHtmlclass()).append(splitchar);
                str.append(sdat.getaround()).append(splitchar);
                str.append(sdat.getregexp()).append("\n");

                bufferedwriter.write(str.toString());
            }
            bufferedwriter.close();
            
        } catch(IOException e) {
            System.out.println(e);
        }
    }
    
    /**
     * 読込(CSV形式).
     * @param file 
     */
    public void loadCsv(File file) {
        slist = new ArrayList();
        
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            InputStreamReader inputstreamreader = new InputStreamReader(fileinputstream, "UTF-8");
            BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
            
            String rec;
            
            // ＵＲＬ
            UrlAdress = bufferedreader.readLine();
            // 検索情報
            while((rec = bufferedreader.readLine()) != null) {
                String[] recary = rec.split(splitchar, -1);
                SearchData sdat = new SearchData();
                sdat.setitem(recary[0]);
                sdat.setHtmltag(recary[1]);                
                sdat.setHtmlid(recary[2]);
                sdat.setHtmlclass(recary[3]);
                sdat.setaround(recary[4]);
                sdat.setregexp(recary[5]);
                
                slist.add(sdat);
            }
            bufferedreader.close();
            
        } catch(IOException e) {
            System.out.println(e);
        }
        
    }
    
    /**
     * 保存(XML形式).
     * @param file 
     */
    public void saveXml(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            
            Document document = domImpl.createDocument("","searchdata",null);
            Element root = document.getDocumentElement();
            
            // ＵＲＬ
            Element url = document.createElement("url");
            url.appendChild(document.createTextNode(UrlAdress));
            root.appendChild(url);
            
            // 検索情報
            for (Object slist1 : slist) {
                SearchData sdat = (SearchData) slist1;
                
                Element cslist    = document.createElement("searchlist");
                Element item      = document.createElement("item");
                Element htmltag   = document.createElement("htmltag");
                Element htmlid    = document.createElement("htmlid");
                Element htmlclass = document.createElement("htmlclass");
                Element around    = document.createElement("around");
                Element regexp    = document.createElement("regexp");
                
                item.appendChild(document.createTextNode(sdat.getitem()));
                htmltag.appendChild(document.createTextNode(sdat.getHtmltag()));
                htmlid.appendChild(document.createTextNode(sdat.getHtmlid()));
                htmlclass.appendChild(document.createTextNode(sdat.getHtmlclass()));
                around.appendChild(document.createTextNode(sdat.getaround()));
                regexp.appendChild(document.createTextNode(sdat.getregexp()));
                
                cslist.appendChild(item);
                cslist.appendChild(htmltag);
                cslist.appendChild(htmlid);
                cslist.appendChild(htmlclass);
                cslist.appendChild(around);
                cslist.appendChild(regexp);

                root.appendChild(cslist);
            }
            // 出力
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            
            DOMSource source = new DOMSource(document);
            FileOutputStream os = new FileOutputStream(file);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            
        } catch (ParserConfigurationException | FileNotFoundException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        } catch (TransformerConfigurationException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        } catch (TransformerException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    /**
     * 読込(XML形式).
     * @param file 
     */
    public void loadXml(File file) {
        slist = new ArrayList();
        
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            
            // ルート要素の取得
            Element root = doc.getDocumentElement();
            
            // ＵＲＬ
            NodeList url = root.getElementsByTagName("url");
            Node urlnode = url.item(0);
            UrlAdress = urlnode.getFirstChild().getNodeValue();
            
            // 検索情報
            NodeList cslist = root.getElementsByTagName("searchlist");
            for(int i = 0; i < cslist.getLength(); i++) {
                SearchData sdat = new SearchData();
                
                Node slistnode = cslist.item(i);
                Node child;
                for (child = slistnode.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if(child.getNodeType() == Node.ELEMENT_NODE) {
                        String tag = child.getNodeName();
                        
                        String rtn = "";
                        if(child.getFirstChild() != null) {
                            rtn = child.getFirstChild().getNodeValue();
                        }
                        
                        switch (tag) {
                            case "item":
                                sdat.setitem(rtn);
                                break;
                            case "htmltag":
                                sdat.setHtmltag(rtn);
                                break;
                            case "htmlid":
                                sdat.setHtmlid(rtn);
                                break;
                            case "htmlclass":
                                sdat.setHtmlclass(rtn);
                                break;
                            case "around":
                                sdat.setaround(rtn);
                                break;
                            case "regexp":
                                sdat.setregexp(rtn);
                                break;
                        }
                    }
                }
                slist.add(sdat);
            }
            
        } catch (ParserConfigurationException | SAXException | IOException ex) {
            Logger.getLogger(SearchDataRW.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
}
