/*
 * Copyright (C) 2014 kgto.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
/*
 * $Id: SearchDataRW.java 54 2014-07-11 07:44:52Z tuna_p $
 */

package Form;

import Lib.SearchData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

/**
 *
 * @author kgto
 */
public class SearchDataRW {
    
    private final String splitchar = "\t";
    
    private String UrlAdress;
    private ArrayList slist;
    
    public void seturl(String UrlAdress) {
        this.UrlAdress = UrlAdress;
    }
    
    public void setslist(ArrayList slist) {
        this.slist = slist;
    }
    
    public String geturl() {
        return UrlAdress;
    }
    
    public ArrayList getslist() {
        return slist;
    }
    
    /**
     * 保存
     * @param file 
     */
    public void save(File file) {
        
        try {
            //空のファイルを作成
            file.createNewFile();
            
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            OutputStreamWriter outputstreamwriter = new OutputStreamWriter(fileoutputstream, "UTF-8");
            BufferedWriter bufferedwriter = new BufferedWriter(outputstreamwriter);
            
            // ＵＲＬ
            bufferedwriter.write(UrlAdress);
            bufferedwriter.write("\n");
            // 検索情報
            for (Object slist1 : slist) {
                SearchData sdat = (SearchData) slist1;
                StringBuilder str = new StringBuilder();
                str.append(sdat.getitem()).append(splitchar);
                str.append(sdat.getHtmltag()).append(splitchar);
                str.append(sdat.getHtmlid()).append(splitchar);
                str.append(sdat.getHtmlclass()).append(splitchar);
                str.append(sdat.getaround()).append(splitchar);
                str.append(sdat.getregexp()).append("\n");

                bufferedwriter.write(str.toString());
            }
            bufferedwriter.close();
            
        } catch(IOException e) {
            System.out.println(e);
        }
    }
    
    /**
     * 読込
     * @param file 
     */
    public void load(File file) {
        slist = new ArrayList();
        
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            InputStreamReader inputstreamreader = new InputStreamReader(fileinputstream, "UTF-8");
            BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
            
            String rec;
            
            // ＵＲＬ
            UrlAdress = bufferedreader.readLine();
            // 検索情報
            while((rec = bufferedreader.readLine()) != null) {
                String[] recary = rec.split(splitchar, -1);
                SearchData sdat = new SearchData();
                sdat.setitem(recary[0]);
                sdat.setHtmltag(recary[1]);                
                sdat.setHtmlid(recary[2]);
                sdat.setHtmlclass(recary[3]);
                sdat.setaround(recary[4]);
                sdat.setregexp(recary[5]);
                
                slist.add(sdat);
            }
            bufferedreader.close();
            
        } catch(IOException e) {
            System.out.println(e);
        }
        
    }
    
}
