/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package sample01;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SampleTableCellRenderer02 extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -4100672856859272722L;
    int row;
    int column;
    Color color;

    SampleTableCellRenderer02() {
        super();
    }
    
    void setColor(int row, int column, Color color) {
        this.row = row;
        this.column = column;
        this.color = color;
        repaint();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        /*
         * どういう呼ばれ方をしてるのか確認するための出力文
         *   目に見えるセルだけ毎度、描画しているらしい
         *   スクロールさせると、それがわかる
         */
        System.out.println("row:" + row + " /column:" + column + " /selected:" + isSelected + " /focus:" + hasFocus + " /value:" + value);
	
        // 選択されている行を赤色にする
        if (isSelected) {
            this.setBackground(Color.RED);
        } else {
            this.setBackground(table.getBackground());
        }

	// フォーカスが当たっているセルを黄色にする
        if (hasFocus) {
            this.setBackground(Color.yellow);
        }

	// 行番号=1/列番号=1のセルを青色にする
        if ((this.row == row) && (this.column == column)) {
            this.setBackground(this.color);
        } else {
            this.setBackground(table.getBackground());
        }
        return this;
    }
}
