using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Eyes.Properties;

namespace Eyes
{
    public delegate void ConfiguredHandler(bool restart);

    public partial class Configure : Form
    {
        public event ConfiguredHandler configured;

        private bool changed = false;
        private bool adapter_changed = false;

        private bool Changed
        {
            get { return changed; }
            set
            {
                changed = value;
                this.buttonApply.Enabled = changed;
            }
        }

        public Configure()
        {
            InitializeComponent();

            textNickName.Text = Settings.Default.NickName;
            textPortNumber.Text = Settings.Default.PortNumber.ToString();
            textBalloon.Text = Settings.Default.Balloon.ToString();
            checkOnline.Checked = Settings.Default.Notify;

            List<NetInfo> infos = NetAdapter.GetNetInfo();
            foreach (NetInfo info in infos){
                comboBoxAdapter.Items.Add(info.Name);
            }
            comboBoxAdapter.SelectedIndex = NetAdapter.GetSelectedIndex(infos);
            Changed = false;
            adapter_changed = false;
        }

        private void save()
        {
            if (Changed)
            {
                Settings.Default.NickName = textNickName.Text;
                Settings.Default.PortNumber = Int32.Parse(textPortNumber.Text);
                Settings.Default.Balloon = Int32.Parse(textBalloon.Text);

                Object selectedItem = comboBoxAdapter.SelectedItem;
                Settings.Default.Adapter = selectedItem.ToString();

                Settings.Default.Save();

                if (configured != null)
                    configured(adapter_changed);

                Changed = false;
                adapter_changed = false;
            }
        }

        private void buttonSave_Click(object sender, EventArgs e)
        {
            save();
            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void buttonApply_Click(object sender, EventArgs e)
        {
            save();
        }

        private void nickName_TextChanged(object sender, EventArgs e)
        {
            Changed = true;
        }

        // |[gԍ͐̂ݓ͉
        private void portNumber_KeyPress(object sender, KeyPressEventArgs e)
        {
            if ((e.KeyChar < '0' || e.KeyChar > '9') && e.KeyChar != '\b')
                e.Handled = true;

            Changed = true;
        }

        private void comboBoxAdapter_SelectedIndexChanged_1(object sender, EventArgs e)
        {
            adapter_changed = true;
            Changed = true;
        }

        private void textBalloon_KeyPress(object sender, KeyPressEventArgs e)
        {
            if ((e.KeyChar < '0' || e.KeyChar > '9') && e.KeyChar != '\b')
                e.Handled = true;

            Changed = true;
        }

        private void checkOnline_CheckedChanged(object sender, EventArgs e)
        {
            Settings.Default.Notify = checkOnline.Checked;
            Changed = true;
        }
    }
}
