<?php
/*
  $Id: contact_us.php,v 1.8 2009/04/14 23:51:23 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_CONTACT_BY_EMAIL") && (KN_CFG_CONTACT_BY_EMAIL == 'false')) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CONTACT_US);

  $error = false;
  $error = "";
  if (isset($_GET['action']) && ($_GET['action'] == 'confirm')) {
    if (!isset($_POST['name']) || ($_POST['name'] == '')) {
      $error = true;
      $error_msg .= ENTRY_NAME_CHECK_ERROR . "<br />";
    }
    if (!tep_validate_email(trim($_POST['email']))) {
      $error = true;
      $error_msg .= ENTRY_EMAIL_CHECK_ERROR . "<br />";
    }
  }  elseif (isset($_GET['action']) && ($_GET['action'] == 'send')) {
    if (($_POST['edit_x']) || ($_POST['edit_y'])) {
      $_GET['action'] = 'back';
    } else {
      if (isset($_POST['check']) && ($_POST['check'] == STORE_OWNER)) {
    	    $mail_contents = ENTRY_NAME . $_POST['name'] . "\n" . ENTRY_EMAIL . $_POST['email'] . "\n" . 
    	                          ENTRY_ENQUIRY . "\n" . $_POST['enquiry'];
        tep_mail(STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS, EMAIL_SUBJECT, $mail_contents, $_POST['name'], $_POST['email']);
        tep_redirect(tep_href_link(FILENAME_CONTACT_US, 'action=success'));
      } else {
        $error = true;
        $error_msg .= ENTRY_EMAIL_SEND_ERROR;
      }
    }
  }

  if ($error) {
    $_GET['action'] = 'error';
  }

  $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_CONTACT_US));
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<?php 
  $customCSS = substr(FILENAME_CONTACT_US, 0, strrpos(FILENAME_CONTACT_US, '.')). ".css";
  if (file_exists($customCSS)){
    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"$customCSS\" media=\"screen,print\" />";
  }
?>
</head>
<body>
<div id="container">
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<div id="mainContents">
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<div id="contactUs">
<?php
  if (isset($_GET['action']) && ($_GET['action'] == 'success')) {
    // OK
?>
<p class="successText"><?php echo TEXT_SUCCESS; ?></p>
<div class="buttonLine">
<p class="buttonRight"><a href="<?php echo tep_href_link(FILENAME_DEFAULT); ?>"><?php echo tep_image_button('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></a></p>
</div>
<?php
  } elseif (isset($_GET['action']) && ($_GET['action'] == 'confirm')) {
    // Ƴǧ
    echo tep_draw_form('contact_us', tep_href_link(FILENAME_CONTACT_US, 'action=send')) . tep_draw_hidden_field('check', STORE_OWNER) . "\n";
?>
<table>
<tr>
<th><?php echo ENTRY_NAME; ?></th>
<td><?php echo $_POST['name'] . tep_draw_hidden_field('name', $_POST['name']); ?></td>
</tr>
<tr>
<th><?php echo ENTRY_EMAIL; ?></th>
<td><?php echo $_POST['email'] . tep_draw_hidden_field('email', $_POST['email']); ?></td>
</tr>
<tr>
<th><?php echo ENTRY_ENQUIRY; ?></th>
<td><?php echo nl2br(htmlspecialchars($_POST['enquiry'])) . tep_draw_hidden_field('enquiry', $_POST['enquiry']); ?></td>
</tr>
</table>

<div class="buttonLine">
<p class="buttonLeft"><?php echo tep_image_submit('button_back.gif', IMAGE_BUTTON_BACK, 'name="edit"'); ?></p>
<p class="buttonRight"><?php echo tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></p>
</div>
</form>
<?php
  } else {
    // 
    if ($_GET['action'] == 'error') {
      echo '<p class="entryError">';
      echo $error_msg;
      echo "</p>\n";
    }
    echo tep_draw_form('contact_us', tep_href_link(FILENAME_CONTACT_US, 'action=confirm')) . "\n";
?>
<table>
<tr>
<th><?php echo ENTRY_NAME; ?></th>
<td><?php echo tep_draw_input_field('name', ($_POST['name'] ? $_POST['name'] : (($language == 'japanese') ? ($last_name . ' ' . $first_name) : ($first_name . ' ' . $last_name)))); ?></td>
</tr>
<tr>
<th><?php echo ENTRY_EMAIL; ?></th>
<td><?php echo tep_draw_input_field('email', ($_POST['email'] ? $_POST['email'] : $email_address)); ?></td>
</tr>
<tr>
<th><?php echo ENTRY_ENQUIRY; ?></th>
<td><?php echo tep_draw_textarea_field('enquiry', 'soft', 50, 15, $_POST['enquiry']); ?></td>
</tr>
</table>

<div class="buttonLine">
<p class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_DEFAULT) . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></p>
<p class="buttonRight"><?php echo tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></p>
</div>
</form>
<?php
  }
?>
</div>
</div>
<!-- /main_contents -->
</div>
<!-- /contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
