/*
 * ALPHAPROJECT AP-SH4A-0A support.
 *
 * Copyright (C) 2010  Sakae OTAKI<sakae_ohtaki@yokogawa-digital.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/io.h>
#include <linux/mtd/physmap.h>
#include <linux/delay.h>
#include <linux/i2c.h>
#include <linux/i2c-pca-platform.h>
#include <linux/i2c-algo-pca.h>
#include <linux/irq.h>
#include <linux/clk.h>
#include <asm/machvec.h>
#include <asm/sizes.h>
#include <asm/clock.h>
#include <asm/heartbeat.h>

#define NOR_FLASH_ADDR	0xA0000000
#define NOR_FLASH_SIZE	0x00800000

/*
 * Heartbeat LED
 */
//static struct resource heartbeat_resources[] = {
//	[0] = {
//		.start	= PLD_LEDCR,
//		.end	= PLD_LEDCR,
//		.flags	= IORESOURCE_MEM,
//	},
//};
//
//static struct heartbeat_data heartbeat_data = {
//	.regsize = 8,
//};
//
//static struct platform_device heartbeat_device = {
//	.name		= "heartbeat",
//	.id		= -1,
//	.dev	= {
//		.platform_data	= &heartbeat_data,
//	},
//	.num_resources	= ARRAY_SIZE(heartbeat_resources),
//	.resource	= heartbeat_resources,
//};

static struct mtd_partition nor_flash_partitions[] = {
	{
		.name		= "loader",
		.offset		= 0x00000000,
		.size		= 128 * 1024,
	},
	{
		.name		= "loader.env",
		.offset		= MTDPART_OFS_APPEND,
		.size		= 128 * 1024,
	},
	{
		.name		= "kernel",
		.offset		= MTDPART_OFS_APPEND,
		.size		= 2 * 1024 * 1024,
	},
	{
		.name		= "rootfs",
		.offset		= MTDPART_OFS_APPEND,
		.size		= MTDPART_SIZ_FULL,
	},
};

static struct physmap_flash_data nor_flash_data = {
	.width		= 4,
	.parts		= nor_flash_partitions,
	.nr_parts	= ARRAY_SIZE(nor_flash_partitions),
};

static struct resource nor_flash_resources[] = {
	[0]	= {
		.start	= NOR_FLASH_ADDR,
		.end	= NOR_FLASH_ADDR + NOR_FLASH_SIZE - 1,
		.flags	= IORESOURCE_MEM,
	}
};

static struct platform_device nor_flash_device = {
	.name		= "physmap-flash",
	.dev		= {
		.platform_data	= &nor_flash_data,
	},
	.num_resources	= ARRAY_SIZE(nor_flash_resources),
	.resource	= nor_flash_resources,
};

static struct platform_device *apsh4a0a_devices[] __initdata = {
	//&heartbeat_device,
	&nor_flash_device,
};

static int __init apsh4a0a_devices_setup(void)
{
	return platform_add_devices(apsh4a0a_devices,
				    ARRAY_SIZE(apsh4a0a_devices));
}
__initcall(apsh4a0a_devices_setup);

/* Initialize IRQ setting */
void __init init_apsh4a0a_IRQ(void)
{
	plat_irq_setup_pins(IRQ_MODE_IRL3210_MASK);
}

/* Initialize the board */
static void __init apsh4a0a_setup(char **cmdline_p)
{
	printk(KERN_INFO "Alpha Project AP-SH4A-0A support:\n");

	/* System FPGA configuration */
		// May be coded here.
}

/*
 * The Machine Vector
 */
static struct sh_machine_vector mv_apsh4a0a __initmv = {
	.mv_name		= "AP-SH4A-0A",
	.mv_setup		= apsh4a0a_setup,
	.mv_init_irq		= init_apsh4a0a_IRQ,
};

