(ns examples.test)

(+ 2 3)
(+ 3 5)
(println "hello, World")
(* 2 3)

(defn blank? [str]
  (every? #(Character/isWhitespace %) str))

(blank? "   \n\t\r ")

(defn hello
  "Writes hello message to *out*. Calls you by username"
  [username]
  (println (str "Hello, " username)))

(hello "Takashi")

(def visitors (atom #{}))

(defn hello
  "Writes hello message to *out*. Calls you by username.
  Knows if you have been here before."
  [username]
  (swap! visitors conj username)
  (str "Hello, " username))

(hello "Stu")
(hello "Takashi")

[visitors]
