package mirrg.simulation.cart.almandine.gui.toolcursor;

import static mirrg.swing.helium.GroupBuilder.*;

import java.awt.event.KeyEvent;
import java.util.Optional;

import javax.swing.JButton;

import mirrg.swing.helium.GroupBuilder;

public class TabItem
{

	private String localizedName;
	private Optional<ShortcutKey> optionalShortcutKey;
	private Runnable listener;

	/**
	 * @param localizedName
	 * @param shortcutKey
	 *            nullable
	 * @param listener
	 */
	public TabItem(String localizedName, ShortcutKey shortcutKey, Runnable listener)
	{
		this.localizedName = localizedName;
		this.optionalShortcutKey = Optional.ofNullable(shortcutKey);
		this.listener = listener;
	}

	public String getText()
	{
		return localizedName + optionalShortcutKey.map(shortcutKey -> " (" + shortcutKey.getText() + ")").orElse("");
	}

	public JButton createButton()
	{
		JButton button = new JButton(getText());
		button.addActionListener(e -> action());
		return button;
	}

	public GroupBuilder createComponent()
	{
		return group(createButton());
	}

	public void action()
	{
		listener.run();
	}

	public boolean match(KeyEvent keyEvent)
	{
		return optionalShortcutKey.map(shortcutKey -> shortcutKey.match(keyEvent)).orElse(false);
	}

}
