package mirrg.simulation.cart.almandine.gui.toolcursor;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Optional;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;

import wraplayout.WrapLayout;

public class RegistryToolCursor
{

	public static RegistryToolCursor instance = new RegistryToolCursor();

	public ArrayList<ShortcutKey> registryShortcutKey = new ArrayList<>();

	public ArrayList<Tab> tabs = new ArrayList<>();

	public void addTab(Tab tab)
	{
		tabs.add(tab);
	}

	public JComponent createComponent()
	{

		// setting components
		JComponent panel = new JPanel();
		for (int i = 0; i < tabs.size(); i++) {
			panel.add(tabs.get(i).createComponent());
		}

		// setting layout
		FlowLayout layout = new WrapLayout();
		layout.setAlignment(FlowLayout.LEFT);
		panel.setLayout(layout);

		// setting scroll pane
		JScrollPane scrollPane = new JScrollPane(panel,
			ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
			ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		scrollPane.setPreferredSize(new Dimension(400, 400));
		scrollPane.getVerticalScrollBar().setUnitIncrement(10);

		return scrollPane;
	}

	public Optional<TabItem> find(KeyEvent keyEvent)
	{
		for (Tab tab : tabs) {
			TabItem tabItem = tab.find(keyEvent).orElse(null);
			if (tabItem != null) return Optional.of(tabItem);
		}
		return Optional.empty();
	}

}
