package mirrg.simulation.cart.almandine.facroty.property;

import java.util.function.BooleanSupplier;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

import mirrg.swing.helium.GroupBuilder;

public interface IDialogProperty
{

	public void addComponent(GroupBuilder groupBuilder);

	public void addPropertyInt(String name, String unit, IntSupplier getter, IntPredicate setter);

	public void addPropertyDouble(String name, String unit, DoubleSupplier getter, DoublePredicate setter);

	public void addPropertyString(String name, Supplier<String> getter, Predicate<String> setter);

	public void addPropertyBoolean(String name, BooleanSupplier getter, Predicate<Boolean> setter);

	public void dispose();

	public void open();

	public <T> void addPropertyComboBox(String name, Stream<T> items, Supplier<T> getter, Predicate<T> setter);

}
