package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.event.MouseEvent;

import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public class ToolCursorSelect extends ToolCursor
{

	public ToolCursorSelect(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		new ModuleClickEntity<Primary>(frameGameAlmandine,
			button -> button == MouseEvent.BUTTON1 || button == MouseEvent.BUTTON3,
			(e, entity) -> {

				if (e.isControlDown() ^ e.getButton() == MouseEvent.BUTTON3) {
					entity.selected = !entity.selected;
				} else {
					getFactory().resetSelection();
					entity.selected = true;
				}

			}, (factory, point) -> {
				return Factory.filterHover(Factory.filterClass(factory.getEntities(), Primary.class), point);
			}).apply(this);
	}

	@Override
	public String getLocalizedName()
	{
		return "選択";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "左クリックで排他的選択、Ctrlまたは右クリックで選択切り替え";
	}

}
