package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Map.Entry;

import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.ManagerEnvironment;

public class ToolCursorEnvironment extends ToolCursor
{

	private Point point;
	private Point pointCoord;

	public ToolCursorEnvironment(IFrameGameAlmandine frameGameAlmandine)
	{
		super(frameGameAlmandine);

		eventManager.register(NitrogenEventMouseMotion.Moved.class, e -> {
			mouseMoved(e.mouseEvent);
		});
		eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> {
			mouseMoved(e.mouseEvent);
		});
		eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
			if (point == null) return;
			if (pointCoord == null) return;

			e.graphics.setColor(Color.black);
			e.graphics.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 14));
			int i = 1;

			Environment environment = ManagerEnvironment.getEnvironment(getGame(), pointCoord);

			for (Entry<String, Integer> entry : environment.integers.entrySet()) {
				e.graphics.drawString("" + entry.getKey() + ": " + entry.getValue(),
					point.x + 20,
					point.y + e.graphics.getFont().getSize() * i);
				i++;
			}

			for (Entry<String, Double> entry : environment.doubles.entrySet()) {
				e.graphics.drawString("" + entry.getKey() + ": " + entry.getValue(),
					point.x + 20,
					point.y + e.graphics.getFont().getSize() * i);
				i++;
			}

			for (Entry<String, String> entry : environment.strings.entrySet()) {
				e.graphics.drawString("" + entry.getKey() + ": " + entry.getValue(),
					point.x + 20,
					point.y + e.graphics.getFont().getSize() * i);
				i++;
			}

			for (Entry<String, Boolean> entry : environment.booleans.entrySet()) {
				e.graphics.drawString("" + entry.getKey() + ": " + entry.getValue(),
					point.x + 20,
					point.y + e.graphics.getFont().getSize() * i);
				i++;
			}

		});
	}

	public void mouseMoved(MouseEvent e)
	{
		point = getPoint(e);
		pointCoord = getCoord(e);
	}

	@Override
	public String getLocalizedName()
	{
		return "環境調査";
	}

	@Override
	public String getLocalizedDescription()
	{
		return "マウスオーバーで地点の環境定数を表示";
	}

}
