package mirrg.simulation.cart.almandine.mods.vanilla.stations;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import java.util.stream.Stream;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.enchant.EnchantCartCover;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart.PositionStation;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;

public abstract class StationCoverBase extends StationThrough
{

	@Deprecated
	public StationCoverBase()
	{
		super();
	}

	public String direction;

	public StationCoverBase(GameAlmandine game, Point point, int radius, double duration)
	{
		super(game, point, radius);
		this.duration = duration;
	}

	public double amount;
	public double duration;

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyDouble("Duration", "s", () -> duration, duration -> {
			if (duration < 0) return false;
			this.duration = duration;
			return true;
		});
		dialogProperty.addPropertyDouble("Amount", "s", () -> amount, amount -> {
			if (amount < 0) return false;
			this.amount = amount;
			return true;
		});
		dialogProperty.addPropertyComboBox("Direction", Stream.of(Direction.values()), () -> Direction.valueOf(direction), direction -> {
			this.direction = direction.name();
			return true;
		});
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		if (direction == null) direction = "UNDEFINED";
		Cart cart = getCartPrimary().orElse(null);
		if (cart == null) return;

		// 指向性が無ければ全てのカートを処理
		Direction direction2 = Direction.valueOf(direction);
		if (direction2 == null || direction2 == Direction.UNDEFINED) {
			processCart(deltaSecond, cart);
			return;
		}

		// 指向性があるがレールが見つからない場合はカートを処理しない
		RailBase rail = getRail(direction2).orElse(null);
		if (rail == null) {
			super.tick(deltaSecond);
			return;
		}

		// 指向性がありカートがそのレールから来た場合は処理をする
		if (rail.getId() == ((PositionStation) cart.position).idRailFrom) {
			processCart(deltaSecond, cart);
			return;
		}

		// 指向性がありレールがあるがカートがそのレールから来ていない場合は処理をしない
		{
			super.tick(deltaSecond);
			return;
		}

	}

	protected void processCart(double deltaSecond, Cart cart) throws IllegalEntityIdException
	{
		if (shouldAction(deltaSecond, cart)) {

			amount += deltaSecond;
			if (amount > duration) {
				amount = 0;

				action(deltaSecond, cart);

			}

		} else {
			super.tick(deltaSecond);
		}
	}

	/**
	 * {@link #shouldAction(double, Cart)} == trueの場合にのみ呼び出される。
	 */
	protected abstract void action(double deltaSecond, Cart cart) throws IllegalEntityIdException;

	protected abstract boolean shouldAction(double deltaSecond, Cart cart) throws IllegalEntityIdException;

	@Override
	public void draw(Graphics2D graphics)
	{
		super.draw(graphics);

		int w = 40;

		graphics.setColor(new Color(0xe0e0e0));
		graphics.fill(new Rectangle2D.Double(
			x - w / 2,
			y - radius - 16,
			w,
			10));
		graphics.setColor(new Color(getColor()));
		graphics.fill(new Rectangle2D.Double(
			x - w / 2,
			y - radius - 16,
			w * (amount / duration),
			10));

		drawMarkerDirection(graphics, direction, true);

	}

	protected Optional<EnchantCartCover> getCover(Cart cart)
	{
		return cart.enchants.stream()
			.filter(enchent -> enchent instanceof EnchantCartCover)
			.findFirst()
			.map(enchant -> (EnchantCartCover) enchant);
	}

}
