package mirrg.simulation.cart.almandine.mods.vanilla.stackslabs.thermo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;

public class StackSlabThermo implements IStackSlab, IStackSlabThermo
{

	public int amount;
	public double temperature = 0;

	@Deprecated
	public StackSlabThermo()
	{

	}

	public StackSlabThermo(int amount, double temperature)
	{
		this.amount = amount;
		this.temperature = temperature;
	}

	@Override
	public IStackSlab tryPop(int amount)
	{
		if (this.amount < amount) {
			// 足りない

			this.amount = 0;
			return new StackSlabThermo(this.amount, temperature);
		} else {
			// 足りる

			this.amount -= amount;
			return new StackSlabThermo(amount, temperature);
		}
	}

	@Override
	public void push(IStackSlab stack)
	{
		double temperature;
		if (stack instanceof IStackSlabThermo) {
			temperature = ((IStackSlabThermo) stack).getTemperatureMean();
		} else {
			temperature = 0;
		}

		double at = amount * this.temperature + stack.getAmount() * temperature;
		amount += stack.getAmount();
		if (amount != 0) this.temperature = at / amount;
		stack.clear();
	}

	@Override
	public int getAmount()
	{
		return amount;
	}

	@Override
	public void clear()
	{
		amount = 0;
		temperature = 0;
	}

	@Override
	public void addProperty(Factory factory, IDialogProperty dialogProperty)
	{
		dialogProperty.addPropertyInt("Amount", "個", () -> amount, amount -> {
			if (amount <= 0) return false;
			this.amount = amount;
			return true;
		});
		dialogProperty.addPropertyDouble("Temperature", "C", () -> temperature, temperature -> {
			this.temperature = temperature;
			return true;
		});
	}

	public void renderGauge(Graphics2D graphics, Rectangle bound, int capacity)
	{

		{
			double r = temperature / 1000;
			if (r < 0) r = 0;
			if (r > 1) r = 1;
			graphics.setColor(new Color((float) r, 0f, 0f));
		}
		int h = (int) (bound.getHeight() * amount / capacity);
		graphics.fillRect(
			(int) bound.getMinX(),
			(int) bound.getMaxY() - h,
			(int) bound.getWidth(),
			h);

	}

	@Override
	public double getTemperatureMean()
	{
		return temperature;
	}

	@Override
	public void tick(Factory factory, double deltaSecond, Environment environment)
	{
		double temperatureEnvironment = environment.getDouble("temperature").orElse(25D);
		double gap = temperature - temperatureEnvironment;

		// 3時間で半減
		// 3*3600second -> 0.5倍

		double durationHeatHalfLife = environment.getDouble("durationHeatHalfLife").orElse(3 * 3600D);

		if (durationHeatHalfLife == 0) {
			temperature = gap;
		} else {
			double ratio = Math.pow(0.5, deltaSecond / durationHeatHalfLife);
			gap *= ratio;

			temperature = temperatureEnvironment + gap;
		}
	}

}
