package mirrg.simulation.cart.almandine.mods.vanilla.stackslab;

import java.awt.Graphics2D;
import java.awt.Rectangle;

import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Factory;

public interface IStackSlab
{

	public int getAmount();

	/**
	 * @param stack
	 *            破壊的な改変を受ける。
	 *            必ず成功する。
	 */
	public void push(IStackSlab stack);

	/**
	 * @param amount
	 *            0以上の数値
	 * @return
	 *         新しいインスタンス。
	 *         引数よりも少ない個数が返される可能性がある。
	 *         非null。
	 */
	public IStackSlab tryPop(int amount);

	public void clear();

	public void addProperty(Factory factory, IDialogProperty dialogProperty);

	public void renderGauge(Graphics2D graphics, Rectangle bound, int capacity);

	public void tick(Factory factory, double deltaSecond, Environment environment);

}
