package mirrg.simulation.cart.almandine.mods.vanilla.furnitures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;

import javax.swing.JButton;

import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.SlotBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Furniture;
import mirrg.simulation.cart.almandine.mods.vanilla.slots.SlotModule;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslabs.thermo.IStackSlabThermo;
import mirrg.swing.helium.GroupBuilder;

public class FurnitureThermometer extends Furniture
{

	public double sumTemperature;
	public int count;

	public SlotModule slotA;
	public SlotModule slotB;

	@Deprecated
	public FurnitureThermometer()
	{
		super();
	}

	public FurnitureThermometer(GameAlmandine game, Point point) throws IllegalEntityIdException
	{
		super(game, new Bound(point.x - 50, point.y - 20, 100, 40));
		slotA = new SlotModule(game, new Bound(point.x - 48, point.y - 18, 16, 16), 1);
		slotB = new SlotModule(game, new Bound(point.x - 48, point.y + 2, 16, 16), 1);
	}

	protected Stream<SlotBase> getSlots()
	{
		return Stream.of(slotA, slotB);
	}

	@Override
	protected void drawBody(Graphics2D graphics)
	{
		graphics.setColor(new Color(0xffd8ee));
		graphics.fill(bound.createShape());
		graphics.setColor(new Color(0x000000));
		graphics.draw(bound.grow(1, 1, 0, 0).createShape());

		graphics.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 14));
		graphics.drawString(String.format("温度: %.1f",
			count == 0 ? 0 : sumTemperature / count),
			bound.getX() + 20,
			bound.getY() + bound.getHeight() / 2 + graphics.getFont().getSize() * 0);
		graphics.drawString("個数: " + count,
			bound.getX() + 20,
			bound.getY() + bound.getHeight() / 2 + graphics.getFont().getSize() * 1);
	}

	@Override
	public void tick(double deltaSecond) throws IllegalEntityIdException
	{
		super.tick(deltaSecond);

		analyze();

	}

	protected void analyze()
	{

		// Bスロが空でない場合はスルー
		if (!slotB.slot.isEmpty()) return;

		// Aスロが空の場合はスルー
		if (slotA.slot.isEmpty()) return;

		double temperature = 0;

		if (slotA.slot.stack instanceof IStackSlabThermo) {
			temperature = ((IStackSlabThermo) slotA.slot.stack).getTemperatureMean();
		}

		int amount = slotB.slot.tryPush(slotA.slot);
		if (amount >= 1) {
			// 移動が成功した場合にのみ加算

			count += amount;
			sumTemperature += temperature;

		}

	}

	@Override
	protected void addProperty(IDialogProperty dialogProperty)
	{
		super.addProperty(dialogProperty);

		dialogProperty.addPropertyDouble("Sum Temperature", "C・個", () -> sumTemperature, sumTemperature -> {
			this.sumTemperature = sumTemperature;
			return true;
		});
		dialogProperty.addPropertyDouble("Average Temperature", "C", () -> {
			return count == 0 ? 0 : sumTemperature / count;
		}, temperature -> {
			if (temperature <= 0) return false;
			this.sumTemperature = temperature * count;
			return true;
		});
		dialogProperty.addPropertyInt("Count", "個", () -> count, count -> {
			if (count < 0) return false;
			this.count = count;
			return true;
		});
		{
			JButton button = new JButton("リセット");
			button.addActionListener(e -> {
				sumTemperature = 0;
				count = 0;
			});
			dialogProperty.addComponent(GroupBuilder.group(button));
		}
	}

}
