/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory.entities.parts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.factory.Bound;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.entities.parts.PartRectangle;
import mirrg.simulation.cart.almandine.gui.property.IDialogProperty;

public class Gauge
extends PartRectangle {
    public double amount;
    public double capacity;

    @Deprecated
    public Gauge() {
    }

    public Gauge(Factory factory, Bound bound, double capacity) {
        super(factory, bound);
        this.capacity = capacity;
    }

    @Override
    public void render(Factory factory, Graphics2D graphics) {
        Rectangle bound = this.bound.createShape();
        graphics.setColor(new Color(0xFFFFFF));
        graphics.fill(bound);
        graphics.setColor(new Color(65280));
        int h = (int)(bound.getHeight() * this.amount / this.capacity);
        graphics.fillRect((int)bound.getMinX(), (int)bound.getMaxY() - h, (int)bound.getWidth(), h);
    }

    @Override
    protected void addProperty(Factory factory, IDialogProperty dialogProperty) {
        super.addProperty(factory, dialogProperty);
        dialogProperty.addPropertyDouble("Amount", "?", () -> this.amount, amount -> {
            if (amount <= 0.0) {
                return false;
            }
            this.amount = amount;
            return true;
        });
        dialogProperty.addPropertyDouble("Capacity", "?", () -> this.capacity, capacity -> {
            if (capacity <= 0.0) {
                return false;
            }
            this.capacity = capacity;
            return true;
        });
    }
}

