/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.swing.helium.logging.HLog;
import mirrg.swing.helium.property.ManagerProperty;

public class GameAlmandine {
    public ManagerProperty managerProperty = new ManagerProperty();
    public Factory factory = new Factory(25.0);
    private IntSupplier tickPerFrame = this.managerProperty.createPropertyInt(1, "panel.tickPerFrame", "1\u63cf\u753b\u30d5\u30ec\u30fc\u30e0\u3042\u305f\u308a\u306eTick\u6570[t/f]");
    private DoubleSupplier secondPerTick = this.managerProperty.createPropertyDouble(2.0, "panel.secondPerTick", "1Tick\u3042\u305f\u308a\u306e\u9032\u884c\u6642\u9593[s/t]");

    public void tick() {
        for (int i = 0; i < this.tickPerFrame.getAsInt(); ++i) {
            this.factory.tick(this.secondPerTick.getAsDouble());
        }
    }

    public void render(Graphics2D graphics, IFrameGameAlmandine frameGameAlmandine) {
        this.factory.render(graphics, frameGameAlmandine);
    }

    public static GameAlmandine load(File file) {
        Object data;
        if (file.exists()) {
            try {
                data = new XStream().fromXML((InputStream)new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                HLog.processExceptionUnexpected((Exception)e);
                return null;
            }
            catch (ConversionException e) {
                HLog.processException((Exception)((Object)e), (String)("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u304a\u308a\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\uff01: " + file.getPath()), (boolean)true);
                return null;
            }
        } else {
            HLog.error((String)("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\uff01: " + file.getPath()));
            return null;
        }
        if (!(data instanceof Factory)) {
            HLog.error((String)("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u307e\u3059\uff01: " + file.getPath()));
            return null;
        }
        GameAlmandine game = new GameAlmandine();
        game.factory = (Factory)data;
        return game;
    }

    public boolean save(File file) {
        if (file.exists()) {
            Path pathBackup = new File(file.getAbsolutePath() + ".orig").toPath();
            try {
                Files.copy(file.toPath(), pathBackup, StandardCopyOption.REPLACE_EXISTING);
                HLog.fine((String)("\u53e4\u3044\u8a2d\u5b9a\u30c7\u30fc\u30bf\u3092\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3057\u307e\u3057\u305f: " + pathBackup));
            }
            catch (IOException e) {
                HLog.processException((Exception)e, (String)("\u53e4\u3044\u8a2d\u5b9a\u30c7\u30fc\u30bf\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + pathBackup), (boolean)false);
            }
        }
        try {
            XStream xStream = new XStream();
            xStream.autodetectAnnotations(true);
            xStream.toXML((Object)this.factory, (OutputStream)new FileOutputStream(file));
        }
        catch (FileNotFoundException e2) {
            HLog.processException((Exception)e2);
            return false;
        }
        HLog.fine((String)("\u8a2d\u5b9a\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + file.getPath()));
        return true;
    }
}

