/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.extension.jta.xa;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * @author higa
 *
 */
public class XidImplTest {

    /** target */
    private XidImpl xid = null;

    /**
     * setUp
     */
    @Before
    public void setUp() {
        this.xid = new XidImpl();
    }

    /**
     * testEquals
     */
    @Test
    public void testEquals() {

        Assert.assertEquals("1", this.xid, this.xid);
        Assert.assertNotNull("2", this.xid);
        Assert.assertNotEquals("3", this.xid, new XidImpl());
        Assert.assertNotEquals("4", this.xid, "test");

        final XidImpl xid2 = new XidImpl(this.xid, 1);
        final XidImpl xid3 = new XidImpl(this.xid, 1);
        Assert.assertEquals("5", xid2, xid3);
        System.out.println(xid2);
        System.out.println(xid3);
    }

    /**
     * testToString
     */
    @Test
    public void testToString() {
        System.out.println(this.xid);
    }
}
