/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.extension.jta;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

/**
 * {@link UserTransaction}の実装クラスです。
 *
 * @author higa
 *
 */
public class UserTransactionImpl implements UserTransaction {

    /** トランザクションマネージャです。 */
    private final TransactionManager manager;

    /**
     * {@link UserTransactionImpl}を作成します。
     *
     * @param tm TransactionManager
     */
    public UserTransactionImpl(final TransactionManager tm) {
        this.manager = tm;
    }

    /**
     * @see javax.transaction.UserTransaction#begin()
     */
    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.manager.begin();
    }

    /**
     * @see javax.transaction.UserTransaction#commit()
     */
    @Override
    public void commit() throws HeuristicMixedException, HeuristicRollbackException,
            RollbackException, SystemException {
        this.manager.commit();
    }

    /**
     * @see javax.transaction.UserTransaction#getStatus()
     */
    @Override
    public int getStatus() throws SystemException {
        return this.manager.getStatus();
    }

    /**
     * @see javax.transaction.UserTransaction#rollback()
     */
    @Override
    public void rollback() throws SystemException {
        this.manager.rollback();
    }

    /**
     * @see javax.transaction.UserTransaction#setRollbackOnly()
     */
    @Override
    public void setRollbackOnly() throws SystemException {
        this.manager.setRollbackOnly();
    }

    /**
     * @see javax.transaction.UserTransaction#setTransactionTimeout(int)
     */
    @Override
    public void setTransactionTimeout(final int timeout) throws SystemException {
        this.manager.setTransactionTimeout(timeout);
    }
}
