/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatProject;

/**
 * TomcatProjectAbstractActionDelegate
 *
 */
public abstract class TomcatProjectAbstractActionDelegate
								extends AbstractHandler implements IWorkbenchWindowActionDelegate {

	/** IWorkbenchWindow */
	private IWorkbenchWindow window;
	/** msg */
	private String msg;
	/** showMessageBox */
	private boolean showMessageBox = true;

	/**
	 * @return the showMessageBox
	 */
	protected boolean isShowMessageBox() {
		return this.showMessageBox;
	}

	/**
	 * @param show the showMessageBox to set
	 */
	protected void setShowMessageBox(final boolean show) {
		this.showMessageBox = show;
	}

	/**
	 * @return the window
	 */
	protected IWorkbenchWindow getWindow() {
		return this.window;
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#dispose()
	 */
	@Override
	public void dispose() {
		return;
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#init(IWorkbenchWindow)
	 */
	@Override
	public void init(final IWorkbenchWindow ww) {
		this.window = ww;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(final IAction action) {
		doAction();
	}

	/**
	 * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		doAction();
		return null;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(
	 * org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(final IAction action, final ISelection selection) {
		return;
	}

	/**
	 *
	 * @return TomcatProject
	 */
	protected TomcatProject getCurrentSelection() {
		return getProject();
	}

	/**
	 *
	 * @param prj TomcatProject
	 * @throws CoreException CoreException
	 */
	public abstract void doActionOn(TomcatProject prj) throws CoreException;


	/**
	 * callAction
	 */
	protected void doAction() {
		setMsgToSuccess();
		try {
			TomcatProject prj = getCurrentSelection();
			if (prj != null) {
				doActionOn(prj);
			}
		} catch (final TomcatActionException ex) {
			setMsgToFail(ex.getMessage(), false);
		} catch (final CoreException ex) {
			TomcatLauncherPlugin.log(ex);
			setMsgToFail(ex.getMessage(), true);
		}

		if (this.showMessageBox) {
			Shell shell = TomcatLauncherPlugin.getShell();
			MessageDialog.openInformation(shell, "Tomcat", this.msg);
		}
	}

	/**
	 * @return TomcatProject
	 */
	private TomcatProject getProject() {
		IWorkbenchWindow win = JavaPlugin.getActiveWorkbenchWindow();
		TomcatProject result = null;
		if (win != null) {
			ISelection selection = win.getSelectionService().getSelection();
			if (selection instanceof IStructuredSelection) {
				Object project = ((IStructuredSelection)selection).getFirstElement();
				if (project instanceof IProject) {
					result = TomcatProject.create((IProject)project);
				} else if (project instanceof IJavaProject) {
					result = TomcatProject.create((IJavaProject)project);
				}
			}
		}
		return result;
	}

	/**
	 * Sets the msg.
	 * @param detail String
	 * @param seelog boolean
	 */
	private void setMsgToFail(final String detail, final boolean seelog) {
		this.msg = TomcatLauncherPlugin.getResourceString("msg.action.failed");
		this.msg += "\n";
		this.msg += detail;
		if (seelog) {
			this.msg += TomcatLauncherPlugin.getResourceString("msg.action.seelog");
		}
	}

	/**
	 * Sets the msg.
	 */
	private void setMsgToSuccess() {
		this.msg = TomcatLauncherPlugin.getResourceString("msg.action.succeeded");
	}
}
