/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_COMPUTESOURCEPATH_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_PROJECTINSOURCEPATH_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.TOMCAT_PREF_COMPUTESOURCEPATH_KEY;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.sysdeo.eclipse.tomcat.editors.ProjectListEditor;

/**
 * TomcatSourcePathPreferencePage
 *
 */
public class TomcatSourcePathPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {

	/** ProjectListEditor */
	private ProjectListEditor projectListEditor;
	/** BooleanFieldEditor */
	private BooleanFieldEditor automaticEditor;

	/**
	 * Constructor
	 */
	public TomcatSourcePathPreferencePage() {
		super();
		setPreferenceStore(TomcatLauncherPlugin.getDefault().getPreferenceStore());
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	@Override
	protected Control createContents(final Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());

		this.automaticEditor = new BooleanFieldEditor(TOMCAT_PREF_COMPUTESOURCEPATH_KEY,
			PREF_PAGE_COMPUTESOURCEPATH_LABEL, composite);
		this.initField(this.automaticEditor);

		final Group projectListGroup = new Group(composite, SWT.NULL);
		projectListGroup.setLayout(new GridLayout());
		this.projectListEditor = new ProjectListEditor();
		this.projectListEditor.setLabel(PREF_PAGE_PROJECTINSOURCEPATH_LABEL);
		final Control projectList = this.projectListEditor.getControl(projectListGroup);
		projectListGroup.setLayoutData(new GridData(GridData.FILL_BOTH));
		projectList.setLayoutData(new GridData(GridData.FILL_BOTH));

		this.projectListEditor.setCheckedElements(TomcatLauncherPlugin.getDefault().readProjectsInSourcePathFromPref());
		this.projectListEditor.setEnabled(!this.automaticEditor.getBooleanValue());
		this.automaticEditor.setPropertyChangeListener(new Listener(this.projectListEditor, this.automaticEditor));

		return composite;
	}

	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	@Override
	public void init(final IWorkbench workbench) {
		return;
	}

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	@Override
	public boolean performOk() {
		this.automaticEditor.store();
		TomcatLauncherPlugin.setProjectsInSourcePath(this.projectListEditor.getCheckedElements());
		return true;
	}

	/**
	 *
	 * @param field FieldEditor
	 */
	private void initField(final FieldEditor field) {
		field.setPreferenceStore(getPreferenceStore());
		field.setPage(this);
		field.load();
	}

	/**
	 * Listener
	 *
	 */
	private static final class Listener implements IPropertyChangeListener {

		/** ProjectListEditor */
		private final ProjectListEditor projectListEditor;
		/** BooleanFieldEditor */
		private final BooleanFieldEditor automaticEditor;

		/**
		 * Constructor
		 * @param pEditor ProjectListEditor
		 * @param bEditor BooleanFieldEditor
		 */
		Listener(final ProjectListEditor pEditor, final BooleanFieldEditor bEditor) {
			this.projectListEditor = pEditor;
			this.automaticEditor = bEditor;
		}

		/**
		 * @see org.eclipse.jface.util.IPropertyChangeListener
		 * #propertyChange(org.eclipse.jface.util.PropertyChangeEvent)
		 */
		@Override
		public void propertyChange(final PropertyChangeEvent event) {
			this.projectListEditor.setEnabled(!this.automaticEditor.getBooleanValue());
		}
	}
}
