package project.common;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * TestCsvUtil
 *
 */
public class TestCsvUtil {

	/**
	 * CSV文字列カンマ含む改行CRLF終了配列化
	 */
	@Test
	@DisplayName("CSV文字列カンマ含む改行CRLF終了配列化")
	public void toArrayTest1() {
		final String[] vals = CsvUtil.toArray(",aaa,\"bbbb,\"\r\n");
		Assertions.assertEquals(3, vals.length);
		Assertions.assertEquals("", vals[0]);
		Assertions.assertEquals("aaa", vals[1]);
		Assertions.assertEquals("bbbb,", vals[2]);
	}

	/**
	 * 文字列配列改行CRありCSV文字列化
	 */
	@Test
	@DisplayName("文字列配列改行CRありCSV文字列化")
	public void toCsvTest1() {
		final String val = CsvUtil.toCsv("aaaa", ",", "aaa\r\nbbb", "\"ddd");
		Assertions.assertEquals("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"", val);
	}

	/**
	 * 文字列配列改行LFありCSV文字列化
	 */
	@Test
	@DisplayName("文字列配列改行LFありCSV文字列化")
	public void toCsvTest2() {
		final String val = CsvUtil.toCsv("aaaa", ",", "aaa\nbbb", "\"ddd");
		Assertions.assertEquals("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"", val);
	}

	/**
	 * CSV文字列配列化改行CRダブルクォートあり
	 */
	@Test
	@DisplayName("CSV文字列配列化改行CRダブルクォートあり")
	public void toArrayTest2() {
		final String[] vals = CsvUtil.toArray("aaaa,\",\",\"aaa\r\nbbb\",\"\"\"ddd\"\r\n");
		Assertions.assertEquals(4, vals.length);
		Assertions.assertEquals("aaaa", vals[0]);
		Assertions.assertEquals(",", vals[1]);
		Assertions.assertEquals("aaa\r\nbbb", vals[2]);
		Assertions.assertEquals("\"ddd", vals[3]);
	}

	/**
	 * CSV文字列配列化改行LFダブルクォートあり
	 */
	@Test
	@DisplayName("CSV文字列配列化改行LFダブルクォートあり")
	public void toArrayTest3() {
		final String[] vals = CsvUtil.toArray("aaaa,\",\",\"aaa\nbbb\",\"\"\"ddd\"\r\n");
		Assertions.assertEquals(4, vals.length);
		Assertions.assertEquals("aaaa", vals[0]);
		Assertions.assertEquals(",", vals[1]);
		Assertions.assertEquals("aaa\nbbb", vals[2]);
		Assertions.assertEquals("\"ddd", vals[3]);
	}

	/**
	 * CSV文字列配列化カンマ終了
	 */
	@Test
	@DisplayName("CSV文字列配列化カンマ終了")
	public void toArrayTest4() {
		final String[] vals = CsvUtil.toArray("1,");
		Assertions.assertEquals(2, vals.length);
		Assertions.assertEquals("1", vals[0]);
		Assertions.assertEquals("", vals[1]);
	}
}
