package online.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

/**
 * TestUniModelBoolean
 *
 */
public class TestUniModelBoolean {

	/**
	 * testNoValue1
	 */
	@Test
	public void testNoValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("AAAAA");

		Assertions.assertTrue(um.containsKey("AAAAA"));
		Assertions.assertFalse(um.hasValue("AAAAA"));
		Assertions.assertNull(um.getBoolean("AAAAA"));
		Assertions.assertEquals(0, um.getArraySize("AAAAA"));
		Assertions.assertEquals(0, um.getBooleanArray("AAAAA").length);
		Assertions.assertFalse(um.isArrayValue("AAAAA"));

		um.addValue("AAAAA", Boolean.FALSE);
		Assertions.assertTrue(um.containsKey("AAAAA"));
		Assertions.assertTrue(um.hasValue("AAAAA"));
		Assertions.assertEquals(Boolean.FALSE, um.getBoolean("AAAAA"));
		Assertions.assertEquals(1, um.getArraySize("AAAAA"));
		Assertions.assertEquals(1, um.getBooleanArray("AAAAA").length);
		Assertions.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * testNoValue2
	 */
	@Test
	public void testNoValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("AAAAA", Boolean.TRUE);

		Assertions.assertTrue(um.containsKey("AAAAA"));
		Assertions.assertTrue(um.hasValue("AAAAA"));
		Assertions.assertEquals(Boolean.TRUE, um.getBoolean("AAAAA"));
		Assertions.assertEquals(Boolean.TRUE, um.getBooleanArray("AAAAA")[0]);
		Assertions.assertEquals(1, um.getArraySize("AAAAA"));
		Assertions.assertEquals(1, um.getBooleanArray("AAAAA").length);
		Assertions.assertFalse(um.isArrayValue("AAAAA"));

		um.noValue("AAAAA");
		Assertions.assertTrue(um.containsKey("AAAAA"));
		Assertions.assertFalse(um.hasValue("AAAAA"));
		Assertions.assertNull(um.getBoolean("AAAAA"));
		Assertions.assertEquals(0, um.getArraySize("AAAAA"));
		Assertions.assertEquals(0, um.getBooleanArray("AAAAA").length);
		Assertions.assertFalse(um.isArrayValue("AAAAA"));

		um.addValue("AAAAA", Boolean.FALSE);
		um.addValue("AAAAA", Boolean.TRUE);
		Assertions.assertTrue(um.containsKey("AAAAA"));
		Assertions.assertTrue(um.hasValue("AAAAA"));
		Assertions.assertEquals(2, um.getArraySize("AAAAA"));
		Assertions.assertEquals(2, um.getBooleanArray("AAAAA").length);
		Assertions.assertEquals(Boolean.FALSE, um.getBooleanArray("AAAAA")[0]);
		Assertions.assertEquals(Boolean.TRUE, um.getBooleanArray("AAAAA")[1]);
		Assertions.assertTrue(um.isArrayValue("AAAAA"));
	}


	/**
	 * testAliasKey0
	 */
	@Test
	public void testAliasKey0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("BBBBB");
		um.aliasKey("BBBBB", "AAAAA");

		Assertions.assertTrue(um.containsKey("BBBBB"));
		Assertions.assertTrue(um.containsKey("AAAAA"));
		Assertions.assertFalse(um.hasValue("AAAAA"));
		Assertions.assertNull(um.getBoolean("AAAAA"));
		Assertions.assertEquals(0, um.getArraySize("AAAAA"));
		Assertions.assertEquals(0, um.getBooleanArray("AAAAA").length);
		Assertions.assertFalse(um.isArrayValue("AAAAA"));
	}

	/**
	 * testAliasKey1
	 */
	@Test
	public void testAliasKey1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertFalse(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey2
	 */
	@Test
	public void testAliasKey2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertFalse(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey3
	 */
	@Test
	public void testAliasKey3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean)null);
		um.addValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey4
	 */
	@Test
	public void testAliasKey4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", new Boolean[]{null});
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey5
	 */
	@Test
	public void testAliasKey5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertEquals(2, um.getArraySize("aaaaa"));
		Assertions.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assertions.assertNull(um.getBooleanArray("aaaaa")[1]);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));

		Assertions.assertTrue(um.containsKey("bbbbb"));
		Assertions.assertTrue(um.hasValue("bbbbb"));
		Assertions.assertNull(um.getBooleanArray("bbbbb")[0]);
		Assertions.assertEquals(1, um.getArraySize("bbbbb"));
		Assertions.assertEquals(1, um.getBooleanArray("bbbbb").length);
		Assertions.assertFalse(um.isArrayValue("bbbbb"));
	}

	/**
	 * testAliasKey6
	 */
	@Test
	public void testAliasKey6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("bbbbb", (Boolean[])null);
		um.addValue("bbbbb", (Boolean)null);
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testAliasKey7
	 */
	@Test
	public void testAliasKey7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Boolean[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", Boolean.FALSE, Boolean.TRUE);
		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertEquals(Boolean.FALSE, um.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(Boolean.TRUE, um.getBooleanArray("aaaaa")[2]);
		Assertions.assertEquals(3, um.getArraySize("aaaaa"));
		Assertions.assertEquals(3, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));

		Assertions.assertTrue(um.containsKey("bbbbb"));
		Assertions.assertTrue(um.hasValue("bbbbb"));
		Assertions.assertNull(um.getBooleanArray("bbbbb")[0]);
		Assertions.assertEquals(1, um.getArraySize("bbbbb"));
		Assertions.assertEquals(1, um.getBooleanArray("bbbbb").length);
		Assertions.assertTrue(um.isArrayValue("bbbbb"));
	}

	/**
	 * testAliasKey8
	 */
	@Test
	public void testAliasKey8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("bbbbb", (Boolean[])null);
		um.aliasKey("bbbbb", "aaaaa");

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(2, um.getArraySize("aaaaa"));
		Assertions.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));

		Assertions.assertTrue(um.containsKey("bbbbb"));
		Assertions.assertTrue(um.hasValue("bbbbb"));
		Assertions.assertNull(um.getBooleanArray("bbbbb")[0]);
		Assertions.assertEquals(1, um.getArraySize("bbbbb"));
		Assertions.assertEquals(1, um.getBooleanArray("bbbbb").length);
		Assertions.assertTrue(um.isArrayValue("bbbbb"));
	}


	/**
	 * testArraySize1
	 */
	@Test
	public void testArraySize1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertFalse(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize2
	 */
	@Test
	public void testArraySize2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertFalse(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertEquals(0, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize3
	 */
	@Test
	public void testArraySize3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize4
	 */
	@Test
	public void testArraySize4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize5
	 */
	@Test
	public void testArraySize5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertFalse(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(2, um.getArraySize("aaaaa"));
		Assertions.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize6
	 */
	@Test
	public void testArraySize6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBoolean("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize7
	 */
	@Test
	public void testArraySize7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", Boolean.TRUE, Boolean.FALSE);
		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertEquals(Boolean.TRUE, um.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(Boolean.FALSE, um.getBooleanArray("aaaaa")[2]);
		Assertions.assertEquals(3, um.getArraySize("aaaaa"));
		Assertions.assertEquals(3, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
	}

	/**
	 * testArraySize8
	 */
	@Test
	public void testArraySize8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[0]);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertEquals(1, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		Assertions.assertTrue(um.containsKey("aaaaa"));
		Assertions.assertTrue(um.hasValue("aaaaa"));
		Assertions.assertNull(um.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(2, um.getArraySize("aaaaa"));
		Assertions.assertEquals(2, um.getBooleanArray("aaaaa").length);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
	}


	/**
	 * testcopyValue0
	 */
	@Test
	public void testcopyValue0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue1
	 */
	@Test
	public void testcopyValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue2
	 */
	@Test
	public void testcopyValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.setValue("bbbbb", new Boolean[0]);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue3
	 */
	@Test
	public void testcopyValue3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue4
	 */
	@Test
	public void testcopyValue4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue5
	 */
	@Test
	public void testcopyValue5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue6
	 */
	@Test
	public void testcopyValue6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue7
	 */
	@Test
	public void testcopyValue7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", Boolean.FALSE, Boolean.TRUE);
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[2], um1.getBooleanArray("aaaaa")[2]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testcopyValue8
	 */
	@Test
	public void testcopyValue8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		um.copyValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testputValue0
	 */
	@Test
	public void testputValue0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue1
	 */
	@Test
	public void testputValue1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue2
	 */
	@Test
	public void testputValue2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue3
	 */
	@Test
	public void testputValue3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue4
	 */
	@Test
	public void testputValue4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue5
	 */
	@Test
	public void testputValue5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue6
	 */
	@Test
	public void testputValue6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue7
	 */
	@Test
	public void testputValue7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", Boolean.TRUE, Boolean.FALSE);
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[2], um1.getBooleanArray("aaaaa")[2]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputValue8
	 */
	@Test
	public void testputValue8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		um.putValueTo(um1, "aaaaa");

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testputAll0
	 */
	@Test
	public void testputAll0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll1
	 */
	@Test
	public void testputAll1() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll2
	 */
	@Test
	public void testputAll2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll3
	 */
	@Test
	public void testputAll3() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll4
	 */
	@Test
	public void testputAll4() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", new Boolean[]{null});

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll5
	 */
	@Test
	public void testputAll5() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll6
	 */
	@Test
	public void testputAll6() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean[])null);
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll7
	 */
	@Test
	public void testputAll7() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", Boolean.TRUE, Boolean.FALSE);
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[2], um1.getBooleanArray("aaaaa")[2]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testputAll8
	 */
	@Test
	public void testputAll8() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean[])null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));

		um.addValue("aaaaa", (Boolean)null);
		um1.putAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getBooleanArray("aaaaa")[1], um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}


	/**
	 * testaddAll0
	 */
	@Test
	public void testaddAll0() {
		final UniModelImpl um = new UniModelImpl();
		um.noValue("aaaaa");

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assertions.assertEquals(um.containsKey("aaaaa"), um1.containsKey("aaaaa"));
		Assertions.assertEquals(um.hasValue("aaaaa"), um1.hasValue("aaaaa"));
		Assertions.assertEquals(
				um.getBooleanArray("aaaaa").length, um1.getBooleanArray("aaaaa").length);
		Assertions.assertEquals(um.getBoolean("aaaaa"), um1.getBoolean("aaaaa"));
		Assertions.assertEquals(um.getArraySize("aaaaa"), um1.getArraySize("aaaaa"));
		Assertions.assertEquals(um.isArrayValue("aaaaa"), um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll1
	 */
	@Test
	public void testaddAll1() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assertions.assertTrue(um1.containsKey("aaaaa"));
		Assertions.assertTrue(um1.hasValue("aaaaa"));
		Assertions.assertEquals(1, um1.getArraySize("aaaaa"));
		Assertions.assertNull(um1.getBooleanArray("aaaaa")[0]);
		Assertions.assertNull(um1.getBoolean("aaaaa"));
		Assertions.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll2
	 */
	@Test
	public void testaddAll2() {
		final UniModelImpl um = new UniModelImpl();
		um.setValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addAll(um);

		Assertions.assertTrue(um1.containsKey("aaaaa"));
		Assertions.assertTrue(um1.hasValue("aaaaa"));
		Assertions.assertEquals(1, um1.getArraySize("aaaaa"));
		Assertions.assertNull(um1.getBooleanArray("aaaaa")[0]);
		Assertions.assertNull(um1.getBoolean("aaaaa"));
		Assertions.assertFalse(um1.isArrayValue("aaaaa"));
	}

	/**
	 * testaddAll3
	 */
	@Test
	public void testaddAll3() {
		final UniModelImpl um = new UniModelImpl();
		um.addValue("aaaaa", (Boolean)null);

		final UniModelImpl um1 = new UniModelImpl();
		um1.addValue("aaaaa", (Boolean)null);
		um1.addAll(um);

		Assertions.assertTrue(um1.containsKey("aaaaa"));
		Assertions.assertTrue(um1.hasValue("aaaaa"));
		Assertions.assertEquals(2, um1.getArraySize("aaaaa"));
		Assertions.assertNull(um1.getBooleanArray("aaaaa")[0]);
		Assertions.assertNull(um1.getBooleanArray("aaaaa")[1]);
		Assertions.assertNull(um1.getBoolean("aaaaa"));
		Assertions.assertTrue(um1.isArrayValue("aaaaa"));
	}
}
