<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8" />
<title>汎用データアップロード</title>
<link rel="stylesheet" href="view/css/import.css" />
</head>

<body>
<header>
	<nav></nav>
	<section></section>
</header>
<main>
	<header>
		<h3>汎用データアップロード</h3>
		<div id="topMessage">${MESSAGE}</div>
	</header>
	<form id="form" method="post" enctype="multipart/form-data" action="${ACTION_PATH}">
	<section>
		<div>
		<label for="datatype">データタイプ:</label>
		<select name="Id" id="datatype">
			<c:forEach items="${band.UploadValue}" var="bind">
				<utl:selected var="sel" name="Id" value="${bind.UploadValue}" />
				<option value="${sel}">${bind.UploadLabel}</option>
			</c:forEach>
		</select>
		</div>
		<div>
			<label for="importFile">アップロードファイル:</label>
			<input type="file" name="ImportFile" id="importFile" />
			<button type="submit" name="AID" value="upload">アップロード</button>
		</div>

		<c:if test="${AID eq 'upload'}">
		<div>
			<table>
			<thead>
				<tr>
					<th>データタイプ</th>
					<th>ファイル名</th>
					<th>エラー件数</th>
					<th>総件数</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td id="datalabel">
					</td>
					<td id="dataFile">${ImportFile}</td>
					<td class="right">
					${fn:length(array.ErrorLine)}
					</td>
					<td class="right">
					${TotalCount}
					</td>
				</tr>
			</tbody>
			</table>
		</div>
		</c:if>

		<c:if test="${not empty ErrorLine}">
		<div>
			<div>アップロード エラー</div>
			<table class="fixborder">
			<thead>
				<tr>
<!--
					<th>
						無視
						<input type="checkbox" class="checkAll" />
					</th>
 -->
					<th>行</th>
					<th>項目名</th>
					<th>内容</th>
				</tr>
			</thead>
			<c:set var="num" value="0" />
			<c:forEach items="${band.ErrorLine}" var="bind">
			<tbody>
				<tr>
<!--
					<td class="center">
						<input type="checkbox" name="Ignore" />
					</td>
 -->
					<td class="center">
						${bind.ErrorLine}
						<c:if test="${num ne bind.ErrorLine}">
						<input type="hidden" name="Error" value="${bind.ErrorLine}" />
						<c:set var="num" value="${bind.ErrorLine}" />
						</c:if>
					</td>
					<td>${bind.ErrorItem}</td>
					<td>${bind.ErrorMsg}</td>
				</tr>
			</tbody>
			</c:forEach>
			</table>
		</div>
		</c:if>
	</section>
	<aside>
	</aside>
	<footer>
		<c:if test="${(AID eq 'upload') and (fn:length(array.ErrorLine) lt TotalCount)}">
		<button type="button" class="import">データ取込</button>
		</c:if>
	</footer>
	</form>
</main>
<footer>
	<nav>
	</nav>
	<section>
	</section>
</footer>

<script src="view/js/jquery.min.js"></script>
<script src="view/js/submit.js"></script>
<script src="view/js/csv/import.js"></script>
</body>
</html>
