package project.check.attribute;

import java.util.Optional;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.common.CheckUtil;

/**
 * 半角数字チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class NumberCheck extends BaseCheck implements ItemCheck {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public NumberCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public NumberCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final var item : items) {
			final var val = getArrayParameter(item);
			for (var j = 0; val != null && j < val.length; j++) {
				if (!isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(getUniModel(), item, j);
				} else if (!CheckUtil.isNumber(val[j])) {
					setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(Pair.of(item, j)));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
